/*
 * Decompiled with CFR 0.152.
 */
package com.jaspersoft.studio.svgimporter;

import com.jaspersoft.studio.JaspersoftStudioPlugin;
import com.jaspersoft.studio.messages.Messages;
import com.jaspersoft.studio.preferences.util.PreferencesUtils;
import com.jaspersoft.studio.svgimporter.InkscapeMessageDialog;
import java.io.BufferedReader;
import java.io.Closeable;
import java.io.File;
import java.io.InputStreamReader;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.List;
import net.sf.jasperreports.eclipse.ui.util.UIUtils;
import net.sf.jasperreports.eclipse.util.FileUtils;
import net.sf.jasperreports.eclipse.util.Pair;
import org.apache.commons.io.FilenameUtils;
import org.apache.commons.lang.StringUtils;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.jobs.IJobChangeListener;
import org.eclipse.core.runtime.jobs.Job;
import org.eclipse.jface.util.Util;
import org.eclipse.ui.PartInitException;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.console.ConsolePlugin;
import org.eclipse.ui.console.IConsole;
import org.eclipse.ui.console.IConsoleManager;
import org.eclipse.ui.console.MessageConsole;
import org.eclipse.ui.console.MessageConsoleStream;

public class ConsolePdfConverter {
    private static final String CONSOLE_NAME = "PDF Converter Console";
    public static final String INKSCAPE_PATH_PROPERTY = "com.jaspersoft.studio.imports.pdf.inkscapepath";
    private List<File> filesToConvert;
    private List<File> convertedSVG = new ArrayList<File>();

    public ConsolePdfConverter(List<File> filesToConvert) {
        this.filesToConvert = filesToConvert;
        this.doConversion((IProgressMonitor)new NullProgressMonitor());
    }

    protected void asyncConvert(IJobChangeListener jobChangeListener) {
        Job readOutputJob = new Job("Compiling job"){

            protected IStatus run(IProgressMonitor monitor) {
                return ConsolePdfConverter.this.doConversion(monitor);
            }
        };
        readOutputJob.setPriority(20);
        readOutputJob.addJobChangeListener(jobChangeListener);
        readOutputJob.schedule();
    }

    private boolean isVersion(String value) {
        String[] numbers;
        String[] stringArray = numbers = value.split("\\.");
        int n = numbers.length;
        int n2 = 0;
        while (n2 < n) {
            String number = stringArray[n2];
            if (!StringUtils.isNumeric((String)number)) {
                return false;
            }
            ++n2;
        }
        return true;
    }

    /*
     * Exception decompiling
     */
    private boolean checkInkspace(MessageConsoleStream outputStream) {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Tried to end blocks [1[TRYBLOCK], 0[TRYBLOCK]], but top level block is 8[DOLOOP]
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.processEndingBlocks(Op04StructuredStatement.java:435)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:484)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    private IStatus doConversion(IProgressMonitor monitor) {
        MessageConsoleStream outputStream;
        IStatus result;
        block14: {
            block16: {
                this.convertedSVG.clear();
                result = Status.OK_STATUS;
                MessageConsole console = this.getCleanConsole();
                outputStream = console.newMessageStream();
                if (!this.checkInkspace(outputStream)) break block16;
                Pair<String, File> inkscapeCommand = this.getInkscapeCommand();
                for (File fileToCompile : this.filesToConvert) {
                    if (monitor.isCanceled()) {
                        result = Status.CANCEL_STATUS;
                        break block14;
                    }
                    if (!fileToCompile.exists()) continue;
                    BufferedReader stdInput = null;
                    BufferedReader stdError = null;
                    try {
                        try {
                            monitor.beginTask(MessageFormat.format("Converting {0}", fileToCompile.getName()), 1);
                            outputStream.println(MessageFormat.format(Messages.ConsolePdfConverter_consoleConversion, fileToCompile.getName()));
                            String absolutePath = fileToCompile.getAbsolutePath();
                            String outName = this.getOutputFilename(fileToCompile);
                            String[] command = new String[]{(String)inkscapeCommand.getKey(), "-l", outName, absolutePath};
                            Process process = Runtime.getRuntime().exec(command, null, null);
                            stdInput = new BufferedReader(new InputStreamReader(process.getInputStream()));
                            stdError = new BufferedReader(new InputStreamReader(process.getErrorStream()));
                            String s = null;
                            int work = 0;
                            try {
                                while ((s = stdInput.readLine()) != null) {
                                    outputStream.println(s);
                                    monitor.worked(++work);
                                }
                            }
                            catch (Exception ex) {
                                outputStream.println(ex.getMessage());
                            }
                            try {
                                while ((s = stdError.readLine()) != null) {
                                    outputStream.println(s);
                                    monitor.worked(++work);
                                }
                            }
                            catch (Exception ex) {
                                outputStream.println(ex.getMessage());
                            }
                            File outFile = new File(outName);
                            if (outFile.exists()) {
                                this.convertedSVG.add(outFile);
                                outputStream.println(MessageFormat.format(Messages.ConsolePdfConverter_consoleDone, outFile.getAbsolutePath()));
                            } else {
                                outputStream.println(Messages.ConsolePdfConverter_consoleFail);
                            }
                            monitor.done();
                        }
                        catch (Exception ex) {
                            ex.printStackTrace();
                            JaspersoftStudioPlugin.getInstance().logError((Throwable)ex);
                            outputStream.println(ex.getMessage());
                            FileUtils.closeStream(stdError);
                            FileUtils.closeStream(stdInput);
                            continue;
                        }
                    }
                    catch (Throwable throwable) {
                        FileUtils.closeStream(stdError);
                        FileUtils.closeStream(stdInput);
                        throw throwable;
                    }
                    FileUtils.closeStream((Closeable)stdError);
                    FileUtils.closeStream((Closeable)stdInput);
                }
                break block14;
            }
            InkscapeMessageDialog showInformationDialog = new InkscapeMessageDialog(UIUtils.getShell());
            result = showInformationDialog.open() == 0 ? this.doConversion(monitor) : Status.CANCEL_STATUS;
        }
        FileUtils.closeStream((Closeable)outputStream);
        return result;
    }

    private Pair<String, File> getInkscapeCommand() {
        String inkscapePath = PreferencesUtils.getJasperReportsProperty((String)INKSCAPE_PATH_PROPERTY);
        if (inkscapePath != null && !inkscapePath.trim().isEmpty()) {
            if (!inkscapePath.endsWith(File.pathSeparator)) {
                inkscapePath = String.valueOf(inkscapePath) + File.separator;
            }
            if (Util.isMac()) {
                return new Pair((Object)(String.valueOf(inkscapePath) + "inkscape"), null);
            }
            return new Pair((Object)(String.valueOf(inkscapePath) + "inkscape"), null);
        }
        Pair command = new Pair((Object)"inkscape", null);
        if (Util.isWindows()) {
            String winCommand = this.getWindowsDir();
            if (winCommand != null) {
                File windowsInkscapeFile = new File(winCommand);
                command = new Pair((Object)windowsInkscapeFile.getAbsolutePath(), (Object)windowsInkscapeFile.getParentFile());
            }
        } else if (Util.isMac()) {
            command = new Pair((Object)"/Applications/Inkscape.app/Contents/Resources/bin/inkscape", null);
        }
        return command;
    }

    private String getWindowsDir() {
        File windowsDefaultPath = new File("C:\\Program Files\\Inkscape\\inkscape.exe");
        if (!windowsDefaultPath.exists() && !(windowsDefaultPath = new File("C:\\Program Files (x86)\\Inkscape\\inkscape.exe")).exists()) {
            return null;
        }
        return FilenameUtils.removeExtension((String)windowsDefaultPath.getAbsolutePath());
    }

    private String getOutputFilename(File targetFile) {
        String tempDir = System.getProperty("java.io.tmpdir");
        String fileNameWithOutExt = FilenameUtils.removeExtension((String)targetFile.getName());
        File tempFile = new File(tempDir, String.valueOf(fileNameWithOutExt) + ".svg");
        int counter = 1;
        while (tempFile.exists()) {
            tempFile = new File(tempDir, String.valueOf(fileNameWithOutExt) + counter + ".svg");
            ++counter;
        }
        return tempFile.getAbsolutePath();
    }

    private MessageConsole getCleanConsole() {
        MessageConsole myConsole = ConsolePdfConverter.findConsole(CONSOLE_NAME);
        try {
            PlatformUI.getWorkbench().getActiveWorkbenchWindow().getActivePage().showView("org.eclipse.ui.console.ConsoleView");
        }
        catch (PartInitException e) {
            e.printStackTrace();
        }
        myConsole.clearConsole();
        return myConsole;
    }

    public static MessageConsole findConsole(String name) {
        ConsolePlugin plugin = ConsolePlugin.getDefault();
        IConsoleManager conMan = plugin.getConsoleManager();
        IConsole[] existing = conMan.getConsoles();
        int i = 0;
        while (i < existing.length) {
            if (name.equals(existing[i].getName())) {
                return (MessageConsole)existing[i];
            }
            ++i;
        }
        MessageConsole myConsole = new MessageConsole(name, null);
        conMan.addConsoles(new IConsole[]{myConsole});
        return myConsole;
    }

    public List<File> getConvertedFiles() {
        return this.convertedSVG;
    }
}

