/*
 * Decompiled with CFR 0.152.
 */
package com.jaspersoft.studio.data;

import com.jaspersoft.studio.data.messages.Messages;
import com.jaspersoft.studio.swt.widgets.table.DeleteButton;
import com.jaspersoft.studio.swt.widgets.table.EditButton;
import com.jaspersoft.studio.swt.widgets.table.IEditElement;
import com.jaspersoft.studio.swt.widgets.table.INewElement;
import com.jaspersoft.studio.swt.widgets.table.ListContentProvider;
import com.jaspersoft.studio.swt.widgets.table.ListOrderButtons;
import com.jaspersoft.studio.swt.widgets.table.NewButton;
import com.jaspersoft.studio.utils.UIUtil;
import java.util.ArrayList;
import java.util.List;
import net.sf.jasperreports.data.http.HttpLocationParameter;
import net.sf.jasperreports.data.http.RequestMethod;
import net.sf.jasperreports.data.http.StandardHttpDataLocation;
import net.sf.jasperreports.eclipse.ui.ATitledDialog;
import net.sf.jasperreports.eclipse.ui.util.UIUtils;
import net.sf.jasperreports.eclipse.util.Misc;
import org.eclipse.jface.viewers.CellLabelProvider;
import org.eclipse.jface.viewers.ColumnLabelProvider;
import org.eclipse.jface.viewers.ColumnViewer;
import org.eclipse.jface.viewers.ColumnViewerToolTipSupport;
import org.eclipse.jface.viewers.DoubleClickEvent;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.IDoubleClickListener;
import org.eclipse.jface.viewers.TableViewer;
import org.eclipse.jface.viewers.TableViewerColumn;
import org.eclipse.swt.custom.CTabFolder;
import org.eclipse.swt.custom.CTabItem;
import org.eclipse.swt.custom.StackLayout;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Combo;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Text;

public class HttpParametersDialog
extends ATitledDialog {
    private StandardHttpDataLocation dataFile;
    private CTabFolder tabFolder;
    private CTabItem bptab;

    protected HttpParametersDialog(Shell parentShell, StandardHttpDataLocation dataFile) {
        super(parentShell);
        this.setTitle(Messages.HttpParametersDialog_0);
        this.setDescription(Messages.HttpParametersDialog_3);
        this.dataFile = dataFile;
    }

    public StandardHttpDataLocation getDataFile() {
        return this.dataFile;
    }

    public void setDataFile(StandardHttpDataLocation dataFile) {
        this.dataFile = dataFile;
    }

    protected Control createDialogArea(Composite parent) {
        Composite cmp = (Composite)super.createDialogArea(parent);
        cmp.setLayout((Layout)new GridLayout(2, false));
        new Label(cmp, 0).setText(Messages.HttpParametersDialog_1);
        final Text user = new Text(cmp, 2048);
        user.setLayoutData((Object)new GridData(768));
        user.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent e) {
                HttpParametersDialog.this.dataFile.setUsername(user.getText());
            }
        });
        new Label(cmp, 0).setText(Messages.HttpParametersDialog_2);
        final Text password = new Text(cmp, 0x400800);
        password.setLayoutData((Object)new GridData(768));
        password.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent e) {
                HttpParametersDialog.this.dataFile.setPassword(password.getText());
            }
        });
        user.setText(Misc.nvl((String)this.dataFile.getUsername()));
        password.setText(Misc.nvl((String)this.dataFile.getPassword()));
        new Label(cmp, 0).setText(Messages.HttpParametersDialog_4);
        final Combo cmb = new Combo(cmp, 8);
        cmb.setItems(new String[]{RequestMethod.GET.name(), RequestMethod.POST.name(), RequestMethod.PUT.name()});
        if (this.dataFile.getMethod() == RequestMethod.POST) {
            cmb.select(1);
        } else if (this.dataFile.getMethod() == RequestMethod.PUT) {
            cmb.select(2);
        } else {
            cmb.select(0);
        }
        cmb.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                HttpParametersDialog.this.setupMethod(cmb);
            }
        });
        this.tabFolder = new CTabFolder(cmp, 0x800080);
        GridData gd = new GridData(1808);
        gd.horizontalSpan = 2;
        this.tabFolder.setLayoutData((Object)gd);
        if (this.dataFile.getUrlParameters() == null) {
            this.dataFile.setUrlParameters(new ArrayList());
        }
        if (this.dataFile.getPostParameters() == null) {
            this.dataFile.setPostParameters(new ArrayList());
        }
        if (this.dataFile.getHeaders() == null) {
            this.dataFile.setHeaders(new ArrayList());
        }
        final TableViewer tv = this.createParameters(this.tabFolder, Messages.HttpParametersDialog_5);
        this.tabFolder.setSelection(0);
        this.setupMethod(cmb);
        UIUtils.getDisplay().asyncExec(new Runnable(){

            @Override
            public void run() {
                tv.setInput((Object)HttpParametersDialog.this.dataFile.getUrlParameters());
            }
        });
        final TableViewer tvh = this.createParameters(this.tabFolder, Messages.HttpParametersDialog_8);
        UIUtils.getDisplay().asyncExec(new Runnable(){

            @Override
            public void run() {
                tvh.setInput((Object)HttpParametersDialog.this.dataFile.getHeaders());
            }
        });
        return cmp;
    }

    private TableViewer createParameters(CTabFolder tFolder, String title) {
        CTabItem bptab = new CTabItem(tFolder, 0);
        bptab.setText(title);
        Composite cmp = new Composite((Composite)tFolder, 0);
        cmp.setLayout((Layout)new GridLayout(2, false));
        TableViewer tviewer = this.createParametersTable(cmp);
        bptab.setControl((Control)cmp);
        return tviewer;
    }

    private TableViewer createParametersBody(CTabFolder tFolder, String title) {
        this.bptab = new CTabItem(tFolder, 0, 1);
        this.bptab.setText(title);
        Composite cmp = new Composite((Composite)tFolder, 0);
        cmp.setLayout((Layout)new GridLayout());
        final Button bBody = new Button(cmp, 32);
        bBody.setText(Messages.HttpParametersDialog_10);
        bBody.setSelection(this.dataFile.getBody() != null);
        final Composite cmpStack = new Composite(cmp, 0);
        final StackLayout slayout = new StackLayout();
        cmpStack.setLayout((Layout)slayout);
        final Text tBody = new Text(cmpStack, 834);
        tBody.setText(Misc.nvl((String)this.dataFile.getBody()));
        tBody.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent e) {
                HttpParametersDialog.this.dataFile.setBody(tBody.getText());
            }
        });
        final Composite cmpTbl = new Composite(cmpStack, 0);
        cmpTbl.setLayout((Layout)new GridLayout(2, false));
        TableViewer tviewer = this.createParametersTable(cmpTbl);
        bBody.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                slayout.topControl = bBody.getSelection() ? tBody : cmpTbl;
                cmpStack.layout();
                if (!bBody.getSelection()) {
                    HttpParametersDialog.this.dataFile.setBody(null);
                } else {
                    HttpParametersDialog.this.dataFile.setBody(tBody.getText());
                }
            }
        });
        slayout.topControl = bBody.getSelection() ? tBody : cmpTbl;
        this.bptab.setControl((Control)cmp);
        return tviewer;
    }

    private TableViewer createParametersTable(Composite cmp) {
        TableViewer tviewer = new TableViewer(cmp, 68098);
        GridData gd = new GridData(1808);
        gd.widthHint = 500;
        gd.heightHint = 200;
        tviewer.getTable().setLayoutData((Object)gd);
        tviewer.getTable().setHeaderVisible(true);
        TableViewerColumn column = new TableViewerColumn(tviewer, 0);
        column.getColumn().setText(Messages.HttpParametersDialog_6);
        column.getColumn().setWidth(250);
        column.setLabelProvider((CellLabelProvider)new ColumnLabelProvider(){

            public String getText(Object element) {
                return ((HttpLocationParameter)element).getName();
            }

            public String getToolTipText(Object element) {
                return ((HttpLocationParameter)element).getName();
            }
        });
        column = new TableViewerColumn(tviewer, 0);
        column.getColumn().setText(Messages.HttpParametersDialog_7);
        column.getColumn().setWidth(250);
        column.setLabelProvider((CellLabelProvider)new ColumnLabelProvider(){

            public String getText(Object element) {
                return ((HttpLocationParameter)element).getValue();
            }

            public String getToolTipText(Object element) {
                return ((HttpLocationParameter)element).getValue();
            }
        });
        tviewer.setContentProvider((IContentProvider)new ListContentProvider());
        ColumnViewerToolTipSupport.enableFor((ColumnViewer)tviewer, (int)2);
        UIUtil.setViewerCellEditingOnDblClick((TableViewer)tviewer);
        Composite bGroup = new Composite(cmp, 0);
        bGroup.setLayout((Layout)new GridLayout(1, false));
        bGroup.setLayoutData((Object)new GridData(1040));
        new NewButton().createNewButtons(bGroup, tviewer, new INewElement(){

            public Object newElement(List<?> input, int pos) {
                HttpLocationParameter hlp = new HttpLocationParameter(Messages.HttpParametersDialog_12, Messages.HttpParametersDialog_13);
                PEditDialog pd = new PEditDialog(UIUtils.getShell(), hlp);
                if (pd.open() == 0) {
                    hlp.setName(pd.getPName());
                    hlp.setValue(pd.getPValue());
                    return hlp;
                }
                return null;
            }
        });
        final EditButton bEditPrm = new EditButton();
        bEditPrm.createEditButtons(bGroup, tviewer, (IEditElement)new IEditElement<HttpLocationParameter>(){

            public void editElement(List<HttpLocationParameter> input, int pos) {
                HttpLocationParameter hlp = input.get(pos);
                PEditDialog pd = new PEditDialog(UIUtils.getShell(), hlp);
                if (pd.open() == 0) {
                    hlp.setName(pd.getPName());
                    hlp.setValue(pd.getPValue());
                }
            }
        });
        tviewer.addDoubleClickListener(new IDoubleClickListener(){

            public void doubleClick(DoubleClickEvent event) {
                bEditPrm.push();
            }
        });
        DeleteButton delb = new DeleteButton();
        delb.createDeleteButton(bGroup, tviewer);
        new ListOrderButtons().createOrderButtons(bGroup, tviewer);
        return tviewer;
    }

    private void setupMethod(Combo cmb) {
        if (this.bptab != null) {
            this.bptab.dispose();
            this.bptab = null;
        }
        switch (cmb.getSelectionIndex()) {
            case 0: {
                this.dataFile.setMethod(RequestMethod.GET);
                int i = 0;
                while (i < this.tabFolder.getItemCount()) {
                    CTabItem item = this.tabFolder.getItem(i);
                    if (item.getText().equals(Messages.HttpParametersDialog_14)) {
                        item.dispose();
                    }
                    ++i;
                }
                break;
            }
            case 1: {
                this.dataFile.setMethod(RequestMethod.POST);
                final TableViewer tvp = this.createParametersBody(this.tabFolder, Messages.HttpParametersDialog_14);
                UIUtils.getDisplay().asyncExec(new Runnable(){

                    @Override
                    public void run() {
                        tvp.setInput((Object)HttpParametersDialog.this.dataFile.getPostParameters());
                    }
                });
                break;
            }
            case 2: {
                this.dataFile.setMethod(RequestMethod.PUT);
                final TableViewer tvput = this.createParametersBody(this.tabFolder, Messages.HttpParametersDialog_11);
                UIUtils.getDisplay().asyncExec(new Runnable(){

                    @Override
                    public void run() {
                        tvput.setInput((Object)HttpParametersDialog.this.dataFile.getPostParameters());
                    }
                });
            }
        }
    }

    protected class PEditDialog
    extends ATitledDialog {
        private String pname;
        private String pvalue;

        protected PEditDialog(Shell parentShell, HttpLocationParameter hlp) {
            super(parentShell);
            this.pname = hlp.getName();
            this.pvalue = hlp.getValue();
            this.setTitle(Messages.HttpParametersDialog_9);
            this.setDefaultSize(500, 200);
        }

        protected Control createDialogArea(Composite parent) {
            Composite composite = (Composite)super.createDialogArea(parent);
            composite.setLayout((Layout)new GridLayout(2, false));
            Label label = new Label(composite, 0);
            label.setText(Messages.HttpParametersDialog_6);
            final Text text = new Text(composite, 2048);
            text.setLayoutData((Object)new GridData(768));
            text.setText(Misc.nvl((Object)this.pname, (String)"net.sf.jasperreports."));
            text.addModifyListener(new ModifyListener(){

                public void modifyText(ModifyEvent e) {
                    PEditDialog.this.pname = text.getText();
                }
            });
            label = new Label(composite, 0);
            label.setText(Messages.HttpParametersDialog_7);
            final Text tname = new Text(composite, 2048);
            tname.setLayoutData((Object)new GridData(768));
            tname.setText(Misc.nvl((Object)this.pvalue, (String)Messages.HttpParametersDialog_7));
            tname.addModifyListener(new ModifyListener(){

                public void modifyText(ModifyEvent e) {
                    PEditDialog.this.pvalue = tname.getText();
                }
            });
            PEditDialog.applyDialogFont((Control)composite);
            return composite;
        }

        public String getPName() {
            return this.pname;
        }

        public String getPValue() {
            return this.pvalue;
        }
    }
}

