/*
 * Decompiled with CFR 0.152.
 */
package com.jaspersoft.studio.data.excel;

import com.jaspersoft.studio.data.DataAdapterDescriptor;
import com.jaspersoft.studio.data.adapter.IDataAdapterCreator;
import com.jaspersoft.studio.data.excel.ExcelDataAdapterDescriptor;
import java.util.ArrayList;
import java.util.Collections;
import net.sf.jasperreports.data.DataAdapter;
import net.sf.jasperreports.data.excel.ExcelDataAdapterImpl;
import net.sf.jasperreports.eclipse.util.DataFileUtils;
import org.w3c.dom.Document;
import org.w3c.dom.NamedNodeMap;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public class ExcelCreator
implements IDataAdapterCreator {
    public DataAdapterDescriptor buildFromXML(Document docXML) {
        ExcelDataAdapterImpl result = new ExcelDataAdapterImpl();
        NamedNodeMap rootAttributes = docXML.getChildNodes().item(0).getAttributes();
        String connectionName = rootAttributes.getNamedItem("name").getTextContent();
        result.setName(connectionName);
        NodeList children = docXML.getChildNodes().item(0).getChildNodes();
        ArrayList<Column> colIndexes = new ArrayList<Column>();
        ArrayList<Column> colNames = new ArrayList<Column>();
        int i = 0;
        while (i < children.getLength()) {
            Node node = children.item(i);
            if (node.getNodeName().equals("connectionParameter")) {
                int index;
                String paramName = node.getAttributes().getNamedItem("name").getTextContent();
                String textContent = node.getTextContent();
                if (paramName.startsWith("INDEX_")) {
                    index = Integer.parseInt(paramName.substring(paramName.lastIndexOf("_") + 1));
                    colIndexes.add(new Column(index, textContent));
                }
                if (paramName.startsWith("COLUMN_")) {
                    index = Integer.parseInt(paramName.substring(paramName.lastIndexOf("_") + 1));
                    colNames.add(new Column(index, textContent));
                }
                if (paramName.equals("useFirstRowAsHeader")) {
                    result.setUseFirstRowAsHeader(textContent.equals("true"));
                }
                if (paramName.equals("customDateFormat")) {
                    result.setDatePattern(textContent);
                }
                if (paramName.equals("customNumberFormat")) {
                    result.setNumberPattern(textContent);
                }
                if (paramName.equals("Filename")) {
                    result.setDataFile(DataFileUtils.getDataFile((String)textContent));
                }
            }
            ++i;
        }
        Collections.sort(colNames);
        ArrayList<String> names = new ArrayList<String>();
        for (Column col : colNames) {
            names.add(col.getValue().toString());
        }
        result.setColumnNames(names);
        Collections.sort(colIndexes);
        ArrayList<Integer> indexes = new ArrayList<Integer>();
        for (Column col : colIndexes) {
            indexes.add(Integer.parseInt(col.getValue().toString()));
        }
        result.setColumnIndexes(indexes);
        ExcelDataAdapterDescriptor desc = new ExcelDataAdapterDescriptor();
        desc.setDataAdapter((DataAdapter)result);
        return desc;
    }

    public String getID() {
        return "com.jaspersoft.ireport.designer.connection.JRExcelDataSourceConnection";
    }

    private class Column
    implements Comparable<Column> {
        private Object value;
        private int index;

        public Column(int index, Object value) {
            this.index = index;
            this.value = value;
        }

        @Override
        public int compareTo(Column o) {
            return this.index - o.getIndex();
        }

        public int getIndex() {
            return this.index;
        }

        public Object getValue() {
            return this.value;
        }
    }
}

