/*
 * Decompiled with CFR 0.152.
 */
package com.jaspersoft.studio.data.jdbc;

import com.jaspersoft.studio.data.jdbc.JDBCDriverDefinition;
import com.jaspersoft.studio.data.jdbc.JDBCDriverDefinitionsContainer;
import java.util.ArrayList;
import java.util.List;

public class CommunityJDBCDriverDefinitions
implements JDBCDriverDefinitionsContainer {
    private static final List<JDBCDriverDefinition> driverDefinitions = new ArrayList<JDBCDriverDefinition>();

    static {
        driverDefinitions.add(new JDBCDriverDefinition("HSQLDB (server)", "org.hsqldb.jdbcDriver", "jdbc:hsqldb:hsql://{0}"));
        driverDefinitions.add(new JDBCDriverDefinition("HSQLDB (file)", "org.hsqldb.jdbcDriver", "jdbc:hsqldb:[PATH_TO_DB_FILES]/{1}"));
        driverDefinitions.add(new JDBCDriverDefinition("H2 (file)", "org.h2.Driver", "jdbc:h2:file:{1}"));
        driverDefinitions.add(new JDBCDriverDefinition("H2 (tco)", "org.h2.Driver", "jdbc:h2:tcp://{0}:9101/~/{1}"));
        driverDefinitions.add(new JDBCDriverDefinition("SQLite (file)", "org.sqlite.JDBC", "jdbc:sqlite:[PATH_TO_DB_FILES]/{1}"));
        driverDefinitions.add(new JDBCDriverDefinition("DerbyDB (Embedded)", "org.apache.derby.jdbc.EmbeddedDriver", "jdbc:derby:/{1}"));
        driverDefinitions.add(new JDBCDriverDefinition("DerbyDB (Client)", "org.apache.derby.jdbc.ClientDriver", "jdbc:derby://{0}[:1527]/{1}"));
        driverDefinitions.add(new JDBCDriverDefinition("Cloudscape", "COM.cloudscape.JDBCDriver", "jdbc:cloudscape:/{1}"));
        driverDefinitions.add(new JDBCDriverDefinition("Firebird", "org.firebirdsql.jdbc.FBDriver", "jdbc:firebirdsql://{0}:3050/{1}"));
        driverDefinitions.add(new JDBCDriverDefinition("IBM DB2 (Type 4)", "com.ibm.db2.jcc.DB2Driver", "jdbc:db2://{0}/{1}"));
        driverDefinitions.add(new JDBCDriverDefinition("IBM DB2 (IBM Cloudscape\u00ae server)", "com.ibm.db2.jcc.DB2Driver", "jdbc:db2j:net://{0}/{1}"));
        driverDefinitions.add(new JDBCDriverDefinition("IBM DB2 (IDS data source)", "com.ibm.db2.jcc.DB2Driver", "jdbc:ids://{0}/{1}"));
        driverDefinitions.add(new JDBCDriverDefinition("inetdae7", "com.inet.tds.TdsDriver", "jdbc:inetdae7:{0}:1433/{1}"));
        driverDefinitions.add(new JDBCDriverDefinition("Informix", "com.informix.jdbc.IfxDriver", "jdbc:informix-sqli://{0}:informixserver={1}"));
        driverDefinitions.add(new JDBCDriverDefinition("Ingres", "com.ingres.jdbc.IngresDriver", "jdbc:ingres://{0}:II7/{1}"));
        driverDefinitions.add(new JDBCDriverDefinition("JDBC-ODBC Bridge", "sun.jdbc.odbc.JdbcOdbcDriver", "jdbc:odbc:{1}", "DSNAME"));
        driverDefinitions.add(new JDBCDriverDefinition("JDBC-ODBC Bridge", "com.ms.jdbc.odbc.JdbcOdbcDriver", "jdbc:odbc:{1}", "DSNAME"));
        driverDefinitions.add(new JDBCDriverDefinition("MS SQLServer (2000)", "com.microsoft.jdbc.sqlserver.SQLServerDriver", "jdbc:microsoft:sqlserver://{0}:1433;DatabaseName={1}"));
        driverDefinitions.add(new JDBCDriverDefinition("MS SQLServer (2005-2012)", "com.microsoft.sqlserver.jdbc.SQLServerDriver", "jdbc:sqlserver://{0}:1433;databaseName={1}"));
        driverDefinitions.add(new JDBCDriverDefinition("MS SQLServer", "net.sourceforge.jtds.jdbc.Driver", "jdbc:jtds:sqlserver://{0}/{1}"));
        driverDefinitions.add(new JDBCDriverDefinition("MS SQLServer", "com.merant.datadirect.jdbc.sqlserver.SQLServerDriver", "jdbc:sqlserver://{0}:1433/{1}"));
        driverDefinitions.add(new JDBCDriverDefinition("MS SQLServer", "com.internetcds.jdbc.tds.Driver", "jdbc:freetds:sqlserver://{0}/{1}"));
        driverDefinitions.add(new JDBCDriverDefinition("MySQL", "org.gjt.mm.mysql.Driver", "jdbc:mysql://{0}/{1}"));
        driverDefinitions.add(new JDBCDriverDefinition("MySQL", "com.mysql.jdbc.Driver", "jdbc:mysql://{0}/{1}"));
        driverDefinitions.add(new JDBCDriverDefinition("MariaDB", "org.mariadb.jdbc.Driver", "jdbc:mariadb://{0}:3306/{1}"));
        driverDefinitions.add(new JDBCDriverDefinition("Oracle", "oracle.jdbc.driver.OracleDriver", "jdbc:oracle:thin:@{0}:1521:{1}"));
        driverDefinitions.add(new JDBCDriverDefinition("PostgreSQL", "org.postgresql.Driver", "jdbc:postgresql://{0}:5432/{1}"));
        driverDefinitions.add(new JDBCDriverDefinition("Sybase", "com.sybase.jdbc4.jdbc.SybDriver", "jdbc:sybase:Tds:{0}:2638/{1}"));
        driverDefinitions.add(new JDBCDriverDefinition("Hadoop Hive", "org.apache.hadoop.hive.jdbc.HiveDriver", "jdbc:hive://{0}:10000/default"));
        driverDefinitions.add(new JDBCDriverDefinition("Vertica", "com.vertica.Driver", "jdbc:vertica://{0}:5433/{1}"));
        driverDefinitions.add(new JDBCDriverDefinition("Vertica", "com.vertica.jdbc.Driver", "jdbc:vertica://{0}:5433/{1}"));
        driverDefinitions.add(new JDBCDriverDefinition("Mondrian", "mondrian.olap4j.MondrianOlap4jDriver", "jdbc:mondrian:"));
        driverDefinitions.add(new JDBCDriverDefinition("OLAP4J", "org.olap4j.driver.xmla.XmlaOlap4jDriver", "jdbc:xmla:"));
    }

    public List<JDBCDriverDefinition> getJDBCDriverDefinitions() {
        return driverDefinitions;
    }
}

