/*
 * Decompiled with CFR 0.152.
 */
package com.jaspersoft.studio.data.mondrian;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import net.sf.jasperreports.engine.JRRuntimeException;
import net.sf.jasperreports.engine.design.JRDesignField;
import net.sf.jasperreports.olap.result.JROlapHierarchy;
import net.sf.jasperreports.olap.result.JROlapHierarchyLevel;
import net.sf.jasperreports.olap.result.JROlapMember;
import net.sf.jasperreports.olap.result.JROlapMemberTuple;
import net.sf.jasperreports.olap.result.JROlapResult;
import net.sf.jasperreports.olap.result.JROlapResultAxis;

public class OlapFieldsProviderSupport {
    private static final String PREFIX_COLUMNS = "Columns";
    private static final String PREFIX_ROWS = "Rows";
    private static final String PREFIX_PAGES = "Pages";
    private static final String PREFIX_CHAPTERS = "Chapters";
    private static final String PREFIX_SECTIONS = "Sections";

    public static List<JRDesignField> getFieldsFromResult(JROlapResult result) {
        HashMap<String, JRDesignField> fields = new HashMap<String, JRDesignField>();
        HashSet<String> measureNames = new HashSet<String>();
        int axisCount = 0;
        int measureLevelAxisIndex = 0;
        JROlapResultAxis[] jROlapResultAxisArray = result.getAxes();
        int n = jROlapResultAxisArray.length;
        int n2 = 0;
        while (n2 < n) {
            JROlapResultAxis axis = jROlapResultAxisArray[n2];
            String prefix = null;
            switch (axisCount) {
                case 0: {
                    prefix = PREFIX_COLUMNS;
                    break;
                }
                case 1: {
                    prefix = PREFIX_ROWS;
                    break;
                }
                case 2: {
                    prefix = PREFIX_PAGES;
                    break;
                }
                case 3: {
                    prefix = PREFIX_CHAPTERS;
                    break;
                }
                case 4: {
                    prefix = PREFIX_SECTIONS;
                    break;
                }
                default: {
                    throw new JRRuntimeException("Unknown axis #: " + axisCount);
                }
            }
            JROlapHierarchy[] jROlapHierarchyArray = axis.getHierarchiesOnAxis();
            int n3 = jROlapHierarchyArray.length;
            int n4 = 0;
            while (n4 < n3) {
                JROlapHierarchy hier = jROlapHierarchyArray[n4];
                boolean foundMeasuresLevel = false;
                JROlapHierarchyLevel[] jROlapHierarchyLevelArray = hier.getLevels();
                int n5 = jROlapHierarchyLevelArray.length;
                int n6 = 0;
                while (n6 < n5) {
                    JROlapHierarchyLevel level = jROlapHierarchyLevelArray[n6];
                    if (level != null) {
                        if (level.getName().equalsIgnoreCase("MeasuresLevel")) {
                            foundMeasuresLevel = true;
                            measureLevelAxisIndex = axisCount;
                        } else {
                            String rowsExpression = String.valueOf(prefix) + OlapFieldsProviderSupport.makeOlapExpression(hier.getDimensionName()) + "[" + level.getName() + "]";
                            OlapFieldsProviderSupport.addField(OlapFieldsProviderSupport.makeJRFieldName(String.valueOf(hier.getDimensionName()) + level.getName()), rowsExpression, "java.lang.String", fields);
                        }
                    }
                    ++n6;
                }
                if (foundMeasuresLevel) {
                    int i = 0;
                    while (i < axis.getTupleCount()) {
                        JROlapMemberTuple memberTuple = axis.getTuple(i);
                        int j = 0;
                        while (j < memberTuple.getMembers().length) {
                            JROlapMember member = memberTuple.getMembers()[j];
                            if (OlapFieldsProviderSupport.isMeasureMember(member.getUniqueName()) && !measureNames.contains(member.getUniqueName())) {
                                measureNames.add(member.getUniqueName());
                            }
                            ++j;
                        }
                        ++i;
                    }
                }
                ++n4;
            }
            ++axisCount;
            ++n2;
        }
        for (String measureName : measureNames) {
            OlapFieldsProviderSupport.addField(OlapFieldsProviderSupport.makeJRFieldName(measureName), OlapFieldsProviderSupport.generateMeasureAxisExpression(measureLevelAxisIndex, axisCount - 1, measureName), "java.lang.Number", fields);
        }
        ArrayList<JRDesignField> returnedList = new ArrayList<JRDesignField>(fields.size());
        for (String key : fields.keySet()) {
            returnedList.add((JRDesignField)fields.get(key));
        }
        return returnedList;
    }

    private static String generateMeasureAxisExpression(int measureLevelIndex, int axisNumber, String measureName) {
        StringBuilder result = new StringBuilder();
        result.append("Data(");
        int i = 0;
        while (i <= axisNumber) {
            if (i == measureLevelIndex) {
                result.append(measureName);
            } else {
                result.append("?");
            }
            if (i != axisNumber) {
                result.append(",");
            }
            ++i;
        }
        result.append(")");
        return result.toString();
    }

    private static void addField(String name, String description, String type, Map<String, JRDesignField> fieldsMap) {
        JRDesignField f = new JRDesignField();
        f.setName(name);
        f.setDescription(description);
        f.getPropertiesMap().setProperty("net.sf.jasperreports.olap.field.mapping", description);
        f.setValueClassName(type);
        fieldsMap.put(name, f);
    }

    private static String makeJRFieldName(String s) {
        String out = s.replace(" ", "");
        out = out.replace("[", "");
        out = out.replace("]", "");
        out = out.replace("(", "");
        out = out.replace(")", "");
        out = out.replace(".", "");
        return out;
    }

    private static String makeOlapExpression(String s) {
        String out = s.trim();
        int pos = out.indexOf("].[");
        if (pos != -1) {
            out = out.substring(pos + 2);
        }
        if (out.charAt(0) != '[') {
            out = "[" + out;
        }
        if (out.charAt(out.length() - 1) != ']') {
            out = String.valueOf(out) + "]";
        }
        return out;
    }

    private static boolean isMeasureMember(String uniqueName) {
        return uniqueName.startsWith("[Measures].");
    }
}

