/*
 * Decompiled with CFR 0.152.
 */
package com.jaspersoft.studio.data.xml;

import com.jaspersoft.studio.data.ATreeWizardDataEditorComposite;
import com.jaspersoft.studio.data.DataAdapterDescriptor;
import com.jaspersoft.studio.data.designer.tree.NodeBoldStyledLabelProvider;
import com.jaspersoft.studio.data.messages.Messages;
import com.jaspersoft.studio.data.querydesigner.xpath.XMLDocumentManager;
import com.jaspersoft.studio.data.querydesigner.xpath.XMLTreeCustomStatus;
import com.jaspersoft.studio.data.querydesigner.xpath.XPathTreeViewerContentProvider;
import com.jaspersoft.studio.model.datasource.xml.XMLNode;
import com.jaspersoft.studio.utils.XMLUtils;
import com.jaspersoft.studio.utils.jasper.JasperReportsConfiguration;
import java.io.IOException;
import java.io.InputStream;
import java.util.HashMap;
import javax.xml.parsers.ParserConfigurationException;
import net.sf.jasperreports.data.DataFile;
import net.sf.jasperreports.data.DataFileStream;
import net.sf.jasperreports.data.DataFileUtils;
import net.sf.jasperreports.data.xml.XmlDataAdapter;
import net.sf.jasperreports.eclipse.ui.util.UIUtils;
import net.sf.jasperreports.engine.JRException;
import net.sf.jasperreports.engine.JasperReportsContext;
import net.sf.jasperreports.engine.ParameterContributorContext;
import net.sf.jasperreports.engine.design.JasperDesign;
import net.sf.jasperreports.engine.util.JRXmlUtils;
import org.apache.commons.io.IOUtils;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.jface.viewers.DoubleClickEvent;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.IDoubleClickListener;
import org.eclipse.jface.viewers.TreeSelection;
import org.eclipse.jface.wizard.WizardPage;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.ui.progress.WorkbenchJob;
import org.w3c.dom.Document;
import org.xml.sax.SAXException;

public class XMLWizardDataEditorComposite
extends ATreeWizardDataEditorComposite {
    private static final int JOB_DELAY = 300;
    private XMLDocumentManager documentManager;
    private DecorateTreeViewerJob decorateJob;
    private NodeBoldStyledLabelProvider<XMLNode> treeLabelProvider;
    private XPathTreeViewerContentProvider treeContentProvider;

    public XMLWizardDataEditorComposite(Composite parent, WizardPage page, DataAdapterDescriptor dataAdapterDescriptor) {
        super(parent, page, dataAdapterDescriptor);
    }

    protected void init() {
        super.init();
        this.documentManager = new XMLDocumentManager();
        this.decorateJob = new DecorateTreeViewerJob();
        this.treeLabelProvider = new NodeBoldStyledLabelProvider();
        this.treeContentProvider = new XPathTreeViewerContentProvider();
    }

    protected IBaseLabelProvider getTreeLabelProvider() {
        return this.treeLabelProvider;
    }

    protected IContentProvider getTreeContentProvider() {
        return this.treeContentProvider;
    }

    protected void refreshTreeViewerContent(final DataAdapterDescriptor da) {
        if (da != null && da.getDataAdapter() instanceof XmlDataAdapter) {
            this.treeViewer.setInput((Object)XMLTreeCustomStatus.LOADING_XML);
            UIUtils.getDisplay().asyncExec(new Runnable(){

                @Override
                public void run() {
                    JasperReportsConfiguration jConfig = XMLWizardDataEditorComposite.this.getJasperReportsConfiguration();
                    try {
                        XMLWizardDataEditorComposite.this.documentManager.setDocument(XMLWizardDataEditorComposite.this.getXMLDocument(da));
                        XMLWizardDataEditorComposite.this.documentManager.setJasperConfiguration(jConfig);
                        XMLWizardDataEditorComposite.this.treeViewer.setInput((Object)XMLWizardDataEditorComposite.this.documentManager.getXMLDocumentModel());
                        XMLWizardDataEditorComposite.this.treeViewer.expandToLevel(2);
                        XMLWizardDataEditorComposite.this.decorateTreeUsingQueryText();
                    }
                    catch (Exception e) {
                        XMLWizardDataEditorComposite.this.getStatusBar().showError((Throwable)e);
                        XMLWizardDataEditorComposite.this.treeViewer.getTree().removeAll();
                        XMLWizardDataEditorComposite.this.treeViewer.setInput((Object)XMLTreeCustomStatus.ERROR_LOADING_XML);
                    }
                }
            });
        } else {
            this.treeViewer.getTree().removeAll();
            this.treeViewer.setInput((Object)XMLTreeCustomStatus.FILE_NOT_FOUND);
        }
    }

    protected void createTreeViewer(Composite parent) {
        super.createTreeViewer(parent);
        this.addDoubleClickSupport();
    }

    private void addDoubleClickSupport() {
        this.treeViewer.addDoubleClickListener(new IDoubleClickListener(){

            public void doubleClick(DoubleClickEvent event) {
                TreeSelection s = (TreeSelection)XMLWizardDataEditorComposite.this.treeViewer.getSelection();
                if (s.getFirstElement() instanceof XMLNode) {
                    XMLNode xmlNode = (XMLNode)s.getFirstElement();
                    String xPathExpression = XMLWizardDataEditorComposite.this.documentManager.getXPathExpression(null, xmlNode);
                    XMLWizardDataEditorComposite.this.queryTextArea.setText(xPathExpression != null ? xPathExpression : "");
                }
            }
        });
    }

    protected void decorateTreeUsingQueryText() {
        if (this.documentManager.isDocumentSet()) {
            this.decorateJob.cancel();
            this.decorateJob.schedule(300L);
        }
    }

    public void dispose() {
        if (this.decorateJob != null) {
            this.decorateJob.cancel();
            this.decorateJob = null;
        }
        super.dispose();
    }

    public String getQueryLanguage() {
        return "xPath";
    }

    protected Document getXMLDocument(DataAdapterDescriptor da) throws SAXException, IOException, ParserConfigurationException, JRException {
        Document doc = null;
        DataFileStream ins = null;
        try {
            DataFile df = ((XmlDataAdapter)da.getDataAdapter()).getDataFile();
            HashMap parameters = new HashMap();
            ins = DataFileUtils.instance((ParameterContributorContext)new ParameterContributorContext((JasperReportsContext)this.getJasperReportsConfiguration(), null, null)).getDataStream(df, parameters);
            doc = JRXmlUtils.parse((InputStream)ins, (boolean)XMLUtils.isNamespaceAware((XmlDataAdapter)((XmlDataAdapter)da.getDataAdapter()), (JasperDesign)this.getJasperReportsConfiguration().getJasperDesign()));
        }
        catch (Throwable throwable) {
            IOUtils.closeQuietly(ins);
            throw throwable;
        }
        IOUtils.closeQuietly((InputStream)ins);
        return doc;
    }

    private final class DecorateTreeViewerJob
    extends WorkbenchJob {
        public DecorateTreeViewerJob() {
            super(Messages.XPathWizardDataEditorComposite_RefreshJobTitle);
            this.setSystem(true);
        }

        public IStatus runInUIThread(IProgressMonitor monitor) {
            if (!XMLWizardDataEditorComposite.this.isDisposed()) {
                monitor.beginTask(Messages.XPathWizardDataEditorComposite_TaskName, -1);
                String query = XMLWizardDataEditorComposite.this.queryTextArea.getText();
                XMLWizardDataEditorComposite.this.treeLabelProvider.setSelectedNodes(XMLWizardDataEditorComposite.this.documentManager.getSelectableNodes(query));
                XMLWizardDataEditorComposite.this.treeViewer.refresh();
                monitor.done();
                return Status.OK_STATUS;
            }
            return Status.CANCEL_STATUS;
        }
    }
}

