/*
 * Decompiled with CFR 0.152.
 */
package de.itemis.xtext.utils.jface.viewers;

import com.google.inject.Injector;
import de.itemis.utils.jface.viewers.StyledTextCellEditor;
import de.itemis.xtext.utils.jface.fieldassist.CompletionProposalAdapter;
import de.itemis.xtext.utils.jface.viewers.ContextElementAdapter;
import de.itemis.xtext.utils.jface.viewers.FilteringMenuManager;
import de.itemis.xtext.utils.jface.viewers.StyledTextXtextAdapter;
import de.itemis.xtext.utils.jface.viewers.context.IXtextFakeContextResourcesProvider;
import org.eclipse.jface.action.MenuManager;
import org.eclipse.jface.bindings.keys.KeyStroke;
import org.eclipse.jface.text.ITextListener;
import org.eclipse.jface.text.TextEvent;
import org.eclipse.jface.text.contentassist.IContentAssistant;
import org.eclipse.swt.SWT;
import org.eclipse.swt.custom.StyledText;
import org.eclipse.swt.events.FocusAdapter;
import org.eclipse.swt.events.FocusEvent;
import org.eclipse.swt.events.FocusListener;
import org.eclipse.swt.events.KeyEvent;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Listener;
import org.eclipse.swt.widgets.Menu;
import org.eclipse.ui.IWorkbenchPartSite;
import org.eclipse.ui.IWorkbenchWindow;
import org.eclipse.ui.PlatformUI;

public class XtextStyledTextCellEditor
extends StyledTextCellEditor {
    private Injector injector;
    private StyledTextXtextAdapter xtextAdapter;
    private IXtextFakeContextResourcesProvider contextFakeResourceProvider;
    private ContextElementAdapter.IContextElementProvider provider;
    private static final String CONTEXTMENUID = "de.itemis.xtext.utils.jface.viewers.StyledTextXtextAdapterContextMenu";
    private boolean ignoreNextFocusLost = false;
    private CompletionProposalAdapter completionProposalAdapter;

    public XtextStyledTextCellEditor(int style, Injector injector, IXtextFakeContextResourcesProvider contextFakeResourceProvider) {
        this(style, injector);
        this.contextFakeResourceProvider = contextFakeResourceProvider;
    }

    public XtextStyledTextCellEditor(int style, Injector injector) {
        this.setStyle(style);
        this.injector = injector;
    }

    public XtextStyledTextCellEditor(int style, Injector injector, ContextElementAdapter.IContextElementProvider provider) {
        this.setStyle(style);
        this.provider = provider;
        this.injector = injector;
    }

    @Override
    protected Control createControl(Composite parent) {
        StyledText styledText = (StyledText)super.createControl(parent);
        styledText.addFocusListener((FocusListener)new FocusAdapter(){

            public void focusLost(FocusEvent e) {
                XtextStyledTextCellEditor.this.focusLost();
            }
        });
        this.xtextAdapter = new StyledTextXtextAdapter(this.injector, this.contextFakeResourceProvider == null ? IXtextFakeContextResourcesProvider.NULL_CONTEXT_PROVIDER : this.contextFakeResourceProvider);
        this.xtextAdapter.adapt(styledText);
        if (this.provider != null) {
            this.xtextAdapter.getFakeResourceContext().getFakeResource().eAdapters().add((Object)new ContextElementAdapter(this.provider));
        }
        IContentAssistant contentAssistant = this.xtextAdapter.getContentAssistant();
        this.completionProposalAdapter = new CompletionProposalAdapter((Control)styledText, contentAssistant, KeyStroke.getInstance((int)262144, (int)32), null);
        this.xtextAdapter.getXtextSourceviewer().addTextListener(new ITextListener(){

            public void textChanged(TextEvent event) {
                XtextStyledTextCellEditor.this.editOccured(null);
            }
        });
        if ((styledText.getStyle() & 4) != 0) {
            styledText.addListener(3005, new Listener(){

                public void handleEvent(Event event) {
                    if (event.character == '\r' && !XtextStyledTextCellEditor.this.completionProposalAdapter.isProposalPopupOpen()) {
                        XtextStyledTextCellEditor.this.focusLost();
                    }
                }
            });
        }
        styledText.addListener(3005, new Listener(){

            public void handleEvent(Event event) {
                if (event.character == '\u001b' && !XtextStyledTextCellEditor.this.completionProposalAdapter.isProposalPopupOpen()) {
                    XtextStyledTextCellEditor.this.fireCancelEditor();
                }
            }
        });
        this.initContextMenu((Control)styledText);
        return styledText;
    }

    protected void initContextMenu(Control control) {
        MenuManager menuManager = this.createMenuManager();
        Menu contextMenu = menuManager.createContextMenu(control);
        control.setMenu(contextMenu);
        IWorkbenchWindow window = PlatformUI.getWorkbench().getActiveWorkbenchWindow();
        IWorkbenchPartSite site = window.getActivePage().getActiveEditor().getSite();
        site.registerContextMenu(CONTEXTMENUID, menuManager, site.getSelectionProvider());
    }

    protected MenuManager createMenuManager() {
        return new FilteringMenuManager();
    }

    @Override
    protected void keyReleaseOccured(KeyEvent keyEvent) {
        if (keyEvent.character == '\u001b') {
            return;
        }
        super.keyReleaseOccured(keyEvent);
    }

    @Override
    protected void doSetValue(Object value) {
        super.doSetValue(value);
        this.xtextAdapter.sourceviewer.getUndoManager().reset();
    }

    public boolean isUndoEnabled() {
        return true;
    }

    public void performUndo() {
        this.xtextAdapter.sourceviewer.getUndoManager().undo();
    }

    public boolean isRedoEnabled() {
        return true;
    }

    public void performRedo() {
        this.xtextAdapter.sourceviewer.getUndoManager().redo();
    }

    public boolean isFindEnabled() {
        return true;
    }

    protected void focusLost() {
        if (SWT.getPlatform().equals("gtk")) {
            if (this.ignoreNextFocusLost) {
                this.ignoreNextFocusLost = false;
                return;
            }
            if (this.completionProposalAdapter.isProposalPopupOpen()) {
                this.ignoreNextFocusLost = true;
                return;
            }
        }
        if (!this.completionProposalAdapter.isProposalPopupOpen()) {
            super.focusLost();
        }
    }

    public void dispose() {
        this.xtextAdapter.dispose();
        super.dispose();
    }

    @Override
    protected boolean dependsOnExternalFocusListener() {
        return false;
    }

    public void setVisibleRegion(int start, int length) {
        this.xtextAdapter.setVisibleRegion(start, length);
    }
}

