/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.pde.internal.ui.commands;

import java.util.ArrayList;
import java.util.TreeMap;
import org.eclipse.core.commands.Category;
import org.eclipse.core.commands.Command;
import org.eclipse.core.commands.common.NotDefinedException;
import org.eclipse.jface.viewers.ITreeContentProvider;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.pde.internal.ui.commands.CommandList;
import org.eclipse.ui.commands.ICommandService;

public class CommandTreeContentProvider
implements ITreeContentProvider {
    protected static final int F_CAT_CONTENT = 0;
    protected static final int F_CON_CONTENT = 1;
    private ICommandService fComServ;
    private TreeMap<Category, ArrayList<Command>> fCatMap;
    private Viewer fViewer;
    private int fCurContent = 0;

    public CommandTreeContentProvider(ICommandService comServ) {
        this.fComServ = comServ;
        this.init();
    }

    private void init() {
        Command[] commands;
        this.fCatMap = new TreeMap((arg0, arg1) -> {
            String comA = CommandList.getText(arg0);
            String comB = CommandList.getText(arg1);
            if (comA != null) {
                return comA.compareTo(comB);
            }
            return 1;
        });
        Command[] commandArray = commands = this.fComServ.getDefinedCommands();
        int n = commands.length;
        int n2 = 0;
        while (n2 < n) {
            Command command = commandArray[n2];
            if (!command.getId().startsWith("AUTOGEN:::")) {
                try {
                    Category cat = command.getCategory();
                    ArrayList<Object> list = this.fCatMap.get(cat);
                    if (list == null) {
                        list = new ArrayList();
                        this.fCatMap.put(cat, list);
                    }
                    list.add(command);
                }
                catch (NotDefinedException notDefinedException) {}
            }
            ++n2;
        }
    }

    public Object getParent(Object element) {
        if (element instanceof Command) {
            try {
                return ((Command)element).getCategory();
            }
            catch (NotDefinedException notDefinedException) {}
        }
        return null;
    }

    public void dispose() {
        this.fCatMap.clear();
    }

    public Object[] getChildren(Object parentElement) {
        ArrayList<Command> list;
        if (parentElement instanceof Category && (list = this.fCatMap.get(parentElement)) != null) {
            return list.toArray(new Command[list.size()]);
        }
        return null;
    }

    public boolean hasChildren(Object element) {
        ArrayList<Command> list;
        if (element instanceof Category && (list = this.fCatMap.get(element)) != null) {
            return !list.isEmpty();
        }
        return false;
    }

    public Object[] getElements(Object inputElement) {
        return switch (this.fCurContent) {
            case 0 -> this.fCatMap.keySet().toArray();
            case 1 -> new Object[]{};
            default -> null;
        };
    }

    public void inputChanged(Viewer viewer, Object oldInput, Object newInput) {
        this.fViewer = viewer;
    }

    public void refreshWithCategoryContent() {
        this.fCurContent = 0;
        if (this.fViewer != null) {
            this.fViewer.refresh();
        }
    }

    public void refreshWithContextContent() {
        this.fCurContent = 1;
        if (this.fViewer != null) {
            this.fViewer.refresh();
        }
    }
}

