/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.pde.internal.ui.editor.product;

import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.function.Consumer;
import java.util.stream.Stream;
import org.eclipse.jface.action.Action;
import org.eclipse.jface.dialogs.Dialog;
import org.eclipse.jface.util.IPropertyChangeListener;
import org.eclipse.jface.util.PropertyChangeEvent;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.jface.viewers.StructuredViewer;
import org.eclipse.jface.wizard.IWizard;
import org.eclipse.jface.wizard.WizardDialog;
import org.eclipse.pde.internal.core.FeatureModelManager;
import org.eclipse.pde.internal.core.PDECore;
import org.eclipse.pde.internal.core.ifeature.IFeature;
import org.eclipse.pde.internal.core.ifeature.IFeatureImport;
import org.eclipse.pde.internal.core.ifeature.IFeatureModel;
import org.eclipse.pde.internal.core.iproduct.IProduct;
import org.eclipse.pde.internal.core.iproduct.IProductFeature;
import org.eclipse.pde.internal.core.iproduct.IProductModelFactory;
import org.eclipse.pde.internal.ui.PDEPlugin;
import org.eclipse.pde.internal.ui.PDEPluginImages;
import org.eclipse.pde.internal.ui.PDEUIMessages;
import org.eclipse.pde.internal.ui.dialogs.FeatureSelectionDialog;
import org.eclipse.pde.internal.ui.editor.PDEFormPage;
import org.eclipse.pde.internal.ui.editor.actions.SortAction;
import org.eclipse.pde.internal.ui.editor.product.AbstractProductContentSection;
import org.eclipse.pde.internal.ui.editor.product.FeatureProperties;
import org.eclipse.pde.internal.ui.parts.EditableTablePart;
import org.eclipse.pde.internal.ui.util.SWTUtil;
import org.eclipse.pde.internal.ui.wizards.feature.NewFeatureProjectWizard;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Table;
import org.eclipse.swt.widgets.TableItem;
import org.eclipse.ui.forms.widgets.FormToolkit;
import org.eclipse.ui.forms.widgets.Section;

public class FeatureSection
extends AbstractProductContentSection<FeatureSection>
implements IPropertyChangeListener {
    private static final List<String> BUTTON_LABELS;
    private static final List<Consumer<FeatureSection>> BUTTON_HANDLERS;
    private static final int BTN_ADD;
    private static final int BTN_ADD_REQ;
    private static final int BTN_REMOVE;
    private static final int BTN_REMOVE_ALL;
    private static final int BTN_PROPS;
    private static final int BTN_ROOT;
    private static final int BTN_UP;
    private static final int BTN_DWN;
    private SortAction fSortAction;

    static {
        ArrayList<String> labels = new ArrayList<String>();
        ArrayList handlers = new ArrayList();
        BTN_ADD = FeatureSection.addButton(PDEUIMessages.Product_FeatureSection_add, FeatureSection::handleAdd, labels, handlers);
        BTN_ADD_REQ = FeatureSection.addButton(PDEUIMessages.FeatureSection_addRequired, FeatureSection::handleAddRequired, labels, handlers);
        BTN_REMOVE = FeatureSection.addButton(PDEUIMessages.PluginSection_remove, AbstractProductContentSection::handleRemove, labels, handlers);
        BTN_REMOVE_ALL = FeatureSection.addButton(PDEUIMessages.Product_PluginSection_removeAll, FeatureSection::handleRemoveAll, labels, handlers);
        BTN_PROPS = FeatureSection.addButton(PDEUIMessages.Product_FeatureSection_properties, FeatureSection::handleProperties, labels, handlers);
        BTN_ROOT = FeatureSection.addButton(PDEUIMessages.FeatureSection_toggleRoot, FeatureSection::handleRootToggle, labels, handlers);
        BTN_UP = FeatureSection.addButton(PDEUIMessages.Product_FeatureSection_up, FeatureSection::handleUp, labels, handlers);
        BTN_DWN = FeatureSection.addButton(PDEUIMessages.Product_FeatureSection_down, FeatureSection::handleDown, labels, handlers);
        BUTTON_LABELS = List.copyOf(labels);
        BUTTON_HANDLERS = List.copyOf(handlers);
    }

    public FeatureSection(PDEFormPage formPage, Composite parent) {
        super(formPage, parent, BUTTON_LABELS, BUTTON_HANDLERS, IProductFeature.class::isInstance);
    }

    @Override
    void populateSection(Section section, Composite container, FormToolkit toolkit) {
        this.createAutoIncludeRequirementsButton(container, PDEUIMessages.Product_FeatureSection_autoIncludeRequirements);
        this.configureTable(IProduct::getFeatures, null);
        this.enableTableButtons(BTN_ADD, BTN_ADD_REQ, BTN_PROPS, BTN_ROOT, BTN_UP, BTN_DWN);
        section.setText(PDEUIMessages.Product_FeatureSection_title);
        section.setDescription(PDEUIMessages.Product_FeatureSection_desc);
    }

    @Override
    List<Action> getToolbarActions() {
        Action newFeatureAction = FeatureSection.createPushAction(PDEUIMessages.Product_FeatureSection_newFeature, PDEPluginImages.DESC_NEWFTRPRJ_TOOL, () -> FeatureSection.handleNewFeature(this));
        this.fSortAction = new SortAction((StructuredViewer)this.getTableViewer(), PDEUIMessages.Product_FeatureSection_sortAlpha, null, null, this);
        return List.of(newFeatureAction, this.fSortAction);
    }

    static void handleRootToggle(AbstractProductContentSection<?> section) {
        List selection = section.getTableViewer().getStructuredSelection().toList();
        boolean nonRootSelected = selection.stream().anyMatch(o -> !o.isRootInstallMode());
        selection.forEach(o -> {
            IProductFeature iProductFeature = o.setRootInstallMode(nonRootSelected);
        });
    }

    /*
     * WARNING - void declaration
     */
    static void handleProperties(AbstractProductContentSection<?> section) {
        Object object;
        IStructuredSelection ssel = section.getTableSelection();
        if (ssel.size() == 1 && (object = ssel.getFirstElement()) instanceof IProductFeature) {
            void feature;
            IProductFeature iProductFeature = (IProductFeature)object;
            IProductFeature cfr_ignored_0 = (IProductFeature)object;
            FeatureProperties dialog = new FeatureProperties(PDEPlugin.getActiveWorkbenchShell(), section.isEditable(), feature.getVersion(), feature.isRootInstallMode());
            dialog.create();
            SWTUtil.setDialogSize((Dialog)dialog, 400, 200);
            if (dialog.open() == 0) {
                feature.setVersion(dialog.getVersion());
                feature.setRootInstallMode(dialog.getRootInstallMode());
            }
        }
    }

    static void handleNewFeature(AbstractProductContentSection<?> section) {
        NewFeatureProjectWizard wizard = new NewFeatureProjectWizard();
        WizardDialog dialog = new WizardDialog(PDEPlugin.getActiveWorkbenchShell(), (IWizard)wizard);
        dialog.create();
        SWTUtil.setDialogSize((Dialog)dialog, 400, 500);
        if (dialog.open() == 0) {
            FeatureSection.addFeature(wizard.getFeatureId(), section);
        }
    }

    private static void addFeature(String id, AbstractProductContentSection<?> section) {
        IProduct product = section.getProduct();
        IProductModelFactory factory = product.getModel().getFactory();
        IProductFeature feature = factory.createFeature();
        feature.setId(id);
        feature.setVersion("");
        feature.setRootInstallMode(true);
        product.addFeatures(new IProductFeature[]{feature});
        section.getTableViewer().setSelection((ISelection)new StructuredSelection((Object)feature));
    }

    @Override
    void handleRemoveAll() {
        IProduct product = this.getProduct();
        product.removeFeatures(product.getFeatures());
    }

    @Override
    protected void doPaste(Object target, Object[] objects) {
        IProductFeature[] features = FeatureSection.filterToArray(Stream.of(objects), IProductFeature.class);
        this.getProduct().addFeatures(features);
    }

    @Override
    void removeElements(IProduct product, List<Object> elements) {
        IProductFeature[] features = FeatureSection.filterToArray(elements.stream(), IProductFeature.class);
        this.getProduct().removeFeatures(features);
    }

    /*
     * WARNING - void declaration
     */
    static void handleAdd(AbstractProductContentSection<?> section) {
        FeatureSelectionDialog dialog = new FeatureSelectionDialog(PDEPlugin.getActiveWorkbenchShell(), FeatureSection.getAvailableChoices(section.getProduct()), true);
        if (dialog.open() == 0) {
            Object[] models;
            Object[] objectArray = models = dialog.getResult();
            int n = models.length;
            int n2 = 0;
            while (n2 < n) {
                Object model = objectArray[n2];
                Object object = model;
                if (object instanceof IFeatureModel) {
                    void featureModel;
                    IFeatureModel cfr_ignored_0 = (IFeatureModel)object;
                    IFeatureModel cfr_ignored_1 = (IFeatureModel)object;
                    IFeature feature = featureModel.getFeature();
                    FeatureSection.addFeature(feature.getId(), section);
                }
                ++n2;
            }
        }
    }

    private void handleAddRequired() {
        FeatureModelManager manager = PDECore.getDefault().getFeatureModelManager();
        IProduct product = this.getProduct();
        IProductFeature[] currentFeatures = product.getFeatures();
        HashSet<String> requiredFeatures = new HashSet<String>();
        IProductFeature[] iProductFeatureArray = currentFeatures;
        int n = currentFeatures.length;
        int n2 = 0;
        while (n2 < n) {
            IProductFeature feature = iProductFeatureArray[n2];
            IFeatureModel model = manager.findFeatureModel(feature.getId(), feature.getVersion());
            if (model != null) {
                requiredFeatures.add(feature.getId());
                this.getFeatureDependencies(model, requiredFeatures);
            }
            ++n2;
        }
        for (String id : requiredFeatures) {
            if (product.containsFeature(id)) continue;
            FeatureSection.addFeature(id, this);
        }
    }

    private void getFeatureDependencies(IFeatureModel model, Set<String> requiredFeatures) {
        IFeatureModel currentModel;
        FeatureModelManager manager = PDECore.getDefault().getFeatureModelManager();
        IFeature feature = model.getFeature();
        IFeatureImport[] iFeatureImportArray = feature.getImports();
        int n = iFeatureImportArray.length;
        int n2 = 0;
        while (n2 < n) {
            IFeatureImport featureImport = iFeatureImportArray[n2];
            if (featureImport.getType() == 1 && !requiredFeatures.contains(featureImport.getId())) {
                requiredFeatures.add(featureImport.getId());
                currentModel = manager.findFeatureModel(featureImport.getId());
                if (currentModel != null) {
                    this.getFeatureDependencies(currentModel, requiredFeatures);
                }
            }
            ++n2;
        }
        iFeatureImportArray = feature.getIncludedFeatures();
        n = iFeatureImportArray.length;
        n2 = 0;
        while (n2 < n) {
            IFeatureImport featureInclude = iFeatureImportArray[n2];
            if (!requiredFeatures.contains(featureInclude.getId())) {
                requiredFeatures.add(featureInclude.getId());
                currentModel = manager.findFeatureModel(featureInclude.getId());
                if (currentModel != null) {
                    this.getFeatureDependencies(currentModel, requiredFeatures);
                }
            }
            ++n2;
        }
    }

    private static IFeatureModel[] getAvailableChoices(IProduct product) {
        IFeatureModel[] models = PDECore.getDefault().getFeatureModelManager().getModels();
        ArrayList<IFeatureModel> list = new ArrayList<IFeatureModel>();
        IFeatureModel[] iFeatureModelArray = models;
        int n = models.length;
        int n2 = 0;
        while (n2 < n) {
            IFeatureModel model = iFeatureModelArray[n2];
            String id = model.getFeature().getId();
            if (id != null && !product.containsFeature(id)) {
                list.add(model);
            }
            ++n2;
        }
        return list.toArray(new IFeatureModel[list.size()]);
    }

    @Override
    void updateButtons(boolean updateRemove, boolean updateRemoveAll) {
        this.updateRemoveButtons(updateRemove ? BTN_REMOVE : -1, updateRemoveAll ? BTN_REMOVE_ALL : -1);
        EditableTablePart tablePart = this.getTablePart();
        Table table = tablePart.getTableViewer().getTable();
        TableItem[] tableSelection = table.getSelection();
        boolean isSingleSelection = this.isEditable() && tableSelection.length == 1;
        boolean canMove = isSingleSelection && table.getItemCount() > 1 && !this.fSortAction.isChecked();
        tablePart.setButtonEnabled(BTN_PROPS, isSingleSelection);
        tablePart.setButtonEnabled(BTN_ROOT, this.isEditable() && tableSelection.length > 0);
        tablePart.setButtonEnabled(BTN_UP, canMove && table.getSelectionIndex() > 0);
        tablePart.setButtonEnabled(BTN_DWN, canMove && table.getSelectionIndex() < table.getItemCount() - 1);
    }

    private void handleUp() {
        Table table = this.getTable();
        int index = table.getSelectionIndex();
        if (index > 0) {
            FeatureSection.swap(index, index - 1, table, this.getProduct());
        }
    }

    private void handleDown() {
        Table table = this.getTable();
        int index = table.getSelectionIndex();
        if (index < table.getItemCount() - 1) {
            FeatureSection.swap(index, index + 1, table, this.getProduct());
        }
    }

    static void swap(int index1, int index2, Table table, IProduct product) {
        IProductFeature feature1 = (IProductFeature)table.getItem(index1).getData();
        IProductFeature feature2 = (IProductFeature)table.getItem(index2).getData();
        product.swap(feature1, feature2);
    }

    public void propertyChange(PropertyChangeEvent event) {
        if (((Object)((Object)this.fSortAction)).equals(event.getSource()) && "result".equals(event.getProperty())) {
            this.updateButtons(true, true);
        }
    }
}

