/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.pde.internal.ui.launcher;

import java.io.File;
import org.eclipse.core.filesystem.URIUtil;
import org.eclipse.core.resources.IContainer;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.IWorkspaceRoot;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.variables.IStringVariableManager;
import org.eclipse.core.variables.VariablesPlugin;
import org.eclipse.debug.ui.StringVariableSelectionDialog;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.osgi.util.NLS;
import org.eclipse.pde.internal.ui.PDEPlugin;
import org.eclipse.pde.internal.ui.PDEUIMessages;
import org.eclipse.pde.internal.ui.util.SWTUtil;
import org.eclipse.pde.ui.launcher.AbstractLauncherTab;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.program.Program;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.DirectoryDialog;
import org.eclipse.swt.widgets.Link;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Text;
import org.eclipse.ui.dialogs.ContainerSelectionDialog;

public abstract class BaseBlock {
    protected AbstractLauncherTab fTab;
    private Button fVariablesButton;
    private Button fFileSystemButton;
    private Button fWorkspaceButton;
    protected Text fLocationText;
    protected Listener fListener = new Listener();
    protected Link fLocationLink;

    public BaseBlock(AbstractLauncherTab tab) {
        this.fTab = tab;
    }

    protected void createText(Composite parent, String text, int indent) {
        GridData gd;
        this.fLocationLink = new Link(parent, 0);
        this.fLocationLink.setText("<a>" + text + "</a>");
        if (indent > 0) {
            gd = new GridData();
            gd.horizontalIndent = indent;
            this.fLocationLink.setLayoutData((Object)gd);
        }
        this.fLocationText = new Text(parent, 2052);
        gd = new GridData(768);
        gd.widthHint = 400;
        this.fLocationText.setLayoutData((Object)gd);
        this.fLocationText.addModifyListener((ModifyListener)this.fListener);
        this.fLocationLink.addSelectionListener(SelectionListener.widgetSelectedAdapter(e -> {
            try {
                String path = VariablesPlugin.getDefault().getStringVariableManager().performStringSubstitution(this.getLocation(), false);
                File f = new File(path);
                if (f.exists()) {
                    Program.launch((String)f.getCanonicalPath());
                } else {
                    MessageDialog.openWarning((Shell)PDEPlugin.getActiveWorkbenchShell(), (String)(this.isFile() ? PDEUIMessages.BaseBlock_fileTitle : PDEUIMessages.BaseBlock_directoryTitle), (String)(this.isFile() ? PDEUIMessages.BaseBlock_fileNotFoundMessage : PDEUIMessages.BaseBlock_directoryNotFoundMessage));
                }
            }
            catch (Exception exception) {
                MessageDialog.openWarning((Shell)PDEPlugin.getActiveWorkbenchShell(), (String)(this.isFile() ? PDEUIMessages.BaseBlock_fileTitle : PDEUIMessages.BaseBlock_directoryTitle), (String)(this.isFile() ? PDEUIMessages.BaseBlock_fileErrorMessage : PDEUIMessages.BaseBlock_directoryErrorMessage));
            }
        }));
    }

    protected void createButtons(Composite parent, String[] buttonLabels) {
        this.fWorkspaceButton = this.createButton(parent, buttonLabels[0]);
        this.fFileSystemButton = this.createButton(parent, buttonLabels[1]);
        this.fVariablesButton = this.createButton(parent, buttonLabels[2]);
    }

    protected Button createButton(Composite parent, String text) {
        Button button = new Button(parent, 8);
        button.setText(text);
        button.setLayoutData((Object)new GridData());
        button.addSelectionListener((SelectionListener)this.fListener);
        SWTUtil.setButtonDimensionHint(button);
        return button;
    }

    protected void handleBrowseFileSystem() {
        DirectoryDialog dialog = new DirectoryDialog(this.fLocationText.getShell());
        dialog.setFilterPath(this.getLocation());
        dialog.setText(PDEUIMessages.BaseBlock_dirSelection);
        dialog.setMessage(PDEUIMessages.BaseBlock_dirChoose);
        String result = dialog.open();
        if (result != null) {
            this.fLocationText.setText(result);
        }
    }

    protected void handleBrowseWorkspace() {
        ContainerSelectionDialog dialog = new ContainerSelectionDialog(this.fLocationText.getShell(), this.getContainer(), true, PDEUIMessages.BaseBlock_relative);
        if (dialog.open() == 0) {
            Object[] result = dialog.getResult();
            if (result.length == 0) {
                return;
            }
            IPath path = (IPath)result[0];
            this.fLocationText.setText("${workspace_loc:" + path.makeRelative().toString() + "}");
        }
    }

    protected IContainer getContainer() {
        String path = this.getLocation();
        if (path.length() > 0) {
            IResource res = null;
            IWorkspaceRoot root = ResourcesPlugin.getWorkspace().getRoot();
            if (path.startsWith("${workspace_loc:")) {
                IStringVariableManager manager = VariablesPlugin.getDefault().getStringVariableManager();
                try {
                    path = manager.performStringSubstitution(path, false);
                    IPath uriPath = IPath.fromOSString((String)path).makeAbsolute();
                    IContainer[] containers = root.findContainersForLocationURI(URIUtil.toURI((IPath)uriPath));
                    if (containers.length > 0) {
                        res = containers[0];
                    }
                }
                catch (CoreException coreException) {}
            } else {
                res = root.findMember(path);
            }
            if (res instanceof IContainer) {
                return (IContainer)res;
            }
        }
        return ResourcesPlugin.getWorkspace().getRoot();
    }

    private void handleInsertVariable() {
        StringVariableSelectionDialog dialog = new StringVariableSelectionDialog(this.fLocationText.getShell());
        if (dialog.open() == 0) {
            this.fLocationText.insert(dialog.getVariableExpression());
        }
    }

    protected String getLocation() {
        return this.fLocationText.getText().trim();
    }

    public String validate() {
        return this.fLocationText.isEnabled() && this.getLocation().length() == 0 ? NLS.bind((String)PDEUIMessages.BaseBlock_errorMessage, (Object)this.getName()) : null;
    }

    protected abstract String getName();

    protected abstract boolean isFile();

    protected void enableBrowseSection(boolean enabled) {
        this.fLocationLink.setEnabled(enabled);
        this.fLocationText.setEnabled(enabled);
        this.fFileSystemButton.setEnabled(enabled);
        this.fWorkspaceButton.setEnabled(enabled);
        this.fVariablesButton.setEnabled(enabled);
        if (this.fTab != null) {
            this.fTab.updateLaunchConfigurationDialog();
        }
    }

    class Listener
    extends SelectionAdapter
    implements ModifyListener {
        Listener() {
        }

        public void widgetSelected(SelectionEvent e) {
            Object source = e.getSource();
            if (source == BaseBlock.this.fFileSystemButton) {
                BaseBlock.this.handleBrowseFileSystem();
            } else if (source == BaseBlock.this.fWorkspaceButton) {
                BaseBlock.this.handleBrowseWorkspace();
            } else if (source == BaseBlock.this.fVariablesButton) {
                BaseBlock.this.handleInsertVariable();
            } else if (BaseBlock.this.fTab != null) {
                BaseBlock.this.fTab.updateLaunchConfigurationDialog();
            }
        }

        public void modifyText(ModifyEvent e) {
            if (BaseBlock.this.fTab != null) {
                BaseBlock.this.fTab.scheduleUpdateJob();
            }
        }
    }
}

