/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ant.internal.ui.preferences;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStreamReader;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.eclipse.ant.internal.ui.AntUIPlugin;
import org.eclipse.ant.internal.ui.preferences.OverlayPreferenceStore;
import org.eclipse.ant.internal.ui.preferences.StatusInfo;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.jface.dialogs.DialogPage;
import org.eclipse.jface.preference.PreferencePage;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Font;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Text;
import org.eclipse.ui.IWorkbench;
import org.eclipse.ui.IWorkbenchPreferencePage;
import org.eclipse.ui.PlatformUI;

public abstract class AbstractAntEditorPreferencePage
extends PreferencePage
implements IWorkbenchPreferencePage {
    private OverlayPreferenceStore fOverlayStore;
    protected List<IStatus> fStatusList;
    private boolean fInitialized = false;
    private Map<Button, String> fCheckBoxes = new HashMap<Button, String>();
    private SelectionListener fCheckBoxListener = new SelectionListener(){

        public void widgetDefaultSelected(SelectionEvent e) {
        }

        public void widgetSelected(SelectionEvent e) {
            Button button = (Button)e.widget;
            AbstractAntEditorPreferencePage.this.fOverlayStore.setValue(AbstractAntEditorPreferencePage.this.fCheckBoxes.get(button), button.getSelection());
        }
    };
    private Map<Text, String> fTextFields = new HashMap<Text, String>();
    private ModifyListener fTextFieldListener = e -> {
        if (this.fInitialized) {
            Text text = (Text)e.widget;
            this.fOverlayStore.setValue(this.fTextFields.get(text), text.getText());
        }
    };
    private Map<Text, String[]> fNumberFields = new HashMap<Text, String[]>();
    private ModifyListener fNumberFieldListener = e -> {
        if (this.fInitialized) {
            this.numberFieldChanged((Text)e.widget);
        }
    };

    public AbstractAntEditorPreferencePage() {
        this.setPreferenceStore(AntUIPlugin.getDefault().getPreferenceStore());
        this.fOverlayStore = this.createOverlayStore();
    }

    protected abstract OverlayPreferenceStore createOverlayStore();

    public void init(IWorkbench workbench) {
    }

    public void createControl(Composite parent) {
        super.createControl(parent);
        PlatformUI.getWorkbench().getHelpSystem().setHelp(this.getControl(), this.getHelpContextId());
    }

    protected abstract String getHelpContextId();

    protected void initializeFields() {
        String key;
        Map<Button, String> checkBoxes = this.getCheckBoxes();
        Map<Text, String> textFields = this.getTextFields();
        for (Button b : checkBoxes.keySet()) {
            key = checkBoxes.get(b);
            b.setSelection(this.getOverlayStore().getBoolean(key));
        }
        for (Text t : textFields.keySet()) {
            key = textFields.get(t);
            t.setText(this.getOverlayStore().getString(key));
        }
        this.fInitialized = true;
    }

    public boolean performOk() {
        this.getOverlayStore().propagate();
        AntUIPlugin.getDefault().savePluginPreferences();
        return true;
    }

    protected OverlayPreferenceStore getOverlayStore() {
        return this.fOverlayStore;
    }

    protected OverlayPreferenceStore setOverlayStore() {
        return this.fOverlayStore;
    }

    protected Map<Button, String> getCheckBoxes() {
        return this.fCheckBoxes;
    }

    protected Map<Text, String> getTextFields() {
        return this.fTextFields;
    }

    protected Map<Text, String[]> getNumberFields() {
        return this.fNumberFields;
    }

    protected void performDefaults() {
        this.getOverlayStore().loadDefaults();
        this.initializeFields();
        this.handleDefaults();
        super.performDefaults();
    }

    protected abstract void handleDefaults();

    public void dispose() {
        if (this.getOverlayStore() != null) {
            this.getOverlayStore().stop();
            this.fOverlayStore = null;
        }
        super.dispose();
    }

    protected Button addCheckBox(Composite parent, String labelText, String key, int indentation) {
        Button checkBox = new Button(parent, 32);
        checkBox.setText(labelText);
        checkBox.setFont(parent.getFont());
        GridData gd = new GridData(32);
        gd.horizontalIndent = indentation;
        gd.horizontalSpan = 2;
        checkBox.setLayoutData((Object)gd);
        checkBox.addSelectionListener(this.fCheckBoxListener);
        this.getCheckBoxes().put(checkBox, key);
        return checkBox;
    }

    protected Text addTextField(Composite composite, String labelText, String key, int textLimit, int indentation, String[] errorMessages) {
        Font font = composite.getFont();
        Label label = new Label(composite, 0);
        label.setText(labelText);
        label.setFont(font);
        GridData gd = new GridData(32);
        gd.horizontalIndent = indentation;
        label.setLayoutData((Object)gd);
        Text textControl = new Text(composite, 2052);
        textControl.setFont(font);
        gd = new GridData(32);
        gd.widthHint = this.convertWidthInCharsToPixels(textLimit + 1);
        textControl.setLayoutData((Object)gd);
        textControl.setTextLimit(textLimit);
        this.getTextFields().put(textControl, key);
        if (errorMessages != null) {
            this.getNumberFields().put(textControl, errorMessages);
            textControl.addModifyListener(this.fNumberFieldListener);
        } else {
            textControl.addModifyListener(this.fTextFieldListener);
        }
        return textControl;
    }

    private void numberFieldChanged(Text textControl) {
        String number = textControl.getText();
        IStatus status = this.validatePositiveNumber(number, this.getNumberFields().get(textControl));
        if (!status.matches(4)) {
            this.getOverlayStore().setValue(this.getTextFields().get(textControl), number);
        }
        this.updateStatus(status);
    }

    private IStatus validatePositiveNumber(String number, String[] errorMessages) {
        StatusInfo status = new StatusInfo();
        if (number.length() == 0) {
            status.setError(errorMessages[0]);
        } else {
            try {
                int value = Integer.parseInt(number);
                if (value < 0) {
                    status.setError(MessageFormat.format(errorMessages[1], number));
                }
            }
            catch (NumberFormatException numberFormatException) {
                status.setError(MessageFormat.format(errorMessages[1], number));
            }
        }
        return status;
    }

    protected void updateStatus(IStatus status) {
        List<IStatus> statusList;
        if (!status.matches(4)) {
            for (Text text : this.getNumberFields().keySet()) {
                IStatus s = this.validatePositiveNumber(text.getText(), this.getNumberFields().get(text));
                IStatus iStatus = status = s.getSeverity() > status.getSeverity() ? s : status;
            }
        }
        if ((statusList = this.getStatusList()) != null) {
            ArrayList<IStatus> temp = new ArrayList<IStatus>(statusList.size() + 1);
            temp.add(status);
            temp.addAll(statusList);
            status = this.getMostSevere(temp);
        }
        this.setValid(!status.matches(4));
        this.applyToStatusLine((DialogPage)this, status);
    }

    protected List<IStatus> getStatusList() {
        return this.fStatusList;
    }

    private IStatus getMostSevere(List<IStatus> statusList) {
        IStatus max = null;
        for (IStatus curr : statusList) {
            if (curr.matches(4)) {
                return curr;
            }
            if (max != null && curr.getSeverity() <= max.getSeverity()) continue;
            max = curr;
        }
        return max;
    }

    private void applyToStatusLine(DialogPage page, IStatus status) {
        String message = status.getMessage();
        switch (status.getSeverity()) {
            case 0: {
                page.setMessage(message, 0);
                page.setErrorMessage(null);
                break;
            }
            case 2: {
                page.setMessage(message, 2);
                page.setErrorMessage(null);
                break;
            }
            case 1: {
                page.setMessage(message, 1);
                page.setErrorMessage(null);
                break;
            }
            default: {
                if (message.length() == 0) {
                    message = null;
                }
                page.setMessage(null);
                page.setErrorMessage(message);
            }
        }
    }

    protected Control[] addLabelledTextField(Composite composite, String label, String key, int textLimit, int indentation, String[] errorMessages) {
        Label labelControl = new Label(composite, 0);
        labelControl.setText(label);
        labelControl.setFont(composite.getFont());
        GridData gd = new GridData(32);
        gd.horizontalIndent = indentation;
        labelControl.setLayoutData((Object)gd);
        Text textControl = new Text(composite, 2052);
        gd = new GridData(32);
        if (textLimit > -1) {
            gd.widthHint = this.convertWidthInCharsToPixels(textLimit + 1);
            textControl.setTextLimit(textLimit);
        } else {
            gd.widthHint = this.convertWidthInCharsToPixels(50);
        }
        textControl.setLayoutData((Object)gd);
        textControl.setFont(composite.getFont());
        this.fTextFields.put(textControl, key);
        if (errorMessages != null) {
            this.fNumberFields.put(textControl, errorMessages);
            textControl.addModifyListener(this.fNumberFieldListener);
        } else {
            textControl.addModifyListener(this.fTextFieldListener);
        }
        return new Control[]{labelControl, textControl};
    }

    protected String loadPreviewContentFromFile(String filename) {
        String separator = System.getProperty("line.separator");
        StringBuilder buffer = new StringBuilder(512);
        try {
            Throwable throwable = null;
            Object var6_7 = null;
            try (BufferedReader reader = new BufferedReader(new InputStreamReader(((Object)((Object)this)).getClass().getResourceAsStream(filename)));){
                String line;
                while ((line = reader.readLine()) != null) {
                    buffer.append(line);
                    buffer.append(separator);
                }
            }
            catch (Throwable throwable2) {
                if (throwable == null) {
                    throwable = throwable2;
                } else if (throwable != throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
        }
        catch (IOException io) {
            AntUIPlugin.log(io);
        }
        return buffer.toString();
    }

    protected Label getLabelControl(Control[] labelledTextField) {
        return (Label)labelledTextField[0];
    }

    protected Text getTextControl(Control[] labelledTextField) {
        return (Text)labelledTextField[1];
    }
}

