/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.nebula.jface.cdatetime;

import java.util.Date;
import org.eclipse.core.runtime.ISafeRunnable;
import org.eclipse.core.runtime.ListenerList;
import org.eclipse.jface.util.SafeRunnable;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.ISelectionProvider;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.SelectionChangedEvent;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.nebula.widgets.cdatetime.CDateTime;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.widgets.Composite;

public class CDateTimeSelectionProvider
implements ISelectionProvider,
SelectionListener {
    private CDateTime cdt;
    private ListenerList selectionChangedListeners = new ListenerList(1);

    public CDateTimeSelectionProvider(CDateTime cdt) {
        this.cdt = cdt;
        cdt.addSelectionListener((SelectionListener)this);
    }

    public CDateTimeSelectionProvider(Composite parent, int style) {
        this.cdt = new CDateTime(parent, style);
        this.cdt.addSelectionListener((SelectionListener)this);
    }

    public void addSelectionChangedListener(ISelectionChangedListener listener) {
        this.selectionChangedListeners.add((Object)listener);
    }

    private void fireSelectionChanged(final SelectionChangedEvent event) {
        Object[] listeners = this.selectionChangedListeners.getListeners();
        int i = 0;
        while (i < listeners.length) {
            final ISelectionChangedListener l = (ISelectionChangedListener)listeners[i];
            SafeRunnable.run((ISafeRunnable)new SafeRunnable(){

                public void run() {
                    l.selectionChanged(event);
                }
            });
            ++i;
        }
    }

    public CDateTime getCDateTime() {
        return this.cdt;
    }

    public ISelection getSelection() {
        return new StructuredSelection((Object)this.cdt.getSelection());
    }

    public void removeSelectionChangedListener(ISelectionChangedListener listener) {
        this.selectionChangedListeners.remove((Object)listener);
    }

    public void setSelection(ISelection selection) {
        Object obj;
        if (!selection.isEmpty() && selection instanceof IStructuredSelection && (obj = ((IStructuredSelection)selection).getFirstElement()) instanceof Date) {
            this.cdt.setSelection((Date)obj);
        }
    }

    public void widgetDefaultSelected(SelectionEvent event) {
        StructuredSelection sel = new StructuredSelection((Object)this.cdt.getSelection());
        SelectionChangedEvent sce = new SelectionChangedEvent((ISelectionProvider)this, (ISelection)sel);
        this.fireSelectionChanged(sce);
    }

    public void widgetSelected(SelectionEvent event) {
        StructuredSelection sel = new StructuredSelection((Object)this.cdt.getSelection());
        SelectionChangedEvent e = new SelectionChangedEvent((ISelectionProvider)this, (ISelection)sel);
        this.fireSelectionChanged(e);
    }
}

