/*
 * Decompiled with CFR 0.152.
 */
package org.apache.lucene.util;

import java.lang.reflect.Array;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.security.AccessControlException;
import java.security.AccessController;
import java.text.DecimalFormat;
import java.text.DecimalFormatSymbols;
import java.util.Collection;
import java.util.Collections;
import java.util.IdentityHashMap;
import java.util.Locale;
import java.util.Map;
import java.util.logging.Logger;
import org.apache.lucene.index.Term;
import org.apache.lucene.search.BooleanClause;
import org.apache.lucene.search.Query;
import org.apache.lucene.search.QueryVisitor;
import org.apache.lucene.util.Accountable;
import org.apache.lucene.util.Constants;

public final class RamUsageEstimator {
    public static final long ONE_KB = 1024L;
    public static final long ONE_MB = 0x100000L;
    public static final long ONE_GB = 0x40000000L;
    public static final boolean COMPRESSED_REFS_ENABLED;
    public static final int NUM_BYTES_OBJECT_REF;
    public static final int NUM_BYTES_OBJECT_HEADER;
    public static final int NUM_BYTES_ARRAY_HEADER;
    public static final int NUM_BYTES_OBJECT_ALIGNMENT;
    public static final int QUERY_DEFAULT_RAM_BYTES_USED = 1024;
    public static final int UNKNOWN_DEFAULT_RAM_BYTES_USED = 256;
    public static final Map<Class<?>, Integer> primitiveSizes;
    static final int INTEGER_SIZE;
    static final int LONG_SIZE;
    static final int STRING_SIZE;
    static final boolean JVM_IS_HOTSPOT_64BIT;
    static final String MANAGEMENT_FACTORY_CLASS = "java.lang.management.ManagementFactory";
    static final String HOTSPOT_BEAN_CLASS = "com.sun.management.HotSpotDiagnosticMXBean";
    public static final long HASHTABLE_RAM_BYTES_PER_ENTRY;
    public static final long LINKED_HASHTABLE_RAM_BYTES_PER_ENTRY;
    public static final int MAX_DEPTH = 1;

    private RamUsageEstimator() {
    }

    public static long alignObjectSize(long size) {
        return (size += (long)NUM_BYTES_OBJECT_ALIGNMENT - 1L) - size % (long)NUM_BYTES_OBJECT_ALIGNMENT;
    }

    public static long sizeOf(Integer ignored) {
        return INTEGER_SIZE;
    }

    public static long sizeOf(Long ignored) {
        return LONG_SIZE;
    }

    public static long sizeOf(byte[] arr) {
        return RamUsageEstimator.alignObjectSize((long)NUM_BYTES_ARRAY_HEADER + (long)arr.length);
    }

    public static long sizeOf(boolean[] arr) {
        return RamUsageEstimator.alignObjectSize((long)NUM_BYTES_ARRAY_HEADER + (long)arr.length);
    }

    public static long sizeOf(char[] arr) {
        return RamUsageEstimator.alignObjectSize((long)NUM_BYTES_ARRAY_HEADER + 2L * (long)arr.length);
    }

    public static long sizeOf(short[] arr) {
        return RamUsageEstimator.alignObjectSize((long)NUM_BYTES_ARRAY_HEADER + 2L * (long)arr.length);
    }

    public static long sizeOf(int[] arr) {
        return RamUsageEstimator.alignObjectSize((long)NUM_BYTES_ARRAY_HEADER + 4L * (long)arr.length);
    }

    public static long sizeOf(float[] arr) {
        return RamUsageEstimator.alignObjectSize((long)NUM_BYTES_ARRAY_HEADER + 4L * (long)arr.length);
    }

    public static long sizeOf(long[] arr) {
        return RamUsageEstimator.alignObjectSize((long)NUM_BYTES_ARRAY_HEADER + 8L * (long)arr.length);
    }

    public static long sizeOf(double[] arr) {
        return RamUsageEstimator.alignObjectSize((long)NUM_BYTES_ARRAY_HEADER + 8L * (long)arr.length);
    }

    public static long sizeOf(String[] arr) {
        long size = RamUsageEstimator.shallowSizeOf(arr);
        for (String s : arr) {
            if (s == null) continue;
            size += RamUsageEstimator.sizeOf(s);
        }
        return size;
    }

    public static long sizeOfMap(Map<?, ?> map) {
        return RamUsageEstimator.sizeOfMap(map, 0, 256L);
    }

    public static long sizeOfMap(Map<?, ?> map, long defSize) {
        return RamUsageEstimator.sizeOfMap(map, 0, defSize);
    }

    private static long sizeOfMap(Map<?, ?> map, int depth, long defSize) {
        if (map == null) {
            return 0L;
        }
        long size = RamUsageEstimator.shallowSizeOf(map);
        if (depth > 1) {
            return size;
        }
        long sizeOfEntry = -1L;
        for (Map.Entry<?, ?> entry : map.entrySet()) {
            if (sizeOfEntry == -1L) {
                sizeOfEntry = RamUsageEstimator.shallowSizeOf(entry);
            }
            size += sizeOfEntry;
            size += RamUsageEstimator.sizeOfObject(entry.getKey(), depth, defSize);
            size += RamUsageEstimator.sizeOfObject(entry.getValue(), depth, defSize);
        }
        return RamUsageEstimator.alignObjectSize(size);
    }

    public static long sizeOfCollection(Collection<?> collection) {
        return RamUsageEstimator.sizeOfCollection(collection, 0, 256L);
    }

    public static long sizeOfCollection(Collection<?> collection, long defSize) {
        return RamUsageEstimator.sizeOfCollection(collection, 0, defSize);
    }

    private static long sizeOfCollection(Collection<?> collection, int depth, long defSize) {
        if (collection == null) {
            return 0L;
        }
        long size = RamUsageEstimator.shallowSizeOf(collection);
        if (depth > 1) {
            return size;
        }
        size += (long)(NUM_BYTES_ARRAY_HEADER + collection.size() * NUM_BYTES_OBJECT_REF);
        for (Object o : collection) {
            size += RamUsageEstimator.sizeOfObject(o, depth, defSize);
        }
        return RamUsageEstimator.alignObjectSize(size);
    }

    public static long sizeOf(Query q) {
        return RamUsageEstimator.sizeOf(q, 1024L);
    }

    public static long sizeOf(Query q, long defSize) {
        if (q instanceof Accountable) {
            return ((Accountable)((Object)q)).ramBytesUsed();
        }
        RamUsageQueryVisitor visitor = new RamUsageQueryVisitor(q, defSize);
        q.visit(visitor);
        return RamUsageEstimator.alignObjectSize(visitor.total);
    }

    public static long sizeOfObject(Object o) {
        return RamUsageEstimator.sizeOfObject(o, 0, 256L);
    }

    public static long sizeOfObject(Object o, long defSize) {
        return RamUsageEstimator.sizeOfObject(o, 0, defSize);
    }

    private static long sizeOfObject(Object o, int depth, long defSize) {
        if (o == null) {
            return 0L;
        }
        long size = o instanceof Accountable ? ((Accountable)o).ramBytesUsed() : (o instanceof String ? RamUsageEstimator.sizeOf((String)o) : (o instanceof boolean[] ? RamUsageEstimator.sizeOf((boolean[])o) : (o instanceof byte[] ? RamUsageEstimator.sizeOf((byte[])o) : (o instanceof char[] ? RamUsageEstimator.sizeOf((char[])o) : (o instanceof double[] ? RamUsageEstimator.sizeOf((double[])o) : (o instanceof float[] ? RamUsageEstimator.sizeOf((float[])o) : (o instanceof int[] ? RamUsageEstimator.sizeOf((int[])o) : (o instanceof Integer ? RamUsageEstimator.sizeOf((Integer)o) : (o instanceof Long ? RamUsageEstimator.sizeOf((Long)o) : (o instanceof long[] ? RamUsageEstimator.sizeOf((long[])o) : (o instanceof short[] ? RamUsageEstimator.sizeOf((short[])o) : (o instanceof String[] ? RamUsageEstimator.sizeOf((String[])o) : (o instanceof Query ? RamUsageEstimator.sizeOf((Query)o, defSize) : (o instanceof Map ? RamUsageEstimator.sizeOfMap((Map)o, ++depth, defSize) : (o instanceof Collection ? RamUsageEstimator.sizeOfCollection((Collection)o, ++depth, defSize) : (defSize > 0L ? defSize : RamUsageEstimator.shallowSizeOf(o)))))))))))))))));
        return size;
    }

    public static long sizeOf(Accountable accountable) {
        return accountable.ramBytesUsed();
    }

    public static long sizeOf(String s) {
        if (s == null) {
            return 0L;
        }
        long size = (long)STRING_SIZE + (long)NUM_BYTES_ARRAY_HEADER + 2L * (long)s.length();
        return RamUsageEstimator.alignObjectSize(size);
    }

    public static long shallowSizeOf(byte[] arr) {
        return RamUsageEstimator.sizeOf(arr);
    }

    public static long shallowSizeOf(boolean[] arr) {
        return RamUsageEstimator.sizeOf(arr);
    }

    public static long shallowSizeOf(char[] arr) {
        return RamUsageEstimator.sizeOf(arr);
    }

    public static long shallowSizeOf(short[] arr) {
        return RamUsageEstimator.sizeOf(arr);
    }

    public static long shallowSizeOf(int[] arr) {
        return RamUsageEstimator.sizeOf(arr);
    }

    public static long shallowSizeOf(float[] arr) {
        return RamUsageEstimator.sizeOf(arr);
    }

    public static long shallowSizeOf(long[] arr) {
        return RamUsageEstimator.sizeOf(arr);
    }

    public static long shallowSizeOf(double[] arr) {
        return RamUsageEstimator.sizeOf(arr);
    }

    public static long shallowSizeOf(Object[] arr) {
        return RamUsageEstimator.alignObjectSize((long)NUM_BYTES_ARRAY_HEADER + (long)NUM_BYTES_OBJECT_REF * (long)arr.length);
    }

    public static long shallowSizeOf(Object obj) {
        if (obj == null) {
            return 0L;
        }
        Class<?> clz = obj.getClass();
        if (clz.isArray()) {
            return RamUsageEstimator.shallowSizeOfArray(obj);
        }
        return RamUsageEstimator.shallowSizeOfInstance(clz);
    }

    public static long shallowSizeOfInstance(Class<?> clazz) {
        if (clazz.isArray()) {
            throw new IllegalArgumentException("This method does not work with array classes.");
        }
        if (clazz.isPrimitive()) {
            return primitiveSizes.get(clazz).intValue();
        }
        long size = NUM_BYTES_OBJECT_HEADER;
        while (clazz != null) {
            Field[] fields;
            Class<?> target = clazz;
            try {
                fields = AccessController.doPrivileged(target::getDeclaredFields);
            }
            catch (AccessControlException e) {
                throw new RuntimeException("Can't access fields of class: " + target, e);
            }
            for (Field f : fields) {
                if (Modifier.isStatic(f.getModifiers())) continue;
                size = RamUsageEstimator.adjustForField(size, f);
            }
            clazz = clazz.getSuperclass();
        }
        return RamUsageEstimator.alignObjectSize(size);
    }

    private static long shallowSizeOfArray(Object array) {
        long size = NUM_BYTES_ARRAY_HEADER;
        int len = Array.getLength(array);
        if (len > 0) {
            Class<?> arrayElementClazz = array.getClass().getComponentType();
            size = arrayElementClazz.isPrimitive() ? (size += (long)len * (long)primitiveSizes.get(arrayElementClazz).intValue()) : (size += (long)NUM_BYTES_OBJECT_REF * (long)len);
        }
        return RamUsageEstimator.alignObjectSize(size);
    }

    public static long adjustForField(long sizeSoFar, Field f) {
        Class<?> type = f.getType();
        int fsize = type.isPrimitive() ? primitiveSizes.get(type) : NUM_BYTES_OBJECT_REF;
        return sizeSoFar + (long)fsize;
    }

    public static String humanReadableUnits(long bytes) {
        return RamUsageEstimator.humanReadableUnits(bytes, new DecimalFormat("0.#", DecimalFormatSymbols.getInstance(Locale.ROOT)));
    }

    public static String humanReadableUnits(long bytes, DecimalFormat df) {
        if (bytes / 0x40000000L > 0L) {
            return df.format((float)bytes / 1.0737418E9f) + " GB";
        }
        if (bytes / 0x100000L > 0L) {
            return df.format((float)bytes / 1048576.0f) + " MB";
        }
        if (bytes / 1024L > 0L) {
            return df.format((float)bytes / 1024.0f) + " KB";
        }
        return bytes + " bytes";
    }

    public static long sizeOf(Accountable[] accountables) {
        long size = RamUsageEstimator.shallowSizeOf(accountables);
        for (Accountable accountable : accountables) {
            if (accountable == null) continue;
            size += accountable.ramBytesUsed();
        }
        return size;
    }

    static {
        IdentityHashMap<Class<Comparable<Boolean>>, Integer> primitiveSizesMap = new IdentityHashMap<Class<Comparable<Boolean>>, Integer>();
        primitiveSizesMap.put(Boolean.TYPE, 1);
        primitiveSizesMap.put(Byte.TYPE, 1);
        primitiveSizesMap.put(Character.TYPE, 2);
        primitiveSizesMap.put(Short.TYPE, 2);
        primitiveSizesMap.put(Integer.TYPE, 4);
        primitiveSizesMap.put(Float.TYPE, 4);
        primitiveSizesMap.put(Double.TYPE, 8);
        primitiveSizesMap.put(Long.TYPE, 8);
        primitiveSizes = Collections.unmodifiableMap(primitiveSizesMap);
        if (Constants.JRE_IS_64BIT) {
            boolean isHotspot;
            int objectAlignment;
            boolean compressedOops;
            block10: {
                compressedOops = false;
                objectAlignment = 8;
                isHotspot = false;
                try {
                    Object vmOption;
                    Class<?> beanClazz = Class.forName(HOTSPOT_BEAN_CLASS);
                    Object hotSpotBean = Class.forName(MANAGEMENT_FACTORY_CLASS).getMethod("getPlatformMXBean", Class.class).invoke(null, beanClazz);
                    if (hotSpotBean == null) break block10;
                    isHotspot = true;
                    Method getVMOptionMethod = beanClazz.getMethod("getVMOption", String.class);
                    try {
                        vmOption = getVMOptionMethod.invoke(hotSpotBean, "UseCompressedOops");
                        compressedOops = Boolean.parseBoolean(vmOption.getClass().getMethod("getValue", new Class[0]).invoke(vmOption, new Object[0]).toString());
                    }
                    catch (ReflectiveOperationException | RuntimeException e) {
                        isHotspot = false;
                    }
                    try {
                        vmOption = getVMOptionMethod.invoke(hotSpotBean, "ObjectAlignmentInBytes");
                        objectAlignment = Integer.parseInt(vmOption.getClass().getMethod("getValue", new Class[0]).invoke(vmOption, new Object[0]).toString());
                    }
                    catch (ReflectiveOperationException | RuntimeException e) {
                        isHotspot = false;
                    }
                }
                catch (ReflectiveOperationException | RuntimeException e) {
                    isHotspot = false;
                    Logger log = Logger.getLogger(RamUsageEstimator.class.getName());
                    Module module = RamUsageEstimator.class.getModule();
                    ModuleLayer layer = module.getLayer();
                    if (layer != null) {
                        if (!layer.findModule("jdk.management").map(module::canRead).orElse(false).booleanValue()) {
                            log.warning("Lucene cannot correctly calculate object sizes on 64bit JVMs, unless the 'jdk.management' Java module is readable [please add 'jdk.management' to modular application either by command line or its module descriptor]");
                        }
                    }
                    log.warning("Lucene cannot correctly calculate object sizes on 64bit JVMs that are not based on Hotspot or a compatible implementation.");
                }
            }
            JVM_IS_HOTSPOT_64BIT = isHotspot;
            COMPRESSED_REFS_ENABLED = compressedOops;
            NUM_BYTES_OBJECT_ALIGNMENT = objectAlignment;
            NUM_BYTES_OBJECT_REF = COMPRESSED_REFS_ENABLED ? 4 : 8;
            NUM_BYTES_OBJECT_HEADER = 8 + NUM_BYTES_OBJECT_REF;
            NUM_BYTES_ARRAY_HEADER = (int)RamUsageEstimator.alignObjectSize(NUM_BYTES_OBJECT_HEADER + 4);
        } else {
            JVM_IS_HOTSPOT_64BIT = false;
            COMPRESSED_REFS_ENABLED = false;
            NUM_BYTES_OBJECT_ALIGNMENT = 8;
            NUM_BYTES_OBJECT_REF = 4;
            NUM_BYTES_OBJECT_HEADER = 8;
            NUM_BYTES_ARRAY_HEADER = NUM_BYTES_OBJECT_HEADER + 4;
        }
        INTEGER_SIZE = (int)RamUsageEstimator.shallowSizeOfInstance(Integer.class);
        LONG_SIZE = (int)RamUsageEstimator.shallowSizeOfInstance(Long.class);
        STRING_SIZE = (int)RamUsageEstimator.shallowSizeOfInstance(String.class);
        HASHTABLE_RAM_BYTES_PER_ENTRY = 2L * (long)NUM_BYTES_OBJECT_REF * 2L;
        LINKED_HASHTABLE_RAM_BYTES_PER_ENTRY = HASHTABLE_RAM_BYTES_PER_ENTRY + 2L * (long)NUM_BYTES_OBJECT_REF;
    }

    private static final class RamUsageQueryVisitor
    extends QueryVisitor {
        long total;
        long defSize;
        Query root;

        RamUsageQueryVisitor(Query root, long defSize) {
            this.root = root;
            this.defSize = defSize;
            this.total = defSize > 0L ? defSize : RamUsageEstimator.shallowSizeOf(root);
        }

        @Override
        public void consumeTerms(Query query, Term ... terms) {
            if (query != this.root) {
                this.total = this.defSize > 0L ? (this.total += this.defSize) : (this.total += RamUsageEstimator.shallowSizeOf(query));
            }
            if (terms != null) {
                this.total += RamUsageEstimator.sizeOf(terms);
            }
        }

        @Override
        public void visitLeaf(Query query) {
            if (query == this.root) {
                return;
            }
            this.total = query instanceof Accountable ? (this.total += ((Accountable)((Object)query)).ramBytesUsed()) : (this.defSize > 0L ? (this.total += this.defSize) : (this.total += RamUsageEstimator.shallowSizeOf(query)));
        }

        @Override
        public QueryVisitor getSubVisitor(BooleanClause.Occur occur, Query parent) {
            return this;
        }
    }
}

