/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.draw2d;

import java.beans.PropertyChangeListener;
import java.beans.PropertyChangeSupport;
import org.eclipse.draw2d.RangeModel;

public class DefaultRangeModel
implements RangeModel {
    protected PropertyChangeSupport propertyListeners = new PropertyChangeSupport(this);
    private int minimum = 0;
    private int maximum = 100;
    private int extent = 20;
    private int value = 0;

    @Override
    public void addPropertyChangeListener(PropertyChangeListener listener) {
        this.propertyListeners.addPropertyChangeListener(listener);
    }

    protected void firePropertyChange(String string, int oldValue, int newValue) {
        this.propertyListeners.firePropertyChange(string, oldValue, newValue);
    }

    @Override
    public int getExtent() {
        return this.extent;
    }

    @Override
    public int getMaximum() {
        return this.maximum;
    }

    @Override
    public int getMinimum() {
        return this.minimum;
    }

    @Override
    public int getValue() {
        return this.value;
    }

    @Override
    public boolean isEnabled() {
        return this.getMaximum() - this.getMinimum() > this.getExtent();
    }

    @Override
    public void removePropertyChangeListener(PropertyChangeListener listener) {
        this.propertyListeners.removePropertyChangeListener(listener);
    }

    @Override
    public void setAll(int min, int ext, int max) {
        int oldMin = this.minimum;
        int oldExtent = this.extent;
        int oldMax = this.maximum;
        this.maximum = max;
        this.minimum = min;
        this.extent = ext;
        if (oldMax != max) {
            this.firePropertyChange("maximum", oldMax, max);
        }
        if (oldExtent != ext) {
            this.firePropertyChange("extent", oldExtent, ext);
        }
        if (oldMin != min) {
            this.firePropertyChange("minimum", oldMin, min);
        }
        this.setValue(this.getValue());
    }

    @Override
    public void setExtent(int extent) {
        if (this.extent == extent) {
            return;
        }
        int oldValue = this.extent;
        this.extent = extent;
        this.firePropertyChange("extent", oldValue, extent);
        this.setValue(this.getValue());
    }

    @Override
    public void setMaximum(int maximum) {
        if (this.maximum == maximum) {
            return;
        }
        int oldValue = this.maximum;
        this.maximum = maximum;
        this.firePropertyChange("maximum", oldValue, maximum);
        this.setValue(this.getValue());
    }

    @Override
    public void setMinimum(int minimum) {
        if (this.minimum == minimum) {
            return;
        }
        int oldValue = this.minimum;
        this.minimum = minimum;
        this.firePropertyChange("minimum", oldValue, minimum);
        this.setValue(this.getValue());
    }

    @Override
    public void setValue(int value) {
        value = Math.max(this.getMinimum(), Math.min(this.getMaximum() - this.getExtent(), value));
        if (this.value == value) {
            return;
        }
        int oldValue = this.value;
        this.value = value;
        this.firePropertyChange("value", oldValue, value);
    }

    public String toString() {
        return String.valueOf(super.toString()) + " (" + this.minimum + ", " + this.maximum + ", " + this.extent + ", " + this.value + ")";
    }
}

