/*
 * Decompiled with CFR 0.152.
 */
package com.jaspersoft.studio.editor.jrexpressions.ui.support.java;

import com.jaspersoft.studio.editor.jrexpressions.ui.messages.Messages;
import com.jaspersoft.studio.editor.jrexpressions.ui.support.ObjectCategorySelectionEvent;
import com.jaspersoft.studio.editor.jrexpressions.ui.support.java.EditingAreaHelper;
import com.jaspersoft.studio.utils.UIUtil;
import java.util.ArrayList;
import net.sf.jasperreports.eclipse.util.Misc;
import net.sf.jasperreports.expressions.annotations.JRExprFunctionBean;
import net.sf.jasperreports.expressions.annotations.JRExprFunctionParameterBean;
import org.eclipse.core.runtime.Assert;
import org.eclipse.swt.custom.CLabel;
import org.eclipse.swt.custom.ScrolledComposite;
import org.eclipse.swt.events.FocusEvent;
import org.eclipse.swt.events.FocusListener;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.events.MouseEvent;
import org.eclipse.swt.events.MouseListener;
import org.eclipse.swt.graphics.Font;
import org.eclipse.swt.graphics.FontData;
import org.eclipse.swt.layout.FillLayout;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Text;
import org.eclipse.wb.swt.ResourceManager;

public class FunctionDetailsComposite
extends Composite {
    private JRExprFunctionBean function;
    private ScrolledComposite contentArea;
    private EditingAreaHelper editingAreaInfo;

    public FunctionDetailsComposite(Composite parent, int style, JRExprFunctionBean function) {
        super(parent, style);
        Assert.isNotNull((Object)function);
        this.function = function;
        GridLayout gl = new GridLayout(1, false);
        gl.marginHeight = 0;
        gl.verticalSpacing = 5;
        this.setLayout((Layout)gl);
        this.createTitleArea(this);
        this.createReturnTypeArea(this);
        this.createContentArea(this, true);
    }

    private void createTitleArea(Composite parent) {
        Label functionName = new Label(parent, 0);
        functionName.setLayoutData((Object)new GridData(16384, 128, true, false));
        functionName.setText(this.function.getName());
        FontData fd = functionName.getFont().getFontData()[0];
        functionName.setFont(ResourceManager.getFont((String)fd.getName(), (int)((int)fd.height + 2), (int)(fd.getStyle() | 1)));
        Label functionDescription = new Label(parent, 64);
        functionDescription.setLayoutData((Object)new GridData(16384, 128, true, false));
        functionDescription.setText(this.function.getDescription());
        Label separator = new Label(parent, 258);
        GridData sepGD = new GridData(4, 128, true, false, 2, 1);
        separator.setLayoutData((Object)sepGD);
    }

    private void createReturnTypeArea(Composite parent) {
        Label returnTypeText = new Label(parent, 64);
        returnTypeText.setLayoutData((Object)new GridData(16384, 128, true, false));
        returnTypeText.setText(Messages.FunctionDetailsComposite_ReturnTypeText);
        Label returnType = new Label(parent, 0);
        returnType.setLayoutData((Object)new GridData(16384, 128, true, false));
        returnType.setText(this.function.getReturnType().getCanonicalName());
        returnType.setFont(ResourceManager.getBoldFont((Font)returnType.getFont()));
        Label separator = new Label(parent, 258);
        separator.setLayoutData((Object)new GridData(4, 128, true, false));
    }

    private void createContentArea(Composite parent, boolean hidden) {
        this.contentArea = new ScrolledComposite(parent, 768);
        this.contentArea.setLayout((Layout)new FillLayout());
        Composite childCmp = new Composite((Composite)this.contentArea, 0);
        GridLayout gl = new GridLayout(3, false);
        gl.marginWidth = 0;
        gl.horizontalSpacing = 5;
        gl.verticalSpacing = 10;
        childCmp.setLayout((Layout)gl);
        GridData gd = new GridData(4, 4, true, true);
        this.contentArea.setLayoutData((Object)gd);
        int paramIndex = 0;
        for (JRExprFunctionParameterBean p : this.function.getParameters()) {
            int numEl = p.isMulti() ? 10 : 1;
            int i = 1;
            while (i <= numEl) {
                ++paramIndex;
                CLabel paramLbl = new CLabel(childCmp, 0);
                paramLbl.setToolTipText(p.getDescription());
                paramLbl.setLayoutData((Object)new GridData(16384, 0x1000000, false, false));
                String paramLblText = p.getName();
                if (numEl > 1) {
                    paramLblText = String.valueOf(paramLblText) + " " + i;
                }
                if (i == 1 && !p.isOptional()) {
                    paramLblText = String.valueOf(paramLblText) + " *";
                }
                paramLbl.setText(paramLblText);
                CLabel enterFunctionLbl = new CLabel(childCmp, 0);
                enterFunctionLbl.setImage(ResourceManager.getPluginImage((String)"com.jaspersoft.studio.editor.jrexpressions.ui", (String)"/resources/icons/enterfunction.gif"));
                GridData enterFunctGD = new GridData(16384, 0x1000000, false, false);
                enterFunctGD.horizontalIndent = 5;
                enterFunctionLbl.setLayoutData((Object)enterFunctGD);
                enterFunctionLbl.setCursor(ResourceManager.getCursor((int)21));
                enterFunctionLbl.setToolTipText(Messages.FunctionDetailsComposite_ComplexExprTooltip);
                final Text paramValue = new Text(childCmp, 2049);
                paramValue.setData("PARAM_RELATIVE_POSITION", (Object)i);
                paramValue.setData("PARAM_INDEX", (Object)paramIndex);
                GridData pValueGD = new GridData(16384, 0x1000000, true, false);
                pValueGD.widthHint = 150;
                paramValue.setLayoutData((Object)pValueGD);
                UIUtil.addSelectOnFocusToText((Text)paramValue);
                paramValue.addFocusListener(new FocusListener(){

                    public void focusLost(FocusEvent e) {
                    }

                    public void focusGained(FocusEvent e) {
                        FunctionDetailsComposite.this.editingAreaInfo.setUpdate(true);
                        FunctionDetailsComposite.this.selectFunctionArgument((Text)e.widget);
                        FunctionDetailsComposite.this.editingAreaInfo.setUpdate(false);
                    }
                });
                paramValue.addModifyListener(new ModifyListener(){

                    public void modifyText(ModifyEvent e) {
                        if (FunctionDetailsComposite.this.editingAreaInfo.isUpdate()) {
                            return;
                        }
                        FunctionDetailsComposite.this.editingAreaInfo.setUpdate(true);
                        FunctionDetailsComposite.this.editingAreaInfo.ignoreAutoEditStrategies(true);
                        FunctionDetailsComposite.this.editingAreaInfo.insertAtCurrentLocation(((Text)e.widget).getText(), true, false);
                        FunctionDetailsComposite.this.editingAreaInfo.ignoreAutoEditStrategies(false);
                        FunctionDetailsComposite.this.editingAreaInfo.setUpdate(false);
                    }
                });
                enterFunctionLbl.addMouseListener(new MouseListener(){

                    public void mouseUp(MouseEvent e) {
                    }

                    public void mouseDown(MouseEvent e) {
                        ObjectCategorySelectionEvent selectionEvent = new ObjectCategorySelectionEvent(e.widget);
                        paramValue.setFocus();
                        FunctionDetailsComposite.this.showParametersPanel(false);
                        FunctionDetailsComposite.this.editingAreaInfo.notifyCategorySelection(selectionEvent);
                    }

                    public void mouseDoubleClick(MouseEvent e) {
                    }
                });
                ++i;
            }
        }
        this.contentArea.setContent((Control)childCmp);
        childCmp.setSize(childCmp.computeSize(-1, -1));
        this.contentArea.setVisible(!hidden);
        this.contentArea.setEnabled(!hidden);
        gd.exclude = hidden;
    }

    public void showParametersPanel(boolean show) {
        this.contentArea.setVisible(show);
        this.contentArea.setEnabled(show);
        ((GridData)this.contentArea.getLayoutData()).exclude = !show;
        this.contentArea.getParent().layout();
        if (show) {
            this.loadFunctionParameters();
        }
    }

    private void loadFunctionParameters() {
        if (this.editingAreaInfo.isUpdate()) {
            return;
        }
        this.editingAreaInfo.setUpdate(true);
        Control[] children = ((Composite)this.contentArea.getChildren()[0]).getChildren();
        int i = 0;
        while (i < children.length) {
            if (i % 3 == 2) {
                ((Text)children[i]).setText(Misc.nvl((String)this.editingAreaInfo.getTextForArgument((i + 1) / 3)).trim());
            }
            ++i;
        }
        this.editingAreaInfo.setUpdate(false);
    }

    private void selectFunctionArgument(Text widget) {
        Integer positionToSelect = (Integer)widget.getData("PARAM_INDEX");
        Integer lastNonEmptyPosition = 0;
        ArrayList<String> parametersTexts = new ArrayList<String>();
        Control[] children = widget.getParent().getChildren();
        int i = 0;
        while (i < children.length) {
            if (i % 3 == 2) {
                String currParamText = ((Text)children[i]).getText().trim();
                parametersTexts.add(currParamText);
                if (!currParamText.isEmpty()) {
                    lastNonEmptyPosition = (Integer)children[i].getData("PARAM_INDEX");
                }
            }
            ++i;
        }
        this.editingAreaInfo.selectMethodArgument(positionToSelect, Math.max(positionToSelect, lastNonEmptyPosition), parametersTexts);
    }

    public void setVisible(boolean visible) {
        if (!visible) {
            this.showParametersPanel(false);
        }
        super.setVisible(visible);
    }

    public void setEditingAreaInfo(EditingAreaHelper editingAreaInfo) {
        this.editingAreaInfo = editingAreaInfo;
    }
}

