/*
 * Decompiled with CFR 0.152.
 */
package com.jaspersoft.studio.editor.jrexpressions.ui.support.java;

import com.jaspersoft.studio.editor.expression.CrosstabTotalVariable;
import com.jaspersoft.studio.editor.expression.ExpObject;
import com.jaspersoft.studio.editor.expression.ExpressionContext;
import com.jaspersoft.studio.editor.expression.ExpressionEditorSupportUtil;
import com.jaspersoft.studio.editor.expression.FunctionsLibraryUtil;
import com.jaspersoft.studio.editor.jrexpressions.functions.AdditionalStaticFunctions;
import com.jaspersoft.studio.editor.jrexpressions.ui.messages.Messages;
import com.jaspersoft.studio.editor.jrexpressions.ui.support.ObjectCategoryItem;
import com.jaspersoft.studio.editor.jrexpressions.ui.support.ObjectItemStyledLabelProvider;
import com.jaspersoft.studio.editor.jrexpressions.ui.support.TreeArrayContentProvider;
import com.jaspersoft.studio.editor.jrexpressions.ui.support.java.EditingAreaHelper;
import com.jaspersoft.studio.editor.jrexpressions.ui.support.java.FunctionDetailsComposite;
import com.jaspersoft.studio.preferences.ExpressionEditorPreferencePage;
import com.jaspersoft.studio.utils.RecentExpressions;
import com.jaspersoft.studio.utils.jasper.JasperReportsConfiguration;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import net.sf.jasperreports.crosstabs.JRCrosstabColumnGroup;
import net.sf.jasperreports.crosstabs.JRCrosstabMeasure;
import net.sf.jasperreports.crosstabs.JRCrosstabRowGroup;
import net.sf.jasperreports.crosstabs.design.JRDesignCrosstab;
import net.sf.jasperreports.crosstabs.design.JRDesignCrosstabColumnGroup;
import net.sf.jasperreports.crosstabs.design.JRDesignCrosstabMeasure;
import net.sf.jasperreports.crosstabs.design.JRDesignCrosstabParameter;
import net.sf.jasperreports.crosstabs.design.JRDesignCrosstabRowGroup;
import net.sf.jasperreports.engine.JRField;
import net.sf.jasperreports.engine.JRParameter;
import net.sf.jasperreports.engine.JRVariable;
import net.sf.jasperreports.expressions.annotations.JRExprFunctionBean;
import org.eclipse.jface.viewers.ColumnViewer;
import org.eclipse.jface.viewers.ColumnViewerToolTipSupport;
import org.eclipse.jface.viewers.DoubleClickEvent;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.IDoubleClickListener;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.SelectionChangedEvent;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.jface.viewers.TreeViewer;
import org.eclipse.swt.custom.SashForm;
import org.eclipse.swt.custom.StackLayout;
import org.eclipse.swt.dnd.DragSource;
import org.eclipse.swt.dnd.DragSourceEvent;
import org.eclipse.swt.dnd.DragSourceListener;
import org.eclipse.swt.dnd.TextTransfer;
import org.eclipse.swt.dnd.Transfer;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.ToolBar;
import org.eclipse.swt.widgets.ToolItem;
import org.eclipse.swt.widgets.TreeItem;
import org.eclipse.ui.dialogs.FilteredTree;
import org.eclipse.ui.dialogs.PatternFilter;
import org.eclipse.wb.swt.ResourceManager;

public class ObjectCategoryDetailsPanel
extends Composite {
    private TreeViewer categoryContent;
    private Composite additionalDetailsCmp;
    private StackLayout additionalDetailsStackLayout;
    private ToolItem hideBuiltinParams;
    private ToolItem hideBuiltinVariables;
    private ToolItem sortIncreaseItems;
    private ToolItem sortDecreaseItems;
    private ObjectItemStyledLabelProvider categoryContentLblProvider;
    private SashForm panelSashForm;
    private ToolBar buttonsToolbar;
    private ExpressionContext exprContext;
    private Map<String, Control> additionalDetailControls = new HashMap<String, Control>();
    private ObjectCategoryItem selItem;
    private List<Object> categoryDetails;
    private boolean functionMode = false;
    private EditingAreaHelper editingAreaInfo;
    private ObjectCategoryItem.Category previousCategory;

    public ObjectCategoryDetailsPanel(Composite parent, int style) {
        super(parent, style);
        GridLayout layout = new GridLayout(1, true);
        layout.marginWidth = 0;
        layout.marginHeight = 0;
        this.setLayout((Layout)layout);
        this.panelSashForm = new SashForm((Composite)this, 256);
        GridData layoutData = new GridData(4, 4, true, true);
        layoutData.widthHint = 600;
        this.panelSashForm.setLayoutData((Object)layoutData);
        Composite categoryContentCmp = new Composite((Composite)this.panelSashForm, 0);
        GridLayout layout2 = new GridLayout(1, false);
        layout2.marginWidth = 0;
        layout2.marginHeight = 0;
        categoryContentCmp.setLayout((Layout)layout2);
        FilteredTree ft = new FilteredTree(categoryContentCmp, 68096, new PatternFilter(), true);
        this.categoryContent = ft.getViewer();
        GridData catContentGD = new GridData(4, 4, true, true);
        catContentGD.heightHint = 350;
        ft.setLayoutData((Object)catContentGD);
        ColumnViewerToolTipSupport.enableFor((ColumnViewer)this.categoryContent);
        this.categoryContentLblProvider = new ObjectItemStyledLabelProvider();
        this.categoryContent.setLabelProvider((IBaseLabelProvider)this.categoryContentLblProvider);
        this.categoryContent.setContentProvider((IContentProvider)new TreeArrayContentProvider());
        this.categoryContent.addSelectionChangedListener(new ISelectionChangedListener(){

            public void selectionChanged(SelectionChangedEvent event) {
                Object selItem;
                ObjectCategoryItem.Category currCategory = ObjectCategoryDetailsPanel.this.selItem.getCategory();
                if (!ObjectCategoryItem.Category.RECENT_EXPRESSIONS.equals((Object)currCategory) && !ObjectCategoryItem.Category.USER_DEFINED_EXPRESSIONS.equals((Object)currCategory) && (selItem = ((IStructuredSelection)event.getSelection()).getFirstElement()) != null) {
                    ObjectCategoryDetailsPanel.this.refreshAdditionalDetailsUI(selItem);
                    if (ObjectCategoryDetailsPanel.this.functionMode && !ObjectCategoryDetailsPanel.this.editingAreaInfo.isUpdate()) {
                        ObjectCategoryDetailsPanel.this.showFunctionDetailsPanel();
                        ObjectCategoryDetailsPanel.this.functionMode = false;
                    }
                }
            }
        });
        this.categoryContent.addDoubleClickListener(new IDoubleClickListener(){

            public void doubleClick(DoubleClickEvent event) {
                Object selObject = ((IStructuredSelection)ObjectCategoryDetailsPanel.this.categoryContent.getSelection()).getFirstElement();
                if (selObject instanceof ExpObject) {
                    ObjectCategoryDetailsPanel.this.editingAreaInfo.setUpdate(true);
                    ObjectCategoryDetailsPanel.this.editingAreaInfo.insertAtCurrentLocation(((ExpObject)selObject).getExpression(), false, true);
                    ObjectCategoryDetailsPanel.this.editingAreaInfo.setUpdate(false);
                } else if (selObject instanceof JRExprFunctionBean) {
                    ObjectCategoryDetailsPanel.this.editingAreaInfo.setUpdate(true);
                    ObjectCategoryDetailsPanel.this.editingAreaInfo.insertAtCurrentLocation(String.valueOf(((JRExprFunctionBean)selObject).getId()) + "( )", false, false);
                    ObjectCategoryDetailsPanel.this.editingAreaInfo.moveCaretToNextParenthesis();
                    ObjectCategoryDetailsPanel.this.editingAreaInfo.setUpdate(false);
                    ObjectCategoryDetailsPanel.this.showFunctionDetailsPanel();
                } else if (selObject instanceof String) {
                    ObjectCategoryDetailsPanel.this.editingAreaInfo.setUpdate(true);
                    ObjectCategoryDetailsPanel.this.editingAreaInfo.insertAtCurrentLocation((String)selObject, false, true);
                    ObjectCategoryDetailsPanel.this.editingAreaInfo.setUpdate(false);
                }
            }
        });
        this.addDragSupport(this.categoryContent);
        this.buttonsToolbar = new ToolBar(categoryContentCmp, 0x800000);
        this.buttonsToolbar.setLayoutData((Object)new GridData(16384, 1024, false, false));
        this.hideBuiltinParams = new ToolItem(this.buttonsToolbar, 32);
        this.hideBuiltinParams.setImage(ResourceManager.getPluginImage((String)"com.jaspersoft.studio.editor.jrexpressions.ui", (String)"/resources/icons/filter-parameters.png"));
        this.hideBuiltinParams.setEnabled(false);
        this.hideBuiltinParams.setSelection(!ExpressionEditorSupportUtil.isShowBuiltInParameters());
        this.hideBuiltinParams.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                if (ObjectCategoryDetailsPanel.this.additionalDetailsStackLayout.topControl != null) {
                    ObjectCategoryDetailsPanel.this.additionalDetailsStackLayout.topControl.setVisible(ExpressionEditorSupportUtil.toggleShowBuiltInParameters());
                    ObjectCategoryDetailsPanel.this.refreshPanelUI(ObjectCategoryDetailsPanel.this.selItem, true);
                } else {
                    ExpressionEditorSupportUtil.toggleShowBuiltInParameters();
                    ObjectCategoryDetailsPanel.this.refreshPanelUI(ObjectCategoryDetailsPanel.this.selItem, true);
                }
            }
        });
        this.hideBuiltinParams.setToolTipText(Messages.ObjectCategoryDetailsPanel_HideBuiltInParametersTooltip);
        this.hideBuiltinVariables = new ToolItem(this.buttonsToolbar, 32);
        this.hideBuiltinVariables.setImage(ResourceManager.getPluginImage((String)"com.jaspersoft.studio.editor.jrexpressions.ui", (String)"/resources/icons/filter-variables.png"));
        this.hideBuiltinVariables.setEnabled(false);
        this.hideBuiltinVariables.setSelection(!ExpressionEditorSupportUtil.isShowBuiltInVariables());
        this.hideBuiltinVariables.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                if (ObjectCategoryDetailsPanel.this.additionalDetailsStackLayout.topControl != null) {
                    ObjectCategoryDetailsPanel.this.additionalDetailsStackLayout.topControl.setVisible(ExpressionEditorSupportUtil.toggleShowBuiltInVariables());
                    ObjectCategoryDetailsPanel.this.refreshPanelUI(ObjectCategoryDetailsPanel.this.selItem, true);
                } else {
                    ExpressionEditorSupportUtil.toggleShowBuiltInVariables();
                    ObjectCategoryDetailsPanel.this.refreshPanelUI(ObjectCategoryDetailsPanel.this.selItem, true);
                }
            }
        });
        this.hideBuiltinVariables.setToolTipText(Messages.ObjectCategoryDetailsPanel_HideBuiltinVars);
        this.sortIncreaseItems = new ToolItem(this.buttonsToolbar, 32);
        this.sortIncreaseItems.setImage(ResourceManager.getPluginImage((String)"com.jaspersoft.studio.editor.jrexpressions.ui", (String)"/resources/icons/sort_increase.png"));
        this.sortIncreaseItems.setEnabled(true);
        this.sortIncreaseItems.setSelection(false);
        this.sortIncreaseItems.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                ExpressionEditorSupportUtil.toggleSortIncreaseItems((int)ObjectCategoryDetailsPanel.this.getExpObjectType(ObjectCategoryDetailsPanel.this.selItem));
                ObjectCategoryDetailsPanel.this.sortDecreaseItems.setSelection(false);
                ObjectCategoryDetailsPanel.this.refreshPanelUI(ObjectCategoryDetailsPanel.this.selItem, true);
            }
        });
        this.sortDecreaseItems = new ToolItem(this.buttonsToolbar, 32);
        this.sortDecreaseItems.setImage(ResourceManager.getPluginImage((String)"com.jaspersoft.studio.editor.jrexpressions.ui", (String)"/resources/icons/sort_decrease.png"));
        this.sortDecreaseItems.setEnabled(true);
        this.sortDecreaseItems.setSelection(false);
        this.sortDecreaseItems.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                ExpressionEditorSupportUtil.toggleSortDecreaseItems((int)ObjectCategoryDetailsPanel.this.getExpObjectType(ObjectCategoryDetailsPanel.this.selItem));
                ObjectCategoryDetailsPanel.this.sortIncreaseItems.setSelection(false);
                ObjectCategoryDetailsPanel.this.refreshPanelUI(ObjectCategoryDetailsPanel.this.selItem, true);
            }
        });
        this.additionalDetailsCmp = new Composite((Composite)this.panelSashForm, 0);
        this.additionalDetailsCmp.setLayoutData((Object)layoutData);
        this.additionalDetailsStackLayout = new StackLayout();
        this.additionalDetailsCmp.setLayout((Layout)this.additionalDetailsStackLayout);
        this.panelSashForm.setWeights(new int[]{40, 60});
    }

    private int getExpObjectType(ObjectCategoryItem selItem) {
        switch (selItem.getCategory()) {
            case FIELDS: 
            case FDATASET: {
                return 0;
            }
            case PARAMETERS: 
            case PDATASET: {
                return 2;
            }
            case RESOURCE_KEYS: {
                return 3;
            }
            case VARIABLES: 
            case VDATASET: {
                return 1;
            }
        }
        return -1;
    }

    public void refreshPanelUI(ObjectCategoryItem selItem) {
        this.refreshPanelUI(selItem, false);
    }

    public void refreshPanelUI(ObjectCategoryItem selItem, boolean force) {
        TreeItem item;
        ISelection currSelection;
        this.selItem = selItem;
        this.categoryContentLblProvider.setCategory(this.selItem.getCategory());
        if (force || !selItem.getCategory().equals((Object)this.previousCategory)) {
            this.updateCategoryChildren(selItem);
            this.previousCategory = this.selItem.getCategory();
        }
        if (selItem.getCategory() == ObjectCategoryItem.Category.BUILT_IN_FUNCTIONS && this.editingAreaInfo != null && this.editingAreaInfo.getCurrentLibraryFunctionName() != null) {
            String currFunctionName = this.editingAreaInfo.getCurrentLibraryFunctionName();
            TreeItem[] treeItemArray = this.categoryContent.getTree().getItems();
            int n = treeItemArray.length;
            int n2 = 0;
            while (n2 < n) {
                TreeItem item2 = treeItemArray[n2];
                JRExprFunctionBean function = (JRExprFunctionBean)item2.getData();
                if (function.getId().equals(currFunctionName)) {
                    this.functionMode = true;
                    this.categoryContent.setSelection((ISelection)new StructuredSelection(item2.getData()), true);
                    break;
                }
                ++n2;
            }
        } else if (this.categoryContent.getTree().getItemCount() > 0 && ((currSelection = this.categoryContent.getSelection()) == null || StructuredSelection.EMPTY.equals((Object)currSelection)) && !(item = this.categoryContent.getTree().getItem(0)).getData().equals(((StructuredSelection)currSelection).getFirstElement())) {
            this.categoryContent.setSelection((ISelection)new StructuredSelection(item.getData()), true);
        }
    }

    private void updateCategoryChildren(ObjectCategoryItem selItem) {
        this.categoryContent.getTree().clearAll(true);
        this.categoryDetails = new ArrayList<Object>();
        switch (selItem.getCategory()) {
            case PARAMETERS: 
            case PDATASET: {
                this.hideBuiltinVariables.setEnabled(false);
                this.hideBuiltinVariables.setSelection(!ExpressionEditorSupportUtil.isShowBuiltInVariables());
                this.hideBuiltinParams.setEnabled(true);
                this.hideBuiltinParams.setSelection(!ExpressionEditorSupportUtil.isShowBuiltInParameters());
                this.sortDecreaseItems.setSelection(ExpressionEditorSupportUtil.isSortDecreaseItems((int)2));
                this.sortIncreaseItems.setSelection(ExpressionEditorSupportUtil.isSortIncreaseItems((int)2));
                ArrayList<ExpObject> paramsList = new ArrayList<ExpObject>();
                Object paramsNodedata = selItem.getData();
                if (paramsNodedata instanceof List) {
                    paramsList.addAll(this.getParametersDTOList(((List)paramsNodedata).iterator()));
                }
                this.categoryDetails.addAll(paramsList);
                break;
            }
            case VARIABLES: 
            case VDATASET: {
                this.hideBuiltinVariables.setEnabled(true);
                this.hideBuiltinVariables.setSelection(!ExpressionEditorSupportUtil.isShowBuiltInVariables());
                this.hideBuiltinParams.setEnabled(false);
                this.hideBuiltinParams.setSelection(!ExpressionEditorSupportUtil.isShowBuiltInParameters());
                this.sortDecreaseItems.setSelection(ExpressionEditorSupportUtil.isSortDecreaseItems((int)1));
                this.sortIncreaseItems.setSelection(ExpressionEditorSupportUtil.isSortIncreaseItems((int)1));
                ArrayList<ExpObject> variablesList = new ArrayList<ExpObject>();
                Object variablesNodeData = selItem.getData();
                if (variablesNodeData instanceof List) {
                    variablesList.addAll(this.getVariablesDTOList(((List)variablesNodeData).iterator()));
                }
                this.categoryDetails.addAll(variablesList);
                break;
            }
            case FIELDS: 
            case FDATASET: {
                this.hideBuiltinVariables.setEnabled(false);
                this.hideBuiltinVariables.setSelection(!ExpressionEditorSupportUtil.isShowBuiltInVariables());
                this.hideBuiltinParams.setEnabled(false);
                this.hideBuiltinParams.setSelection(!ExpressionEditorSupportUtil.isShowBuiltInParameters());
                this.sortDecreaseItems.setSelection(ExpressionEditorSupportUtil.isSortDecreaseItems((int)0));
                this.sortIncreaseItems.setSelection(ExpressionEditorSupportUtil.isSortIncreaseItems((int)0));
                ArrayList<ExpObject> fieldsList = new ArrayList<ExpObject>();
                Object fieldsNodeData = selItem.getData();
                if (fieldsNodeData instanceof List) {
                    fieldsList.addAll(this.getFieldsDTOList(((List)fieldsNodeData).iterator()));
                }
                this.categoryDetails.addAll(fieldsList);
                break;
            }
            case RESOURCE_KEYS: {
                this.hideBuiltinVariables.setEnabled(false);
                this.hideBuiltinVariables.setSelection(!ExpressionEditorSupportUtil.isShowBuiltInVariables());
                this.hideBuiltinParams.setEnabled(false);
                this.hideBuiltinParams.setSelection(!ExpressionEditorSupportUtil.isShowBuiltInParameters());
                this.sortDecreaseItems.setSelection(ExpressionEditorSupportUtil.isSortDecreaseItems((int)3));
                this.sortIncreaseItems.setSelection(ExpressionEditorSupportUtil.isSortIncreaseItems((int)3));
                ArrayList<ExpObject> rbKeysList = new ArrayList<ExpObject>();
                Object rbKeysListData = selItem.getData();
                if (rbKeysListData instanceof List) {
                    rbKeysList.addAll(this.getRBKeysDTOList((List)rbKeysListData));
                }
                this.categoryDetails.addAll(rbKeysList);
                break;
            }
            case FUNCTION_CATEGORY: {
                List categoryFunctions = FunctionsLibraryUtil.getFunctionsByCategory((String)((String)selItem.getData()));
                Collections.sort(categoryFunctions);
                this.categoryDetails.addAll(categoryFunctions);
                ((GridData)this.buttonsToolbar.getLayoutData()).exclude = true;
                this.buttonsToolbar.getParent().layout();
                break;
            }
            case RECENT_EXPRESSIONS: {
                this.categoryDetails.addAll(RecentExpressions.getRecentExpressionsList());
                this.configureMinimalLayout();
                break;
            }
            case USER_DEFINED_EXPRESSIONS: {
                this.categoryDetails.addAll(ExpressionEditorPreferencePage.getUserDefinedExpressionList());
                this.configureMinimalLayout();
                break;
            }
            case CROSSTAB: {
                JRDesignCrosstab crosstab = (JRDesignCrosstab)selItem.getData();
                List rowGroups = crosstab.getRowGroupsList();
                List columnGroups = crosstab.getColumnGroupsList();
                for (JRDesignCrosstabMeasure measure : crosstab.getMesuresList()) {
                    this.categoryDetails.add(new ExpObject((Object)measure.getVariable()));
                    int i = 0;
                    while (i < rowGroups.size()) {
                        JRDesignCrosstabRowGroup rowGroup = (JRDesignCrosstabRowGroup)rowGroups.get(i);
                        this.categoryDetails.add(new CrosstabTotalVariable((JRCrosstabMeasure)measure, (JRCrosstabRowGroup)rowGroup, null));
                        int j = 0;
                        while (j < columnGroups.size()) {
                            JRDesignCrosstabColumnGroup columnGroup = (JRDesignCrosstabColumnGroup)columnGroups.get(j);
                            if (j == 0) {
                                this.categoryDetails.add(new CrosstabTotalVariable((JRCrosstabMeasure)measure, null, (JRCrosstabColumnGroup)columnGroup));
                            }
                            this.categoryDetails.add(new CrosstabTotalVariable((JRCrosstabMeasure)measure, (JRCrosstabRowGroup)rowGroup, (JRCrosstabColumnGroup)columnGroup));
                            ++j;
                        }
                        ++i;
                    }
                }
                int i = 0;
                while (i < rowGroups.size()) {
                    JRDesignCrosstabRowGroup rowGroup = (JRDesignCrosstabRowGroup)rowGroups.get(i);
                    this.categoryDetails.add(new ExpObject((Object)rowGroup.getVariable()));
                    ++i;
                }
                i = 0;
                while (i < columnGroups.size()) {
                    JRDesignCrosstabColumnGroup columnGroup = (JRDesignCrosstabColumnGroup)columnGroups.get(i);
                    this.categoryDetails.add(new ExpObject((Object)columnGroup.getVariable()));
                    ++i;
                }
                List crosstabParameters = crosstab.getParametersList();
                int i2 = 0;
                while (i2 < crosstabParameters.size()) {
                    JRDesignCrosstabParameter parameter = (JRDesignCrosstabParameter)crosstabParameters.get(i2);
                    this.categoryDetails.add(new ExpObject((Object)parameter));
                    ++i2;
                }
                break;
            }
            case BUILT_IN_FUNCTIONS: {
                List allFunctionsLst = FunctionsLibraryUtil.getAllFunctions();
                Collections.sort(allFunctionsLst);
                this.categoryDetails.addAll(allFunctionsLst);
                this.categoryDetails.addAll(AdditionalStaticFunctions.getAllFunctions());
                ((GridData)this.buttonsToolbar.getLayoutData()).exclude = true;
                this.buttonsToolbar.getParent().layout();
                break;
            }
            case STATIC_FUNCTION_CATEGORY: {
                this.categoryDetails.addAll((List)selItem.getData());
                ((GridData)this.buttonsToolbar.getLayoutData()).exclude = true;
                this.buttonsToolbar.getParent().layout();
                break;
            }
        }
        this.categoryContent.setInput((Object)this.categoryDetails.toArray());
    }

    private void configureMinimalLayout() {
        int[] nArray = new int[2];
        nArray[0] = 100;
        this.panelSashForm.setWeights(nArray);
        this.panelSashForm.SASH_WIDTH = 0;
        this.buttonsToolbar.setVisible(false);
        ((GridData)this.buttonsToolbar.getLayoutData()).exclude = true;
        this.buttonsToolbar.getParent().layout();
    }

    private void refreshAdditionalDetailsUI(Object selItem) {
        String key = this.getItemKey(selItem);
        Object currentControl = this.additionalDetailControls.get(key);
        if (currentControl == null) {
            if (selItem instanceof ExpObject) {
                Composite cmp = new Composite(this.additionalDetailsCmp, 0);
                GridLayout gl = new GridLayout(1, true);
                gl.marginHeight = 0;
                gl.marginWidth = 0;
                cmp.setLayout((Layout)gl);
                FilteredTree ft = new FilteredTree(cmp, 68097, new PatternFilter(), true);
                ft.setLayoutData((Object)new GridData(4, 4, true, true));
                final TreeViewer tv = ft.getViewer();
                ColumnViewerToolTipSupport.enableFor((ColumnViewer)tv);
                this.addDragSupport(tv);
                currentControl = cmp;
                List<String> methodFirms = this.getExpObjectMethodFirms((ExpObject)selItem);
                tv.setContentProvider((IContentProvider)new TreeArrayContentProvider());
                tv.setLabelProvider((IBaseLabelProvider)new ObjectItemStyledLabelProvider());
                Collections.sort(methodFirms);
                tv.setInput((Object)methodFirms.toArray());
                tv.addDoubleClickListener(new IDoubleClickListener(){

                    public void doubleClick(DoubleClickEvent event) {
                        Object selElement = ((IStructuredSelection)tv.getSelection()).getFirstElement();
                        Object categoryContentSel = ((IStructuredSelection)ObjectCategoryDetailsPanel.this.categoryContent.getSelection()).getFirstElement();
                        if (selElement instanceof String && categoryContentSel instanceof ExpObject) {
                            String detailStr = (String)selElement;
                            ObjectCategoryDetailsPanel.this.editingAreaInfo.setUpdate(true);
                            ObjectCategoryDetailsPanel.this.editingAreaInfo.insertAtCurrentLocation(String.valueOf(((ExpObject)categoryContentSel).getExpression()) + "." + detailStr.substring(0, detailStr.lastIndexOf(41) + 1), false, true);
                            ObjectCategoryDetailsPanel.this.editingAreaInfo.setUpdate(false);
                        }
                    }
                });
            } else if (selItem instanceof JRExprFunctionBean) {
                FunctionDetailsComposite fdetails = new FunctionDetailsComposite(this.additionalDetailsCmp, 0, (JRExprFunctionBean)selItem);
                fdetails.setLayoutData(new GridData(1808));
                fdetails.setEditingAreaInfo(this.editingAreaInfo);
                currentControl = fdetails;
            }
            if (currentControl != null) {
                this.additionalDetailControls.put(key, (Control)currentControl);
            }
        }
        Control[] children = this.additionalDetailsCmp.getChildren();
        int i = 0;
        while (i < children.length) {
            if (children[i] != currentControl) {
                children[i].setVisible(false);
            }
            ++i;
        }
        currentControl.setVisible(true);
        this.additionalDetailsStackLayout.topControl = currentControl;
        this.additionalDetailsCmp.layout();
    }

    private void showFunctionDetailsPanel() {
        FunctionDetailsComposite functionDetails = (FunctionDetailsComposite)this.additionalDetailsStackLayout.topControl;
        functionDetails.showParametersPanel(true);
    }

    public void setExpressionContext(ExpressionContext context) {
        this.exprContext = context;
    }

    public void setVisible(boolean visible) {
        if (this.additionalDetailsStackLayout.topControl != null) {
            if (this.categoryDetails == null || this.categoryDetails.isEmpty()) {
                this.additionalDetailsStackLayout.topControl.setVisible(false);
            } else {
                this.additionalDetailsStackLayout.topControl.setVisible(visible);
            }
        }
        super.setVisible(visible);
    }

    public void setEditingAreaInfo(EditingAreaHelper editingAreaInfo) {
        this.editingAreaInfo = editingAreaInfo;
    }

    private String getPrintableTypeName(String type) {
        if (type == null) {
            return "void";
        }
        if (type.endsWith(";")) {
            type = type.substring(0, type.length() - 1);
        }
        while (type.startsWith("[")) {
            if ((type = String.valueOf(type.substring(1)) + "[]").startsWith("[")) continue;
            if (type.startsWith("L")) {
                type = type.substring(1);
            }
            if (type.startsWith("Z")) {
                type = "boolean" + type.substring(1);
            }
            if (type.startsWith("B")) {
                type = "byte" + type.substring(1);
            }
            if (type.startsWith("C")) {
                type = "char" + type.substring(1);
            }
            if (type.startsWith("D")) {
                type = "double" + type.substring(1);
            }
            if (type.startsWith("F")) {
                type = "float" + type.substring(1);
            }
            if (type.startsWith("I")) {
                type = "int" + type.substring(1);
            }
            if (type.startsWith("J")) {
                type = "long" + type.substring(1);
            }
            if (!type.startsWith("S")) continue;
            type = "short" + type.substring(1);
        }
        if (type.startsWith("java.lang.") && (type = type.substring("java.lang.".length())).indexOf(".") > 0) {
            type = "java.lang." + type;
        }
        return type;
    }

    private String getItemKey(Object selItem) {
        String key = selItem.toString();
        if (selItem instanceof ExpObject) {
            key = String.valueOf(((ExpObject)selItem).getName()) + "_" + ((ExpObject)selItem).getClassType();
        } else if (selItem instanceof JRExprFunctionBean) {
            key = String.valueOf(((JRExprFunctionBean)selItem).getId()) + "_" + ((JRExprFunctionBean)selItem).getClass().getCanonicalName();
        }
        return key;
    }

    private List<String> getExpObjectMethodFirms(ExpObject selItem) {
        ArrayList<String> methodFirms = new ArrayList<String>();
        JasperReportsConfiguration jasperConfiguration = this.exprContext.getJasperReportsConfiguration();
        Class<?> loadClass = null;
        try {
            loadClass = jasperConfiguration.getClassLoader().loadClass(selItem.getClassType());
        }
        catch (ClassNotFoundException classNotFoundException) {}
        if (loadClass != null) {
            Method[] methods = loadClass.getMethods();
            int i = 0;
            while (i < methods.length) {
                if ((methods[i].getModifiers() & 1) != 0) {
                    String method_firm = String.valueOf(methods[i].getName()) + "(";
                    Class<?>[] params = methods[i].getParameterTypes();
                    int j = 0;
                    j = 0;
                    while (j < params.length) {
                        method_firm = j > 0 ? String.valueOf(method_firm) + ", " : String.valueOf(method_firm) + " ";
                        method_firm = String.valueOf(method_firm) + this.getPrintableTypeName(params[j].getName());
                        ++j;
                    }
                    if (j > 0) {
                        method_firm = String.valueOf(method_firm) + " ";
                    }
                    method_firm = String.valueOf(method_firm) + ") ";
                    String rname = methods[i].getReturnType().getName();
                    if (!rname.equals("void")) {
                        method_firm = String.valueOf(method_firm) + this.getPrintableTypeName(rname);
                        methodFirms.add(method_firm);
                    }
                }
                ++i;
            }
        }
        return methodFirms;
    }

    private List<ExpObject> getParametersDTOList(Iterator<JRParameter> parameters) {
        ArrayList<ExpObject> tmpParamList = new ArrayList<ExpObject>();
        while (parameters.hasNext()) {
            JRParameter parameter = parameters.next();
            if (!ExpressionEditorSupportUtil.isShowBuiltInParameters() && parameter.isSystemDefined()) continue;
            tmpParamList.add(new ExpObject((Object)parameter));
        }
        this.reorderList(tmpParamList);
        return tmpParamList;
    }

    private List<ExpObject> getVariablesDTOList(Iterator<JRVariable> variables) {
        ArrayList<ExpObject> tmpVarList = new ArrayList<ExpObject>();
        while (variables.hasNext()) {
            JRVariable variable = variables.next();
            if (!ExpressionEditorSupportUtil.isShowBuiltInVariables() && variable.isSystemDefined()) continue;
            tmpVarList.add(new ExpObject((Object)variable));
        }
        this.reorderList(tmpVarList);
        return tmpVarList;
    }

    private List<ExpObject> getFieldsDTOList(Iterator<JRField> fields) {
        ArrayList<ExpObject> tmpFieldList = new ArrayList<ExpObject>();
        while (fields.hasNext()) {
            ExpObject eo = new ExpObject((Object)fields.next());
            tmpFieldList.add(eo);
        }
        this.reorderList(tmpFieldList);
        return tmpFieldList;
    }

    private List<ExpObject> getRBKeysDTOList(List<String> rbkeys) {
        ArrayList<ExpObject> rbKeysList = new ArrayList<ExpObject>();
        for (String rbk : rbkeys) {
            rbKeysList.add(new ExpObject(rbk, 3, "java.lang.String"));
        }
        this.reorderList(rbKeysList);
        return rbKeysList;
    }

    private void reorderList(List<ExpObject> items) {
        if (ExpressionEditorSupportUtil.isSortDecreaseItems((int)this.getExpObjectType(this.selItem))) {
            Collections.sort(items);
            Collections.reverse(items);
        } else if (ExpressionEditorSupportUtil.isSortIncreaseItems((int)this.getExpObjectType(this.selItem))) {
            Collections.sort(items);
        }
    }

    private void addDragSupport(final TreeViewer tv) {
        DragSource dragSrc = new DragSource((Control)tv.getTree(), 17);
        dragSrc.setTransfer(new Transfer[]{TextTransfer.getInstance()});
        dragSrc.addDragListener(new DragSourceListener(){
            private int textLength = -1;
            private boolean moveNextParenthesis = false;

            public void dragStart(DragSourceEvent event) {
                TreeItem[] selection = tv.getTree().getSelection();
                if (selection != null && selection.length == 1) {
                    event.doit = true;
                }
                ObjectCategoryDetailsPanel.this.editingAreaInfo.setUpdate(true);
            }

            public void dragSetData(DragSourceEvent event) {
                Object selElement;
                StringBuffer dataTxtSB = new StringBuffer();
                Object categoryContentSel = ((IStructuredSelection)ObjectCategoryDetailsPanel.this.categoryContent.getSelection()).getFirstElement();
                if (categoryContentSel instanceof ExpObject) {
                    dataTxtSB.append(((ExpObject)categoryContentSel).getExpression());
                } else if (categoryContentSel instanceof JRExprFunctionBean) {
                    JRExprFunctionBean funct = (JRExprFunctionBean)categoryContentSel;
                    dataTxtSB.append(funct.getId()).append("()");
                    this.moveNextParenthesis = true;
                } else if (categoryContentSel instanceof String) {
                    dataTxtSB.append(categoryContentSel);
                } else {
                    dataTxtSB.append("");
                }
                if (tv != ObjectCategoryDetailsPanel.this.categoryContent && (selElement = ((IStructuredSelection)tv.getSelection()).getFirstElement()) instanceof String) {
                    String detailStr = (String)selElement;
                    dataTxtSB.append(".").append(detailStr.substring(0, detailStr.lastIndexOf(41) + 1));
                }
                String text = dataTxtSB.toString();
                this.textLength = text.length();
                event.data = text;
            }

            public void dragFinished(DragSourceEvent event) {
                if (event.doit && this.textLength > 0) {
                    if (this.moveNextParenthesis) {
                        ObjectCategoryDetailsPanel.this.editingAreaInfo.moveCaretToNextParenthesis();
                    } else {
                        ObjectCategoryDetailsPanel.this.editingAreaInfo.moveCaretAhead(this.textLength);
                    }
                }
                this.moveNextParenthesis = false;
                this.textLength = -1;
                ObjectCategoryDetailsPanel.this.editingAreaInfo.setUpdate(false);
            }
        });
    }
}

