/*
 * Decompiled with CFR 0.152.
 */
package com.jaspersoft.studio.html.model;

import com.jaspersoft.studio.html.HtmlNodeIconDescriptor;
import com.jaspersoft.studio.html.messages.Messages;
import com.jaspersoft.studio.model.ANode;
import com.jaspersoft.studio.model.DefaultValue;
import com.jaspersoft.studio.model.MGraphicElement;
import com.jaspersoft.studio.model.util.IIconDescriptor;
import com.jaspersoft.studio.property.descriptor.NullEnum;
import com.jaspersoft.studio.property.descriptor.checkbox.CheckBoxPropertyDescriptor;
import com.jaspersoft.studio.property.descriptor.combo.RComboBoxPropertyDescriptor;
import com.jaspersoft.studio.property.descriptor.expression.ExprUtil;
import com.jaspersoft.studio.property.descriptor.expression.JRExpressionPropertyDescriptor;
import com.jaspersoft.studio.property.descriptors.NamedEnumPropertyDescriptor;
import com.jaspersoft.studio.utils.EnumHelper;
import com.jaspersoft.studio.utils.ModelUtils;
import java.beans.PropertyChangeListener;
import java.util.List;
import java.util.Map;
import net.sf.jasperreports.components.html.HtmlComponent;
import net.sf.jasperreports.eclipse.util.Misc;
import net.sf.jasperreports.engine.JRDefaultStyleProvider;
import net.sf.jasperreports.engine.JRExpression;
import net.sf.jasperreports.engine.component.Component;
import net.sf.jasperreports.engine.component.ComponentKey;
import net.sf.jasperreports.engine.design.JRDesignComponentElement;
import net.sf.jasperreports.engine.design.JRDesignElement;
import net.sf.jasperreports.engine.design.JRDesignExpression;
import net.sf.jasperreports.engine.design.JasperDesign;
import net.sf.jasperreports.engine.design.events.JRChangeEventsSupport;
import net.sf.jasperreports.engine.type.EvaluationTimeEnum;
import net.sf.jasperreports.engine.type.HorizontalImageAlignEnum;
import net.sf.jasperreports.engine.type.NamedEnum;
import net.sf.jasperreports.engine.type.ScaleImageEnum;
import net.sf.jasperreports.engine.type.VerticalImageAlignEnum;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.ui.views.properties.IPropertyDescriptor;

public class MHtml
extends MGraphicElement {
    public static final long serialVersionUID = 10200L;
    private IPropertyDescriptor[] descriptors;
    private static IIconDescriptor iconDescriptor;
    private RComboBoxPropertyDescriptor evaluationGroupNameD;
    private static NamedEnumPropertyDescriptor<ScaleImageEnum> scaleTypeD;
    private static NamedEnumPropertyDescriptor<HorizontalImageAlignEnum> hAlignD;
    private static NamedEnumPropertyDescriptor<VerticalImageAlignEnum> vAlignD;
    private static NamedEnumPropertyDescriptor<EvaluationTimeEnum> evaluationTimeD;

    public static IIconDescriptor getIconDescriptor() {
        if (iconDescriptor == null) {
            iconDescriptor = new HtmlNodeIconDescriptor("html");
        }
        return iconDescriptor;
    }

    public MHtml() {
    }

    public MHtml(ANode parent, int newIndex) {
        super(parent, newIndex);
    }

    public MHtml(ANode parent, JRDesignComponentElement jrHtml, int newIndex) {
        this(parent, newIndex);
        this.setValue(jrHtml);
    }

    public IPropertyDescriptor[] getDescriptors() {
        return this.descriptors;
    }

    public void setDescriptors(IPropertyDescriptor[] descriptors1) {
        this.descriptors = descriptors1;
    }

    public JRDesignElement createJRElement(JasperDesign jasperDesign) {
        JRDesignComponentElement el = new JRDesignComponentElement((JRDefaultStyleProvider)jasperDesign);
        HtmlComponent component = new HtmlComponent();
        JRDesignExpression exp = new JRDesignExpression();
        exp.setValueClassName("java.lang.String");
        exp.setText("\"<p style='background-color:yellow;'>HTML paragraph</p>\"");
        component.setHtmlContentExpression((JRExpression)exp);
        el.setComponent((Component)component);
        el.setComponentKey(new ComponentKey("http://jasperreports.sourceforge.net/htmlcomponent", "hc", "html"));
        return el;
    }

    public String getDisplayText() {
        String p = this.getElementNameProperty();
        return Misc.isNullOrEmpty((String)p) ? MHtml.getIconDescriptor().getTitle() : p;
    }

    public ImageDescriptor getImagePath() {
        return MHtml.getIconDescriptor().getIcon16();
    }

    public String getToolTip() {
        return MHtml.getIconDescriptor().getToolTip();
    }

    public void createPropertyDescriptors(List<IPropertyDescriptor> desc) {
        super.createPropertyDescriptors(desc);
        JRExpressionPropertyDescriptor contentExprD = new JRExpressionPropertyDescriptor((Object)"htmlContentExpression", Messages.MHtml_content_expression);
        contentExprD.setDescription(Messages.MHtml_content_expression_description);
        desc.add((IPropertyDescriptor)contentExprD);
        scaleTypeD = new NamedEnumPropertyDescriptor((Object)"scaleType", Messages.MHtml_scaletype, (Enum)ScaleImageEnum.CLIP, NullEnum.NOTNULL);
        scaleTypeD.setDescription(Messages.MHtml_scaletype_description);
        desc.add((IPropertyDescriptor)scaleTypeD);
        CheckBoxPropertyDescriptor clipOverflow = new CheckBoxPropertyDescriptor((Object)"clipOnOverflow", Messages.MHtml_cliponoverflow, NullEnum.NULL);
        clipOverflow.setDescription(Messages.MHtml_cliponoverflow_desc);
        desc.add((IPropertyDescriptor)clipOverflow);
        hAlignD = new NamedEnumPropertyDescriptor((Object)"horizontalAlign", Messages.MHtml_horizontalalign, (Enum)HorizontalImageAlignEnum.CENTER, NullEnum.NOTNULL);
        hAlignD.setDescription(Messages.MHtml_horizontalalign_description);
        desc.add((IPropertyDescriptor)hAlignD);
        vAlignD = new NamedEnumPropertyDescriptor((Object)"verticalAlign", Messages.MHtml_verticalalign, (Enum)VerticalImageAlignEnum.BOTTOM, NullEnum.NOTNULL);
        vAlignD.setDescription(Messages.MHtml_verticalalign_description);
        desc.add((IPropertyDescriptor)vAlignD);
        evaluationTimeD = new NamedEnumPropertyDescriptor((Object)"evaluationTime", Messages.MHtml_evaluation_time, (Enum)EvaluationTimeEnum.AUTO, NullEnum.NOTNULL);
        evaluationTimeD.setDescription(Messages.MHtml_evaluation_time_description);
        desc.add((IPropertyDescriptor)evaluationTimeD);
        this.evaluationGroupNameD = new RComboBoxPropertyDescriptor((Object)"evaluationGroup", Messages.MHtml_evaluation_group, new String[]{""});
        this.evaluationGroupNameD.setDescription(Messages.MHtml_evaluation_group_description);
        desc.add((IPropertyDescriptor)this.evaluationGroupNameD);
        contentExprD.setCategory(Messages.common_properties_category);
        scaleTypeD.setCategory(Messages.common_properties_category);
        hAlignD.setCategory(Messages.common_properties_category);
        vAlignD.setCategory(Messages.common_properties_category);
        evaluationTimeD.setCategory(Messages.common_properties_category);
        this.evaluationGroupNameD.setCategory(Messages.common_properties_category);
        clipOverflow.setCategory(Messages.common_properties_category);
    }

    protected Map<String, DefaultValue> createDefaultsMap() {
        Map defaultsMap = super.createDefaultsMap();
        defaultsMap.put("evaluationTime", new DefaultValue((Object)EvaluationTimeEnum.NOW, false));
        defaultsMap.put("clipOnOverflow", new DefaultValue((Object)Boolean.FALSE, false));
        int scaleValue = NamedEnumPropertyDescriptor.getIntValue((Enum)ScaleImageEnum.RETAIN_SHAPE, (NullEnum)NullEnum.NOTNULL, (Enum)ScaleImageEnum.RETAIN_SHAPE);
        defaultsMap.put("scaleType", new DefaultValue((Object)scaleValue, false));
        int horizontalAlignmentValue = NamedEnumPropertyDescriptor.getIntValue((Enum)HorizontalImageAlignEnum.LEFT, (NullEnum)NullEnum.NOTNULL, (Enum)HorizontalImageAlignEnum.LEFT);
        defaultsMap.put("horizontalAlign", new DefaultValue((Object)horizontalAlignmentValue, false));
        int verticalAligmentValue = NamedEnumPropertyDescriptor.getIntValue((Enum)VerticalImageAlignEnum.MIDDLE, (NullEnum)NullEnum.NOTNULL, (Enum)VerticalImageAlignEnum.MIDDLE);
        defaultsMap.put("verticalAlign", new DefaultValue((Object)verticalAligmentValue, false));
        return defaultsMap;
    }

    protected void setGroupItems(String[] items) {
        super.setGroupItems(items);
        if (this.evaluationGroupNameD != null) {
            this.evaluationGroupNameD.setItems(items);
        }
    }

    public void setValue(Object value) {
        Object obj;
        if (this.getValue() != null && (obj = this.getComponent()) instanceof JRChangeEventsSupport) {
            ((JRChangeEventsSupport)obj).getEventSupport().removePropertyChangeListener((PropertyChangeListener)((Object)this));
        }
        if (value != null) {
            obj = this.getComponent(value);
            if (value instanceof JRChangeEventsSupport) {
                ((JRChangeEventsSupport)obj).getEventSupport().addPropertyChangeListener((PropertyChangeListener)((Object)this));
            }
        }
        super.setValue(value);
    }

    private Object getComponent() {
        return this.getComponent(this.getValue());
    }

    private Object getComponent(Object value) {
        if (value != null) {
            JRDesignComponentElement jrElement = (JRDesignComponentElement)value;
            return jrElement.getComponent();
        }
        return null;
    }

    public Object getPropertyValue(Object id) {
        JRDesignComponentElement jrElement = (JRDesignComponentElement)this.getValue();
        HtmlComponent htmlComp = (HtmlComponent)jrElement.getComponent();
        if (id.equals("evaluationTime")) {
            return htmlComp.getEvaluationTime();
        }
        if (id.equals("evaluationGroup")) {
            return htmlComp.getEvaluationGroup();
        }
        if (id.equals("scaleType")) {
            return scaleTypeD.getIntValue((Enum)htmlComp.getScaleType());
        }
        if (id.equals("horizontalAlign")) {
            return hAlignD.getIntValue((Enum)htmlComp.getHorizontalImageAlign());
        }
        if (id.equals("verticalAlign")) {
            return vAlignD.getIntValue((Enum)htmlComp.getVerticalImageAlign());
        }
        if (id.equals("htmlContentExpression")) {
            return ExprUtil.getExpression((JRExpression)htmlComp.getHtmlContentExpression());
        }
        if (id.equals("clipOnOverflow")) {
            return htmlComp.getClipOnOverflow();
        }
        return super.getPropertyValue(id);
    }

    public void setPropertyValue(Object id, Object value) {
        JRDesignComponentElement jrElement = (JRDesignComponentElement)this.getValue();
        HtmlComponent htmlComp = (HtmlComponent)jrElement.getComponent();
        if (id.equals("evaluationTime")) {
            EvaluationTimeEnum evalTime = (EvaluationTimeEnum)EnumHelper.getEnumByObjectValue((NamedEnum[])EvaluationTimeEnum.values(), (Object)value);
            htmlComp.setEvaluationTime(evalTime);
            if (evalTime != null && !evalTime.equals((Object)EvaluationTimeEnum.GROUP)) {
                htmlComp.setEvaluationGroup(null);
            }
        } else if (id.equals("evaluationGroup")) {
            htmlComp.setEvaluationGroup(ModelUtils.getGroupNameForProperty((Object)value));
        } else if (id.equals("scaleType")) {
            htmlComp.setScaleType((ScaleImageEnum)scaleTypeD.getEnumValue(value));
        } else if (id.equals("horizontalAlign")) {
            htmlComp.setHorizontalImageAlign((HorizontalImageAlignEnum)hAlignD.getEnumValue(value));
        } else if (id.equals("verticalAlign")) {
            htmlComp.setVerticalImageAlign((VerticalImageAlignEnum)vAlignD.getEnumValue(value));
        } else if (id.equals("htmlContentExpression")) {
            htmlComp.setHtmlContentExpression(ExprUtil.setValues((JRExpression)htmlComp.getHtmlContentExpression(), (Object)value));
        } else if (id.equals("clipOnOverflow")) {
            htmlComp.setClipOnOverflow((Boolean)value);
        } else {
            super.setPropertyValue(id, value);
        }
    }
}

