/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jdt.internal.debug.eval;

import com.sun.jdi.InvocationException;
import com.sun.jdi.ObjectReference;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.debug.core.DebugException;
import org.eclipse.debug.core.model.IVariable;
import org.eclipse.jdt.core.eval.ICodeSnippetRequestor;
import org.eclipse.jdt.debug.core.IJavaArray;
import org.eclipse.jdt.debug.core.IJavaArrayType;
import org.eclipse.jdt.debug.core.IJavaClassObject;
import org.eclipse.jdt.debug.core.IJavaClassType;
import org.eclipse.jdt.debug.core.IJavaDebugTarget;
import org.eclipse.jdt.debug.core.IJavaFieldVariable;
import org.eclipse.jdt.debug.core.IJavaObject;
import org.eclipse.jdt.debug.core.IJavaReferenceType;
import org.eclipse.jdt.debug.core.IJavaThread;
import org.eclipse.jdt.debug.core.IJavaType;
import org.eclipse.jdt.debug.core.IJavaValue;
import org.eclipse.jdt.debug.core.IJavaVariable;
import org.eclipse.jdt.debug.core.JDIDebugModel;
import org.eclipse.jdt.internal.debug.core.JDIDebugPlugin;
import org.eclipse.jdt.internal.debug.core.model.JDIDebugTarget;
import org.eclipse.jdt.internal.debug.core.model.JDIValue;
import org.eclipse.jdt.internal.debug.eval.EvaluationMessages;

public class RemoteEvaluator {
    private final LinkedHashMap<String, byte[]> classFiles;
    private final String codeSnippetClassName;
    private final List<String> variableNames;
    private IJavaClassObject loadedClass = null;
    private String enclosingTypeName;

    public RemoteEvaluator(LinkedHashMap<String, byte[]> classFiles, String codeSnippetClassName, List<String> variableNames, String enclosingTypeName) {
        this.classFiles = classFiles;
        this.enclosingTypeName = enclosingTypeName;
        this.codeSnippetClassName = codeSnippetClassName.replace('.', '/');
        this.variableNames = variableNames;
    }

    private IJavaClassObject loadTheClasses(IJavaThread theThread) throws DebugException {
        if (this.loadedClass != null) {
            return this.loadedClass;
        }
        JDIDebugTarget debugTarget = (JDIDebugTarget)theThread.getDebugTarget();
        IJavaClassObject theMainClass = null;
        IJavaObject classloader = null;
        IJavaReferenceType surroundingClass = this.findType(this.enclosingTypeName, debugTarget);
        classloader = surroundingClass.getClassLoaderObject();
        for (Map.Entry<String, byte[]> entry : this.classFiles.entrySet()) {
            String className = entry.getKey();
            IJavaReferenceType existingClass = this.tryLoadType(className, debugTarget);
            if (existingClass != null) {
                if (!this.codeSnippetClassName.equals(className)) continue;
                theMainClass = existingClass.getClassObject();
                continue;
            }
            IJavaArray byteArray = this.createClassBytes(theThread, debugTarget, entry);
            IJavaValue[] defineClassArgs = new IJavaValue[]{debugTarget.newValue(className.replaceAll("/", ".")), byteArray, debugTarget.newValue(0), debugTarget.newValue(entry.getValue().length), debugTarget.nullValue()};
            IJavaClassObject theClass = (IJavaClassObject)classloader.sendMessage("defineClass", "(Ljava/lang/String;[BIILjava/security/ProtectionDomain;)Ljava/lang/Class;", defineClassArgs, theThread, false);
            if (!this.codeSnippetClassName.equals(className)) continue;
            theMainClass = theClass;
        }
        return theMainClass;
    }

    private IJavaArray createClassBytes(IJavaThread theThread, JDIDebugTarget debugTarget, Map.Entry<String, byte[]> entry) throws DebugException {
        IJavaReferenceType byteArrayType = this.findType("byte[]", debugTarget);
        byte[] classBytes = entry.getValue();
        IJavaArray byteArray = ((IJavaArrayType)byteArrayType).newInstance(classBytes.length);
        IJavaValue[] debugClassBytes = new IJavaValue[classBytes.length];
        int ix = 0;
        while (ix < classBytes.length) {
            debugClassBytes[ix] = ((JDIDebugTarget)theThread.getDebugTarget()).newValue(classBytes[ix]);
            ++ix;
        }
        byteArray.setValues(debugClassBytes);
        return byteArray;
    }

    private IJavaReferenceType findType(String typeName, IJavaDebugTarget debugTarget) throws DebugException {
        IJavaReferenceType theClass = this.tryLoadType(typeName, debugTarget);
        if (theClass == null) {
            throw new DebugException((IStatus)new Status(4, JDIDebugModel.getPluginIdentifier(), 5012, EvaluationMessages.RemoteEvaluationEngine_Evaluation_failed___unable_to_find_injected_class, null));
        }
        return theClass;
    }

    private IJavaReferenceType tryLoadType(String typeName, IJavaDebugTarget debugTarget) throws DebugException {
        IJavaReferenceType clazz = null;
        IJavaType[] types = debugTarget.getJavaTypes(typeName);
        if (types != null && types.length > 0) {
            clazz = (IJavaReferenceType)types[0];
        }
        return clazz;
    }

    protected void initializeFreeVars(IJavaObject object, IJavaValue[] boundValues) throws DebugException {
        if (boundValues.length != this.variableNames.size()) {
            throw new DebugException((IStatus)new Status(4, JDIDebugModel.getPluginIdentifier(), 5012, EvaluationMessages.LocalEvaluationEngine_Evaluation_failed___unable_to_initialize_local_variables__4, null));
        }
        int i = 0;
        while (i < boundValues.length) {
            IJavaFieldVariable field = object.getField(new String(ICodeSnippetRequestor.LOCAL_VAR_PREFIX) + this.variableNames.get(i), false);
            if (field == null) {
                throw new DebugException((IStatus)new Status(4, JDIDebugModel.getPluginIdentifier(), 5012, EvaluationMessages.LocalEvaluationEngine_Evaluation_failed___unable_to_initialize_local_variables__4, null));
            }
            IJavaValue bound = boundValues[i];
            field.setValue(bound);
            ++i;
        }
    }

    protected IJavaObject newInstance(IJavaThread theThread) throws DebugException {
        IJavaDebugTarget debugTarget = (IJavaDebugTarget)theThread.getDebugTarget();
        IJavaObject object = null;
        IJavaClassObject clazz = this.loadTheClasses(theThread);
        if (clazz == null) {
            IJavaType[] types = debugTarget.getJavaTypes("java.lang.Class");
            IJavaClassType classClass = null;
            if (types != null && types.length > 0) {
                classClass = (IJavaClassType)types[0];
            }
            if (classClass == null) {
                throw new DebugException((IStatus)new Status(4, JDIDebugModel.getPluginIdentifier(), 5012, EvaluationMessages.LocalEvaluationEngine_Evaluation_failed___unable_to_instantiate_code_snippet_class__11, null));
            }
            IJavaValue[] args = new IJavaValue[]{debugTarget.newValue(this.codeSnippetClassName)};
            IJavaObject classObject = (IJavaObject)classClass.sendMessage("forName", "(Ljava/lang/String;)Ljava/lang/Class;", args, theThread);
            object = (IJavaObject)classObject.sendMessage("newInstance", "()Ljava/lang/Object;", null, theThread, false);
        } else {
            object = (IJavaObject)clazz.sendMessage("newInstance", "()Ljava/lang/Object;", null, theThread, false);
        }
        return object;
    }

    protected IJavaValue convertResult(IJavaDebugTarget debugTarget, IJavaClassObject resultType, IJavaValue result) throws DebugException {
        if (resultType == null) {
            return null;
        }
        String sig = resultType.getInstanceType().getSignature();
        if (sig.equals("V") || sig.equals("Lvoid;")) {
            return debugTarget.voidValue();
        }
        if (result.getJavaType() == null) {
            return result;
        }
        if (sig.length() == 1) {
            IVariable[] vars = result.getVariables();
            IJavaVariable var = null;
            IVariable[] iVariableArray = vars;
            int n = vars.length;
            int n2 = 0;
            while (n2 < n) {
                IVariable var2 = iVariableArray[n2];
                IJavaVariable jv = (IJavaVariable)var2;
                if (!jv.isStatic() && jv.getSignature().equals(sig)) {
                    var = jv;
                    break;
                }
                ++n2;
            }
            if (var != null) {
                return (IJavaValue)var.getValue();
            }
        } else {
            return result;
        }
        throw new DebugException((IStatus)new Status(4, JDIDebugModel.getPluginIdentifier(), 5012, EvaluationMessages.LocalEvaluationEngine_Evaluation_failed___internal_error_retreiving_result__17, null));
    }

    protected String getCodeSnippetClassName() {
        return this.codeSnippetClassName;
    }

    public IJavaValue evaluate(IJavaThread theThread, IJavaValue[] args) throws DebugException {
        IJavaObject codeSnippetInstance = null;
        IJavaDebugTarget debugTarget = (IJavaDebugTarget)theThread.getDebugTarget();
        try {
            codeSnippetInstance = this.newInstance(theThread);
            this.initializeFreeVars(codeSnippetInstance, args);
            codeSnippetInstance.sendMessage("run", "()V", null, theThread, false);
            IVariable[] fields = codeSnippetInstance.getVariables();
            IJavaVariable resultValue = null;
            IJavaVariable resultType = null;
            IVariable[] iVariableArray = fields;
            int n = fields.length;
            int n2 = 0;
            while (n2 < n) {
                IVariable field = iVariableArray[n2];
                if (field.getName().equals("resultType")) {
                    resultType = (IJavaVariable)field;
                }
                if (field.getName().equals("resultValue")) {
                    resultValue = (IJavaVariable)field;
                }
                ++n2;
            }
            IJavaValue result = this.convertResult(debugTarget, (IJavaClassObject)resultType.getValue(), (IJavaValue)resultValue.getValue());
            return result;
        }
        catch (DebugException e) {
            ObjectReference theException;
            Throwable underlyingException = e.getStatus().getException();
            if (underlyingException instanceof InvocationException && (theException = ((InvocationException)underlyingException).exception()) != null) {
                try {
                    try {
                        IJavaObject v = (IJavaObject)((Object)JDIValue.createValue((JDIDebugTarget)debugTarget, theException));
                        v.sendMessage("printStackTrace", "()V", null, theThread, false);
                    }
                    catch (DebugException de) {
                        JDIDebugPlugin.log(de);
                    }
                }
                catch (RuntimeException re) {
                    JDIDebugPlugin.log(re);
                }
            }
            throw e;
        }
    }

    public int getVariableCount() {
        return this.variableNames.size();
    }

    public String getVariableName(int i) {
        return this.variableNames.get(i);
    }
}

