/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ui.internal.cheatsheets.views;

import java.net.MalformedURLException;
import java.net.URL;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.ListIterator;
import java.util.Map;
import java.util.Properties;
import java.util.StringTokenizer;
import org.eclipse.core.runtime.FileLocator;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Platform;
import org.eclipse.core.runtime.Status;
import org.eclipse.help.ui.internal.views.HelpTray;
import org.eclipse.help.ui.internal.views.IHelpPart;
import org.eclipse.help.ui.internal.views.IHelpPartPage;
import org.eclipse.help.ui.internal.views.ReusableHelpPart;
import org.eclipse.jface.action.Action;
import org.eclipse.jface.dialogs.DialogTray;
import org.eclipse.jface.dialogs.ErrorDialog;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.dialogs.TrayDialog;
import org.eclipse.osgi.util.NLS;
import org.eclipse.swt.graphics.Cursor;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Listener;
import org.eclipse.swt.widgets.Menu;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Widget;
import org.eclipse.ui.IMemento;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.cheatsheets.CheatSheetListener;
import org.eclipse.ui.cheatsheets.ICheatSheetViewer;
import org.eclipse.ui.forms.widgets.ImageHyperlink;
import org.eclipse.ui.internal.cheatsheets.CheatSheetPlugin;
import org.eclipse.ui.internal.cheatsheets.CheatSheetStopWatch;
import org.eclipse.ui.internal.cheatsheets.Messages;
import org.eclipse.ui.internal.cheatsheets.actions.IMenuContributor;
import org.eclipse.ui.internal.cheatsheets.composite.model.CompositeCheatSheetModel;
import org.eclipse.ui.internal.cheatsheets.composite.views.CompositeCheatSheetPage;
import org.eclipse.ui.internal.cheatsheets.data.CheatSheet;
import org.eclipse.ui.internal.cheatsheets.data.CheatSheetParser;
import org.eclipse.ui.internal.cheatsheets.data.CheatSheetSaveHelper;
import org.eclipse.ui.internal.cheatsheets.data.ICheatSheet;
import org.eclipse.ui.internal.cheatsheets.data.ParserInput;
import org.eclipse.ui.internal.cheatsheets.registry.CheatSheetElement;
import org.eclipse.ui.internal.cheatsheets.registry.CheatSheetRegistryReader;
import org.eclipse.ui.internal.cheatsheets.state.DefaultStateManager;
import org.eclipse.ui.internal.cheatsheets.state.ICheatSheetStateManager;
import org.eclipse.ui.internal.cheatsheets.state.NoSaveStateManager;
import org.eclipse.ui.internal.cheatsheets.state.TrayStateManager;
import org.eclipse.ui.internal.cheatsheets.views.CheatSheetExpandRestoreAction;
import org.eclipse.ui.internal.cheatsheets.views.CheatSheetHelpPart;
import org.eclipse.ui.internal.cheatsheets.views.CheatSheetManager;
import org.eclipse.ui.internal.cheatsheets.views.CheatSheetPage;
import org.eclipse.ui.internal.cheatsheets.views.CoreItem;
import org.eclipse.ui.internal.cheatsheets.views.ErrorPage;
import org.eclipse.ui.internal.cheatsheets.views.IntroItem;
import org.eclipse.ui.internal.cheatsheets.views.Page;
import org.eclipse.ui.internal.cheatsheets.views.SubItemCompositeHolder;
import org.eclipse.ui.internal.cheatsheets.views.ViewItem;
import org.osgi.framework.Bundle;

public class CheatSheetViewer
implements ICheatSheetViewer,
IMenuContributor {
    private CheatSheetElement contentElement;
    private ParserInput parserInput;
    private String currentID;
    private int currentItemNum = -1;
    private boolean invalidCheatSheetId = false;
    private boolean nullCheatSheetId = false;
    private CheatSheetParser parser;
    private ICheatSheet model;
    private CheatSheetManager manager;
    private CheatSheetSaveHelper saveHelper;
    private CheatSheetExpandRestoreAction expandRestoreAction;
    private Action copyAction;
    private ViewItem currentItem;
    private ArrayList<String> expandRestoreList = new ArrayList();
    private ArrayList<ViewItem> viewItemList = new ArrayList();
    protected Composite control;
    private Cursor busyCursor;
    private Page currentPage;
    private Label howToBegin;
    private boolean inDialog;
    private Listener listener;
    private ICheatSheetStateManager stateManager;
    private ICheatSheetStateManager preTrayManager;
    private String restorePath;
    private int dialogReturnCode;
    private boolean isRestricted;

    public CheatSheetViewer(boolean inDialog) {
        this.inDialog = inDialog;
        this.saveHelper = new CheatSheetSaveHelper();
    }

    public void advanceIntroItem() {
        if (this.getViewItemAtIndex(0) == null) {
            return;
        }
        this.resetItemState();
        this.currentItemNum = 1;
        ViewItem nextItem = this.getViewItemAtIndex(this.currentItemNum);
        if (nextItem.item.isDynamic()) {
            nextItem.handleButtons();
        }
        nextItem.setAsCurrentActiveItem();
        this.currentItem = nextItem;
        this.collapseAllButCurrent(false);
        this.saveCurrentSheet();
        Display.getDefault().asyncExec(() -> this.currentPage.form.showControl((Control)this.currentItem.getMainItemComposite()));
    }

    private void resetItemState() {
        IntroItem introItem = (IntroItem)this.getViewItemAtIndex(0);
        boolean isStarted = introItem.isCompleted();
        this.expandRestoreList = new ArrayList();
        if (this.expandRestoreAction != null) {
            this.expandRestoreAction.setCollapsed(false);
        }
        this.clearBackgrounds();
        this.clearIcons();
        this.collapseAllButtons();
        if (isStarted) {
            this.initManager();
        }
        for (ViewItem item : this.viewItemList) {
            CoreItem c;
            ArrayList<SubItemCompositeHolder> l;
            if (!(item instanceof CoreItem) || (l = (c = (CoreItem)item).getListOfSubItemCompositeHolders()) == null) continue;
            int j = 0;
            while (j < l.size()) {
                l.get(j).setSkipped(false);
                l.get(j).setCompleted(false);
                ++j;
            }
        }
        if (isStarted) {
            this.getManager().fireEvent(3);
        } else {
            this.getManager().fireEvent(2);
        }
        isStarted = true;
        introItem.setAsNormalCollapsed();
        introItem.setComplete();
        introItem.setRestartImage();
    }

    public void advanceItem(ImageHyperlink link, boolean markAsCompleted) {
        boolean isFinalItem;
        this.currentItem = (ViewItem)link.getData();
        int indexNextItem = this.getIndexOfItem(this.currentItem) + 1;
        boolean bl = isFinalItem = indexNextItem >= this.viewItemList.size();
        if (markAsCompleted && this.currentItem.hasCompletionMessage() && !this.currentItem.isCompletionMessageExpanded()) {
            this.currentItem.setCompletionMessageExpanded(isFinalItem);
            this.currentItem.setComplete();
            if (isFinalItem) {
                this.getManager().fireEvent(4);
            }
            this.saveCurrentSheet();
            return;
        }
        if (indexNextItem < this.currentItemNum) {
            ViewItem vi = this.getViewItemAtIndex(this.currentItemNum);
            vi.setAsNormalNonCollapsed();
        }
        if (this.currentItem != null) {
            this.currentItem.setAsNormalCollapsed();
            if (markAsCompleted) {
                if (!this.currentItem.isCompleted()) {
                    this.currentItem.setComplete();
                }
            } else {
                this.currentItem.setSkipped();
            }
        }
        if (!isFinalItem) {
            ViewItem nextItem = this.getViewItemAtIndex(indexNextItem);
            this.currentItemNum = indexNextItem;
            if (nextItem != null) {
                if (nextItem.item.isDynamic()) {
                    ((CoreItem)nextItem).handleButtons();
                }
                nextItem.setAsCurrentActiveItem();
                this.currentItem = nextItem;
            }
            Display.getDefault().asyncExec(() -> this.currentPage.form.showControl((Control)this.currentItem.getMainItemComposite()));
        } else if (indexNextItem == this.viewItemList.size()) {
            if (!this.currentItem.isCompletionMessageExpanded()) {
                this.getManager().fireEvent(4);
            }
            this.showIntroItem();
        }
        this.saveCurrentSheet();
    }

    private void showIntroItem() {
        ViewItem item = this.getViewItemAtIndex(0);
        item.setAsCurrentActiveItem();
        this.currentItem = item;
    }

    public void advanceSubItem(ImageHyperlink link, boolean markAsCompleted, int subItemIndex) {
        Label l = null;
        ArrayList<SubItemCompositeHolder> list = null;
        SubItemCompositeHolder sich = null;
        CoreItem ciws = null;
        this.currentItem = (ViewItem)link.getData();
        if (this.currentItem instanceof CoreItem) {
            ciws = (CoreItem)this.currentItem;
        }
        if (ciws != null) {
            list = ciws.getListOfSubItemCompositeHolders();
            sich = list.get(subItemIndex);
            l = sich.getCheckDoneLabel();
        }
        if (l != null) {
            if (markAsCompleted) {
                sich.setCompleted(true);
                sich.setSkipped(false);
            } else {
                sich.setSkipped(true);
                sich.setCompleted(false);
            }
            ciws.refreshItem();
        }
        boolean allAttempted = this.checkAllAttempted(list);
        boolean anySkipped = this.checkContainsSkipped(list);
        if (allAttempted && !anySkipped) {
            this.advanceItem(link, true);
            return;
        }
        if (allAttempted && anySkipped) {
            this.advanceItem(link, false);
            return;
        }
        this.setFocus();
        this.saveCurrentSheet();
    }

    private boolean checkAllAttempted(ArrayList<SubItemCompositeHolder> list) {
        int i = 0;
        while (i < list.size()) {
            SubItemCompositeHolder s = list.get(i);
            if (!s.isCompleted() && !s.isSkipped()) {
                return false;
            }
            ++i;
        }
        return true;
    }

    private boolean checkContainsSkipped(ArrayList<SubItemCompositeHolder> list) {
        int i = 0;
        while (i < list.size()) {
            SubItemCompositeHolder s = list.get(i);
            if (s.isSkipped()) {
                return true;
            }
            ++i;
        }
        return false;
    }

    private boolean loadState() {
        Properties props;
        block31: {
            props = this.stateManager.getProperties();
            this.manager = this.stateManager.getCheatSheetManager();
            this.clearBackgrounds();
            if (props != null) break block31;
            this.getViewItemAtIndex(0).setAsCurrentActiveItem();
            return true;
        }
        try {
            boolean buttonIsDown = Integer.parseInt((String)props.get("button")) != 0;
            int itemNum = Integer.parseInt((String)props.get("current"));
            ArrayList completedStatesList = (ArrayList)props.get("completed");
            ArrayList expandedStatesList = (ArrayList)props.get("expanded");
            this.expandRestoreList = (ArrayList)props.get("expandRestore");
            String cid = (String)props.get("id");
            Hashtable completedSubItems = (Hashtable)props.get("subitemcompleted");
            Hashtable skippedSubItems = (Hashtable)props.get("subitemskipped");
            ArrayList completedSubItemsItemList = new ArrayList();
            ArrayList skippedSubItemsItemList = new ArrayList();
            Enumeration e = completedSubItems.keys();
            while (e.hasMoreElements()) {
                completedSubItemsItemList.add(e.nextElement());
            }
            Enumeration e2 = skippedSubItems.keys();
            while (e2.hasMoreElements()) {
                skippedSubItemsItemList.add(e2.nextElement());
            }
            if (cid != null) {
                this.currentID = cid;
            }
            if (itemNum >= 0) {
                this.currentItemNum = itemNum;
                this.currentItem = this.getViewItemAtIndex(itemNum);
                CheatSheetStopWatch.startStopWatch("CheatSheetViewer.checkSavedState()");
                int i = 0;
                while (i < this.viewItemList.size()) {
                    CoreItem coreitemws;
                    StringTokenizer st;
                    String subItemNumbers;
                    ViewItem item = this.getViewItemAtIndex(i);
                    if (i > 0 && item.item.isDynamic() && i <= this.currentItemNum) {
                        item.handleButtons();
                        item.setOriginalColor();
                    }
                    if (completedStatesList.contains(Integer.toString(i))) {
                        item.setComplete();
                        item.setRestartImage();
                    } else if (i < this.currentItemNum) {
                        item.setSkipped();
                    }
                    if (expandedStatesList.contains(Integer.toString(i))) {
                        item.setExpanded();
                    } else {
                        item.setCollapsed();
                    }
                    if (i > this.currentItemNum) {
                        item.setButtonsVisible(false);
                        item.setCompletionMessageCollapsed();
                    } else {
                        item.setButtonsVisible(true);
                        if (i > this.currentItemNum || item.isCompleted()) {
                            item.setCompletionMessageExpanded(i + 1 >= this.viewItemList.size());
                        } else {
                            item.setCompletionMessageCollapsed();
                        }
                    }
                    if (this.expandRestoreList.contains(Integer.toString(i))) {
                        item.setCollapsed();
                    }
                    if (completedSubItemsItemList.contains(Integer.toString(i))) {
                        ArrayList<SubItemCompositeHolder> subItemCompositeHolders;
                        subItemNumbers = (String)completedSubItems.get(Integer.toString(i));
                        st = new StringTokenizer(subItemNumbers, ",");
                        if (item instanceof CoreItem && (subItemCompositeHolders = (coreitemws = (CoreItem)item).getListOfSubItemCompositeHolders()) != null) {
                            while (st.hasMoreTokens()) {
                                String token = st.nextToken();
                                subItemCompositeHolders.get(Integer.parseInt(token)).setCompleted(true);
                                ArrayList<SubItemCompositeHolder> l = subItemCompositeHolders;
                                SubItemCompositeHolder s = l.get(Integer.parseInt(token));
                                if (s == null || s.getStartButton() == null) continue;
                                s.getStartButton().setImage(CheatSheetPlugin.getPlugin().getImage("CHEATSHEET_ITEM_BUTTON_RESTART"));
                                s.getStartButton().setToolTipText(Messages.RESTART_TASK_TOOLTIP);
                            }
                        }
                    }
                    if (skippedSubItemsItemList.contains(Integer.toString(i))) {
                        subItemNumbers = (String)skippedSubItems.get(Integer.toString(i));
                        st = new StringTokenizer(subItemNumbers, ",");
                        if (item instanceof CoreItem) {
                            coreitemws = (CoreItem)item;
                            while (st.hasMoreTokens()) {
                                String token = st.nextToken();
                                coreitemws.getListOfSubItemCompositeHolders().get(Integer.parseInt(token)).setSkipped(true);
                            }
                        }
                    }
                    CheatSheetStopWatch.printLapTime("CheatSheetViewer.checkSavedState()", "Time in CheatSheetViewer.checkSavedState() after loop #" + i + ": ");
                    ++i;
                }
                CheatSheetStopWatch.printLapTime("CheatSheetViewer.checkSavedState()", "Time in CheatSheetViewer.checkSavedState() after loop: ");
                if (buttonIsDown && this.expandRestoreAction != null) {
                    this.expandRestoreAction.setCollapsed(true);
                }
                if (this.viewItemList.size() - 1 == itemNum && this.currentItem.isCompleted()) {
                    this.currentItem.setCollapsed();
                    this.getViewItemAtIndex(0).getMainItemComposite().setFocus();
                    this.getManager().fireEvent(5);
                    this.getManager().fireEvent(4);
                } else {
                    this.currentItem.setAsCurrentActiveItem();
                    if (this.getViewItemAtIndex(0).isCompleted()) {
                        this.getManager().fireEvent(5);
                    }
                }
            } else {
                this.getViewItemAtIndex(0).setAsCurrentActiveItem();
                this.currentItem = this.getViewItemAtIndex(0);
            }
            return true;
        }
        catch (Exception e) {
            boolean reset = MessageDialog.openConfirm((Shell)PlatformUI.getWorkbench().getActiveWorkbenchWindow().getShell(), (String)Messages.CHEATSHEET_STATE_RESTORE_FAIL_TITLE, (String)Messages.CHEATSHEET_STATE_RESET_CONFIRM);
            if (reset) {
                this.restart();
                return true;
            }
            String stateFile = this.saveHelper.getStateFile(this.currentID).toOSString();
            String message = NLS.bind((String)Messages.ERROR_APPLYING_STATE_DATA_LOG, (Object[])new Object[]{stateFile, this.currentID});
            CheatSheetPlugin.getPlugin().getLog().error(message, (Throwable)e);
            this.currentID = null;
            this.internalDispose();
            this.parserInput = null;
            this.currentItem = null;
            this.currentItemNum = -1;
            this.currentPage = null;
            this.expandRestoreList = new ArrayList();
            this.viewItemList = new ArrayList();
            this.createErrorPage(Messages.ERROR_APPLYING_STATE_DATA);
            return false;
        }
    }

    private void clearBackgrounds() {
        for (ViewItem item : this.viewItemList) {
            item.setOriginalColor();
        }
    }

    private void clearIcons() {
        for (ViewItem item : this.viewItemList) {
            item.setOriginalColor();
            if (!item.isCompleted() && !item.isExpanded() && !item.isSkipped()) continue;
            item.setIncomplete();
        }
    }

    private void collapseAllButCurrent(boolean fromAction) {
        this.expandRestoreList = new ArrayList();
        try {
            ViewItem current = this.getViewItemAtIndex(this.currentItemNum);
            ListIterator<ViewItem> iter = this.viewItemList.listIterator(this.viewItemList.size());
            while (iter.hasPrevious()) {
                ViewItem item = iter.previous();
                if (item == current || !item.isExpanded()) continue;
                item.setCollapsed();
                if (!fromAction) continue;
                this.expandRestoreList.add(Integer.toString(this.getIndexOfItem(item)));
            }
        }
        catch (Exception exception) {}
    }

    private void collapseAllButtons() {
        ListIterator<ViewItem> iter = this.viewItemList.listIterator(1);
        while (iter.hasNext()) {
            ViewItem item = (ViewItem)iter.next();
            item.setButtonsVisible(false);
            item.setCompletionMessageCollapsed();
        }
    }

    private void createErrorPage(String message) {
        this.setCollapseExpandButtonEnabled(false);
        this.currentPage = message != null ? new ErrorPage(message) : new ErrorPage();
        this.currentPage.createPart(this.control);
        this.control.layout(true);
    }

    private void showStartPage() {
        this.setCollapseExpandButtonEnabled(false);
        this.internalDispose();
        this.howToBegin = new Label(this.control, 64);
        this.howToBegin.setText(Messages.INITIAL_VIEW_DIRECTIONS);
        this.howToBegin.setLayoutData((Object)new GridData(1808));
        this.currentPage = null;
        this.control.layout(true);
    }

    private void createErrorPage(IStatus status) {
        this.setCollapseExpandButtonEnabled(false);
        this.currentPage = new ErrorPage(status);
        this.currentPage.createPart(this.control);
        this.control.layout(true);
    }

    @Override
    public void createPartControl(Composite parent) {
        this.control = new Composite(parent, 0);
        GridLayout layout = new GridLayout();
        layout.marginHeight = 0;
        layout.marginWidth = 0;
        layout.verticalSpacing = 0;
        layout.horizontalSpacing = 0;
        layout.numColumns = 1;
        this.control.setLayout((Layout)layout);
        this.control.addDisposeListener(e -> this.dispose());
        this.showStartPage();
        Display display = parent.getDisplay();
        this.busyCursor = display.getSystemCursor(1);
        if (this.contentElement != null) {
            this.initCheatSheetView();
        }
    }

    private void dialogOpened(TrayDialog dialog) {
        if (this.isActive()) {
            HelpTray tray = (HelpTray)dialog.getTray();
            if (tray == null) {
                tray = new HelpTray();
                dialog.openTray((DialogTray)tray);
            }
            ReusableHelpPart helpPart = tray.getHelpPart();
            IHelpPartPage page = helpPart.createPage("cheatsheet-page", null, null);
            page.setVerticalSpacing(0);
            page.setHorizontalMargin(0);
            TrayStateManager trayManager = new TrayStateManager();
            this.preTrayManager = this.stateManager;
            this.stateManager = trayManager;
            this.saveCurrentSheet();
            helpPart.addPart("cheatsheet-page", (IHelpPart)new CheatSheetHelpPart(helpPart.getForm().getForm().getBody(), helpPart.getForm().getToolkit(), page.getToolBarManager(), this.contentElement, trayManager));
            page.addPart("cheatsheet-page", true);
            helpPart.addPage(page);
            helpPart.showPage("cheatsheet-page");
            this.control.setVisible(false);
            Display.getCurrent().removeFilter(22, this.listener);
            helpPart.getControl().addListener(12, event -> {
                this.control.setVisible(true);
                Display.getCurrent().addFilter(22, this.listener);
                if (this.preTrayManager != null) {
                    this.loadState();
                    this.stateManager = this.preTrayManager;
                    this.preTrayManager = null;
                }
                this.dialogReturnCode = dialog.getReturnCode();
            });
        }
    }

    private void dispose() {
        this.internalDispose();
    }

    public ICheatSheet getCheatSheet() {
        return this.model;
    }

    @Override
    public String getCheatSheetID() {
        if (this.getContent() != null) {
            return this.getContent().getID();
        }
        return null;
    }

    CheatSheetElement getContent() {
        return this.contentElement;
    }

    @Override
    public Control getControl() {
        return this.control;
    }

    private int getIndexOfItem(ViewItem item) {
        int index = this.viewItemList.indexOf(item);
        if (index != -1) {
            return index;
        }
        return 0;
    }

    CheatSheetManager getManager() {
        if (this.manager == null) {
            this.getNewManager();
        }
        return this.manager;
    }

    private CheatSheetManager getNewManager() {
        this.manager = new CheatSheetManager(this.contentElement);
        return this.manager;
    }

    private CheatSheetManager initManager() {
        CheatSheetManager csManager = this.getManager();
        csManager.setData(new Hashtable<String, String>());
        return csManager;
    }

    private ViewItem getViewItemAtIndex(int index) {
        if (this.viewItemList != null && !this.viewItemList.isEmpty()) {
            return this.viewItemList.get(index);
        }
        return null;
    }

    public boolean hasFocusControl(Control control) {
        return control == this.control || this.currentPage.getControl() == control;
    }

    private void hookDialogListener() {
        if (!this.inDialog && this.isInDialogItem() && Platform.getBundle((String)"org.eclipse.help.ui") != null) {
            this.listener = event -> {
                if (this.isTrayDialog(event.widget)) {
                    this.dialogOpened((TrayDialog)((Shell)event.widget).getData());
                }
            };
            Display.getCurrent().addFilter(22, this.listener);
        }
    }

    private void unhookDialogListener() {
        if (this.listener != null) {
            Display.getCurrent().removeFilter(22, this.listener);
        }
    }

    private boolean initCheatSheetView() {
        CheatSheetStopWatch.startStopWatch("CheatSheetViewer.initCheatSheetView()");
        this.expandRestoreList = new ArrayList();
        if (this.expandRestoreAction != null) {
            this.expandRestoreAction.setCollapsed(false);
        }
        this.currentItem = null;
        this.currentItemNum = 0;
        this.viewItemList = new ArrayList();
        this.currentPage = null;
        if (this.howToBegin != null) {
            this.howToBegin.dispose();
            this.howToBegin = null;
        }
        if (this.nullCheatSheetId) {
            return false;
        }
        if (this.invalidCheatSheetId) {
            this.createErrorPage(Messages.ERROR_CHEATSHEET_DOESNOT_EXIST);
            return false;
        }
        CheatSheetStopWatch.printLapTime("CheatSheetViewer.initCheatSheetView()", "Time in CheatSheetViewer.initCheatSheetView() before readFile() call: ");
        IStatus parseStatus = this.readFile();
        CheatSheetStopWatch.printLapTime("CheatSheetViewer.initCheatSheetView()", "Time in CheatSheetViewer.initCheatSheetView() after readFile() call: ");
        if (!parseStatus.isOK()) {
            CheatSheetPlugin.getPlugin().getLog().log(parseStatus);
        }
        if (parseStatus.getSeverity() == 4) {
            this.createErrorPage(parseStatus);
            return false;
        }
        this.control.setRedraw(false);
        if (this.model instanceof CheatSheet) {
            boolean isOK;
            CheatSheet cheatSheetModel = (CheatSheet)this.model;
            if (this.isRestricted && cheatSheetModel.isContainsCommandOrAction() && !(isOK = MessageDialog.openConfirm((Shell)PlatformUI.getWorkbench().getActiveWorkbenchWindow().getShell(), (String)Messages.CHEATSHEET_FROM_URL_WITH_EXEC_TITLE, (String)Messages.CHEATSHEET_FROM_URL_WITH_EXEC))) {
                this.control.setRedraw(true);
                this.showStartPage();
                return true;
            }
            this.currentPage = new CheatSheetPage(cheatSheetModel, this.viewItemList, this);
            this.setCollapseExpandButtonEnabled(true);
        } else if (this.model instanceof CompositeCheatSheetModel) {
            CompositeCheatSheetModel compositeCheatSheetModel = (CompositeCheatSheetModel)this.model;
            compositeCheatSheetModel.setId(this.currentID);
            this.currentPage = new CompositeCheatSheetPage(compositeCheatSheetModel, this.stateManager);
            compositeCheatSheetModel.setCheatSheetManager(this.initManager());
            this.setCollapseExpandButtonEnabled(false);
        }
        CheatSheetStopWatch.printLapTime("CheatSheetViewer.initCheatSheetView()", "Time in CheatSheetViewer.initCheatSheetView() after CheatSheetPage() call: ");
        this.currentPage.createPart(this.control);
        CheatSheetStopWatch.printLapTime("CheatSheetViewer.initCheatSheetView()", "Time in CheatSheetViewer.initCheatSheetView() after CheatSheetPage.createPart() call: ");
        if (this.model instanceof CheatSheet) {
            CheatSheetStopWatch.printLapTime("CheatSheetViewer.initCheatSheetView()", "Time in CheatSheetViewer.initCheatSheetView() after fireEvent() call: ");
            if (!this.loadState()) {
                this.control.setRedraw(true);
                this.control.layout();
                return true;
            }
            this.getManager().fireEvent(0);
        }
        CheatSheetStopWatch.printLapTime("CheatSheetViewer.initCheatSheetView()", "Time in CheatSheetViewer.initCheatSheetView() after checkSavedState() call: ");
        this.currentPage.initialized();
        this.control.setRedraw(true);
        this.control.layout();
        CheatSheetStopWatch.printLapTime("CheatSheetViewer.initCheatSheetView()", "Time in CheatSheetViewer.initCheatSheetView() after layout() call: ");
        if (this.currentItem != null && !this.currentItem.isCompleted()) {
            this.currentItem.setFocus();
        }
        CheatSheetStopWatch.printLapTime("CheatSheetViewer.initCheatSheetView()", "Time in CheatSheetViewer.initCheatSheetView() at end of method: ");
        return true;
    }

    private void internalDispose() {
        if (this.manager != null) {
            this.manager.fireEvent(1);
        }
        this.saveCurrentSheet();
        for (ViewItem item : this.viewItemList) {
            item.dispose();
        }
        if (this.currentPage != null) {
            this.currentPage.dispose();
        }
        this.manager = null;
    }

    private boolean isActive() {
        Control control = this.getControl();
        if (control != null && !control.isDisposed()) {
            Composite parent = control.getParent();
            return parent != null && !parent.isDisposed() && parent.isVisible() && parent.isEnabled();
        }
        return false;
    }

    private void setCollapseExpandButtonEnabled(boolean enable) {
        if (this.expandRestoreAction != null) {
            this.expandRestoreAction.setEnabled(enable);
        }
    }

    private boolean isInDialogItem() {
        if (this.currentItem != null) {
            return this.currentItem.getItem().isDialog();
        }
        return false;
    }

    public boolean isInDialogMode() {
        return this.inDialog;
    }

    private boolean isTrayDialog(Widget widget) {
        return widget instanceof Shell && ((Shell)widget).getData() instanceof TrayDialog;
    }

    private IStatus readFile() {
        if (this.parser == null) {
            this.parser = new CheatSheetParser();
        }
        int cheatSheetKind = 3;
        if (this.contentElement.isRegistered()) {
            cheatSheetKind = this.contentElement.isComposite() ? 1 : 2;
        }
        this.model = this.parser.parse(this.parserInput, cheatSheetKind);
        return this.parser.getStatus();
    }

    private void restoreExpandStates() {
        try {
            int i = 0;
            while (i < this.expandRestoreList.size()) {
                int index = Integer.parseInt(this.expandRestoreList.get(i));
                ViewItem item = this.getViewItemAtIndex(index);
                if (!item.isExpanded()) {
                    item.setExpanded();
                }
                ++i;
            }
            this.expandRestoreList = null;
        }
        catch (Exception exception) {}
    }

    void runPerformExecutable(ImageHyperlink link) {
        link.setCursor(this.busyCursor);
        this.currentItem = (ViewItem)link.getData();
        CoreItem coreItem = (CoreItem)this.currentItem;
        Page page = this.currentPage;
        if (coreItem != null) {
            try {
                this.hookDialogListener();
                this.dialogReturnCode = -1;
                IStatus status = coreItem.runExecutable(this.getManager());
                if (status.getSeverity() == 4) {
                    CheatSheetPlugin.getPlugin().getLog().log(status);
                    ErrorDialog.openError((Shell)PlatformUI.getWorkbench().getActiveWorkbenchWindow().getShell(), null, null, (IStatus)status);
                }
                if (page != this.currentPage) {
                    return;
                }
                if (status.isOK() && this.dialogReturnCode != 1) {
                    coreItem.setRestartImage();
                    if (!coreItem.hasConfirm()) {
                        this.advanceItem(link, true);
                        this.saveCurrentSheet();
                    }
                }
            }
            finally {
                this.unhookDialogListener();
            }
        }
        link.setCursor(null);
    }

    void runSubItemPerformExecutable(ImageHyperlink link, int subItemIndex) {
        CoreItem coreItem = null;
        link.setCursor(this.busyCursor);
        this.currentItem = (ViewItem)link.getData();
        coreItem = (CoreItem)this.currentItem;
        try {
            try {
                if (coreItem != null) {
                    this.hookDialogListener();
                    if (coreItem.runSubItemExecutable(this.getManager(), subItemIndex) == 0 && !coreItem.hasConfirm(subItemIndex)) {
                        ArrayList<SubItemCompositeHolder> l = coreItem.getListOfSubItemCompositeHolders();
                        SubItemCompositeHolder s = l.get(subItemIndex);
                        s.getStartButton().setImage(CheatSheetPlugin.getPlugin().getImage("CHEATSHEET_ITEM_BUTTON_RESTART"));
                        s.getStartButton().setToolTipText(Messages.RESTART_TASK_TOOLTIP);
                        this.advanceSubItem(link, true, subItemIndex);
                        this.saveCurrentSheet();
                    }
                }
            }
            catch (RuntimeException e) {
                Status status = new Status(4, "org.eclipse.ui.cheatsheets", 0, Messages.ERROR_RUNNING_ACTION, (Throwable)e);
                CheatSheetPlugin.getPlugin().getLog().log((IStatus)status);
                ErrorDialog.openError((Shell)PlatformUI.getWorkbench().getActiveWorkbenchWindow().getShell(), null, null, (IStatus)status);
                this.unhookDialogListener();
                link.setCursor(null);
            }
        }
        finally {
            this.unhookDialogListener();
            link.setCursor(null);
        }
    }

    public void saveCurrentSheet() {
        if (this.currentID != null) {
            if (this.currentPage instanceof CheatSheetPage) {
                Properties properties = this.saveHelper.createProperties(this.currentItemNum, this.viewItemList, this.getExpandRestoreActionState(), this.expandRestoreList, this.currentID, this.restorePath);
                IStatus status = this.stateManager.saveState(properties, this.getManager());
                if (!status.isOK()) {
                    CheatSheetPlugin.getPlugin().getLog().log(status);
                }
            } else if (this.currentPage instanceof CompositeCheatSheetPage) {
                ((CompositeCheatSheetPage)this.currentPage).saveState();
            }
        }
    }

    private boolean getExpandRestoreActionState() {
        boolean expandRestoreActionState = false;
        if (this.expandRestoreAction != null) {
            expandRestoreActionState = this.expandRestoreAction.isCollapsed();
        }
        return expandRestoreActionState;
    }

    void setContent(CheatSheetElement element, ICheatSheetStateManager inputStateManager) {
        CheatSheetStopWatch.startStopWatch("CheatSheetViewer.setContent(CheatSheetElement element)");
        this.internalDispose();
        this.contentElement = element;
        this.stateManager = inputStateManager;
        this.stateManager.setElement(element);
        this.currentID = null;
        this.parserInput = null;
        if (element != null) {
            this.initInputFields(element);
        }
        CheatSheetStopWatch.printLapTime("CheatSheetViewer.setContent(CheatSheetElement element)", "Time in CheatSheetViewer.setContent() before initCheatSheetView() call: ");
        boolean cheatSheetOpened = false;
        if (this.control != null) {
            cheatSheetOpened = this.initCheatSheetView();
        }
        if (!cheatSheetOpened) {
            this.contentElement = null;
            this.stateManager = null;
        }
        CheatSheetStopWatch.printLapTime("CheatSheetViewer.setContent(CheatSheetElement element)", "Time in CheatSheetViewer.setContent() after initCheatSheetView() call: ");
    }

    private void initInputFields(CheatSheetElement element) {
        String pluginId;
        this.currentID = element.getID();
        String contentXml = element.getContentXml();
        URL contentURL = null;
        this.restorePath = element.getRestorePath();
        String errorMessage = null;
        if (contentXml != null) {
            this.parserInput = new ParserInput(contentXml, element.getHref());
            return;
        }
        Bundle bundle = null;
        if (element != null && element.getConfigurationElement() != null) {
            try {
                pluginId = element.getConfigurationElement().getContributor().getName();
                bundle = Platform.getBundle((String)pluginId);
            }
            catch (Exception exception) {}
        }
        if (bundle != null && (contentURL = FileLocator.find(bundle, (IPath)IPath.fromOSString((String)element.getContentFile()), null)) == null && element.getContentFile() != null) {
            errorMessage = NLS.bind((String)Messages.ERROR_OPENING_FILE_IN_PARSER, (Object[])new Object[]{element.getContentFile()});
        }
        if (contentURL == null) {
            try {
                contentURL = new URL(element.getHref());
            }
            catch (MalformedURLException malformedURLException) {}
            if (contentURL == null && element.getHref() != null) {
                errorMessage = NLS.bind((String)Messages.ERROR_OPENING_FILE_IN_PARSER, (Object[])new Object[]{element.getHref()});
            }
        }
        pluginId = bundle != null ? bundle.getSymbolicName() : null;
        this.parserInput = new ParserInput(contentURL, pluginId, errorMessage);
    }

    void setExpandRestoreAction(CheatSheetExpandRestoreAction action) {
        this.expandRestoreAction = action;
    }

    @Override
    public void setFocus() {
        if (this.currentItem != null) {
            this.currentItem.setFocus();
        } else {
            this.getControl().setFocus();
        }
    }

    @Override
    public void setInput(String id) {
        this.setInput(id, new DefaultStateManager());
    }

    public void setInput(String id, ICheatSheetStateManager inputStateManager) {
        CheatSheetStopWatch.startStopWatch("CheatSheetViewer.setInput(String id)");
        CheatSheetElement element = null;
        if (id == null) {
            this.nullCheatSheetId = true;
        } else {
            this.nullCheatSheetId = false;
            element = CheatSheetRegistryReader.getInstance().findCheatSheet(id);
            if (element == null) {
                String message = NLS.bind((String)Messages.ERROR_INVALID_CHEATSHEET_ID, (Object[])new Object[]{id});
                Status status = new Status(4, "org.eclipse.ui.cheatsheets", 0, message, null);
                CheatSheetPlugin.getPlugin().getLog().log((IStatus)status);
                this.invalidCheatSheetId = true;
            } else {
                this.invalidCheatSheetId = false;
                this.isRestricted = false;
            }
        }
        CheatSheetStopWatch.printLapTime("CheatSheetViewer.setInput(String id)", "Time in CheatSheetViewer.setInput(String id) before setContent() call: ");
        this.setContent(element, inputStateManager);
        CheatSheetStopWatch.printLapTime("CheatSheetViewer.setInput(String id)", "Time in CheatSheetViewer.setInput(String id) after setContent() call: ");
        CheatSheetPlugin.getPlugin().getCheatSheetHistory().add(element);
        CheatSheetStopWatch.printLapTime("CheatSheetViewer.setInput(String id)", "Time in CheatSheetViewer.setInput(String id) after getCheatSheetHistory() call: ");
    }

    @Override
    public void setInput(String id, String name, URL url) {
        this.setInput(id, name, url, new DefaultStateManager(), false);
    }

    public void setInputFromXml(String id, String name, String xml, String basePath) {
        if (id == null || name == null || xml == null) {
            throw new IllegalArgumentException();
        }
        CheatSheetElement element = new CheatSheetElement(name);
        element.setID(id);
        element.setContentXml(xml);
        element.setHref(basePath);
        this.nullCheatSheetId = false;
        this.invalidCheatSheetId = false;
        this.isRestricted = false;
        this.setContent(element, new NoSaveStateManager());
    }

    public void setInput(String id, String name, URL url, ICheatSheetStateManager inputStateManager, boolean isRestricted) {
        if (id == null || name == null || url == null) {
            throw new IllegalArgumentException();
        }
        CheatSheetElement element = new CheatSheetElement(name);
        element.setID(id);
        element.setHref(url.toString());
        this.nullCheatSheetId = false;
        this.invalidCheatSheetId = false;
        this.isRestricted = isRestricted;
        this.setContent(element, inputStateManager);
    }

    void toggleExpandRestore() {
        if (this.expandRestoreAction == null) {
            return;
        }
        if (this.expandRestoreAction.isCollapsed()) {
            this.restoreExpandStates();
            this.expandRestoreAction.setCollapsed(false);
        } else {
            this.collapseAllButCurrent(true);
            this.expandRestoreAction.setCollapsed(true);
        }
    }

    public Action getCopyAction() {
        return this.copyAction;
    }

    public void setCopyAction(Action copyAction) {
        this.copyAction = copyAction;
    }

    public void copy() {
        for (ViewItem viewItem : this.viewItemList) {
            if (!viewItem.hasFocus()) continue;
            viewItem.copy();
            return;
        }
    }

    public void addListener(CheatSheetListener listener) {
        if (this.contentElement != null) {
            this.getManager().addListener(listener);
        }
    }

    @Override
    public int contributeToViewMenu(Menu menu, int index) {
        if (this.currentPage instanceof IMenuContributor) {
            return ((IMenuContributor)((Object)this.currentPage)).contributeToViewMenu(menu, index);
        }
        return index;
    }

    public void restart() {
        this.resetItemState();
        this.currentItemNum = 0;
        this.collapseAllButCurrent(false);
        IntroItem introItem = (IntroItem)this.getViewItemAtIndex(0);
        introItem.setIncomplete();
        this.showIntroItem();
    }

    public void saveState(IMemento memento) {
        if (this.currentPage instanceof CheatSheetPage) {
            Properties properties = this.saveHelper.createProperties(this.currentItemNum, this.viewItemList, this.getExpandRestoreActionState(), this.expandRestoreList, this.currentID, this.restorePath);
            this.saveHelper.saveToMemento(properties, this.getManager(), memento);
        }
    }

    @Override
    public void reset(Map<String, String> cheatSheetData) {
        if (this.currentPage instanceof CheatSheetPage) {
            this.restart();
            this.getManager().setData(cheatSheetData);
        } else if (this.currentPage instanceof CompositeCheatSheetPage) {
            ((CompositeCheatSheetPage)this.currentPage).restart(cheatSheetData);
        }
    }

    public void showError(String message) {
        this.internalDispose();
        if (this.howToBegin != null) {
            this.howToBegin.dispose();
            this.howToBegin = null;
        }
        this.createErrorPage(message);
    }
}

