/*
 * Decompiled with CFR 0.152.
 */
package com.jaspersoft.studio.components.chart.model.chartAxis;

import com.jaspersoft.studio.components.chart.ChartNodeIconDescriptor;
import com.jaspersoft.studio.components.chart.messages.Messages;
import com.jaspersoft.studio.components.chart.model.MChart;
import com.jaspersoft.studio.components.chart.model.plot.PlotFactory;
import com.jaspersoft.studio.model.ANode;
import com.jaspersoft.studio.model.APropertyNode;
import com.jaspersoft.studio.model.ICopyable;
import com.jaspersoft.studio.model.IDragable;
import com.jaspersoft.studio.model.INode;
import com.jaspersoft.studio.model.IPastableGraphic;
import com.jaspersoft.studio.model.MElementGroup;
import com.jaspersoft.studio.model.util.IIconDescriptor;
import com.jaspersoft.studio.property.descriptor.JRPropertyDescriptor;
import com.jaspersoft.studio.property.descriptor.NullEnum;
import com.jaspersoft.studio.property.descriptors.NamedEnumPropertyDescriptor;
import java.beans.PropertyChangeListener;
import java.util.HashSet;
import java.util.List;
import net.sf.jasperreports.charts.JRChartAxis;
import net.sf.jasperreports.charts.design.JRDesignChartAxis;
import net.sf.jasperreports.charts.type.AxisPositionEnum;
import net.sf.jasperreports.engine.JRChart;
import net.sf.jasperreports.engine.JRGroup;
import net.sf.jasperreports.engine.design.JRDesignChart;
import net.sf.jasperreports.engine.design.JasperDesign;
import org.eclipse.gef.EditPart;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.ui.views.properties.IPropertyDescriptor;

public class MChartAxes
extends APropertyNode
implements IDragable,
ICopyable {
    public static final long serialVersionUID = 10200L;
    private static IIconDescriptor iconDescriptor;
    private static IPropertyDescriptor[] descriptors;
    private MChart mChart;

    public static IIconDescriptor getIconDescriptor() {
        if (iconDescriptor == null) {
            iconDescriptor = new ChartNodeIconDescriptor("chartaxis");
        }
        return iconDescriptor;
    }

    public String getDisplayText() {
        JRChartAxis ca = this.getValue();
        if (ca != null) {
            JRChart c = ca.getChart();
            String dt = PlotFactory.getChartPlot(c.getPlot()).getDisplayText();
            if (c.getKey() != null && !c.getKey().trim().isEmpty()) {
                dt = String.valueOf(dt) + " (" + c.getKey() + ")";
            }
            return dt;
        }
        return MChartAxes.getIconDescriptor().getTitle();
    }

    public ImageDescriptor getImagePath() {
        return MChartAxes.getIconDescriptor().getIcon16();
    }

    public MChartAxes() {
    }

    public MChartAxes(ANode parent, JRChartAxis jrChart, int newIndex) {
        super(parent, newIndex);
        this.setValue(jrChart);
    }

    public JRChartAxis getValue() {
        return (JRChartAxis)super.getValue();
    }

    public IPropertyDescriptor[] getDescriptors() {
        return descriptors;
    }

    public void setDescriptors(IPropertyDescriptor[] descriptors1) {
        descriptors = descriptors1;
    }

    public void createPropertyDescriptors(List<IPropertyDescriptor> desc) {
        NamedEnumPropertyDescriptor positionD = new NamedEnumPropertyDescriptor((Object)"position", Messages.MChartAxes_position, (Enum)AxisPositionEnum.LEFT_OR_TOP, NullEnum.NOTNULL);
        positionD.setDescription(Messages.MChartAxes_position_description);
        desc.add((IPropertyDescriptor)positionD);
        JRPropertyDescriptor chartD = new JRPropertyDescriptor((Object)"chart", Messages.MChartAxes_chart);
        chartD.setDescription(Messages.MChartAxes_chart_description);
        desc.add((IPropertyDescriptor)chartD);
        this.setHelpPrefix(desc, "net.sf.jasperreports.doc/docs/schema.reference.html?cp=0_1#axis");
    }

    protected void postDescriptors(IPropertyDescriptor[] descriptors) {
        super.postDescriptors(descriptors);
        JasperDesign jasperDesign = this.getJasperDesign();
        if (jasperDesign != null) {
            JRGroup[] groups = jasperDesign.getGroups();
            String[] items = new String[groups.length + 1];
            items[0] = "";
            int j = 0;
            while (j < groups.length) {
                items[j + 1] = groups[j].getName();
                ++j;
            }
            this.setGroupItems(items);
        }
    }

    protected void setGroupItems(String[] items) {
        if (this.mChart != null) {
            this.mChart.setGroupItems(items);
        }
    }

    public Object getPropertyValue(Object id) {
        JRDesignChartAxis jrElement = (JRDesignChartAxis)this.getValue();
        if (id.equals("position")) {
            return NamedEnumPropertyDescriptor.getIntValue((NullEnum)NullEnum.NOTNULL, (Enum)jrElement.getPositionValue());
        }
        if (id.equals("chart")) {
            if (this.mChart == null) {
                this.mChart = new MChart();
            }
            this.mChart.setJasperConfiguration(this.getJasperConfiguration());
            this.setChildListener((ANode)this.mChart);
            this.mChart.setValue(jrElement.getChart());
            return this.mChart;
        }
        return null;
    }

    public void setPropertyValue(Object id, Object value) {
        JRDesignChartAxis jrElement = (JRDesignChartAxis)this.getValue();
        if (id.equals("position")) {
            AxisPositionEnum axisPosition = (AxisPositionEnum)NamedEnumPropertyDescriptor.getEnumValue((Enum)AxisPositionEnum.LEFT_OR_TOP, (NullEnum)NullEnum.NOTNULL, (Object)value);
            jrElement.setPosition(axisPosition);
        } else if (this.mChart != null) {
            this.mChart.setPropertyValue(id, value);
        }
    }

    public void setValue(Object value) {
        JRDesignChartAxis oldObject = (JRDesignChartAxis)this.getValue();
        JRDesignChartAxis newObject = (JRDesignChartAxis)value;
        if (oldObject != null) {
            ((JRDesignChart)oldObject.getChart()).getEventSupport().removePropertyChangeListener((PropertyChangeListener)((Object)this));
        }
        if (newObject != null) {
            ((JRDesignChart)newObject.getChart()).getEventSupport().addPropertyChangeListener((PropertyChangeListener)((Object)this));
        }
        super.setValue(value);
    }

    public ICopyable.RESULT isCopyable2(Object parent) {
        if (parent instanceof MChart || parent instanceof MElementGroup || parent instanceof IPastableGraphic) {
            return ICopyable.RESULT.COPYABLE;
        }
        return ICopyable.RESULT.CHECK_PARENT;
    }

    public boolean isCuttable(ISelection currentSelection) {
        ANode parent = this.getParent();
        if (parent != null) {
            if (parent.getChildren().size() <= 1) {
                return false;
            }
            StructuredSelection sSel = (StructuredSelection)currentSelection;
            HashSet<Object> selectedModels = new HashSet<Object>();
            Object[] objectArray = sSel.toArray();
            int n = objectArray.length;
            int n2 = 0;
            while (n2 < n) {
                Object obj = objectArray[n2];
                if (obj instanceof EditPart) {
                    EditPart part = (EditPart)obj;
                    selectedModels.add(part.getModel());
                }
                ++n2;
            }
            boolean allIncluded = true;
            for (INode child : parent.getChildren()) {
                if (selectedModels.contains(child)) continue;
                allIncluded = false;
                break;
            }
            return !allIncluded;
        }
        return false;
    }
}

