/*
 * Decompiled with CFR 0.152.
 */
package com.jaspersoft.studio.components.chart.model.chartAxis.command;

import com.jaspersoft.studio.components.chart.model.MChart;
import com.jaspersoft.studio.components.chart.model.chartAxis.MChartAxes;
import com.jaspersoft.studio.components.chart.model.chartAxis.command.ChartAxesWizard;
import net.sf.jasperreports.charts.JRChartAxis;
import net.sf.jasperreports.charts.design.JRDesignChartAxis;
import net.sf.jasperreports.charts.design.JRDesignMultiAxisPlot;
import net.sf.jasperreports.engine.design.JRDesignChart;
import net.sf.jasperreports.engine.design.JasperDesign;
import org.eclipse.gef.commands.Command;
import org.eclipse.jface.wizard.IWizard;
import org.eclipse.jface.wizard.WizardDialog;
import org.eclipse.swt.widgets.Display;

public class CreateChartAxesCommand
extends Command {
    private JRDesignChartAxis jrElement;
    private JRDesignMultiAxisPlot jrPlot;
    private JRDesignChart chart;
    private int index;
    private JasperDesign jDesign;
    private Byte selectedAxes;

    public CreateChartAxesCommand(MChart destNode, MChartAxes srcNode, int newIndex) {
        this(destNode.getValue(), (JRDesignChartAxis)srcNode.getValue(), newIndex, destNode.getJasperDesign());
    }

    public CreateChartAxesCommand(JRDesignChart chart, JRDesignChartAxis chartAxis, int newIndex, JasperDesign jDesign) {
        this.jrElement = chartAxis;
        this.chart = chart;
        this.jrPlot = (JRDesignMultiAxisPlot)chart.getPlot();
        this.index = newIndex;
        this.jDesign = jDesign;
    }

    public void setSelectedAxes(Byte selectedAxes) {
        this.selectedAxes = selectedAxes;
    }

    protected void createObject() {
        if (this.jrElement == null) {
            if (this.selectedAxes == null) {
                ChartAxesWizard wizard = new ChartAxesWizard();
                WizardDialog dialog = new WizardDialog(Display.getDefault().getActiveShell(), (IWizard)wizard);
                dialog.create();
                if (dialog.open() == 0) {
                    this.selectedAxes = wizard.getChartAxis();
                }
            }
            if (this.selectedAxes != null) {
                this.jrElement = new JRDesignChartAxis(this.chart);
                JRDesignChart c = MChart.createJRElement(this.jDesign, this.selectedAxes, true);
                this.jrElement.setChart(c);
            }
        }
    }

    public void execute() {
        this.createObject();
        if (this.jrElement != null) {
            if (this.index >= 0 && this.index < this.jrPlot.getAxes().size()) {
                this.jrPlot.addAxis(this.index, (JRChartAxis)this.jrElement);
            } else {
                this.jrPlot.addAxis((JRChartAxis)this.jrElement);
            }
        }
    }

    public boolean canUndo() {
        return this.jrPlot != null && this.jrElement != null;
    }

    public void undo() {
        this.jrPlot.removeAxis((JRChartAxis)this.jrElement);
    }
}

