/*
 * Decompiled with CFR 0.152.
 */
package com.jaspersoft.studio.components.chart.model.plot;

import com.jaspersoft.studio.components.chart.messages.Messages;
import com.jaspersoft.studio.components.chart.property.descriptor.seriescolor.SeriesColorPropertyDescriptor;
import com.jaspersoft.studio.help.HelpReferenceBuilder;
import com.jaspersoft.studio.help.IHelpRefBuilder;
import com.jaspersoft.studio.model.APropertyNode;
import com.jaspersoft.studio.model.DefaultValue;
import com.jaspersoft.studio.property.descriptor.NullEnum;
import com.jaspersoft.studio.property.descriptor.color.ColorPropertyDescriptor;
import com.jaspersoft.studio.property.descriptors.NamedEnumPropertyDescriptor;
import com.jaspersoft.studio.property.descriptors.TransparencyPropertyDescriptor;
import com.jaspersoft.studio.utils.AlfaRGB;
import com.jaspersoft.studio.utils.Colors;
import java.awt.Color;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import net.sf.jasperreports.charts.type.PlotOrientationEnum;
import net.sf.jasperreports.engine.JRChartPlot;
import net.sf.jasperreports.engine.base.JRBaseChartPlot;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.ui.views.properties.IPropertyDescriptor;

public class MChartPlot
extends APropertyNode {
    public static final long serialVersionUID = 10200L;
    private static IPropertyDescriptor[] descriptors;
    private static NamedEnumPropertyDescriptor<PlotOrientationEnum> orientationD;

    public MChartPlot(JRChartPlot value) {
        this.setValue(value);
    }

    public void createPropertyDescriptors(List<IPropertyDescriptor> desc) {
        ColorPropertyDescriptor backcolorD = new ColorPropertyDescriptor((Object)"backcolor", Messages.MChartPlot_backcolor, NullEnum.INHERITED);
        backcolorD.setDescription(Messages.MChartPlot_backcolor_description);
        desc.add((IPropertyDescriptor)backcolorD);
        TransparencyPropertyDescriptor backAlphaD = new TransparencyPropertyDescriptor((Object)"backgroundAlpha", Messages.MChartPlot_background_alpha_percent);
        backAlphaD.setDescription(Messages.MChartPlot_background_alpha_percent_description);
        desc.add((IPropertyDescriptor)backAlphaD);
        TransparencyPropertyDescriptor foreAlphaD = new TransparencyPropertyDescriptor((Object)"foregroundAlpha", Messages.MChartPlot_foreground_alpha_percent);
        foreAlphaD.setDescription(Messages.MChartPlot_foreground_alpha_percent_description);
        desc.add((IPropertyDescriptor)foreAlphaD);
        orientationD = new NamedEnumPropertyDescriptor((Object)"orientation", Messages.MChartPlot_orientation, (Enum)PlotOrientationEnum.HORIZONTAL, NullEnum.NULL);
        orientationD.setDescription(Messages.MChartPlot_orientation_description);
        desc.add((IPropertyDescriptor)orientationD);
        SeriesColorPropertyDescriptor scpd = new SeriesColorPropertyDescriptor("seriesColors", Messages.MChartPlot_series_colors);
        scpd.setDescription(Messages.MChartPlot_series_colors_description);
        desc.add((IPropertyDescriptor)scpd);
        scpd.setHelpRefBuilder((IHelpRefBuilder)new HelpReferenceBuilder("net.sf.jasperreports.doc/docs/schema.reference.html?cp=0_1#seriesColor"));
        this.setHelpPrefix(desc, "net.sf.jasperreports.doc/docs/schema.reference.html?cp=0_1#plot");
    }

    protected Map<String, DefaultValue> createDefaultsMap() {
        Map defaultsMap = super.createDefaultsMap();
        defaultsMap.put("backgroundAlpha", new DefaultValue(true));
        defaultsMap.put("foregroundAlpha", new DefaultValue(true));
        defaultsMap.put("backcolor", new DefaultValue(true));
        return defaultsMap;
    }

    public IPropertyDescriptor[] getDescriptors() {
        return descriptors;
    }

    public void setDescriptors(IPropertyDescriptor[] descriptors1) {
        descriptors = descriptors1;
    }

    public Object getPropertyValue(Object id) {
        JRBaseChartPlot jrElement = (JRBaseChartPlot)this.getValue();
        if (id.equals("backcolor")) {
            return Colors.getSWTRGB4AWTGBColor((Color)jrElement.getOwnBackcolor());
        }
        if (id.equals("backgroundAlpha")) {
            return jrElement.getBackgroundAlphaFloat();
        }
        if (id.equals("foregroundAlpha")) {
            return jrElement.getForegroundAlphaFloat();
        }
        if (id.equals("orientation")) {
            return orientationD.getIntValue((Enum)jrElement.getOrientationValue());
        }
        if (id.equals("seriesColors")) {
            return jrElement.getSeriesColors();
        }
        return null;
    }

    public Object getPropertyActualValue(Object id) {
        JRBaseChartPlot jrElement = (JRBaseChartPlot)this.getValue();
        if (id.equals("backcolor")) {
            return Colors.getSWTRGB4AWTGBColor((Color)jrElement.getBackcolor());
        }
        if (id.equals("backgroundAlpha")) {
            Float alpha = jrElement.getBackgroundAlphaFloat();
            return Float.valueOf(alpha != null ? alpha.floatValue() : 1.0f);
        }
        if (id.equals("foregroundAlpha")) {
            Float alpha = jrElement.getForegroundAlphaFloat();
            return Float.valueOf(alpha != null ? alpha.floatValue() : 1.0f);
        }
        return super.getPropertyActualValue(id);
    }

    public void setPropertyValue(Object id, Object value) {
        JRBaseChartPlot jrElement = (JRBaseChartPlot)this.getValue();
        if (id.equals("backcolor")) {
            if (value == null || value instanceof AlfaRGB) {
                jrElement.setBackcolor(Colors.getAWT4SWTRGBColor((AlfaRGB)((AlfaRGB)value)));
            }
        } else if (id.equals("backgroundAlpha")) {
            jrElement.setBackgroundAlpha((Float)value);
        } else if (id.equals("foregroundAlpha")) {
            jrElement.setForegroundAlpha((Float)value);
        } else if (id.equals("orientation")) {
            jrElement.setOrientation((PlotOrientationEnum)orientationD.getEnumValue(value));
        } else if (id.equals("seriesColors")) {
            jrElement.setSeriesColors((Collection)value);
        }
    }

    public ImageDescriptor getImagePath() {
        return null;
    }

    public String getDisplayText() {
        return null;
    }
}

