/*
 * Decompiled with CFR 0.152.
 */
package com.jaspersoft.studio.components.chart.wizard.fragments.data;

import com.jaspersoft.studio.components.chart.messages.Messages;
import com.jaspersoft.studio.components.chart.wizard.HyperlinkPage;
import com.jaspersoft.studio.components.chart.wizard.fragments.data.ADSComponent;
import com.jaspersoft.studio.components.chart.wizard.fragments.data.dialog.SeriesDialog;
import com.jaspersoft.studio.components.chart.wizard.fragments.data.series.CategorySerie;
import com.jaspersoft.studio.components.chart.wizard.fragments.data.widget.DatasetSeriesWidget;
import com.jaspersoft.studio.editor.expression.ExpressionContext;
import com.jaspersoft.studio.jasper.JSSDrawVisitor;
import com.jaspersoft.studio.model.APropertyNode;
import com.jaspersoft.studio.model.MHyperLink;
import com.jaspersoft.studio.property.dataset.ExpressionWidget;
import com.jaspersoft.studio.utils.jasper.JasperReportsConfiguration;
import java.text.MessageFormat;
import java.util.List;
import net.sf.jasperreports.charts.JRCategorySeries;
import net.sf.jasperreports.charts.design.JRDesignCategoryDataset;
import net.sf.jasperreports.charts.design.JRDesignCategorySeries;
import net.sf.jasperreports.engine.JRExpression;
import net.sf.jasperreports.engine.JRHyperlink;
import net.sf.jasperreports.engine.design.JRDesignElement;
import net.sf.jasperreports.engine.design.JRDesignElementDataset;
import net.sf.jasperreports.engine.design.JRDesignHyperlink;
import org.eclipse.core.runtime.Assert;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Combo;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;

public class DSCategory
extends ADSComponent {
    private JRDesignCategoryDataset dataset;
    private ExpressionWidget valueWidget;
    private ExpressionWidget categWidget;
    private ExpressionWidget labelWidget;
    private Combo seriesCombo;
    private Button hyperlinkBtn;

    public DSCategory(Composite composite, DatasetSeriesWidget dsWidget) {
        super(composite, dsWidget);
    }

    @Override
    public String getName() {
        return Messages.DSCategory_datasetName;
    }

    @Override
    public void setData(JSSDrawVisitor drawVisitor, JRDesignElement jrChart, JRDesignElementDataset eDataset, JasperReportsConfiguration jrContext) {
        Assert.isTrue((boolean)(eDataset instanceof JRDesignCategoryDataset));
        super.setData(drawVisitor, jrChart, eDataset, jrContext);
        this.dataset = (JRDesignCategoryDataset)eDataset;
        this.setSeries(0);
    }

    private void setSeries(int selection) {
        List seriesList = this.dataset.getSeriesList();
        if (!seriesList.isEmpty()) {
            String[] srnames = new String[seriesList.size()];
            int i = 0;
            while (i < seriesList.size()) {
                JRCategorySeries cs = (JRCategorySeries)seriesList.get(i);
                JRExpression se = cs.getSeriesExpression();
                srnames[i] = se != null && se.getText() != null ? se.getText() : "";
                ++i;
            }
            this.seriesCombo.setItems(srnames);
            this.seriesCombo.select(selection);
            this.hyperlinkBtn.setEnabled(true);
            this.handleSelectSeries(selection);
        } else {
            this.seriesCombo.setItems(new String[0]);
            this.hyperlinkBtn.setEnabled(false);
            this.hyperlinkBtn.setText(Messages.DSCategory_hyperlinkButtonDisabled);
            this.handleSelectSeries(-1);
        }
    }

    private void handleSelectSeries(int selection) {
        JRCategorySeries serie = null;
        if (selection >= 0 && selection < this.dataset.getSeriesList().size()) {
            serie = (JRCategorySeries)this.dataset.getSeriesList().get(selection);
        }
        this.valueWidget.bindObject(serie, "ValueExpression");
        this.categWidget.bindObject(serie, "CategoryExpression");
        this.labelWidget.bindObject((Object)serie, "LabelExpression");
        String seriesText = this.seriesCombo.getText();
        if (seriesText.length() > 30) {
            this.hyperlinkBtn.setToolTipText(MessageFormat.format(Messages.DSCategory_defineHyperlinkButtton, seriesText));
            seriesText = String.valueOf(seriesText.substring(0, 27)) + "...";
        } else {
            this.hyperlinkBtn.setToolTipText(null);
        }
        this.hyperlinkBtn.setText(MessageFormat.format(Messages.DSCategory_defineHyperlinkButtton, seriesText));
        this.valueWidget.setEnabled(serie != null);
        this.categWidget.setEnabled(serie != null);
        this.labelWidget.setEnabled(serie != null);
        this.hyperlinkBtn.setEnabled(serie != null);
    }

    @Override
    protected Control createChartTop(Composite composite) {
        Composite yCompo = new Composite(composite, 0);
        yCompo.setLayoutData((Object)new GridData(64));
        yCompo.setLayout((Layout)new GridLayout(10, false));
        Label lbl = new Label(yCompo, 0);
        lbl.setText(Messages.DSCategory_seriesLabel);
        lbl.setToolTipText(Messages.DSCategory_seriesTooltip);
        this.seriesCombo = new Combo(yCompo, 2056);
        this.seriesCombo.setToolTipText(Messages.DSCategory_seriesTooltip);
        GridData gd = new GridData(768);
        gd.widthHint = 300;
        this.seriesCombo.setLayoutData((Object)gd);
        this.seriesCombo.setItems(new String[]{"series 1"});
        this.seriesCombo.addSelectionListener(new SelectionListener(){

            public void widgetSelected(SelectionEvent e) {
                DSCategory.this.handleSelectSeries(DSCategory.this.seriesCombo.getSelectionIndex());
            }

            public void widgetDefaultSelected(SelectionEvent e) {
                this.widgetSelected(e);
            }
        });
        final Button btn = new Button(yCompo, 0x800008);
        btn.setText("...");
        btn.addSelectionListener(new SelectionListener(){

            public void widgetSelected(SelectionEvent e) {
                CategorySerie serie = new CategorySerie();
                SeriesDialog<JRCategorySeries> dlg = new SeriesDialog<JRCategorySeries>(btn.getShell(), serie);
                dlg.setExpressionContext(DSCategory.this.expContext);
                List oldList = DSCategory.this.dataset.getSeriesList();
                int oldsel = DSCategory.this.seriesCombo.getSelectionIndex();
                JRCategorySeries selected = null;
                if (oldsel >= 0) {
                    selected = (JRCategorySeries)oldList.get(oldsel);
                }
                serie.setList(oldList);
                if (dlg.open() == 0) {
                    List<JRCategorySeries> newlist = serie.getList();
                    JRCategorySeries[] jRCategorySeriesArray = DSCategory.this.dataset.getSeries();
                    int n = jRCategorySeriesArray.length;
                    int n2 = 0;
                    while (n2 < n) {
                        JRCategorySeries item = jRCategorySeriesArray[n2];
                        DSCategory.this.dataset.removeCategorySeries(item);
                        ++n2;
                    }
                    for (JRCategorySeries item : newlist) {
                        DSCategory.this.dataset.addCategorySeries(item);
                    }
                    int sel = selected != null && newlist.indexOf(selected) >= 0 ? newlist.indexOf(selected) : 0;
                    DSCategory.this.setSeries(sel);
                }
            }

            public void widgetDefaultSelected(SelectionEvent e) {
                this.widgetSelected(e);
            }
        });
        this.hyperlinkBtn = new Button(yCompo, 0x800008);
        this.hyperlinkBtn.setSelection(false);
        this.hyperlinkBtn.addSelectionListener(new SelectionListener(){

            public void widgetSelected(SelectionEvent e) {
                int selection = DSCategory.this.seriesCombo.getSelectionIndex();
                JRDesignCategorySeries serie = null;
                if (selection >= 0 && selection < DSCategory.this.dataset.getSeriesList().size()) {
                    serie = (JRDesignCategorySeries)DSCategory.this.dataset.getSeriesList().get(selection);
                }
                if (serie != null) {
                    MHyperLink hyperLinkElement = null;
                    JRHyperlink hyperlink = serie.getItemHyperlink();
                    hyperLinkElement = hyperlink != null ? DSCategory.this.createHyperlinkModel((JRHyperlink)hyperlink.clone()) : DSCategory.this.createHyperlinkModel((JRHyperlink)new JRDesignHyperlink());
                    HyperlinkPage dlg = new HyperlinkPage(DSCategory.this.hyperlinkBtn.getShell(), (APropertyNode)hyperLinkElement, DSCategory.this.seriesCombo.getText(), serie.getItemHyperlink() != null);
                    int operationResult = dlg.open();
                    if (operationResult == 0) {
                        serie.setItemHyperlink((JRHyperlink)dlg.getElement().getValue());
                    } else if (operationResult == 7) {
                        serie.setItemHyperlink(null);
                    }
                }
            }

            public void widgetDefaultSelected(SelectionEvent e) {
                this.widgetSelected(e);
            }
        });
        return yCompo;
    }

    @Override
    protected Control createChartRight(Composite parent) {
        Composite yCompo = new Composite(parent, 0);
        yCompo.setLayoutData((Object)new GridData(768));
        yCompo.setLayout((Layout)new GridLayout(3, false));
        this.labelWidget = new ExpressionWidget(yCompo, Messages.DSCategory_labelLabel);
        this.labelWidget.setToolTipText(Messages.DSCategory_labelTooltip);
        return yCompo;
    }

    @Override
    protected Control createChartLeft(Composite parent) {
        Composite yCompo = new Composite(parent, 0);
        yCompo.setLayoutData((Object)new GridData(768));
        yCompo.setLayout((Layout)new GridLayout(3, false));
        this.valueWidget = new ExpressionWidget(yCompo, Messages.DSCategory_valueLabel);
        this.valueWidget.setToolTipText(Messages.DSCategory_valueTooltip);
        return yCompo;
    }

    @Override
    protected Control createChartBottom(Composite parent) {
        Composite xCompo = new Composite(parent, 0);
        xCompo.setLayout((Layout)new GridLayout(3, false));
        xCompo.setLayoutData((Object)new GridData(64));
        this.categWidget = new ExpressionWidget(xCompo, Messages.DSCategory_categoryLabel);
        this.categWidget.setToolTipText(Messages.DSCategory_categoryTooltip);
        return xCompo;
    }

    @Override
    public void setExpressionContext(ExpressionContext expContext) {
        super.setExpressionContext(expContext);
        this.categWidget.setExpressionContext(expContext);
        this.labelWidget.setExpressionContext(expContext);
        this.valueWidget.setExpressionContext(expContext);
    }
}

