/*
 * Decompiled with CFR 0.152.
 */
package com.jaspersoft.studio.components.chart.wizard.fragments.data;

import com.jaspersoft.studio.components.chart.messages.Messages;
import com.jaspersoft.studio.components.chart.wizard.HyperlinkPage;
import com.jaspersoft.studio.components.chart.wizard.fragments.data.ADSComponent;
import com.jaspersoft.studio.components.chart.wizard.fragments.data.dialog.SeriesDialog;
import com.jaspersoft.studio.components.chart.wizard.fragments.data.series.XySerie;
import com.jaspersoft.studio.components.chart.wizard.fragments.data.widget.DatasetSeriesWidget;
import com.jaspersoft.studio.editor.expression.ExpressionContext;
import com.jaspersoft.studio.jasper.JSSDrawVisitor;
import com.jaspersoft.studio.model.APropertyNode;
import com.jaspersoft.studio.model.MHyperLink;
import com.jaspersoft.studio.property.dataset.ExpressionWidget;
import com.jaspersoft.studio.utils.jasper.JasperReportsConfiguration;
import java.text.MessageFormat;
import java.util.List;
import net.sf.jasperreports.charts.JRXySeries;
import net.sf.jasperreports.charts.design.JRDesignXyDataset;
import net.sf.jasperreports.charts.design.JRDesignXySeries;
import net.sf.jasperreports.engine.JRExpression;
import net.sf.jasperreports.engine.JRHyperlink;
import net.sf.jasperreports.engine.design.JRDesignElement;
import net.sf.jasperreports.engine.design.JRDesignElementDataset;
import net.sf.jasperreports.engine.design.JRDesignHyperlink;
import org.eclipse.core.runtime.Assert;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Combo;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;

public class DSXy
extends ADSComponent {
    private JRDesignXyDataset dataset;
    private ExpressionWidget labelWidget;
    private ExpressionWidget xvalueWidget;
    private ExpressionWidget yvalueWidget;
    private Combo seriesCombo;
    private Button hyperlinkBtn;

    public DSXy(Composite composite, DatasetSeriesWidget dsWidget) {
        super(composite, dsWidget);
    }

    @Override
    public String getName() {
        return "XY Dataset";
    }

    @Override
    public void setData(JSSDrawVisitor drawVisitor, JRDesignElement jrChart, JRDesignElementDataset eDataset, JasperReportsConfiguration jrContext) {
        Assert.isTrue((boolean)(eDataset instanceof JRDesignXyDataset));
        super.setData(drawVisitor, jrChart, eDataset, jrContext);
        this.dataset = (JRDesignXyDataset)eDataset;
        this.setSeries(0);
    }

    private void setSeries(int selection) {
        List seriesList = this.dataset.getSeriesList();
        if (!seriesList.isEmpty()) {
            String[] srnames = new String[seriesList.size()];
            int i = 0;
            while (i < seriesList.size()) {
                JRXySeries cs = (JRXySeries)seriesList.get(i);
                JRExpression se = cs.getSeriesExpression();
                srnames[i] = se != null && se.getText() != null ? se.getText() : "";
                ++i;
            }
            this.seriesCombo.setItems(srnames);
            this.seriesCombo.select(selection);
            this.hyperlinkBtn.setEnabled(true);
            this.handleSelectSeries(selection);
        } else {
            this.seriesCombo.setItems(new String[0]);
            this.hyperlinkBtn.setEnabled(false);
            this.hyperlinkBtn.setText(Messages.DSCategory_hyperlinkButtonDisabled);
            this.handleSelectSeries(-1);
        }
    }

    private void handleSelectSeries(int selection) {
        JRXySeries serie = null;
        if (selection >= 0 && selection < this.dataset.getSeriesList().size()) {
            serie = (JRXySeries)this.dataset.getSeriesList().get(selection);
        }
        this.xvalueWidget.bindObject(serie, "XValueExpression");
        this.yvalueWidget.bindObject(serie, "YValueExpression");
        this.labelWidget.bindObject((Object)serie, "LabelExpression");
        this.hyperlinkBtn.setText(MessageFormat.format(Messages.DSCategory_defineHyperlinkButtton, this.seriesCombo.getText()));
        this.xvalueWidget.setEnabled(serie != null);
        this.yvalueWidget.setEnabled(serie != null);
        this.labelWidget.setEnabled(serie != null);
        this.hyperlinkBtn.setEnabled(serie != null);
    }

    @Override
    protected Control createChartTop(Composite composite) {
        Composite yCompo = new Composite(composite, 0);
        yCompo.setLayoutData((Object)new GridData(64));
        yCompo.setLayout((Layout)new GridLayout(10, false));
        Label lbl = new Label(yCompo, 0);
        lbl.setText(Messages.DSCategory_seriesLabel);
        lbl.setToolTipText(Messages.DSCategory_seriesTooltip);
        this.seriesCombo = new Combo(yCompo, 2056);
        this.seriesCombo.setToolTipText(Messages.DSCategory_seriesTooltip);
        GridData gd = new GridData(768);
        gd.widthHint = 300;
        this.seriesCombo.setLayoutData((Object)gd);
        this.seriesCombo.setItems(new String[]{"series 1"});
        this.seriesCombo.addSelectionListener(new SelectionListener(){

            public void widgetSelected(SelectionEvent e) {
                DSXy.this.handleSelectSeries(DSXy.this.seriesCombo.getSelectionIndex());
            }

            public void widgetDefaultSelected(SelectionEvent e) {
                this.widgetSelected(e);
            }
        });
        final Button btn = new Button(yCompo, 0x800008);
        btn.setText("...");
        btn.addSelectionListener(new SelectionListener(){

            public void widgetSelected(SelectionEvent e) {
                XySerie serie = new XySerie();
                SeriesDialog<JRXySeries> dlg = new SeriesDialog<JRXySeries>(btn.getShell(), serie);
                dlg.setExpressionContext(DSXy.this.expContext);
                List oldList = DSXy.this.dataset.getSeriesList();
                int oldsel = DSXy.this.seriesCombo.getSelectionIndex();
                JRXySeries selected = null;
                if (oldsel >= 0) {
                    selected = (JRXySeries)oldList.get(oldsel);
                }
                serie.setList(oldList);
                if (dlg.open() == 0) {
                    List<JRXySeries> newlist = serie.getList();
                    JRXySeries[] jRXySeriesArray = DSXy.this.dataset.getSeries();
                    int n = jRXySeriesArray.length;
                    int n2 = 0;
                    while (n2 < n) {
                        JRXySeries item = jRXySeriesArray[n2];
                        DSXy.this.dataset.removeXySeries(item);
                        ++n2;
                    }
                    for (JRXySeries item : serie.getList()) {
                        DSXy.this.dataset.addXySeries(item);
                    }
                    int sel = selected != null && newlist.indexOf(selected) >= 0 ? newlist.indexOf(selected) : 0;
                    DSXy.this.setSeries(sel);
                }
            }

            public void widgetDefaultSelected(SelectionEvent e) {
                this.widgetSelected(e);
            }
        });
        this.hyperlinkBtn = new Button(yCompo, 0x800008);
        this.hyperlinkBtn.setSelection(false);
        this.hyperlinkBtn.addSelectionListener(new SelectionListener(){

            public void widgetSelected(SelectionEvent e) {
                int selection = DSXy.this.seriesCombo.getSelectionIndex();
                JRDesignXySeries serie = null;
                if (selection >= 0 && selection < DSXy.this.dataset.getSeriesList().size()) {
                    serie = (JRDesignXySeries)DSXy.this.dataset.getSeriesList().get(selection);
                }
                if (serie != null) {
                    MHyperLink hyperLinkElement = null;
                    JRHyperlink hyperlink = serie.getItemHyperlink();
                    hyperLinkElement = hyperlink != null ? DSXy.this.createHyperlinkModel((JRHyperlink)hyperlink.clone()) : DSXy.this.createHyperlinkModel((JRHyperlink)new JRDesignHyperlink());
                    HyperlinkPage dlg = new HyperlinkPage(DSXy.this.hyperlinkBtn.getShell(), (APropertyNode)hyperLinkElement, DSXy.this.seriesCombo.getText(), serie.getItemHyperlink() != null);
                    int operationResult = dlg.open();
                    if (operationResult == 0) {
                        serie.setItemHyperlink((JRHyperlink)dlg.getElement().getValue());
                    } else if (operationResult == 7) {
                        serie.setItemHyperlink(null);
                    }
                }
            }

            public void widgetDefaultSelected(SelectionEvent e) {
                this.widgetSelected(e);
            }
        });
        return yCompo;
    }

    @Override
    protected Control createChartLeft(Composite parent) {
        Composite yCompo = new Composite(parent, 0);
        yCompo.setLayoutData((Object)new GridData(768));
        yCompo.setLayout((Layout)new GridLayout(3, false));
        this.yvalueWidget = new ExpressionWidget(yCompo, Messages.DSXy_valueYLabel);
        this.yvalueWidget.setToolTipText(Messages.DSCategory_valueTooltip);
        return yCompo;
    }

    @Override
    protected Control createChartBottom(Composite parent) {
        Composite yCompo = new Composite(parent, 0);
        yCompo.setLayoutData((Object)new GridData(64));
        yCompo.setLayout((Layout)new GridLayout(3, false));
        this.xvalueWidget = new ExpressionWidget(yCompo, Messages.DSXy_valueXLabel);
        this.xvalueWidget.setToolTipText(Messages.DSCategory_categoryTooltip);
        return yCompo;
    }

    @Override
    protected Control createChartRight(Composite parent) {
        Composite yCompo = new Composite(parent, 0);
        yCompo.setLayoutData((Object)new GridData(768));
        yCompo.setLayout((Layout)new GridLayout(3, false));
        this.labelWidget = new ExpressionWidget(yCompo, Messages.DSCategory_labelLabel);
        return yCompo;
    }

    @Override
    public void setExpressionContext(ExpressionContext expContext) {
        super.setExpressionContext(expContext);
        this.xvalueWidget.setExpressionContext(expContext);
        this.yvalueWidget.setExpressionContext(expContext);
        this.labelWidget.setExpressionContext(expContext);
    }
}

