/*
 * Decompiled with CFR 0.152.
 */
package com.jaspersoft.studio.components.chart.wizard.fragments.data.dialog;

import com.jaspersoft.studio.components.chart.ContextHelpIDs;
import com.jaspersoft.studio.components.chart.messages.Messages;
import com.jaspersoft.studio.components.chart.property.descriptor.ChartCustomizerDefinition;
import com.jaspersoft.studio.components.chart.property.descriptor.CustomizerPropertyExpressionsDTO;
import com.jaspersoft.studio.components.chart.wizard.fragments.data.dialog.DtoPropertyEditor;
import com.jaspersoft.studio.editor.expression.ExpressionContext;
import com.jaspersoft.studio.utils.jasper.JasperReportsConfiguration;
import com.jaspersoft.studio.widgets.framework.IPropertyEditor;
import com.jaspersoft.studio.widgets.framework.IWItemProperty;
import com.jaspersoft.studio.widgets.framework.events.ItemPropertyModifiedEvent;
import com.jaspersoft.studio.widgets.framework.events.ItemPropertyModifiedListener;
import com.jaspersoft.studio.widgets.framework.manager.WidgetFactory;
import com.jaspersoft.studio.widgets.framework.manager.panel.BasePanelManager;
import com.jaspersoft.studio.widgets.framework.manager.panel.IPanelManager;
import com.jaspersoft.studio.widgets.framework.model.WidgetPropertyDescriptor;
import com.jaspersoft.studio.widgets.framework.model.WidgetsDescriptor;
import com.jaspersoft.studio.widgets.framework.ui.ItemPropertyDescription;
import com.jaspersoft.studio.wizards.JSSHelpWizardPage;
import java.util.List;
import net.sf.jasperreports.engine.JRExpression;
import org.eclipse.jface.wizard.IWizardPage;
import org.eclipse.swt.custom.ScrolledComposite;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;

public class EditCustomizerPage
extends JSSHelpWizardPage {
    private Composite dynamicParent;
    private ScrolledComposite scrolledContainer;
    private ExpressionContext ec;
    private CustomizerPropertyExpressionsDTO dto;
    private JasperReportsConfiguration jConfig;
    private ChartCustomizerDefinition editedElement;
    private IPanelManager currentPanelManager = null;

    public EditCustomizerPage(JasperReportsConfiguration jConfig, ExpressionContext ec, CustomizerPropertyExpressionsDTO dto) {
        super("customizerEditPage");
        this.dto = dto;
        this.jConfig = jConfig;
        this.ec = ec;
        this.setMessage(this.getCustmizerMessage());
    }

    protected String getCustmizerMessage() {
        if (this.getCurrentDefinition() != null && this.getCurrentDefinition().getDescriptor() != null) {
            return this.getCurrentDefinition().getDescriptor().getDescription();
        }
        return Messages.EditCustomizerPage_pageMessage;
    }

    public void createControl(Composite parent) {
        this.scrolledContainer = new ScrolledComposite(parent, 512);
        this.scrolledContainer.setExpandHorizontal(true);
        this.scrolledContainer.setExpandVertical(true);
        this.dynamicParent = new Composite((Composite)this.scrolledContainer, 0);
        this.scrolledContainer.setContent((Control)this.dynamicParent);
        this.setControl((Control)this.scrolledContainer);
    }

    public void setVisible(boolean visible) {
        super.setVisible(visible);
        if (visible) {
            if (this.currentPanelManager != null) {
                this.currentPanelManager.disposeWidgets();
                this.currentPanelManager = null;
            }
            this.setTitle(this.getCurrentDefinition().getDescriptor().getLabel());
            ChartCustomizerDefinition selectedDefinition = this.getCurrentDefinition();
            String propertyKeyPrefix = "net.sf.jasperreports.customizer." + selectedDefinition.getKey() + '.';
            DialogDtoPropertyEditor pEditor = new DialogDtoPropertyEditor(propertyKeyPrefix, this.dto);
            WidgetsDescriptor cd = selectedDefinition.getDescriptor();
            this.currentPanelManager = cd.getPanelManager(this.dynamicParent);
            if (this.currentPanelManager == null) {
                this.currentPanelManager = new BasePanelManager(this.dynamicParent);
            }
            for (WidgetPropertyDescriptor p : cd.getPlainWidgets()) {
                ItemPropertyDescription descriptor = WidgetFactory.createItemPropertyDescriptor((WidgetsDescriptor)cd, (WidgetPropertyDescriptor)p, (JasperReportsConfiguration)this.jConfig);
                IWItemProperty widget = this.currentPanelManager.createWidget(p, descriptor, (IPropertyEditor)pEditor, this.ec);
                if (!p.getName().equals("selectionMode")) continue;
                widget.addModifyListener(new ItemPropertyModifiedListener(){

                    public void itemModified(ItemPropertyModifiedEvent event) {
                        EditCustomizerPage.this.getContainer().updateButtons();
                    }
                });
            }
            this.currentPanelManager.updateWidgets();
            int compositeHeight = this.dynamicParent.computeSize((int)500, (int)-1).y;
            this.scrolledContainer.setMinHeight(compositeHeight);
            this.dynamicParent.layout(true, true);
            this.getContainer().updateButtons();
        }
    }

    protected boolean validate() {
        List invalidProperty;
        if (this.currentPanelManager != null && (invalidProperty = this.currentPanelManager.validateWidgets(true)) != null && !invalidProperty.isEmpty()) {
            this.setErrorMessage((String)invalidProperty.get(0));
            return false;
        }
        this.setMessage(this.getCustmizerMessage());
        this.setErrorMessage(null);
        return true;
    }

    public boolean isPageComplete() {
        return this.validate();
    }

    protected String getContextName() {
        return ContextHelpIDs.WIZARD_CONFIGURE_CUSTOMIZER;
    }

    public void setEditedElement(ChartCustomizerDefinition editedElement) {
        this.editedElement = editedElement;
    }

    protected ChartCustomizerDefinition getCurrentDefinition() {
        return this.editedElement;
    }

    public IWizardPage getNextPage() {
        return null;
    }

    private class DialogDtoPropertyEditor
    extends DtoPropertyEditor {
        public DialogDtoPropertyEditor(String keyPrefix, CustomizerPropertyExpressionsDTO propertiesDTO) {
            super(keyPrefix, propertiesDTO);
        }

        @Override
        public void createUpdateProperty(String propertyName, String value, JRExpression valueExpression) {
            super.createUpdateProperty(propertyName, value, valueExpression);
            EditCustomizerPage.this.getContainer().updateButtons();
        }

        @Override
        public void removeProperty(String propertyName) {
            super.removeProperty(propertyName);
            EditCustomizerPage.this.getContainer().updateButtons();
        }
    }
}

