/*
 * Decompiled with CFR 0.152.
 */
package com.jaspersoft.studio.components.chart.wizard.fragments.data.dialog;

import com.jaspersoft.studio.components.chart.messages.Messages;
import com.jaspersoft.studio.components.chart.wizard.fragments.data.series.ISeriesFactory;
import com.jaspersoft.studio.editor.expression.ExpressionContext;
import com.jaspersoft.studio.editor.expression.ExpressionEditorSupportUtil;
import com.jaspersoft.studio.editor.expression.IExpressionContextSetter;
import com.jaspersoft.studio.property.descriptor.expression.JRExpressionCellEditor;
import com.jaspersoft.studio.property.descriptor.expression.dialog.JRExpressionEditor;
import com.jaspersoft.studio.swt.widgets.table.DeleteButton;
import com.jaspersoft.studio.swt.widgets.table.INewElement;
import com.jaspersoft.studio.swt.widgets.table.ListContentProvider;
import com.jaspersoft.studio.swt.widgets.table.ListOrderButtons;
import com.jaspersoft.studio.swt.widgets.table.NewButton;
import java.util.List;
import net.sf.jasperreports.engine.design.JRDesignExpression;
import org.eclipse.jface.viewers.CellEditor;
import org.eclipse.jface.viewers.ColumnLayoutData;
import org.eclipse.jface.viewers.ColumnWeightData;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.ICellModifier;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.ITableLabelProvider;
import org.eclipse.jface.viewers.LabelProvider;
import org.eclipse.jface.viewers.TableLayout;
import org.eclipse.jface.viewers.TableViewer;
import org.eclipse.jface.wizard.Wizard;
import org.eclipse.jface.wizard.WizardDialog;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Table;
import org.eclipse.swt.widgets.TableColumn;
import org.eclipse.swt.widgets.TableItem;
import org.eclipse.ui.forms.FormDialog;
import org.eclipse.ui.forms.IManagedForm;

public class SeriesDialog<T>
extends FormDialog
implements IExpressionContextSetter {
    private Table table;
    private TableViewer tableViewer;
    private ISeriesFactory<T> serie;
    private ExpressionContext expContext;
    private T lastCreatedSeries = null;

    public SeriesDialog(Shell parentShellProvider, ISeriesFactory<T> serie) {
        super(parentShellProvider);
        this.serie = serie;
    }

    protected void configureShell(Shell newShell) {
        super.configureShell(newShell);
        newShell.setText(Messages.SeriesDialog_0);
    }

    protected void createFormContent(IManagedForm mform) {
        mform.getForm().setText(Messages.SeriesDialog_1);
        mform.getForm().getBody().setLayout((Layout)new GridLayout(2, false));
        this.buildTable(mform.getForm().getBody());
        final Composite bGroup = new Composite(mform.getForm().getBody(), 0);
        bGroup.setLayout((Layout)new GridLayout(1, false));
        bGroup.setLayoutData((Object)new GridData(1040));
        bGroup.setBackground(mform.getForm().getBody().getBackground());
        new NewButton().createNewButtons(bGroup, this.tableViewer, new INewElement(){

            public Object newElement(List<?> input, int pos) {
                if (!ExpressionEditorSupportUtil.isExpressionEditorDialogOpen()) {
                    JRExpressionEditor wizard = new JRExpressionEditor();
                    wizard.setValue(new JRDesignExpression("\"SERIES " + (input.size() + 1) + "\""));
                    wizard.setExpressionContext(SeriesDialog.this.expContext);
                    WizardDialog dialog = ExpressionEditorSupportUtil.getExpressionEditorWizardDialog((Shell)bGroup.getShell(), (Wizard)wizard);
                    dialog.create();
                    if (dialog.open() == 0) {
                        Object prev = null;
                        if (input.size() > 0) {
                            prev = input.get(input.size() - 1);
                        }
                        SeriesDialog.this.lastCreatedSeries = SeriesDialog.this.serie.createSerie(wizard.getValue(), prev);
                        return SeriesDialog.this.lastCreatedSeries;
                    }
                }
                return null;
            }
        });
        new DeleteButton().createDeleteButton(bGroup, this.tableViewer);
        new ListOrderButtons().createOrderButtons(bGroup, this.tableViewer);
        this.fillTable(this.table);
    }

    private void buildTable(Composite composite) {
        this.table = new Table(composite, 67588);
        GridData gd = new GridData(1808);
        gd.heightHint = 350;
        gd.widthHint = 300;
        this.table.setLayoutData((Object)gd);
        this.table.setToolTipText("");
        this.table.setHeaderVisible(true);
        this.table.setLinesVisible(true);
        this.tableViewer = new TableViewer(this.table);
        this.attachContentProvider(this.tableViewer);
        this.attachLabelProvider(this.tableViewer);
        this.attachCellEditors(this.tableViewer, (Composite)this.table);
        TableLayout tlayout = new TableLayout();
        tlayout.addColumnData((ColumnLayoutData)new ColumnWeightData(100));
        this.table.setLayout((Layout)tlayout);
        TableColumn[] column = new TableColumn[]{new TableColumn(this.table, 0)};
        column[0].setText(Messages.SeriesDialog_4);
        int i = 0;
        int n = column.length;
        while (i < n) {
            column[i].pack();
            ++i;
        }
    }

    private void attachLabelProvider(TableViewer viewer) {
        viewer.setLabelProvider((IBaseLabelProvider)new TLabelProvider());
    }

    private void attachContentProvider(TableViewer viewer) {
        viewer.setContentProvider((IContentProvider)new ListContentProvider());
    }

    private void attachCellEditors(TableViewer viewer, Composite parent) {
        viewer.setCellModifier(new ICellModifier(){

            public boolean canModify(Object element, String property) {
                return property.equals("NAME");
            }

            public Object getValue(Object element, String property) {
                return SeriesDialog.this.serie.getValue(element, property);
            }

            public void modify(Object element, String property, Object value) {
                TableItem tableItem = (TableItem)element;
                SeriesDialog.this.serie.modify(tableItem.getData(), property, value);
                SeriesDialog.this.tableViewer.update(element, new String[]{property});
                SeriesDialog.this.tableViewer.refresh();
            }
        });
        JRExpressionCellEditor jrExpressionCellEditor = new JRExpressionCellEditor(parent, this.expContext);
        viewer.setCellEditors(new CellEditor[]{jrExpressionCellEditor});
        viewer.setColumnProperties(new String[]{"NAME"});
    }

    private void fillTable(Table table) {
        this.tableViewer.setInput(this.serie.getList());
    }

    public void setExpressionContext(ExpressionContext expContext) {
        this.expContext = expContext;
    }

    public T getLastCreatedSeries() {
        return this.lastCreatedSeries;
    }

    private final class TLabelProvider
    extends LabelProvider
    implements ITableLabelProvider {
        private TLabelProvider() {
        }

        public Image getColumnImage(Object element, int columnIndex) {
            return null;
        }

        public String getColumnText(Object element, int columnIndex) {
            return SeriesDialog.this.serie.getColumnText(element, columnIndex);
        }
    }
}

