/*
 * Decompiled with CFR 0.152.
 */
package com.jaspersoft.studio.components.chart.wizard.fragments.data.widget;

import com.jaspersoft.studio.components.chart.messages.Messages;
import com.jaspersoft.studio.editor.expression.ExpressionContext;
import com.jaspersoft.studio.editor.expression.ExpressionEditorSupportUtil;
import com.jaspersoft.studio.editor.expression.IExpressionContextSetter;
import com.jaspersoft.studio.model.dataset.MDatasetRun;
import com.jaspersoft.studio.model.dataset.descriptor.DatasetRunRVPropertyEditor;
import com.jaspersoft.studio.property.dataset.DatasetRunSelectionListener;
import com.jaspersoft.studio.property.dataset.DatasetRunWidget;
import com.jaspersoft.studio.property.descriptor.expression.dialog.JRExpressionEditor;
import com.jaspersoft.studio.property.descriptor.parameter.dialog.ComboParameterEditor;
import com.jaspersoft.studio.property.descriptor.parameter.dialog.GenericJSSParameter;
import com.jaspersoft.studio.utils.EnumHelper;
import com.jaspersoft.studio.utils.ModelUtils;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import net.sf.jasperreports.eclipse.ui.util.UIUtils;
import net.sf.jasperreports.engine.JRDataset;
import net.sf.jasperreports.engine.JRDatasetParameter;
import net.sf.jasperreports.engine.JRDatasetRun;
import net.sf.jasperreports.engine.JRException;
import net.sf.jasperreports.engine.JRExpression;
import net.sf.jasperreports.engine.JRGroup;
import net.sf.jasperreports.engine.design.JRDesignDataset;
import net.sf.jasperreports.engine.design.JRDesignDatasetRun;
import net.sf.jasperreports.engine.design.JRDesignElementDataset;
import net.sf.jasperreports.engine.design.JRDesignExpression;
import net.sf.jasperreports.engine.design.JasperDesign;
import net.sf.jasperreports.engine.type.DatasetResetTypeEnum;
import net.sf.jasperreports.engine.type.IncrementTypeEnum;
import net.sf.jasperreports.engine.type.NamedEnum;
import net.sf.jasperreports.engine.type.ResetTypeEnum;
import org.eclipse.jface.wizard.IWizard;
import org.eclipse.jface.wizard.Wizard;
import org.eclipse.jface.wizard.WizardDialog;
import org.eclipse.swt.custom.CTabFolder;
import org.eclipse.swt.custom.CTabItem;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Combo;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.ToolBar;
import org.eclipse.swt.widgets.ToolItem;

public class ElementDatasetWidget
implements IExpressionContextSetter {
    private static final String GROUPPREFIX = "[Group] ";
    private JRDesignElementDataset eDataset;
    private JasperDesign jrDesign;
    private Combo dsCombo;
    private Combo cbIncrement;
    private Combo cbReset;
    private Button btnIncrement;
    private ToolItem prmItem;
    private ToolItem prmMapItem;
    private ToolItem returnValue;
    private DatasetRunWidget dsRun;
    private ExpressionContext expContext;
    private List<DatasetRunSelectionListener> dsRunSelectionListeners;
    private HashMap<String, JRDesignDatasetRun> datasetRunMap = new HashMap();
    public CTabFolder ctFolder;

    public ElementDatasetWidget(Composite parent) {
        this.dsRunSelectionListeners = new ArrayList<DatasetRunSelectionListener>();
        this.createDataset(parent);
        this.bindData();
    }

    public void setDataset(JRDesignElementDataset eDataset, JasperDesign jrDesign) {
        this.eDataset = eDataset;
        this.jrDesign = jrDesign;
        this.fillData();
    }

    private void fillData() {
        String[] ds = ModelUtils.getDataSets((JasperDesign)this.jrDesign, (boolean)true);
        this.dsCombo.setItems(ds);
        this.dsCombo.select(0);
        if (this.eDataset != null && this.eDataset.getDatasetRun() != null) {
            int i = 0;
            while (i < ds.length) {
                if (ds[i].equals(this.eDataset.getDatasetRun().getDatasetName())) {
                    this.dsCombo.select(i);
                    break;
                }
                ++i;
            }
            this.dsRun.setData((JRDesignDatasetRun)this.eDataset.getDatasetRun());
            this.dsRun.setExpressionContext(this.expContext);
        }
        this.enableMainDatasetRun();
        this.fillIncrement();
        this.fillResetGroup();
        this.dsCombo.getParent().layout(true);
    }

    private void fillIncrement() {
        ArrayList<String> lsIncs = new ArrayList<String>();
        lsIncs.add(IncrementTypeEnum.REPORT.getName());
        lsIncs.add(IncrementTypeEnum.PAGE.getName());
        lsIncs.add(IncrementTypeEnum.COLUMN.getName());
        JRDataset jrds = this.getJRdataset(this.eDataset);
        JRGroup[] jRGroupArray = jrds.getGroups();
        int n = jRGroupArray.length;
        int n2 = 0;
        while (n2 < n) {
            JRGroup gr = jRGroupArray[n2];
            lsIncs.add(GROUPPREFIX + gr.getName());
            ++n2;
        }
        lsIncs.add(IncrementTypeEnum.NONE.getName());
        this.cbIncrement.setItems(lsIncs.toArray(new String[lsIncs.size()]));
        IncrementTypeEnum rst = this.eDataset.getIncrementTypeValue();
        String grname = this.eDataset.getIncrementGroup() != null ? this.eDataset.getIncrementGroup().getName() : null;
        int i = 0;
        while (i < lsIncs.size()) {
            String rsttype = (String)lsIncs.get(i);
            if (rst.equals((Object)IncrementTypeEnum.GROUP)) {
                if (rsttype.startsWith(GROUPPREFIX) && grname.equals(rsttype.substring(GROUPPREFIX.length()))) {
                    this.cbIncrement.select(i);
                    break;
                }
            } else if (rsttype.equals(rst.getName())) {
                this.cbIncrement.select(i);
                break;
            }
            ++i;
        }
    }

    private void fillResetGroup() {
        JRDataset jrds = this.getJRdataset(this.eDataset);
        ArrayList<String> lsRsts = new ArrayList<String>();
        lsRsts.add(ResetTypeEnum.REPORT.getName());
        lsRsts.add(ResetTypeEnum.COLUMN.getName());
        lsRsts.add(ResetTypeEnum.PAGE.getName());
        JRGroup[] jRGroupArray = jrds.getGroups();
        int n = jRGroupArray.length;
        int n2 = 0;
        while (n2 < n) {
            JRGroup gr = jRGroupArray[n2];
            lsRsts.add(GROUPPREFIX + gr.getName());
            ++n2;
        }
        lsRsts.add(ResetTypeEnum.NONE.getName());
        this.cbReset.setItems(lsRsts.toArray(new String[lsRsts.size()]));
        DatasetResetTypeEnum rst = this.eDataset.getDatasetResetType();
        String grname = this.eDataset.getResetGroup() != null ? this.eDataset.getResetGroup().getName() : null;
        int i = 0;
        while (i < lsRsts.size()) {
            String rsttype = (String)lsRsts.get(i);
            if (rst.equals((Object)DatasetResetTypeEnum.GROUP)) {
                if (rsttype.startsWith(GROUPPREFIX) && grname.equals(rsttype.substring(GROUPPREFIX.length()))) {
                    this.cbReset.select(i);
                    break;
                }
            } else if (rsttype.equals(rst.getName())) {
                this.cbReset.select(i);
                break;
            }
            ++i;
        }
    }

    private void bindData() {
        this.dsCombo.addSelectionListener(new SelectionListener(){

            public void widgetSelected(SelectionEvent e) {
                if (ElementDatasetWidget.this.eDataset.getIncrementTypeValue().equals((Object)IncrementTypeEnum.GROUP)) {
                    ElementDatasetWidget.this.eDataset.setIncrementType(IncrementTypeEnum.REPORT);
                    ElementDatasetWidget.this.eDataset.setIncrementGroup(null);
                    ElementDatasetWidget.this.cbIncrement.select(0);
                }
                if (ElementDatasetWidget.this.eDataset.getDatasetResetType().equals((Object)DatasetResetTypeEnum.GROUP)) {
                    ElementDatasetWidget.this.eDataset.setResetType(DatasetResetTypeEnum.REPORT);
                    ElementDatasetWidget.this.eDataset.setResetGroup(null);
                    ElementDatasetWidget.this.cbReset.select(0);
                }
                if (ElementDatasetWidget.this.dsCombo.getSelectionIndex() == 0) {
                    ElementDatasetWidget.this.eDataset.setDatasetRun(null);
                } else {
                    JRDesignDatasetRun datasetRun = ElementDatasetWidget.this.datasetRunMap.get(ElementDatasetWidget.this.dsCombo.getText());
                    if (datasetRun == null) {
                        datasetRun = new JRDesignDatasetRun();
                        datasetRun.setDatasetName(ElementDatasetWidget.this.dsCombo.getText());
                        ElementDatasetWidget.this.datasetRunMap.put(ElementDatasetWidget.this.dsCombo.getText(), datasetRun);
                    }
                    ElementDatasetWidget.this.eDataset.setDatasetRun((JRDatasetRun)datasetRun);
                }
                ElementDatasetWidget.this.dsRun.setData((JRDesignDatasetRun)ElementDatasetWidget.this.eDataset.getDatasetRun());
                ElementDatasetWidget.this.enableMainDatasetRun();
                ElementDatasetWidget.this.fillResetGroup();
                ElementDatasetWidget.this.fillIncrement();
                ElementDatasetWidget.this.notifyDatasetRunSelectionChanged();
            }

            public void widgetDefaultSelected(SelectionEvent e) {
                this.widgetSelected(e);
            }
        });
        this.bindIncrementGroup();
        this.bindResetGroup();
        this.returnValue.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                MDatasetRun datasetModel = new MDatasetRun(ElementDatasetWidget.this.eDataset.getDatasetRun(), ElementDatasetWidget.this.jrDesign);
                DatasetRunRVPropertyEditor wizard = new DatasetRunRVPropertyEditor(datasetModel);
                WizardDialog dialog = new WizardDialog(ElementDatasetWidget.this.returnValue.getParent().getShell(), (IWizard)wizard);
                dialog.create();
                UIUtils.resizeAndCenterShell((Shell)dialog.getShell(), (int)730, (int)-1);
                if (dialog.open() == 0) {
                    datasetModel.setPropertyValue((Object)"returnValues", (Object)wizard.getValue());
                }
            }
        });
        this.prmItem.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                JRDesignDatasetRun datasetRun = (JRDesignDatasetRun)ElementDatasetWidget.this.eDataset.getDatasetRun();
                ComboParameterEditor wizard = new ComboParameterEditor(new MDatasetRun(ElementDatasetWidget.this.eDataset.getDatasetRun(), ElementDatasetWidget.this.jrDesign));
                wizard.setValue(GenericJSSParameter.convertFrom((JRDatasetParameter[])datasetRun.getParameters()));
                wizard.setExpressionContext(ElementDatasetWidget.this.expContext);
                WizardDialog dialog = new WizardDialog(ElementDatasetWidget.this.btnIncrement.getShell(), (IWizard)wizard);
                dialog.create();
                if (dialog.open() == 0) {
                    JRDatasetParameter[] params = GenericJSSParameter.convertToDataset((List)wizard.getValue());
                    JRDatasetParameter[] jRDatasetParameterArray = datasetRun.getParameters();
                    int n = jRDatasetParameterArray.length;
                    int n2 = 0;
                    while (n2 < n) {
                        JRDatasetParameter prm = jRDatasetParameterArray[n2];
                        datasetRun.removeParameter(prm);
                        ++n2;
                    }
                    jRDatasetParameterArray = params;
                    n = params.length;
                    n2 = 0;
                    while (n2 < n) {
                        JRDatasetParameter param = jRDatasetParameterArray[n2];
                        try {
                            datasetRun.addParameter(param);
                        }
                        catch (JRException er) {
                            er.printStackTrace();
                        }
                        ++n2;
                    }
                }
            }
        });
        this.prmMapItem.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                if (!ExpressionEditorSupportUtil.isExpressionEditorDialogOpen()) {
                    JRExpressionEditor wizard = new JRExpressionEditor();
                    wizard.setValue((JRDesignExpression)ElementDatasetWidget.this.eDataset.getDatasetRun().getParametersMapExpression());
                    wizard.setExpressionContext(ElementDatasetWidget.this.expContext);
                    WizardDialog dialog = ExpressionEditorSupportUtil.getExpressionEditorWizardDialog((Shell)ElementDatasetWidget.this.btnIncrement.getShell(), (Wizard)wizard);
                    if (dialog.open() == 0) {
                        ((JRDesignDatasetRun)ElementDatasetWidget.this.eDataset.getDatasetRun()).setParametersMapExpression((JRExpression)wizard.getValue());
                    }
                }
            }
        });
    }

    private void enableMainDatasetRun() {
        boolean en = this.dsCombo.getSelectionIndex() != 0;
        this.prmItem.setEnabled(en);
        this.prmMapItem.setEnabled(en);
        this.returnValue.setEnabled(en);
        this.dsRun.setEnabled(en);
    }

    private void bindResetGroup() {
        this.cbReset.addSelectionListener(new SelectionListener(){

            public void widgetSelected(SelectionEvent e) {
                String newval = ElementDatasetWidget.this.cbReset.getText();
                DatasetResetTypeEnum val = (DatasetResetTypeEnum)EnumHelper.getEnumByObjectValue((NamedEnum[])DatasetResetTypeEnum.values(), (Object)newval);
                if (val != null) {
                    ElementDatasetWidget.this.eDataset.setResetType(val);
                } else {
                    ElementDatasetWidget.this.eDataset.setResetType(DatasetResetTypeEnum.GROUP);
                    JRDataset jrds = ElementDatasetWidget.this.getJRdataset(ElementDatasetWidget.this.eDataset);
                    JRGroup[] jRGroupArray = jrds.getGroups();
                    int n = jRGroupArray.length;
                    int n2 = 0;
                    while (n2 < n) {
                        JRGroup gr = jRGroupArray[n2];
                        if (gr.getName().equals(newval.substring(ElementDatasetWidget.GROUPPREFIX.length()))) {
                            ElementDatasetWidget.this.eDataset.setResetGroup(gr);
                            break;
                        }
                        ++n2;
                    }
                }
            }

            public void widgetDefaultSelected(SelectionEvent e) {
                this.widgetSelected(e);
            }
        });
    }

    private void bindIncrementGroup() {
        this.cbIncrement.addSelectionListener(new SelectionListener(){

            public void widgetSelected(SelectionEvent e) {
                String newval = ElementDatasetWidget.this.cbIncrement.getText();
                IncrementTypeEnum val = (IncrementTypeEnum)EnumHelper.getEnumByObjectValue((NamedEnum[])IncrementTypeEnum.values(), (Object)newval);
                if (val != null) {
                    ElementDatasetWidget.this.eDataset.setIncrementType(val);
                } else {
                    ElementDatasetWidget.this.eDataset.setIncrementType(IncrementTypeEnum.GROUP);
                    JRDataset jrds = ElementDatasetWidget.this.getJRdataset(ElementDatasetWidget.this.eDataset);
                    JRGroup[] jRGroupArray = jrds.getGroups();
                    int n = jRGroupArray.length;
                    int n2 = 0;
                    while (n2 < n) {
                        JRGroup gr = jRGroupArray[n2];
                        if (gr.getName().equals(newval.substring(ElementDatasetWidget.GROUPPREFIX.length()))) {
                            ElementDatasetWidget.this.eDataset.setIncrementGroup(gr);
                            break;
                        }
                        ++n2;
                    }
                }
            }

            public void widgetDefaultSelected(SelectionEvent e) {
                this.widgetSelected(e);
            }
        });
        this.btnIncrement.addSelectionListener(new SelectionListener(){

            public void widgetSelected(SelectionEvent e) {
                if (!ExpressionEditorSupportUtil.isExpressionEditorDialogOpen()) {
                    JRExpressionEditor wizard = new JRExpressionEditor();
                    wizard.setValue((JRDesignExpression)ElementDatasetWidget.this.eDataset.getIncrementWhenExpression());
                    JRDatasetRun datasetRun = ElementDatasetWidget.this.eDataset.getDatasetRun();
                    JRDesignDataset dds = ElementDatasetWidget.this.jrDesign.getMainDesignDataset();
                    if (datasetRun != null && datasetRun.getDatasetName() != null) {
                        dds = ModelUtils.getDesignDatasetByName((JasperDesign)ElementDatasetWidget.this.jrDesign, (String)datasetRun.getDatasetName());
                    }
                    ExpressionContext ec = new ExpressionContext(dds, ElementDatasetWidget.this.expContext.getJasperReportsConfiguration());
                    wizard.setExpressionContext(ec);
                    WizardDialog dialog = ExpressionEditorSupportUtil.getExpressionEditorWizardDialog((Shell)ElementDatasetWidget.this.btnIncrement.getShell(), (Wizard)wizard);
                    if (dialog.open() == 0) {
                        ElementDatasetWidget.this.eDataset.setIncrementWhenExpression((JRExpression)wizard.getValue());
                    }
                }
            }

            public void widgetDefaultSelected(SelectionEvent e) {
                this.widgetSelected(e);
            }
        });
    }

    private JRDataset getJRdataset(JRDesignElementDataset jrDataset) {
        if (jrDataset != null && jrDataset.getDatasetRun() != null) {
            String dsname = jrDataset.getDatasetRun().getDatasetName();
            if (this.jrDesign.getDatasetMap().containsKey(dsname)) {
                return (JRDataset)this.jrDesign.getDatasetMap().get(dsname);
            }
        }
        return this.jrDesign.getMainDataset();
    }

    public void createDataset(Composite composite) {
        Composite grDataset = new Composite(composite, 0);
        grDataset.setLayoutData((Object)new GridData(768));
        grDataset.setLayout((Layout)new GridLayout(1, false));
        this.ctFolder = new CTabFolder(grDataset, 128);
        this.ctFolder.setLayoutData((Object)new GridData(1808));
        this.createParametersMap(this.ctFolder);
        this.createConnection(this.ctFolder);
        GridData folderData = new GridData(4, 128, true, false);
        folderData.heightHint = 90;
        folderData.minimumHeight = 90;
        this.ctFolder.setLayoutData((Object)folderData);
        this.ctFolder.setSelection(0);
    }

    private void createConnection(CTabFolder tabFolder) {
        CTabItem bptab = new CTabItem(tabFolder, 0);
        bptab.setText(Messages.ElementDatasetWidget_tabTitle);
        Composite composite = new Composite((Composite)tabFolder, 0);
        composite.setLayout((Layout)new GridLayout(2, true));
        Composite leftComposite = new Composite(composite, 0);
        leftComposite.setLayout((Layout)new GridLayout(3, false));
        leftComposite.setLayoutData((Object)new GridData(1810));
        new Label(leftComposite, 0).setText(Messages.ElementDatasetWidget_incrementOnLabel);
        this.cbIncrement = new Combo(leftComposite, 2060);
        this.cbIncrement.setLayoutData((Object)new GridData(768));
        this.cbIncrement.setToolTipText("Define the moment during the execution of the report when the chart will read the current and use its values to populate itslef. None means each record, report only at the end, page and column each page or column or group when the group changes");
        this.btnIncrement = new Button(leftComposite, 8);
        this.btnIncrement.setText("...");
        this.btnIncrement.setToolTipText(Messages.ElementDatasetWidget_buttonTooltip);
        new Label(leftComposite, 0).setText(Messages.ElementDatasetWidget_resetOnLabel);
        this.cbReset = new Combo(leftComposite, 2060);
        this.cbReset.setLayoutData((Object)new GridData(768));
        this.cbReset.setToolTipText("Define the moment during the execution when the chart delete the acquired data from the previous record and start from the current record. This can be used when the chart is printed on more paged and it need to show only a subset of the dataset record in the moment it is printed");
        new Label(leftComposite, 0);
        this.dsRun = new DatasetRunWidget(composite);
        this.dsRun.getControl().setLayoutData((Object)new GridData(1808));
        bptab.setControl((Control)composite);
    }

    private void createParametersMap(CTabFolder ctfolder) {
        Composite composite = new Composite((Composite)ctfolder, 0);
        GridLayout layout = new GridLayout(10, false);
        layout.verticalSpacing = 1;
        layout.marginWidth = 1;
        layout.marginTop = 1;
        layout.marginBottom = 1;
        composite.setLayout((Layout)layout);
        Label lbl = new Label(composite, 0);
        lbl.setText(Messages.ElementDatasetWidget_datasetLabel);
        this.dsCombo = new Combo(composite, 2060);
        this.dsCombo.setItems(new String[]{"main dataset"});
        ToolBar toolBar = new ToolBar(composite, 8520000);
        this.returnValue = new ToolItem(toolBar, 8);
        this.returnValue.setText(com.jaspersoft.studio.messages.Messages.common_return_values);
        this.prmItem = new ToolItem(toolBar, 8);
        this.prmItem.setText(Messages.ElementDatasetWidget_parametersLabel);
        this.prmMapItem = new ToolItem(toolBar, 8);
        this.prmMapItem.setText(Messages.ElementDatasetWidget_parametersMapLabel);
        int tabHeight = composite.computeSize((int)-1, (int)-1).y;
        tabHeight = Math.max(tabHeight, ctfolder.getTabHeight());
        ctfolder.setTabHeight(tabHeight);
        ctfolder.setTopRight((Control)composite);
    }

    public void setExpressionContext(ExpressionContext expContext) {
        this.expContext = expContext;
    }

    public void addDatasetRunSelectionListener(DatasetRunSelectionListener listener) {
        this.dsRunSelectionListeners.add(listener);
    }

    public void removeDatasetRunSelectionListener(DatasetRunSelectionListener listener) {
        this.dsRunSelectionListeners.remove(listener);
    }

    private void notifyDatasetRunSelectionChanged() {
        for (DatasetRunSelectionListener l : this.dsRunSelectionListeners) {
            l.selectionChanged();
        }
    }
}

