/*
 * Decompiled with CFR 0.152.
 */
package com.jaspersoft.studio.components.commonstyles;

import com.jaspersoft.studio.components.Activator;
import com.jaspersoft.studio.components.commonstyles.ExportDialog;
import com.jaspersoft.studio.components.commonstyles.ImportDialog;
import com.jaspersoft.studio.components.commonstyles.ViewProviderInterface;
import com.jaspersoft.studio.components.commonstyles.messages.Messages;
import com.jaspersoft.studio.editor.style.TemplateStyle;
import com.jaspersoft.studio.style.view.TemplateStyleView;
import com.jaspersoft.studio.style.view.TemplateViewProvider;
import com.jaspersoft.studio.utils.IOUtils;
import com.jaspersoft.studio.wizards.JSSWizard;
import java.awt.Rectangle;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.wizard.IWizard;
import org.eclipse.jface.wizard.WizardDialog;
import org.eclipse.nebula.widgets.gallery.AbstractGalleryGroupRenderer;
import org.eclipse.nebula.widgets.gallery.AbstractGalleryItemRenderer;
import org.eclipse.nebula.widgets.gallery.Gallery;
import org.eclipse.nebula.widgets.gallery.GalleryItem;
import org.eclipse.nebula.widgets.gallery.NoGroupRenderer;
import org.eclipse.nebula.widgets.gallery.RoundedGalleryItemRenderer;
import org.eclipse.swt.dnd.DragSourceEvent;
import org.eclipse.swt.dnd.DragSourceListener;
import org.eclipse.swt.events.MouseEvent;
import org.eclipse.swt.events.MouseListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.GC;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Menu;
import org.eclipse.swt.widgets.MenuItem;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.ToolBar;
import org.eclipse.swt.widgets.ToolItem;
import org.eclipse.ui.PlatformUI;
import org.eclipse.wb.swt.ResourceManager;

public abstract class CommonViewProvider
implements TemplateViewProvider,
ViewProviderInterface {
    protected Gallery checkedGallery = null;
    protected MenuItem deleteAction = null;
    protected MenuItem editAction = null;
    protected MenuItem createAction = null;
    private ToolItem createStyle = null;
    private ToolItem editStyle = null;
    private ToolItem deleteStyle = null;

    protected void initializeDeleteAction() {
        this.deleteAction = new MenuItem(this.checkedGallery.getMenu(), 0);
        this.deleteAction.setText(Messages.CommonViewProvider_deleteStyleLabel);
        this.deleteAction.setImage(this.getDeleteStyleImage());
        this.deleteAction.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                CommonViewProvider.this.doDelete();
                CommonViewProvider.this.updateToolBartSelection();
            }
        });
    }

    protected void doDelete() {
        Shell actualShell = PlatformUI.getWorkbench().getDisplay().getActiveShell();
        if (MessageDialog.openQuestion((Shell)actualShell, (String)Messages.CommonViewProvider_deleteStyleQuestionTitle, (String)Messages.CommonViewProvider_deleteStyleQuestionText)) {
            GalleryItem selectedItem = this.checkedGallery.getSelection()[0];
            TemplateStyleView.getTemplateStylesStorage().removeStyle((TemplateStyle)selectedItem.getData());
        }
    }

    protected void initializeCreateAction() {
        this.createAction = new MenuItem(this.checkedGallery.getMenu(), 0);
        this.createAction.setText(Messages.CommonViewProvider_createStyleLabel);
        this.createAction.setImage(this.getNewStyleImage());
        this.createAction.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                CommonViewProvider.this.doCreate();
                CommonViewProvider.this.updateToolBartSelection();
            }
        });
    }

    protected void doCreate() {
    }

    protected void initializeEditAction() {
        this.editAction = new MenuItem(this.checkedGallery.getMenu(), 0);
        this.editAction.setText(Messages.CommonViewProvider_editStyleLabel);
        this.editAction.setImage(this.getEditStyleImage());
        this.editAction.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                CommonViewProvider.this.doEdit();
                CommonViewProvider.this.updateToolBartSelection();
            }
        });
    }

    protected void doEdit() {
    }

    public Image getNewStyleImage() {
        Image image = ResourceManager.getImage((String)"create-style");
        if (image == null) {
            image = Activator.getDefault().getImageDescriptor("icons/create-style.png").createImage();
            ResourceManager.addImage((String)"create-style", (Image)image);
        }
        return image;
    }

    public Image getDeleteStyleImage() {
        Image image = ResourceManager.getImage((String)"delete-style");
        if (image == null) {
            image = Activator.getDefault().getImageDescriptor("icons/delete_style.gif").createImage();
            ResourceManager.addImage((String)"delete-style", (Image)image);
        }
        return image;
    }

    public Image getExportStylesImage() {
        Image image = ResourceManager.getImage((String)"export-styles");
        if (image == null) {
            image = Activator.getDefault().getImageDescriptor("icons/table-export.png").createImage();
            ResourceManager.addImage((String)"export-styles", (Image)image);
        }
        return image;
    }

    public Image getImportStylesImage() {
        Image image = ResourceManager.getImage((String)"import-styles");
        if (image == null) {
            image = Activator.getDefault().getImageDescriptor("icons/table-import.png").createImage();
            ResourceManager.addImage((String)"import-styles", (Image)image);
        }
        return image;
    }

    public Image getEditStyleImage() {
        Image image = ResourceManager.getImage((String)"edit-style");
        if (image == null) {
            image = Activator.getDefault().getImageDescriptor("icons/edit-style.png").createImage();
            ResourceManager.addImage((String)"edit-style", (Image)image);
        }
        return image;
    }

    protected WizardDialog getEditorDialog(JSSWizard wizardPage) {
        WizardDialog dialog = new WizardDialog(Display.getDefault().getActiveShell(), (IWizard)wizardPage){

            protected Button createButton(Composite parent, int id, String label, boolean defaultButton) {
                Button button = super.createButton(parent, id, label, defaultButton);
                if (id == 16) {
                    button.setText(Messages.CommonViewProvider_finishLabel);
                }
                return button;
            }
        };
        return dialog;
    }

    protected GalleryItem getItem(TemplateStyle style, GalleryItem rootItem) {
        GalleryItem ti = new GalleryItem(rootItem, 0);
        String description = style.getDescription();
        ti.setText(description.isEmpty() ? " " : description);
        Image previewImage = this.generatePreviewFigure(style);
        ti.setImage(previewImage);
        ti.setSelectedImage(previewImage);
        ti.setStandardImage(previewImage);
        ti.setData((Object)style);
        return ti;
    }

    protected void updateItem(TemplateStyle style, GalleryItem itemToUpdate) {
        String description = style.getDescription();
        itemToUpdate.setText(description.isEmpty() ? " " : description);
        Image previewImage = this.generatePreviewFigure(style);
        itemToUpdate.setImage(previewImage);
        itemToUpdate.setSelectedImage(previewImage);
        itemToUpdate.setStandardImage(previewImage);
        itemToUpdate.setData((Object)style);
    }

    public static void fillRoundRectangleDropShadow(GC gc, Rectangle bounds, int xOffset, int yOffset, int radius) {
        gc.setAdvanced(true);
        gc.setAntialias(1);
        Color oldColor = gc.getBackground();
        int oldAlpha = gc.getAlpha();
        gc.setBackground(Display.getCurrent().getSystemColor(2));
        gc.setAlpha(143 / radius);
        int i = 0;
        while (i < radius) {
            Rectangle shadowBounds = new Rectangle(bounds.x + xOffset, bounds.y + yOffset, bounds.width - i, bounds.height - i);
            gc.fillRoundRectangle(shadowBounds.x, shadowBounds.y, shadowBounds.width, shadowBounds.height, radius, radius);
            ++i;
        }
        gc.setBackground(oldColor);
        gc.setAlpha(oldAlpha);
    }

    private void updateToolBartSelection() {
        boolean selectionState;
        boolean bl = selectionState = this.checkedGallery.getSelectionCount() > 0;
        if (this.editStyle != null) {
            this.editStyle.setEnabled(selectionState);
        }
        if (this.deleteStyle != null) {
            this.deleteStyle.setEnabled(selectionState);
        }
    }

    protected void createToolBar(Composite parent) {
        this.checkedGallery.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                CommonViewProvider.this.updateToolBartSelection();
            }
        });
        ToolBar toolBar = new ToolBar(parent, 0x800000);
        this.createStyle = new ToolItem(toolBar, 8);
        this.createStyle.setImage(this.getNewStyleImage());
        this.createStyle.setToolTipText(Messages.CommonViewProvider_createStyleToolButton);
        this.createStyle.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                CommonViewProvider.this.doCreate();
                CommonViewProvider.this.updateToolBartSelection();
            }
        });
        this.editStyle = new ToolItem(toolBar, 8);
        this.editStyle.setImage(this.getEditStyleImage());
        this.editStyle.setToolTipText(Messages.CommonViewProvider_editStyleToolButton);
        this.editStyle.setEnabled(false);
        this.editStyle.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                CommonViewProvider.this.doEdit();
                CommonViewProvider.this.updateToolBartSelection();
            }
        });
        this.deleteStyle = new ToolItem(toolBar, 8);
        this.deleteStyle.setImage(this.getDeleteStyleImage());
        this.deleteStyle.setToolTipText(Messages.CommonViewProvider_deleteStyleToolButton);
        this.deleteStyle.setEnabled(false);
        this.deleteStyle.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                CommonViewProvider.this.doDelete();
                CommonViewProvider.this.updateToolBartSelection();
            }
        });
        ToolItem exportItem = new ToolItem(toolBar, 8);
        exportItem.setImage(this.getExportStylesImage());
        exportItem.setToolTipText(Messages.CommonViewProvider_exportStylesToolTip);
        final CommonViewProvider exportProvider = this;
        exportItem.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                ExportDialog dlg = new ExportDialog(PlatformUI.getWorkbench().getDisplay().getActiveShell(), exportProvider);
                dlg.open();
            }
        });
        ToolItem importItem = new ToolItem(toolBar, 8);
        importItem.setImage(this.getImportStylesImage());
        importItem.setToolTipText("Import the styles from an XML file");
        final CommonViewProvider importProvider = this;
        importItem.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                ImportDialog dlg = new ImportDialog(PlatformUI.getWorkbench().getDisplay().getActiveShell(), importProvider);
                dlg.open();
            }
        });
        GridData toolButtonData = new GridData();
        toolButtonData.horizontalAlignment = 0x1000008;
        toolBar.setLayoutData((Object)toolButtonData);
    }

    protected void createControls(Composite parent, int imageWidth, int imageHeight, String labelText) {
        Composite firstLine = new Composite(parent, 0);
        GridLayout firstLineLayout = new GridLayout(2, false);
        firstLineLayout.verticalSpacing = 0;
        firstLineLayout.marginHeight = 0;
        firstLine.setLayout((Layout)firstLineLayout);
        GridData firstLineData = new GridData();
        firstLineData.grabExcessHorizontalSpace = true;
        firstLineData.horizontalAlignment = 4;
        firstLine.setLayoutData((Object)firstLineData);
        Label dragLabel = new Label(firstLine, 0);
        dragLabel.setText(labelText);
        GridData labelData = new GridData();
        labelData.grabExcessHorizontalSpace = true;
        labelData.horizontalAlignment = 4;
        dragLabel.setLayoutData((Object)labelData);
        this.checkedGallery = new Gallery(parent, 0x10000A00);
        NoGroupRenderer gr = new NoGroupRenderer();
        gr.setMinMargin(2);
        gr.setItemSize(imageWidth, imageHeight);
        gr.setAutoMargin(true);
        GridData gd = new GridData(1808);
        this.checkedGallery.setLayoutData((Object)gd);
        this.checkedGallery.setGroupRenderer((AbstractGalleryGroupRenderer)gr);
        this.checkedGallery.enableItemsTooltip(false);
        RoundedGalleryItemRenderer ir = new RoundedGalleryItemRenderer();
        ir.setShowLabels(true);
        this.checkedGallery.setItemRenderer((AbstractGalleryItemRenderer)ir);
        GridData galleryData = new GridData();
        galleryData.grabExcessHorizontalSpace = true;
        galleryData.grabExcessVerticalSpace = true;
        galleryData.horizontalAlignment = 4;
        galleryData.verticalAlignment = 4;
        this.checkedGallery.setLayoutData((Object)galleryData);
        Menu popupMenu = new Menu((Control)this.checkedGallery);
        this.checkedGallery.setMenu(popupMenu);
        this.checkedGallery.addMouseListener((MouseListener)new GalleryRightClick());
        this.initializeCreateAction();
        this.initializeEditAction();
        this.initializeDeleteAction();
        this.createToolBar(firstLine);
    }

    protected class GalleryRightClick
    implements MouseListener {
        public void mouseUp(MouseEvent e) {
        }

        public void mouseDown(MouseEvent e) {
            boolean allDeselected;
            boolean bl = allDeselected = e.button == 3 && CommonViewProvider.this.checkedGallery.getItem(new Point(e.x, e.y)) == null;
            if (allDeselected) {
                CommonViewProvider.this.checkedGallery.deselectAll();
            }
            if (CommonViewProvider.this.deleteAction != null) {
                CommonViewProvider.this.deleteAction.setEnabled(!allDeselected);
            }
            if (CommonViewProvider.this.editAction != null) {
                CommonViewProvider.this.editAction.setEnabled(!allDeselected);
            }
            CommonViewProvider.this.updateToolBartSelection();
        }

        public void mouseDoubleClick(MouseEvent e) {
            boolean isEdit;
            boolean bl = isEdit = e.button == 1 && CommonViewProvider.this.checkedGallery.getSelectionCount() > 0;
            if (isEdit) {
                CommonViewProvider.this.doEdit();
            }
        }
    }

    protected class StyleDragListener
    implements DragSourceListener {
        public void dragStart(DragSourceEvent event) {
            this.dragSetData(event);
        }

        public void dragSetData(DragSourceEvent event) {
            if (CommonViewProvider.this.checkedGallery.getSelection().length > 0) {
                Object data = CommonViewProvider.this.checkedGallery.getSelection()[0].getData();
                byte[] serializedData = IOUtils.writeToByteArray((Object)data);
                event.data = serializedData;
            }
        }

        public void dragFinished(DragSourceEvent event) {
        }
    }
}

