/*
 * Decompiled with CFR 0.152.
 */
package com.jaspersoft.studio.components.commonstyles;

import com.jaspersoft.studio.components.commonstyles.ViewProviderInterface;
import com.jaspersoft.studio.components.commonstyles.messages.Messages;
import com.jaspersoft.studio.editor.style.TemplateStyle;
import com.jaspersoft.studio.style.view.TemplateStyleView;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileReader;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import org.eclipse.draw2d.ColorConstants;
import org.eclipse.swt.SWT;
import org.eclipse.swt.custom.ScrolledComposite;
import org.eclipse.swt.events.ControlAdapter;
import org.eclipse.swt.events.ControlEvent;
import org.eclipse.swt.events.ControlListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Rectangle;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.FileDialog;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Listener;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Text;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.forms.FormDialog;
import org.eclipse.ui.forms.IManagedForm;

public class ImportDialog
extends FormDialog {
    private Composite body;
    private Text pathText;
    private List<Button> buttons;
    private ViewProviderInterface styleProvider;

    public ImportDialog(Shell shell, ViewProviderInterface styleProvider) {
        super(shell);
        this.styleProvider = styleProvider;
        this.buttons = new ArrayList<Button>();
    }

    protected void configureShell(Shell newShell) {
        super.configureShell(newShell);
        newShell.setText(Messages.ImportDialog_dialogName);
        this.setShellStyle(this.getShellStyle() | 0x80 | 0x400 | 0x10);
    }

    private String selectPathDialog(Shell shell) {
        FileDialog dialog = new FileDialog(shell, 4096);
        String[] filterNames = new String[]{"XML files"};
        String[] filterExtensions = new String[]{"*.xml;"};
        String filterPath = "/";
        String platform = SWT.getPlatform();
        if (platform.equals("win32") || platform.equals("wpf")) {
            filterNames = new String[]{"XML files"};
            filterExtensions = new String[]{"*.xml;"};
            filterPath = "c:\\";
        }
        dialog.setFilterNames(filterNames);
        dialog.setFilterExtensions(filterExtensions);
        dialog.setFilterPath(filterPath);
        dialog.setFileName("");
        return dialog.open();
    }

    private String readFile(String path) {
        try {
            String line;
            BufferedReader br = new BufferedReader(new FileReader(new File(path)));
            StringBuilder sb = new StringBuilder();
            while ((line = br.readLine()) != null) {
                sb.append(line.trim());
            }
            br.close();
            return sb.toString();
        }
        catch (IOException e) {
            e.printStackTrace();
            return null;
        }
    }

    protected void okPressed() {
        for (Button button : this.buttons) {
            if (!button.getSelection()) continue;
            TemplateStyle style = (TemplateStyle)button.getData();
            TemplateStyleView.getTemplateStylesStorage().addStyle(style);
        }
        super.okPressed();
    }

    protected void setHelpControl(Control newControl) {
        newControl.addListener(28, new Listener(){

            public void handleEvent(Event event) {
                ImportDialog.this.performHelp();
            }
        });
    }

    public void performHelp() {
        String id = "com.jaspersoft.studio.doc.ImportStyleDialog";
        PlatformUI.getWorkbench().getHelpSystem().setHelp((Control)this.body, id);
        PlatformUI.getWorkbench().getHelpSystem().displayHelp(id);
    }

    protected void createFormContent(IManagedForm mform) {
        this.body = mform.getForm().getBody();
        this.body.setLayout((Layout)new GridLayout(1, true));
        this.body.setBackground(this.body.getDisplay().getSystemColor(22));
        this.setHelpControl((Control)this.body);
        Composite pathComposite = new Composite(this.body, 0);
        pathComposite.setLayout((Layout)new GridLayout(3, false));
        GridData pathData = new GridData();
        pathData.grabExcessHorizontalSpace = true;
        pathData.horizontalAlignment = 4;
        pathComposite.setLayoutData((Object)pathData);
        Label pathLabel = new Label(pathComposite, 0);
        pathLabel.setText(Messages.ImportDialog_pathLabel);
        this.pathText = new Text(pathComposite, 2048);
        this.pathText.setEditable(false);
        GridData textData = new GridData();
        textData.grabExcessHorizontalSpace = true;
        textData.horizontalAlignment = 4;
        this.pathText.setLayoutData((Object)textData);
        Button browseButton = new Button(pathComposite, 0);
        browseButton.setText(Messages.ImportExportDialog_browseButtonText);
        Label bodyLabel = new Label(this.body, 0);
        bodyLabel.setText(Messages.ImportDialog_dialogLabel);
        Composite mainComposite = new Composite(this.body, 0);
        mainComposite.setLayout((Layout)new GridLayout(2, false));
        mainComposite.setLayoutData((Object)new GridData(4, 4, true, true));
        final ScrolledComposite scrollComposite = new ScrolledComposite(mainComposite, 2560);
        GridData scrolledData = new GridData(4, 4, true, true);
        scrolledData.heightHint = 400;
        scrolledData.widthHint = 600;
        scrollComposite.setLayout((Layout)new GridLayout(1, false));
        scrollComposite.setLayoutData((Object)scrolledData);
        final Composite dataComposite = new Composite((Composite)scrollComposite, 0);
        dataComposite.setBackground(ColorConstants.white);
        dataComposite.setLayout((Layout)new GridLayout(3, false));
        GridData tableData = new GridData(4, 4, true, true);
        dataComposite.setLayoutData((Object)tableData);
        scrollComposite.setContent((Control)dataComposite);
        scrollComposite.setExpandVertical(true);
        scrollComposite.setExpandHorizontal(true);
        scrollComposite.addControlListener((ControlListener)new ControlAdapter(){

            public void controlResized(ControlEvent e) {
                Rectangle r = scrollComposite.getClientArea();
                scrollComposite.setMinSize(dataComposite.computeSize(r.width, -1));
            }
        });
        Composite buttonComposite = new Composite(mainComposite, 0);
        buttonComposite.setLayout((Layout)new GridLayout(1, false));
        buttonComposite.setLayoutData((Object)new GridData(16384, 4, false, true));
        Button selectAll = new Button(buttonComposite, 0);
        selectAll.setText(Messages.ImportDialog_selectAllButton);
        selectAll.addSelectionListener((SelectionListener)new SelectItemsAdapter(true));
        selectAll.setLayoutData((Object)new GridData(4, 128, true, false));
        Button deselectAll = new Button(buttonComposite, 0);
        deselectAll.setText(Messages.ImportDialog_deselectAllButton);
        deselectAll.addSelectionListener((SelectionListener)new SelectItemsAdapter(false));
        deselectAll.setLayoutData((Object)new GridData(4, 128, true, false));
        browseButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                String path = ImportDialog.this.selectPathDialog(ImportDialog.this.getShell());
                if (path != null) {
                    ImportDialog.this.pathText.setText(path);
                    String xml = ImportDialog.this.readFile(path);
                    List<TemplateStyle> styles = ImportDialog.this.styleProvider.getStylesList(TemplateStyleView.getTemplateStylesStorage().readTemplateFromFile(xml));
                    Control[] children = dataComposite.getChildren();
                    int i = 0;
                    while (i < children.length) {
                        children[i].dispose();
                        ++i;
                    }
                    ImportDialog.this.buttons = new ArrayList<Button>();
                    for (TemplateStyle style : styles) {
                        Button checkBox = new Button(dataComposite, 32);
                        checkBox.setData((Object)style);
                        ImportDialog.this.buttons.add(checkBox);
                        GridData checkBoxData = new GridData();
                        checkBoxData.minimumWidth = 25;
                        checkBoxData.minimumWidth = 25;
                        checkBoxData.horizontalAlignment = 0x1000000;
                        checkBoxData.verticalAlignment = 0x1000000;
                        checkBox.setLayoutData((Object)checkBoxData);
                        Label imageLabel = new Label(dataComposite, 0);
                        imageLabel.setBackground(dataComposite.getBackground());
                        imageLabel.setImage(ImportDialog.this.styleProvider.generatePreviewFigure(style));
                        GridData imageData = new GridData();
                        imageData.minimumWidth = 100;
                        imageData.minimumWidth = 100;
                        imageData.horizontalAlignment = 0x1000000;
                        imageData.verticalAlignment = 0x1000000;
                        imageLabel.setLayoutData((Object)imageData);
                        Label descriptionLabel = new Label(dataComposite, 0);
                        descriptionLabel.setText(style.getDescription());
                        descriptionLabel.setBackground(dataComposite.getBackground());
                        descriptionLabel.setLayoutData((Object)new GridData(4, 0x1000000, true, false));
                    }
                    dataComposite.layout();
                    Rectangle r = scrollComposite.getClientArea();
                    scrollComposite.setMinSize(dataComposite.computeSize(r.width, -1));
                }
            }
        });
    }

    private class SelectItemsAdapter
    extends SelectionAdapter {
        private boolean selectionValue;

        public SelectItemsAdapter(boolean selectAll) {
            this.selectionValue = selectAll;
        }

        public void widgetSelected(SelectionEvent e) {
            for (Button check : ImportDialog.this.buttons) {
                check.setSelection(this.selectionValue);
            }
        }
    }
}

