/*
 * Decompiled with CFR 0.152.
 */
package com.jaspersoft.studio.components.crosstab.figure;

import com.jaspersoft.studio.components.Activator;
import com.jaspersoft.studio.components.commonstyles.CommonViewProvider;
import com.jaspersoft.studio.components.crosstab.figure.CrosstabStyleTransferDropListener;
import com.jaspersoft.studio.components.crosstab.figure.CrosstrabRestrictedTransferType;
import com.jaspersoft.studio.components.crosstab.messages.Messages;
import com.jaspersoft.studio.components.crosstab.model.crosstab.command.wizard.CrosstabStyleWizard;
import com.jaspersoft.studio.components.crosstab.model.dialog.CrosstabStyle;
import com.jaspersoft.studio.editor.style.TemplateStyle;
import com.jaspersoft.studio.style.view.TemplateStyleView;
import com.jaspersoft.studio.utils.AlfaRGB;
import java.awt.Rectangle;
import java.beans.PropertyChangeEvent;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import org.eclipse.draw2d.ColorConstants;
import org.eclipse.gef.EditPartViewer;
import org.eclipse.gef.dnd.AbstractTransferDropTargetListener;
import org.eclipse.jface.wizard.WizardDialog;
import org.eclipse.nebula.widgets.gallery.GalleryItem;
import org.eclipse.swt.dnd.DragSource;
import org.eclipse.swt.dnd.DragSourceListener;
import org.eclipse.swt.dnd.Transfer;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.Device;
import org.eclipse.swt.graphics.Drawable;
import org.eclipse.swt.graphics.GC;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.graphics.RGB;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.ui.PlatformUI;
import org.eclipse.wb.swt.ResourceManager;

public class CrosstabStyleView
extends CommonViewProvider {
    private static final int GALLERY_HEIGHT = 80;
    private static final int GALLERY_WIDTH = 100;
    private GalleryItem tableGroup;

    public void createControls(Composite parent) {
        super.createControls(parent, 100, 80, Messages.CrosstabStyleView_0);
        this.addDragSupport();
    }

    @Override
    protected void doCreate() {
        CrosstabStyleWizard wizard = new CrosstabStyleWizard(true, null);
        WizardDialog dialog = this.getEditorDialog(wizard);
        if (dialog.open() == 0) {
            CrosstabStyle newStyle = wizard.getTableStyle();
            TemplateStyleView.getTemplateStylesStorage().addStyle((TemplateStyle)newStyle);
        }
    }

    @Override
    protected void doEdit() {
        GalleryItem selectedItem = this.checkedGallery.getSelection()[0];
        TemplateStyle oldStyle = (TemplateStyle)selectedItem.getData();
        CrosstabStyleWizard wizard = new CrosstabStyleWizard(true, oldStyle);
        WizardDialog dialog = this.getEditorDialog(wizard);
        if (dialog.open() == 0) {
            CrosstabStyle newStyle = wizard.getTableStyle();
            TemplateStyleView.getTemplateStylesStorage().editStyle(oldStyle, (TemplateStyle)newStyle);
        }
    }

    public String getTabName() {
        return "Crosstab Styles";
    }

    @Override
    public List<TemplateStyle> getStylesList() {
        ArrayList<TemplateStyle> result = new ArrayList<TemplateStyle>();
        Collection savedStyles = TemplateStyleView.getTemplateStylesStorage().getStylesDescriptors("crosstabStyle");
        if (savedStyles != null) {
            for (TemplateStyle style : savedStyles) {
                result.add(style);
            }
        }
        return result;
    }

    public void fillStyles() {
        this.tableGroup = new GalleryItem(this.checkedGallery, 0);
        this.checkedGallery.setRedraw(false);
        Collection styles = TemplateStyleView.getTemplateStylesStorage().getStylesDescriptors("crosstabStyle");
        if (styles != null) {
            for (TemplateStyle style : styles) {
                this.getItem(style, this.tableGroup);
            }
        }
        this.checkedGallery.setRedraw(true);
    }

    @Override
    public Image generatePreviewFigure(TemplateStyle style) {
        String key = "crosstabTemplates_" + style.toString();
        Image image = ResourceManager.getImage((String)key);
        if (image == null && style instanceof CrosstabStyle) {
            CrosstabStyle crosstabStyle = (CrosstabStyle)style;
            image = new Image(null, new org.eclipse.swt.graphics.Rectangle(0, 0, 100, 80));
            GC graphics = new GC((Drawable)image);
            try {
                int y = 1;
                int x = 1;
                int w = 94;
                int h = 74;
                int rowHeight = h / 4;
                int rowWidth = w / 4;
                w = rowWidth * 4;
                h = rowHeight * 4;
                Rectangle bounds = new Rectangle(x, y, w, h);
                CrosstabStyleView.fillRoundRectangleDropShadow(graphics, bounds, 6, 4, 4);
                RGB c = null;
                Display disp = PlatformUI.getWorkbench().getDisplay();
                Rectangle firstSquare = new Rectangle(x, y, rowWidth, rowHeight);
                graphics.setBackground(this.checkedGallery.getBackground());
                graphics.fillRectangle(firstSquare.x, firstSquare.y, firstSquare.width, firstSquare.width);
                Rectangle lastRow = new Rectangle(x, y + rowHeight * 3, w, rowHeight);
                Rectangle lastCol = new Rectangle(x + rowWidth * 3, y, rowWidth, h);
                AlfaRGB alfaRGB = style.getColor("color_total");
                c = alfaRGB.getRgb();
                graphics.setAlpha(alfaRGB.getAlfa());
                Color swtColor = new Color((Device)disp, c);
                graphics.setBackground(swtColor);
                graphics.fillRectangle(lastRow.x, lastRow.y, lastRow.width, lastRow.height);
                graphics.fillRectangle(lastCol.x, lastCol.y, lastCol.width, lastCol.height);
                Rectangle beforeLastRow = new Rectangle(x, y + rowHeight * 2, rowWidth * 3, rowHeight);
                Rectangle beforeLastCol = new Rectangle(x + rowWidth * 2, y, rowWidth, rowHeight * 3);
                swtColor.dispose();
                alfaRGB = style.getColor("color_group");
                c = alfaRGB.getRgb();
                graphics.setAlpha(alfaRGB.getAlfa());
                swtColor = new Color((Device)disp, c);
                graphics.setBackground(swtColor);
                graphics.fillRectangle(beforeLastRow.x, beforeLastRow.y, beforeLastRow.width, beforeLastRow.height);
                graphics.fillRectangle(beforeLastCol.x, beforeLastCol.y, beforeLastCol.width, beforeLastCol.height);
                Rectangle detail = new Rectangle(x + rowWidth, y + rowHeight, rowWidth, rowHeight);
                swtColor.dispose();
                alfaRGB = style.getColor("color_detail");
                c = alfaRGB.getRgb();
                graphics.setAlpha(alfaRGB.getAlfa());
                swtColor = new Color((Device)disp, c);
                graphics.setBackground(swtColor);
                graphics.fillRectangle(detail.x, detail.y, detail.width, detail.height);
                Rectangle measure1 = new Rectangle(x, y + rowHeight, rowWidth, rowHeight);
                Rectangle measure2 = new Rectangle(x + rowWidth, y, rowWidth, rowHeight);
                swtColor.dispose();
                alfaRGB = style.getColor("color_measures");
                c = alfaRGB.getRgb();
                graphics.setAlpha(alfaRGB.getAlfa());
                swtColor = new Color((Device)disp, c);
                graphics.setBackground(swtColor);
                graphics.fillRectangle(measure1.x, measure1.y, measure1.width, measure1.height);
                graphics.fillRectangle(measure2.x, measure2.y, measure2.width, measure2.height);
                swtColor.dispose();
                if (crosstabStyle.isShowGrid().booleanValue()) {
                    if (crosstabStyle.getWhiteGrid().booleanValue()) {
                        graphics.setForeground(ColorConstants.white);
                    } else {
                        graphics.setForeground(ColorConstants.black);
                    }
                    int i = 0;
                    while (i < 5) {
                        if (i == 0) {
                            graphics.drawLine(x + rowWidth, y + rowHeight * i, x + w, y + rowHeight * i);
                        } else {
                            graphics.drawLine(x, y + rowHeight * i, x + w, y + rowHeight * i);
                        }
                        ++i;
                    }
                    i = 0;
                    while (i < 5) {
                        if (i == 0) {
                            graphics.drawLine(x + rowWidth * i, y + rowHeight, x + rowWidth * i, y + h);
                        } else {
                            graphics.drawLine(x + rowWidth * i, y, x + rowWidth * i, y + h);
                        }
                        ++i;
                    }
                }
            }
            finally {
                graphics.dispose();
            }
            ResourceManager.addImage((String)key, (Image)image);
        }
        return image;
    }

    private void addDragSupport() {
        int operations = 2;
        Transfer[] types = new Transfer[]{CrosstrabRestrictedTransferType.getInstance()};
        DragSource source = new DragSource((Control)this.checkedGallery, operations);
        source.setTransfer(types);
        source.addDragListener((DragSourceListener)new CommonViewProvider.StyleDragListener());
    }

    public AbstractTransferDropTargetListener getDropListener(EditPartViewer viewer) {
        return new CrosstabStyleTransferDropListener(viewer);
    }

    public TemplateStyle getBuilder() {
        return new CrosstabStyle();
    }

    public Image getTabImage() {
        Image image = ResourceManager.getImage((String)"crosstab-style-16");
        if (image == null) {
            image = Activator.getDefault().getImageDescriptor("icons/crosstab-style-16.png").createImage();
            ResourceManager.addImage((String)"crosstab-style-16", (Image)image);
        }
        return image;
    }

    @Override
    public List<TemplateStyle> getStylesList(List<TemplateStyle> mixedList) {
        ArrayList<TemplateStyle> result = new ArrayList<TemplateStyle>();
        for (TemplateStyle style : mixedList) {
            if (!(style instanceof CrosstabStyle)) continue;
            result.add(style);
        }
        return result;
    }

    public void notifyChange(PropertyChangeEvent e) {
        if (e.getNewValue() instanceof CrosstabStyle) {
            this.refreshStyles();
        }
    }

    public void refreshStyles() {
        if (this.checkedGallery != null) {
            this.checkedGallery.clearAll();
            this.tableGroup = new GalleryItem(this.checkedGallery, 0);
            this.checkedGallery.setRedraw(false);
            for (TemplateStyle style : this.getStylesList()) {
                if (!(style instanceof CrosstabStyle)) continue;
                this.getItem(style, this.tableGroup);
            }
            this.checkedGallery.setRedraw(true);
        }
    }
}

