/*
 * Decompiled with CFR 0.152.
 */
package com.jaspersoft.studio.components.crosstab.figure;

import com.jaspersoft.studio.components.crosstab.figure.CellFigure;
import com.jaspersoft.studio.editor.gef.figures.APageFigure;
import com.jaspersoft.studio.editor.gef.figures.ComponentFigure;
import com.jaspersoft.studio.editor.gef.figures.GridPainter;
import com.jaspersoft.studio.editor.gef.util.FigureTextWriter;
import java.awt.Color;
import java.awt.Font;
import java.awt.Graphics2D;
import java.awt.geom.Rectangle2D;
import org.eclipse.draw2d.ColorConstants;
import org.eclipse.draw2d.Graphics;
import org.eclipse.draw2d.IClippingStrategy;
import org.eclipse.draw2d.IFigure;
import org.eclipse.draw2d.geometry.Rectangle;

public class WhenNoDataCellFigure
extends CellFigure {
    private static final String HINT = "If the crosstab will not contain any data, this cell will be printed instead.";
    private FigureTextWriter twriter = new FigureTextWriter();
    private Rectangle2D hintBounds;
    private IClippingStrategy clippingStrategy = new IClippingStrategy(){

        public Rectangle[] getClip(IFigure childFigure) {
            Rectangle b = childFigure.getBounds();
            if (WhenNoDataCellFigure.this.hintBounds != null && childFigure == WhenNoDataCellFigure.this) {
                return new Rectangle[]{new Rectangle(b.x, b.y, Math.max(b.width, (int)WhenNoDataCellFigure.this.hintBounds.getWidth() + APageFigure.PAGE_BORDER.left), b.height)};
            }
            return new Rectangle[]{b};
        }
    };

    public WhenNoDataCellFigure() {
        this.twriter.setText("When No Data Cell");
    }

    public void paint(Graphics graphics) {
        GridPainter grid;
        Rectangle b = this.getHandleBounds();
        graphics.setBackgroundColor(ColorConstants.white);
        graphics.fillRectangle(b.x, b.y, b.width, b.height);
        super.paint(graphics);
        Graphics2D g = ComponentFigure.getG2D((Graphics)graphics);
        if (g != null) {
            this.twriter.painText(g, (IFigure)this);
            Font currfont = g.getFont();
            g.setFont(currfont.deriveFont(16.0f));
            Color currColor = g.getColor();
            g.setColor(Color.GRAY);
            this.hintBounds = g.getFontMetrics().getStringBounds(HINT, g);
            this.getParent().setClippingStrategy(this.clippingStrategy);
            g.drawString(HINT, b.x, b.y - 15);
            g.setColor(currColor);
            g.setFont(currfont);
        }
        if (this.getParent() instanceof APageFigure && (grid = ((APageFigure)this.getParent()).getGrid()).isVisible()) {
            grid.setBounds(b);
            grid.paintGrid(graphics, (IFigure)this);
        }
        if (this.getBorder() != null) {
            this.getBorder().paint((IFigure)this, graphics, APageFigure.PAGE_BORDER);
        }
    }

    public Rectangle getHandleBounds() {
        Rectangle r = super.getHandleBounds();
        r.x += APageFigure.PAGE_BORDER.left;
        r.y += 30;
        return r;
    }

    public void setShowBandName(boolean showBandName) {
        this.twriter.setShowName(showBandName);
    }

    public void setBandText(String bandText) {
        this.twriter.setText(bandText);
    }

    protected void paintBorder(Graphics graphics) {
    }
}

