/*
 * Decompiled with CFR 0.152.
 */
package com.jaspersoft.studio.components.crosstab.model.cell;

import com.jaspersoft.studio.components.crosstab.CrosstabCell;
import com.jaspersoft.studio.components.crosstab.CrosstabNodeIconDescriptor;
import com.jaspersoft.studio.components.crosstab.messages.Messages;
import com.jaspersoft.studio.components.crosstab.model.MCrosstab;
import com.jaspersoft.studio.editor.layout.ILayout;
import com.jaspersoft.studio.editor.layout.LayoutManager;
import com.jaspersoft.studio.editor.layout.VerticalRowLayout;
import com.jaspersoft.studio.model.ANode;
import com.jaspersoft.studio.model.APropertyNode;
import com.jaspersoft.studio.model.DefaultValue;
import com.jaspersoft.studio.model.IContainer;
import com.jaspersoft.studio.model.IContainerEditPart;
import com.jaspersoft.studio.model.IContainerLayout;
import com.jaspersoft.studio.model.IGraphicElement;
import com.jaspersoft.studio.model.IGraphicElementContainer;
import com.jaspersoft.studio.model.IGraphicalPropertiesHandler;
import com.jaspersoft.studio.model.IGroupElement;
import com.jaspersoft.studio.model.ILineBox;
import com.jaspersoft.studio.model.INode;
import com.jaspersoft.studio.model.IPastable;
import com.jaspersoft.studio.model.IPastableGraphic;
import com.jaspersoft.studio.model.MGraphicElement;
import com.jaspersoft.studio.model.MLineBox;
import com.jaspersoft.studio.model.MRoot;
import com.jaspersoft.studio.model.util.IIconDescriptor;
import com.jaspersoft.studio.property.descriptor.NullEnum;
import com.jaspersoft.studio.property.descriptor.box.BoxPropertyDescriptor;
import com.jaspersoft.studio.property.descriptor.color.ColorPropertyDescriptor;
import com.jaspersoft.studio.property.descriptor.combo.RWComboBoxPropertyDescriptor;
import com.jaspersoft.studio.property.descriptor.properties.JPropertiesPropertyDescriptor;
import com.jaspersoft.studio.property.descriptors.OpaqueModePropertyDescriptor;
import com.jaspersoft.studio.property.descriptors.PixelPropertyDescriptor;
import com.jaspersoft.studio.utils.AlfaRGB;
import com.jaspersoft.studio.utils.Colors;
import java.awt.Color;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import net.sf.jasperreports.crosstabs.JRCellContents;
import net.sf.jasperreports.crosstabs.design.JRDesignCellContents;
import net.sf.jasperreports.engine.JRBoxContainer;
import net.sf.jasperreports.engine.JRElementGroup;
import net.sf.jasperreports.engine.JRPropertiesHolder;
import net.sf.jasperreports.engine.JRPropertiesMap;
import net.sf.jasperreports.engine.JRStyle;
import net.sf.jasperreports.engine.design.JRDesignElement;
import net.sf.jasperreports.engine.design.JasperDesign;
import net.sf.jasperreports.engine.type.ModeEnum;
import org.eclipse.draw2d.geometry.Dimension;
import org.eclipse.draw2d.geometry.Rectangle;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.ui.views.properties.IPropertyDescriptor;

public class MCell
extends APropertyNode
implements IGraphicElement,
IPastable,
IContainerLayout,
IPastableGraphic,
IContainer,
IContainerEditPart,
ILineBox,
IGroupElement,
IGraphicElementContainer,
IGraphicalPropertiesHandler {
    public static final long serialVersionUID = 10200L;
    private static IIconDescriptor iconDescriptor;
    public static final String LINE_BOX = "LineBox";
    private static OpaqueModePropertyDescriptor opaqueD;
    private static RWComboBoxPropertyDescriptor styleD;
    private static IPropertyDescriptor[] descriptors;
    private MLineBox lineBox;
    private String name;
    private boolean visualPropertyChanged = true;
    private static HashSet<String> cachedGraphicalProperties;

    static {
        cachedGraphicalProperties = null;
    }

    public static IIconDescriptor getIconDescriptor() {
        if (iconDescriptor == null) {
            iconDescriptor = new CrosstabNodeIconDescriptor("cell");
        }
        return iconDescriptor;
    }

    public MCell() {
    }

    public MCell(ANode parent, JRCellContents jfRield, String name) {
        super(parent, -1);
        this.setValue(jfRield);
        this.setName(name);
    }

    public MCell(ANode parent, JRCellContents jfRield, String name, int index) {
        super(parent, index);
        this.setValue(jfRield);
        this.setName(name);
    }

    public JRDesignCellContents getValue() {
        return (JRDesignCellContents)super.getValue();
    }

    public String getDisplayText() {
        return this.name;
    }

    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public ImageDescriptor getImagePath() {
        return MCell.getIconDescriptor().getIcon16();
    }

    public String getToolTip() {
        return String.valueOf(MCell.getIconDescriptor().getToolTip()) + ": " + this.getDisplayText();
    }

    public IPropertyDescriptor[] getDescriptors() {
        return descriptors;
    }

    public void setDescriptors(IPropertyDescriptor[] descriptors1) {
        descriptors = descriptors1;
    }

    protected void postDescriptors(IPropertyDescriptor[] descriptors) {
        super.postDescriptors(descriptors);
        JasperDesign jasperDesign = this.getJasperDesign();
        if (jasperDesign != null && styleD != null) {
            JRDesignCellContents jrElement = this.getValue();
            JRStyle[] styles = jasperDesign.getStyles();
            String[] items = new String[styles.length + 1];
            items[0] = jrElement.getStyleNameReference() != null ? jrElement.getStyleNameReference() : "";
            int j = 0;
            while (j < styles.length) {
                items[j + 1] = styles[j].getName();
                ++j;
            }
            styleD.setItems(items);
        }
    }

    public void createPropertyDescriptors(List<IPropertyDescriptor> desc) {
        opaqueD = new OpaqueModePropertyDescriptor((Object)"mode", Messages.MCell_transparent, NullEnum.NOTNULL);
        opaqueD.setDescription(Messages.MCell_transparent_description);
        desc.add((IPropertyDescriptor)opaqueD);
        ColorPropertyDescriptor backcolorD = new ColorPropertyDescriptor((Object)"backcolor", Messages.MCell_backcolor, NullEnum.INHERITED);
        backcolorD.setDescription(Messages.MCell_backcolor_description);
        desc.add((IPropertyDescriptor)backcolorD);
        styleD = new RWComboBoxPropertyDescriptor((Object)"style", Messages.MCell_parent_style, new String[]{""}, NullEnum.NULL);
        styleD.setDescription(Messages.MCell_parent_style_description);
        desc.add((IPropertyDescriptor)styleD);
        PixelPropertyDescriptor wD = new PixelPropertyDescriptor((Object)"width", Messages.common_width);
        desc.add((IPropertyDescriptor)wD);
        PixelPropertyDescriptor hD = new PixelPropertyDescriptor((Object)"height", Messages.common_height);
        desc.add((IPropertyDescriptor)hD);
        BoxPropertyDescriptor lineBoxD = new BoxPropertyDescriptor((Object)LINE_BOX, Messages.MCell_line_box);
        lineBoxD.setDescription(Messages.MCell_line_box_description);
        desc.add((IPropertyDescriptor)lineBoxD);
        JPropertiesPropertyDescriptor propertiesMapD = new JPropertiesPropertyDescriptor((Object)"PROPERTY_MAP", com.jaspersoft.studio.messages.Messages.common_properties, this.getJasperConfiguration(), (Object)this.getValue());
        propertiesMapD.setDescription(com.jaspersoft.studio.messages.Messages.common_properties);
        desc.add((IPropertyDescriptor)propertiesMapD);
        this.setHelpPrefix(desc, "net.sf.jasperreports.doc/docs/schema.reference.html?cp=0_1#crosstabCell");
    }

    protected Map<String, DefaultValue> createDefaultsMap() {
        Map defaultsMap = super.createDefaultsMap();
        defaultsMap.put("mode", new DefaultValue((Object)ModeEnum.OPAQUE, false));
        defaultsMap.put("backcolor", new DefaultValue(null, true));
        defaultsMap.put("style", new DefaultValue(null, true));
        return defaultsMap;
    }

    public Object getPropertyValue(Object id) {
        JRDesignCellContents jrElement = this.getValue();
        if (jrElement != null) {
            if (id.equals("mode")) {
                return opaqueD.getIntValue((Enum)jrElement.getModeValue());
            }
            if (id.equals("backcolor")) {
                return Colors.getSWTRGB4AWTGBColor((Color)jrElement.getBackcolor());
            }
            if (id.equals("style")) {
                if (jrElement.getStyleNameReference() != null) {
                    return jrElement.getStyleNameReference();
                }
                if (jrElement.getStyle() != null) {
                    return jrElement.getStyle().getName();
                }
                return "";
            }
            if (id.equals("width")) {
                return jrElement.getWidth();
            }
            if (id.equals("height")) {
                return jrElement.getHeight();
            }
            if (id.equals(LINE_BOX)) {
                JRDesignCellContents jrGraphicElement = this.getValue();
                if (this.lineBox == null) {
                    this.lineBox = new MLineBox(jrGraphicElement.getLineBox(), (ANode)this);
                    this.lineBox.getPropertyChangeSupport().addPropertyChangeListener((PropertyChangeListener)((Object)this));
                }
                return this.lineBox;
            }
            if (id.equals("PROPERTY_MAP")) {
                return this.getPropertiesMapClone(jrElement);
            }
        }
        return null;
    }

    protected JRPropertiesMap getPropertiesMapClone(JRDesignCellContents element) {
        JRPropertiesMap propertiesMap = element.getPropertiesMap();
        if (propertiesMap != null) {
            propertiesMap = propertiesMap.cloneProperties();
        }
        return propertiesMap;
    }

    public void setPropertyValue(Object id, Object value) {
        JRDesignCellContents jrElement = this.getValue();
        if (jrElement != null) {
            if (id.equals("mode")) {
                jrElement.setMode((ModeEnum)opaqueD.getEnumValue(value));
            } else if (id.equals("backcolor")) {
                jrElement.setBackcolor(Colors.getAWT4SWTRGBColor((AlfaRGB)((AlfaRGB)value)));
            } else if (id.equals("style")) {
                if (!value.equals("")) {
                    JRStyle style = (JRStyle)this.getJasperDesign().getStylesMap().get(value);
                    if (style != null) {
                        jrElement.setStyle(style);
                        jrElement.setStyleNameReference(null);
                    } else {
                        jrElement.setStyleNameReference((String)value);
                        jrElement.setStyle(null);
                    }
                }
            } else if (id.equals("width")) {
                MCrosstab cross = this.getMCrosstab();
                if (cross != null) {
                    cross.getCrosstabManager().setWidth(jrElement, (Integer)value);
                    cross.getCrosstabManager().refresh();
                    this.getPropertyChangeSupport().firePropertyChange(new PropertyChangeEvent((Object)this, "width", null, value));
                }
            } else if (id.equals("height")) {
                MCrosstab cross = this.getMCrosstab();
                if (cross != null) {
                    cross.getCrosstabManager().setHeight(jrElement, (Integer)value);
                    cross.getCrosstabManager().refresh();
                    this.getPropertyChangeSupport().firePropertyChange(new PropertyChangeEvent((Object)this, "height", null, value));
                }
            } else if (id.equals("PROPERTY_MAP")) {
                JRPropertiesMap originalMap = jrElement.getPropertiesMap().cloneProperties();
                JRPropertiesMap v = (JRPropertiesMap)value;
                String[] names = jrElement.getPropertiesMap().getPropertyNames();
                int i = 0;
                while (i < names.length) {
                    jrElement.getPropertiesMap().removeProperty(names[i]);
                    ++i;
                }
                names = v.getPropertyNames();
                i = 0;
                while (i < names.length) {
                    jrElement.getPropertiesMap().setProperty(names[i], v.getProperty(names[i]));
                    ++i;
                }
                this.getPropertyChangeSupport().firePropertyChange(new PropertyChangeEvent(jrElement, "PROPERTY_MAP", originalMap, jrElement.getPropertiesMap()));
            }
        }
    }

    public int getDefaultWidth() {
        return 20;
    }

    public int getDefaultHeight() {
        return 20;
    }

    public JRDesignElement createJRElement(JasperDesign jasperDesign) {
        return null;
    }

    public Rectangle getBounds() {
        MCrosstab mc = this.getMCrosstab();
        if (mc != null) {
            return mc.getCrosstabManager().getBounds(new CrosstabCell(this.getValue()));
        }
        return null;
    }

    public JRBoxContainer getBoxContainer() {
        return this.getValue();
    }

    public Integer getTopPadding() {
        JRDesignCellContents c = null;
        if (this.getValue() != null) {
            c = this.getValue();
            return c.getLineBox().getTopPadding();
        }
        return 0;
    }

    public Integer getLeftPadding() {
        JRDesignCellContents c = null;
        if (this.getValue() != null) {
            c = this.getValue();
            return c.getLineBox().getLeftPadding();
        }
        return 0;
    }

    public Integer getBottomPadding() {
        JRDesignCellContents c = null;
        if (this.getValue() != null) {
            c = this.getValue();
            return c.getLineBox().getBottomPadding();
        }
        return 0;
    }

    public Integer getRightPadding() {
        JRDesignCellContents c = null;
        if (this.getValue() != null) {
            c = this.getValue();
            return c.getLineBox().getRightPadding();
        }
        return 0;
    }

    public Integer getPadding() {
        JRDesignCellContents c = null;
        if (this.getValue() != null) {
            c = this.getValue();
            return c.getLineBox().getPadding();
        }
        return 0;
    }

    public MCrosstab getCrosstab() {
        MCell node = this;
        while (node != null && node.getParent() != null && !(node instanceof MCrosstab) && !(node instanceof MRoot)) {
            node = node.getParent();
        }
        if (node instanceof MCrosstab) {
            return (MCrosstab)((Object)node);
        }
        return null;
    }

    public MCrosstab getMCrosstab() {
        return this.getCrosstab();
    }

    public Dimension getSize() {
        JRDesignCellContents v = this.getValue();
        return new Dimension(v.getWidth(), v.getHeight());
    }

    public JRElementGroup getJRElementGroup() {
        return this.getValue();
    }

    public JRPropertiesHolder[] getPropertyHolder() {
        return new JRPropertiesHolder[]{this.getValue(), this.getMCrosstab().getValue()};
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean hasChangedProperty() {
        MCell mCell = this;
        synchronized (mCell) {
            return this.visualPropertyChanged;
        }
    }

    public void setStyleChangedProperty() {
        HashSet<ANode> refreshedParents = new HashSet<ANode>();
        PropertyChangeListener[] propertyChangeListenerArray = this.getValue().getEventSupport().getPropertyChangeListeners();
        int n = propertyChangeListenerArray.length;
        int n2 = 0;
        while (n2 < n) {
            ANode tableParent;
            MCell listenerCell;
            MCrosstab crosstab;
            PropertyChangeListener listener = propertyChangeListenerArray[n2];
            if (listener instanceof MCell && (crosstab = (listenerCell = (MCell)((Object)listener)).getMCrosstab()) != null && (tableParent = crosstab.getParent()) != null && !refreshedParents.contains(tableParent)) {
                refreshedParents.add(tableParent);
                listenerCell.setChangedProperty(true);
            }
            ++n2;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setChangedProperty(boolean value) {
        MCell mCell = this;
        synchronized (mCell) {
            if (value) {
                ANode parent = this.getParent();
                while (parent != null) {
                    if (parent instanceof IGraphicalPropertiesHandler) {
                        IGraphicalPropertiesHandler handler = (IGraphicalPropertiesHandler)parent;
                        handler.setChangedProperty(true);
                        break;
                    }
                    parent = parent.getParent();
                }
            }
            this.visualPropertyChanged = value;
        }
    }

    public HashSet<String> getGraphicalProperties() {
        if (cachedGraphicalProperties == null) {
            cachedGraphicalProperties = new HashSet();
            cachedGraphicalProperties.add("mode");
            cachedGraphicalProperties.add("backcolor");
            cachedGraphicalProperties.add("style");
            cachedGraphicalProperties.add("width");
            cachedGraphicalProperties.add("height");
            cachedGraphicalProperties.add("bottomPadding");
            cachedGraphicalProperties.add("leftPadding");
            cachedGraphicalProperties.add("padding");
            cachedGraphicalProperties.add("rightPadding");
            cachedGraphicalProperties.add("topPadding");
            cachedGraphicalProperties.add("lineColor");
            cachedGraphicalProperties.add("lineStyle");
            cachedGraphicalProperties.add("lineWidth");
        }
        return cachedGraphicalProperties;
    }

    public Map<String, List<ANode>> getUsedStyles() {
        JRDesignCellContents jrElement = this.getValue();
        Map result = super.getUsedStyles();
        if (jrElement != null && jrElement.getStyle() != null) {
            this.addElementStyle(jrElement.getStyle(), result);
        }
        for (INode node : this.getChildren()) {
            if (!(node instanceof ANode)) continue;
            this.mergeElementStyle(result, ((ANode)node).getUsedStyles());
        }
        return result;
    }

    public void setStyle(JRStyle style) {
        JRDesignCellContents jrElement = this.getValue();
        if (jrElement != null) {
            jrElement.setStyle(style);
        }
    }

    public void propertyChange(PropertyChangeEvent evt) {
        HashSet<String> graphicalProperties = this.getGraphicalProperties();
        if (graphicalProperties.contains(evt.getPropertyName())) {
            this.setChangedProperty(true);
        }
        super.propertyChange(evt);
    }

    public ILayout getDefaultLayout() {
        return LayoutManager.getLayout((String)VerticalRowLayout.class.getName());
    }

    public void updateName() {
        if (this.getValue() != null) {
            this.propertyChange(new PropertyChangeEvent(this.getValue(), MGraphicElement.FORCE_GRAPHICAL_REFRESH, null, null));
        }
    }

    public HashMap<String, Object> getStylesDescriptors() {
        HashMap result = super.getStylesDescriptors();
        if (this.getValue() == null) {
            return result;
        }
        MLineBox element = (MLineBox)this.getPropertyValue(LINE_BOX);
        result.put(LINE_BOX, element);
        return result;
    }

    public Rectangle getAbsoluteBounds() {
        MCrosstab crosstabModel = this.getCrosstab();
        Rectangle crosstabLocationLocation = crosstabModel.getAbsoluteBounds();
        Rectangle cellBounds = this.getBounds();
        int x = cellBounds.x + crosstabLocationLocation.x;
        int y = cellBounds.y + crosstabLocationLocation.y;
        return new Rectangle(x, y, cellBounds.width, cellBounds.height);
    }
}

