/*
 * Decompiled with CFR 0.152.
 */
package com.jaspersoft.studio.components.crosstab.model.columngroup.command;

import com.jaspersoft.studio.JSSCompoundCommand;
import com.jaspersoft.studio.components.crosstab.model.CrosstabUtil;
import com.jaspersoft.studio.components.crosstab.model.MCrosstab;
import com.jaspersoft.studio.components.crosstab.model.cell.command.PostSetSizeCell;
import com.jaspersoft.studio.components.crosstab.model.columngroup.MColumnGroup;
import com.jaspersoft.studio.components.crosstab.model.columngroup.MColumnGroups;
import com.jaspersoft.studio.model.ANode;
import com.jaspersoft.studio.model.INode;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import net.sf.jasperreports.crosstabs.JRCrosstabCell;
import net.sf.jasperreports.crosstabs.JRCrosstabColumnGroup;
import net.sf.jasperreports.crosstabs.design.JRDesignCrosstab;
import net.sf.jasperreports.crosstabs.design.JRDesignCrosstabCell;
import net.sf.jasperreports.crosstabs.design.JRDesignCrosstabColumnGroup;
import net.sf.jasperreports.engine.JRException;
import org.eclipse.gef.commands.Command;

public class DeleteColumnGroupCommand
extends Command {
    private JRDesignCrosstab jrCrosstab;
    private JRDesignCrosstabColumnGroup jrColumnGroup;
    private MCrosstab crosstabNode;
    private Map<String, JRCrosstabCell> removedCells = null;
    private int index = 0;

    public DeleteColumnGroupCommand(MColumnGroups destNode, MColumnGroup srcNode) {
        this.jrCrosstab = (JRDesignCrosstab)destNode.getValue();
        this.crosstabNode = (MCrosstab)destNode.getParent();
        this.jrColumnGroup = srcNode.getValue();
    }

    public DeleteColumnGroupCommand(MCrosstab destNode, MColumnGroup srcNode) {
        this.jrCrosstab = destNode.getValue();
        this.crosstabNode = destNode;
        this.jrColumnGroup = srcNode.getValue();
    }

    public DeleteColumnGroupCommand(MCrosstab crosstab, JRDesignCrosstabColumnGroup columnGroup) {
        this.jrCrosstab = crosstab.getValue();
        this.crosstabNode = crosstab;
        this.jrColumnGroup = columnGroup;
    }

    public void execute() {
        this.index = this.jrCrosstab.getColumnGroupsList().indexOf(this.jrColumnGroup);
        this.removeColumnGroup(this.jrCrosstab, this.jrColumnGroup);
        JSSCompoundCommand c = new JSSCompoundCommand("Resize Crosstab Cell", (ANode)this.crosstabNode);
        PostSetSizeCell.createLayoutCommand((INode)this.crosstabNode, c);
        c.execute();
        this.jrCrosstab.getEventSupport().firePropertyChange("updateCrosstabModel", null, (Object)this.jrColumnGroup);
    }

    public boolean canUndo() {
        return this.jrCrosstab != null && this.jrColumnGroup != null;
    }

    public void undo() {
        try {
            CrosstabUtil.addColumnGroup(this.jrCrosstab, this.jrColumnGroup, this.index, this.removedCells);
            JSSCompoundCommand c = new JSSCompoundCommand("Resize Crosstab Cell", (ANode)this.crosstabNode);
            PostSetSizeCell.createLayoutCommand((INode)this.crosstabNode, c);
            c.execute();
            this.jrCrosstab.getEventSupport().firePropertyChange("updateCrosstabModel", null, (Object)this.jrColumnGroup);
        }
        catch (JRException ex) {
            ex.printStackTrace();
        }
    }

    public void removeColumnGroup(JRDesignCrosstab jrCross, JRDesignCrosstabColumnGroup jrColGr) {
        this.removedCells = new HashMap<String, JRCrosstabCell>();
        String name = jrColGr.getName();
        ArrayList cells = new ArrayList(jrCross.getCellsList());
        int i = 0;
        while (i < cells.size()) {
            String totalGroup;
            JRDesignCrosstabCell cell = (JRDesignCrosstabCell)cells.get(i);
            if (cell != null && (totalGroup = cell.getColumnTotalGroup()) != null && totalGroup.equals(name)) {
                this.removedCells.put(cell.getRowTotalGroup(), (JRCrosstabCell)cell);
                jrCross.removeCell((JRCrosstabCell)cell);
            }
            ++i;
        }
        jrCross.removeColumnGroup((JRCrosstabColumnGroup)jrColGr);
        jrCross.preprocess();
    }

    public Map<String, JRCrosstabCell> getRemovedCells() {
        return this.removedCells;
    }
}

