/*
 * Decompiled with CFR 0.152.
 */
package com.jaspersoft.studio.components.crosstab.model.crosstab.command.wizard;

import com.jaspersoft.studio.components.Activator;
import com.jaspersoft.studio.components.crosstab.messages.Messages;
import com.jaspersoft.studio.components.crosstab.model.MCrosstab;
import com.jaspersoft.studio.components.crosstab.model.dialog.CrosstabStyle;
import com.jaspersoft.studio.components.crosstab.model.dialog.CrosstabStylePreview;
import com.jaspersoft.studio.components.widgets.ColorSelectionWidget;
import com.jaspersoft.studio.editor.style.TemplateStyle;
import com.jaspersoft.studio.property.color.ColorSchemaGenerator;
import com.jaspersoft.studio.utils.AlfaRGB;
import com.jaspersoft.studio.wizards.ContextHelpIDs;
import com.jaspersoft.studio.wizards.JSSHelpWizardPage;
import java.awt.Color;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.RGB;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Group;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Text;

public class CrosstabWizardLayoutPage
extends JSSHelpWizardPage {
    private MCrosstab crosstab;
    private boolean isAddRowTotal = true;
    private boolean isAddColTotal = true;
    private Button whiteGrid;
    private CrosstabStylePreview preview;
    private CrosstabStyle lastGeneratedStyle = null;
    private Button showGrid;
    private Text titleText = null;
    private boolean createTitle;
    private TemplateStyle templateToOpen;
    private static final String totalColor = "TOTAL_COLOR";
    private static final String groupColor = "GROUP_COLOR";
    private static final String measuresColor = "MEASURES_COLOR";
    private static final String detailColor = "DETAIL_COLOR";
    private ColorSelectionWidget selectionWidget;
    private ModifyListener modifyListener = new ModifyListener(){

        public void modifyText(ModifyEvent e) {
            CrosstabWizardLayoutPage.this.notifyChange();
        }
    };
    private SelectionAdapter selectionListener = new SelectionAdapter(){

        public void widgetSelected(SelectionEvent e) {
            CrosstabWizardLayoutPage.this.notifyChange();
        }
    };

    protected CrosstabWizardLayoutPage(boolean createTitle) {
        super("crosstablayoutpage");
        this.setTitle(Messages.CrosstabWizardLayoutPage_layout);
        this.setImageDescriptor(Activator.getDefault().getImageDescriptor("icons/wizard_preview.png"));
        this.setDescription(Messages.CrosstabWizardLayoutPage_description);
        this.createTitle = createTitle;
        this.templateToOpen = null;
    }

    protected CrosstabWizardLayoutPage() {
        this(false);
    }

    public boolean isAddRowTotal() {
        return this.isAddRowTotal;
    }

    public boolean isAddColTotal() {
        return this.isAddColTotal;
    }

    public void setCrosstab(MCrosstab crosstab) {
        this.crosstab = crosstab;
    }

    public MCrosstab getCrosstab() {
        return this.crosstab;
    }

    private void updateSelectedColor() {
        String colorName = this.selectionWidget.getSchemaSelected();
        Color color = ColorSchemaGenerator.getColor((String)colorName);
        ColorSchemaGenerator.SCHEMAS variantKey = this.selectionWidget.getVariantSelectedKey();
        AlfaRGB argbColor = new AlfaRGB(new RGB(color.getRed(), color.getGreen(), color.getBlue()), color.getAlpha());
        CrosstabStyle tempStyle = new CrosstabStyle(argbColor, variantKey, false);
        this.selectionWidget.setButtonData(totalColor, tempStyle.getColor("color_total"));
        this.selectionWidget.setButtonData(groupColor, tempStyle.getColor("color_group"));
        this.selectionWidget.setButtonData(measuresColor, tempStyle.getColor("color_measures"));
        this.selectionWidget.setButtonData(detailColor, tempStyle.getColor("color_detail"));
    }

    private void createColorGroup(Composite parent) {
        SelectionAdapter schemaSelectionAdapter = new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                CrosstabWizardLayoutPage.this.updateSelectedColor();
                CrosstabWizardLayoutPage.this.notifyChange();
            }
        };
        this.selectionWidget = new ColorSelectionWidget(parent, this.selectionListener, schemaSelectionAdapter, ColorSelectionWidget.STYLE.BOTTOM);
        CrosstabStyle temp = CrosstabWizardLayoutPage.getDefaultStyle();
        this.selectionWidget.addButton(totalColor, Messages.CrosstabWizardLayoutPage_totalLabel, temp.getColor("color_total"));
        this.selectionWidget.addButton(groupColor, Messages.CrosstabWizardLayoutPage_groupLabel, temp.getColor("color_group"));
        this.selectionWidget.addButton(measuresColor, Messages.CrosstabWizardLayoutPage_measuresLabel, temp.getColor("color_measures"));
        this.selectionWidget.addButton(detailColor, Messages.CrosstabWizardLayoutPage_detailLabel, temp.getColor("color_detail"));
        this.selectionWidget.createControl(Messages.CrosstabWizardLayoutPage_schemaGroupLabel, Messages.CrosstabWizardLayoutPage_manualGroupLabel, 4);
        Composite checkComposite = new Composite(parent, 0);
        checkComposite.setLayout((Layout)new GridLayout(2, false));
        checkComposite.setLayoutData((Object)new GridData(1808));
        this.whiteGrid = new Button(checkComposite, 32);
        Label whiteGridLabel = new Label(checkComposite, 64);
        whiteGridLabel.setText(Messages.CrosstabWizardLayoutPage_white_grid_check);
        GridData checkBoxData = new GridData(768);
        whiteGridLabel.setLayoutData((Object)checkBoxData);
        this.showGrid = new Button(checkComposite, 32);
        Label showGridLabel = new Label(checkComposite, 64);
        showGridLabel.setText(Messages.CrosstabWizardLayoutPage_noGrid_label);
        GridData showGridData = new GridData(768);
        showGridLabel.setLayoutData((Object)showGridData);
        this.showGrid.setSelection(true);
        this.whiteGrid.addSelectionListener((SelectionListener)this.selectionListener);
        this.showGrid.addSelectionListener((SelectionListener)this.selectionListener);
    }

    private void setData() {
        if (this.templateToOpen instanceof CrosstabStyle) {
            CrosstabStyle cStyle = (CrosstabStyle)this.templateToOpen;
            this.selectionWidget.setButtonData(totalColor, this.templateToOpen.getColor("color_total"));
            this.selectionWidget.setButtonData(groupColor, this.templateToOpen.getColor("color_group"));
            this.selectionWidget.setButtonData(measuresColor, this.templateToOpen.getColor("color_measures"));
            this.selectionWidget.setButtonData(detailColor, this.templateToOpen.getColor("color_detail"));
            this.selectionWidget.switchInputMethod(ColorSelectionWidget.ColorInput.MANUAL);
            this.whiteGrid.setSelection(cStyle.getWhiteGrid().booleanValue());
            this.showGrid.setSelection(cStyle.isShowGrid().booleanValue());
            if (this.titleText != null) {
                this.titleText.setText(cStyle.getDescription());
            }
        }
    }

    private void createSectionsGroup(Composite parent) {
        Group group = new Group(parent, 0);
        group.setText(Messages.CrosstabWizardLayoutPage_visible_sections_group);
        group.setLayout((Layout)new GridLayout(1, false));
        group.setLayoutData((Object)new GridData(1808));
        final Button addRowTotals = new Button((Composite)group, 32);
        addRowTotals.setText(Messages.CrosstabWizardLayoutPage_add_row_group_totals);
        GridData gd = new GridData();
        gd.horizontalSpan = 2;
        addRowTotals.setLayoutData((Object)gd);
        addRowTotals.setSelection(true);
        addRowTotals.addSelectionListener(new SelectionListener(){

            public void widgetSelected(SelectionEvent e) {
                CrosstabWizardLayoutPage.this.isAddRowTotal = addRowTotals.getSelection();
            }

            public void widgetDefaultSelected(SelectionEvent e) {
            }
        });
        final Button addColumnTotals = new Button((Composite)group, 32);
        addColumnTotals.setText(Messages.CrosstabWizardLayoutPage_add_column_group_totals);
        gd = new GridData();
        gd.horizontalSpan = 2;
        addColumnTotals.setLayoutData((Object)gd);
        addColumnTotals.setSelection(true);
        addColumnTotals.addSelectionListener(new SelectionListener(){

            public void widgetSelected(SelectionEvent e) {
                CrosstabWizardLayoutPage.this.isAddColTotal = addColumnTotals.getSelection();
            }

            public void widgetDefaultSelected(SelectionEvent e) {
            }
        });
        group.setVisible(false);
    }

    private void createLeftCol(Composite parent) {
        Composite leftCol = new Composite(parent, 0);
        leftCol.setLayout((Layout)new GridLayout(1, false));
        this.createColorGroup(leftCol);
        this.createSectionsGroup(leftCol);
        GridData leftPanelData = new GridData(1040);
        leftPanelData.widthHint = 300;
        leftPanelData.minimumHeight = 200;
        leftCol.setLayoutData((Object)leftPanelData);
    }

    public void setTemplateToOpen(TemplateStyle template) {
        this.templateToOpen = template;
    }

    private void createPreview(Composite parent, Composite wizardMainTab) {
        Group group = new Group(parent, 0);
        group.setText(Messages.CrosstabWizardLayoutPage_style_preview_group);
        group.setLayout((Layout)new GridLayout(1, false));
        group.setLayoutData((Object)new GridData(1808));
        this.preview = new CrosstabStylePreview((Composite)group, 0);
        this.preview.setLayoutData(new GridData(1808));
    }

    private void notifyChange() {
        AlfaRGB colorTotal = this.selectionWidget.getButtonData(totalColor);
        AlfaRGB colorGroup = this.selectionWidget.getButtonData(groupColor);
        AlfaRGB colorDetail = this.selectionWidget.getButtonData(detailColor);
        AlfaRGB colorMeasures = this.selectionWidget.getButtonData(measuresColor);
        this.lastGeneratedStyle = new CrosstabStyle(colorTotal, colorGroup, colorMeasures, colorDetail, this.whiteGrid.getSelection());
        this.lastGeneratedStyle.setShowGrid(this.showGrid.getSelection());
        if (this.titleText != null) {
            this.lastGeneratedStyle.setDescription(this.titleText.getText());
        }
        this.preview.setTableStyle(this.lastGeneratedStyle);
    }

    public CrosstabStyle getSelectedStyle() {
        if (this.lastGeneratedStyle == null) {
            this.lastGeneratedStyle = CrosstabWizardLayoutPage.getDefaultStyle();
        }
        return this.lastGeneratedStyle;
    }

    public static CrosstabStyle getDefaultStyle() {
        String firstColor = (String)ColorSchemaGenerator.getColors().get(0);
        Color color = ColorSchemaGenerator.getColor((String)firstColor);
        AlfaRGB rgbColor = new AlfaRGB(new RGB(color.getRed(), color.getGreen(), color.getBlue()), color.getAlpha());
        CrosstabStyle style = new CrosstabStyle(rgbColor, ColorSchemaGenerator.SCHEMAS.DEFAULT, false);
        return style;
    }

    private void createTitleLabel(Composite parent) {
        Composite titleComposite = new Composite(parent, 0);
        titleComposite.setLayout((Layout)new GridLayout(2, false));
        GridData titleCompositeData = new GridData();
        titleCompositeData.horizontalSpan = 2;
        titleCompositeData.grabExcessHorizontalSpace = true;
        titleCompositeData.horizontalAlignment = 4;
        titleComposite.setLayoutData((Object)titleCompositeData);
        Label descriptionLabel = new Label(titleComposite, 0);
        descriptionLabel.setText(Messages.CrosstabWizardLayoutPage_nameLabel);
        this.titleText = new Text(titleComposite, 2048);
        this.titleText.addModifyListener(this.modifyListener);
        GridData textData = new GridData();
        textData.grabExcessHorizontalSpace = true;
        textData.horizontalAlignment = 4;
        this.titleText.setLayoutData((Object)textData);
    }

    public void createControl(Composite parent) {
        Composite dialog = new Composite(parent, 0);
        GridLayout generalLayout = new GridLayout(2, false);
        dialog.setLayout((Layout)generalLayout);
        this.setControl((Control)dialog);
        if (this.createTitle) {
            this.createTitleLabel(dialog);
        }
        this.createLeftCol(dialog);
        this.createPreview(dialog, parent);
        if (this.templateToOpen != null) {
            this.setData();
        }
        this.notifyChange();
    }

    protected String getContextName() {
        return ContextHelpIDs.CROSSTAB_STYLES;
    }
}

