/*
 * Decompiled with CFR 0.152.
 */
package com.jaspersoft.studio.components.crosstab.model.dialog;

import com.jaspersoft.studio.JaspersoftStudioPlugin;
import com.jaspersoft.studio.components.crosstab.messages.Messages;
import com.jaspersoft.studio.editor.action.exporter.BaseResource;
import com.jaspersoft.studio.editor.action.exporter.IExportedResourceHandler;
import com.jaspersoft.studio.editor.action.exporter.IResourceDefinition;
import com.jaspersoft.studio.editor.style.TemplateStyle;
import com.jaspersoft.studio.property.color.ColorSchemaGenerator;
import com.jaspersoft.studio.style.view.TemplateStyleView;
import com.jaspersoft.studio.utils.AlfaRGB;
import java.awt.Color;
import java.io.Closeable;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.OutputStream;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import net.sf.jasperreports.eclipse.ui.util.RunnableOverwriteQuestion;
import net.sf.jasperreports.eclipse.util.FileUtils;
import net.sf.jasperreports.eclipse.util.Pair;
import org.eclipse.draw2d.ColorConstants;
import org.eclipse.swt.graphics.RGB;
import org.w3c.dom.NamedNodeMap;
import org.w3c.dom.Node;

public class CrosstabStyle
extends TemplateStyle
implements IExportedResourceHandler {
    public static final String TEMPLATE_TYPE = "crosstabStyle";
    private static final long serialVersionUID = -2866538585051431701L;
    private static final String WHITE_GRID = "white_grid";
    private static final String SHOW_GRID = "show_grid";
    public static final String COLOR_TOTAL = "color_total";
    public static final String COLOR_GROUP = "color_group";
    public static final String COLOR_DETAIL = "color_detail";
    public static final String COLOR_MEASURES = "color_measures";
    private static final String INDEX_FILE_NAME = "index.properties";
    private static final String STYLE_FILE_NAME = "exportedStyles.xml";
    private List<IResourceDefinition> cachedExportableResources = null;
    private Pair<String, List<IResourceDefinition>> cachedImportableResources = null;

    public CrosstabStyle(AlfaRGB baseColor, ColorSchemaGenerator.SCHEMAS variation, boolean whiteGrid) {
        super(baseColor, variation);
        this.storePropertiy(WHITE_GRID, whiteGrid);
        this.storePropertiy(SHOW_GRID, true);
        this.generateAndStoreColor(COLOR_TOTAL, 1);
        this.generateAndStoreColor(COLOR_GROUP, 2);
        this.generateAndStoreColor(COLOR_MEASURES, 3);
        this.storeColor(COLOR_DETAIL, AlfaRGB.getFullyOpaque((RGB)ColorConstants.white.getRGB()));
    }

    public CrosstabStyle(AlfaRGB colorTotal, AlfaRGB colorGroup, AlfaRGB colorMeasures, AlfaRGB colorDetail, boolean whiteGrid) {
        super(null, null);
        this.storePropertiy(WHITE_GRID, whiteGrid);
        this.storePropertiy(SHOW_GRID, true);
        this.storeColor(COLOR_TOTAL, colorTotal);
        this.storeColor(COLOR_GROUP, colorGroup);
        this.storeColor(COLOR_MEASURES, colorMeasures);
        this.storeColor(COLOR_DETAIL, colorDetail);
    }

    public CrosstabStyle() {
        super(null, null);
    }

    public Boolean getWhiteGrid() {
        return (Boolean)this.getProperty(WHITE_GRID);
    }

    public Boolean isShowGrid() {
        return (Boolean)this.getProperty(SHOW_GRID);
    }

    public void setShowGrid(boolean value) {
        this.storePropertiy(SHOW_GRID, value);
    }

    public void setWhiteGrid(Boolean value) {
        this.storePropertiy(WHITE_GRID, value);
    }

    public Color getColorValue(String name) {
        AlfaRGB alphaColor = super.getColor(name);
        RGB rgbColor = alphaColor.getRgb();
        return new Color(rgbColor.red, rgbColor.green, rgbColor.blue, alphaColor.getAlfa());
    }

    public String toString() {
        String color1 = this.getColor(COLOR_TOTAL).toString();
        String color2 = this.getColor(COLOR_GROUP).toString();
        String color3 = this.getColor(COLOR_MEASURES).toString();
        String color4 = this.getColor(COLOR_DETAIL).toString();
        return color1.concat(color2).concat(color3).concat(color4).concat(this.getWhiteGrid().toString());
    }

    public String getXMLData() {
        String result = "<" + this.getTemplateName() + " type=\"" + this.getTemplateName() + "\" ";
        result = String.valueOf(result) + "whiteGrid=\"" + this.getWhiteGrid().toString() + "\">";
        result = String.valueOf(result) + "<description>".concat(this.getDescription()).concat("</description>");
        result = String.valueOf(result) + CrosstabStyle.xmlColor((String)"colorTotal", (AlfaRGB)this.getColor(COLOR_TOTAL));
        result = String.valueOf(result) + CrosstabStyle.xmlColor((String)"colorGroup", (AlfaRGB)this.getColor(COLOR_GROUP));
        result = String.valueOf(result) + CrosstabStyle.xmlColor((String)"colorMeasures", (AlfaRGB)this.getColor(COLOR_MEASURES));
        result = String.valueOf(result) + CrosstabStyle.xmlColor((String)"colorDetail", (AlfaRGB)this.getColor(COLOR_DETAIL));
        result = String.valueOf(result) + "</" + this.getTemplateName() + ">";
        return result;
    }

    public TemplateStyle buildFromXML(Node xmlNode) {
        try {
            NamedNodeMap rootAttributes = xmlNode.getAttributes();
            boolean whiteGrid = rootAttributes.getNamedItem("whiteGrid").getNodeValue().equals("true");
            Node schemasNode = rootAttributes.getNamedItem("colorSchema");
            ColorSchemaGenerator.SCHEMAS variation = schemasNode != null ? ColorSchemaGenerator.SCHEMAS.valueOf((String)schemasNode.getNodeValue()) : null;
            Node firstChild = xmlNode.getFirstChild();
            String description = null;
            AlfaRGB baseColor = null;
            AlfaRGB colorTotal = null;
            AlfaRGB colorGroup = null;
            AlfaRGB colorMeasures = null;
            AlfaRGB colorDetail = null;
            while (firstChild != null) {
                if (firstChild.getNodeName().equals("baseColor")) {
                    baseColor = CrosstabStyle.rgbColor((Node)firstChild);
                } else if (firstChild.getNodeName().equals("description")) {
                    Node descriptionNode = firstChild.getChildNodes().item(0);
                    description = descriptionNode != null ? descriptionNode.getNodeValue() : "";
                } else if (firstChild.getNodeName().equals("colorTotal")) {
                    colorTotal = CrosstabStyle.rgbColor((Node)firstChild);
                } else if (firstChild.getNodeName().equals("colorGroup")) {
                    colorGroup = CrosstabStyle.rgbColor((Node)firstChild);
                } else if (firstChild.getNodeName().equals("colorMeasures")) {
                    colorMeasures = CrosstabStyle.rgbColor((Node)firstChild);
                } else if (firstChild.getNodeName().equals("colorDetail")) {
                    colorDetail = CrosstabStyle.rgbColor((Node)firstChild);
                }
                firstChild = firstChild.getNextSibling();
            }
            CrosstabStyle result = null;
            result = variation != null && baseColor != null ? new CrosstabStyle(baseColor, variation, whiteGrid) : new CrosstabStyle(colorTotal, colorGroup, colorMeasures, colorDetail, whiteGrid);
            result.setDescription(description);
            return result;
        }
        catch (Exception ex) {
            System.out.println("Unable to rebuild the crosstab style");
            ex.printStackTrace();
            return null;
        }
    }

    public String getTemplateName() {
        return TEMPLATE_TYPE;
    }

    public String getResourceNameExport() {
        Collection styles = TemplateStyleView.getTemplateStylesStorage().getStylesDescriptors(TEMPLATE_TYPE);
        return "Crosstab Styles (" + styles.size() + ")";
    }

    public String getResourceNameImport(File exportedContainer) {
        ArrayList loadedStyles = new ArrayList();
        File exportedFolder = new File(exportedContainer, TEMPLATE_TYPE);
        File[] fileArray = exportedFolder.listFiles();
        int n = fileArray.length;
        int n2 = 0;
        while (n2 < n) {
            File styleDefinition = fileArray[n2];
            try {
                String xml = FileUtils.readFileAsAString((File)styleDefinition);
                List fileStyles = TemplateStyleView.getTemplateStylesStorage().readTemplateFromFile(xml);
                loadedStyles.addAll(fileStyles);
            }
            catch (Exception ex) {
                ex.printStackTrace();
            }
            ++n2;
        }
        return "Crosstab Styles (" + loadedStyles.size() + ")";
    }

    public File exportContentFolder(List<IResourceDefinition> resourcesToExport) {
        File destDir;
        block10: {
            File tempDir = new File(System.getProperty("java.io.tmpdir"));
            tempDir.deleteOnExit();
            destDir = new File(tempDir, TEMPLATE_TYPE);
            if (destDir.exists()) {
                FileUtils.recursiveDelete((File)destDir);
            }
            destDir.mkdirs();
            HashSet<TemplateStyle> resourcesToExportSet = new HashSet<TemplateStyle>();
            for (IResourceDefinition definition : resourcesToExport) {
                resourcesToExportSet.add((TemplateStyle)definition.getData());
            }
            Properties props = new Properties();
            Collection styles = TemplateStyleView.getTemplateStylesStorage().getStylesDescriptors(TEMPLATE_TYPE);
            StringBuffer xmlBuffer = new StringBuffer();
            xmlBuffer.append("<?xml version=\"1.0\" encoding=\"UTF-8\" ?>\r\n<templateStyles>");
            int index = 0;
            for (TemplateStyle style : styles) {
                if (!resourcesToExportSet.contains(style)) continue;
                xmlBuffer.append(style.getXMLData());
                props.put((Object)index, style.getDescription());
                ++index;
            }
            xmlBuffer.append("</templateStyles>");
            try {
                FileOutputStream file = new FileOutputStream(new File(destDir, STYLE_FILE_NAME));
                String xml = xmlBuffer.toString();
                ((OutputStream)file).write(xml.getBytes("UTF-8"));
                file.flush();
                ((OutputStream)file).close();
            }
            catch (Exception e) {
                e.printStackTrace();
            }
            FileOutputStream out = null;
            try {
                try {
                    out = new FileOutputStream(new File(destDir, INDEX_FILE_NAME));
                    props.store(out, "Exported Crosstab Styles Index");
                }
                catch (Exception ex) {
                    JaspersoftStudioPlugin.getInstance().logError((Throwable)ex);
                    FileUtils.closeStream(out);
                    break block10;
                }
            }
            catch (Throwable throwable) {
                FileUtils.closeStream(out);
                throw throwable;
            }
            FileUtils.closeStream((Closeable)out);
        }
        return destDir;
    }

    public void restoreContentFolder(File exportedContainer, List<IResourceDefinition> resourcesToImport) {
        HashSet<Integer> stylesToImport = new HashSet<Integer>();
        for (IResourceDefinition resourceToImport : resourcesToImport) {
            stylesToImport.add((Integer)resourceToImport.getData());
        }
        ArrayList<TemplateStyle> loadedStyles = new ArrayList<TemplateStyle>();
        File exportedFolder = new File(exportedContainer, TEMPLATE_TYPE);
        File exportedFile = new File(exportedFolder, STYLE_FILE_NAME);
        try {
            String xml = FileUtils.readFileAsAString((File)exportedFile);
            List fileStyles = TemplateStyleView.getTemplateStylesStorage().readTemplateFromFile(xml);
            int index = 0;
            for (TemplateStyle style : fileStyles) {
                if (stylesToImport.contains(index)) {
                    loadedStyles.add(style);
                }
                ++index;
            }
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
        HashMap existingStyles = this.getExistingStyles(TEMPLATE_TYPE);
        ArrayList<String> duplicatedStyles = new ArrayList<String>();
        for (TemplateStyle style : loadedStyles) {
            if (!existingStyles.containsKey(style.getDescription())) continue;
            duplicatedStyles.add(style.getDescription());
        }
        RunnableOverwriteQuestion.RESPONSE_TYPE response = RunnableOverwriteQuestion.RESPONSE_TYPE.KEEP_BOTH;
        if (duplicatedStyles.size() > 0) {
            response = this.askOverwrite(duplicatedStyles);
        }
        for (TemplateStyle style : loadedStyles) {
            String name = style.getDescription();
            if (existingStyles.containsKey(name)) {
                if (response == RunnableOverwriteQuestion.RESPONSE_TYPE.KEEP_BOTH) {
                    style.setDescription(this.getName(existingStyles, name));
                    TemplateStyleView.getTemplateStylesStorage().addStyle(style);
                    continue;
                }
                if (response != RunnableOverwriteQuestion.RESPONSE_TYPE.OVERWRITE) continue;
                TemplateStyleView.getTemplateStylesStorage().removeStyle((TemplateStyle)existingStyles.get(name));
                TemplateStyleView.getTemplateStylesStorage().addStyle(style);
                continue;
            }
            TemplateStyleView.getTemplateStylesStorage().addStyle(style);
        }
    }

    public List<IResourceDefinition> getRestorableResources(File exportedContainer) {
        block9: {
            String containerPath = exportedContainer.getAbsolutePath();
            if (this.cachedImportableResources == null || !((String)this.cachedImportableResources.getKey()).equals(containerPath)) {
                File exportedFolder = new File(exportedContainer, TEMPLATE_TYPE);
                File indexFile = new File(exportedFolder, INDEX_FILE_NAME);
                if (indexFile.exists()) {
                    FileInputStream is = null;
                    try {
                        try {
                            ArrayList<BaseResource> result = new ArrayList<BaseResource>();
                            is = new FileInputStream(indexFile);
                            Properties loadedProperties = new Properties();
                            loadedProperties.load(is);
                            for (Map.Entry<Object, Object> entry : loadedProperties.entrySet()) {
                                BaseResource resource = new BaseResource(entry.getValue().toString());
                                resource.setData(entry.getKey());
                                result.add(resource);
                            }
                            this.cachedImportableResources = new Pair((Object)containerPath, result);
                        }
                        catch (Exception ex) {
                            JaspersoftStudioPlugin.getInstance().logError((Throwable)ex);
                            this.cachedImportableResources = new Pair((Object)containerPath, new ArrayList());
                            FileUtils.closeStream((Closeable)is);
                            break block9;
                        }
                    }
                    catch (Throwable throwable) {
                        FileUtils.closeStream(is);
                        throw throwable;
                    }
                    FileUtils.closeStream((Closeable)is);
                } else {
                    this.cachedImportableResources = new Pair((Object)containerPath, new ArrayList());
                }
            }
        }
        return (List)this.cachedImportableResources.getValue();
    }

    public List<IResourceDefinition> getExportableResources() {
        if (this.cachedExportableResources == null) {
            Collection styles = TemplateStyleView.getTemplateStylesStorage().getStylesDescriptors(TEMPLATE_TYPE);
            this.cachedExportableResources = new ArrayList<IResourceDefinition>();
            for (TemplateStyle style : styles) {
                BaseResource resource = new BaseResource(style.getDescription());
                resource.setData((Object)style);
                this.cachedExportableResources.add((IResourceDefinition)resource);
            }
        }
        return this.cachedExportableResources;
    }

    private RunnableOverwriteQuestion.RESPONSE_TYPE askOverwrite(List<String> stylesName) {
        String baseMessage = Messages.CrosstabStyle_overlappingMessage;
        StringBuilder message = new StringBuilder();
        int index = 1;
        for (String adapter : stylesName) {
            message.append(adapter);
            message.append(index == stylesName.size() ? "" : "\n");
            ++index;
        }
        String composedMessage = MessageFormat.format(baseMessage, message.toString());
        return RunnableOverwriteQuestion.showQuestion((String)Messages.CrosstabStyle_overlappingTitle, (String)composedMessage);
    }

    private String getName(HashMap<String, TemplateStyle> existingStyles, String baseName) {
        int index = 1;
        String newName = String.valueOf(baseName) + "_" + index;
        while (existingStyles.containsKey(newName)) {
            newName = String.valueOf(baseName) + "_" + ++index;
        }
        return newName;
    }
}

