/*
 * Decompiled with CFR 0.152.
 */
package com.jaspersoft.studio.components.crosstab.model.rowgroup;

import com.jaspersoft.studio.JSSCompoundCommand;
import com.jaspersoft.studio.components.crosstab.CrosstabNodeIconDescriptor;
import com.jaspersoft.studio.components.crosstab.messages.Messages;
import com.jaspersoft.studio.components.crosstab.model.MCrosstab;
import com.jaspersoft.studio.components.crosstab.model.MCrosstabGroup;
import com.jaspersoft.studio.components.crosstab.model.cell.MGroupCell;
import com.jaspersoft.studio.components.crosstab.model.rowgroup.MRowGroups;
import com.jaspersoft.studio.model.ANode;
import com.jaspersoft.studio.model.ICopyable;
import com.jaspersoft.studio.model.IDragable;
import com.jaspersoft.studio.model.INode;
import com.jaspersoft.studio.model.util.IIconDescriptor;
import com.jaspersoft.studio.property.descriptor.NullEnum;
import com.jaspersoft.studio.property.descriptors.NamedEnumPropertyDescriptor;
import com.jaspersoft.studio.property.descriptors.PixelPropertyDescriptor;
import com.jaspersoft.studio.utils.ModelUtils;
import java.beans.PropertyChangeEvent;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import net.sf.jasperreports.crosstabs.JRCrosstabCell;
import net.sf.jasperreports.crosstabs.JRCrosstabGroup;
import net.sf.jasperreports.crosstabs.JRCrosstabRowGroup;
import net.sf.jasperreports.crosstabs.design.JRCrosstabOrigin;
import net.sf.jasperreports.crosstabs.design.JRDesignCellContents;
import net.sf.jasperreports.crosstabs.design.JRDesignCrosstab;
import net.sf.jasperreports.crosstabs.design.JRDesignCrosstabRowGroup;
import net.sf.jasperreports.crosstabs.type.CrosstabRowPositionEnum;
import net.sf.jasperreports.engine.util.Pair;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.ui.views.properties.IPropertyDescriptor;

public class MRowGroup
extends MCrosstabGroup
implements ICopyable,
IDragable {
    public static final long serialVersionUID = 10200L;
    private static IIconDescriptor iconDescriptor;
    private static IPropertyDescriptor[] descriptors;
    private static NamedEnumPropertyDescriptor<CrosstabRowPositionEnum> columnPositionD;

    public static IIconDescriptor getIconDescriptor() {
        if (iconDescriptor == null) {
            iconDescriptor = new CrosstabNodeIconDescriptor("rowgroup");
        }
        return iconDescriptor;
    }

    public MRowGroup() {
    }

    public MRowGroup(ANode parent, JRCrosstabRowGroup jfRield, int newIndex) {
        super(parent, (JRCrosstabGroup)jfRield, newIndex);
    }

    public ImageDescriptor getImagePath() {
        return MRowGroup.getIconDescriptor().getIcon16();
    }

    public String getToolTip() {
        return MRowGroup.getIconDescriptor().getToolTip();
    }

    @Override
    public IPropertyDescriptor[] getDescriptors() {
        return descriptors;
    }

    @Override
    public void setDescriptors(IPropertyDescriptor[] descriptors1) {
        descriptors = descriptors1;
    }

    @Override
    public void createPropertyDescriptors(List<IPropertyDescriptor> desc) {
        super.createPropertyDescriptors(desc);
        columnPositionD = new NamedEnumPropertyDescriptor((Object)"position", Messages.MRowGroup_row_position, (Enum)CrosstabRowPositionEnum.BOTTOM, NullEnum.NOTNULL);
        columnPositionD.setDescription(Messages.MRowGroup_row_position_description);
        desc.add((IPropertyDescriptor)columnPositionD);
        PixelPropertyDescriptor widthD = new PixelPropertyDescriptor((Object)"width", Messages.common_width);
        widthD.setDescription(Messages.MRowGroup_width_description);
        desc.add((IPropertyDescriptor)widthD);
    }

    @Override
    public Object getPropertyValue(Object id) {
        JRDesignCrosstabRowGroup jrField = (JRDesignCrosstabRowGroup)this.getValue();
        if (id.equals("position")) {
            return columnPositionD.getIntValue((Enum)jrField.getPositionValue());
        }
        if (id.equals("width")) {
            return jrField.getWidth();
        }
        return super.getPropertyValue(id);
    }

    @Override
    protected void updateGroups(String oldName, String newName) {
        MCrosstab crosstab = this.getMCrosstab();
        ArrayList<Object> cellsToRefresh = new ArrayList<Object>();
        for (INode child : crosstab.getChildren()) {
            Object cell;
            String rowGroup;
            if (!(child instanceof MGroupCell) || (rowGroup = ((MGroupCell)((Object)(cell = (MGroupCell)child))).getCell().getRowTotalGroup()) == null || !rowGroup.equals(oldName)) continue;
            ((MGroupCell)((Object)cell)).getCell().setRowTotalGroup(newName);
            cellsToRefresh.add(cell);
        }
        List contents = ModelUtils.getAllCells((JRDesignCrosstab)crosstab.getValue());
        for (JRDesignCellContents content : contents) {
            Object origin;
            if (content == null || !ModelUtils.safeEquals((Object)(origin = content.getOrigin()).getRowGroupName(), (Object)oldName)) continue;
            JRCrosstabOrigin jRCrosstabOrigin = new JRCrosstabOrigin(crosstab.getValue(), origin.getType(), newName, origin.getColumnGroupName());
            content.setOrigin(jRCrosstabOrigin);
        }
        Map cellsMap = crosstab.getValue().getCellsMap();
        for (Pair key : new ArrayList(cellsMap.keySet())) {
            if (!ModelUtils.safeEquals((Object)oldName, (Object)key.first())) continue;
            JRCrosstabCell jRCrosstabCell = (JRCrosstabCell)cellsMap.remove(key);
            cellsMap.put(new Pair((Object)newName, (Object)((String)key.second())), jRCrosstabCell);
        }
        JRDesignCrosstab jrCrosstab = crosstab.getValue();
        Map groupMap = jrCrosstab.getRowGroupIndicesMap();
        if (groupMap.containsKey(oldName)) {
            Integer n = (Integer)groupMap.remove(oldName);
            groupMap.put(newName, n);
        }
        for (MGroupCell mGroupCell : cellsToRefresh) {
            JSSCompoundCommand.forceRefreshVisuals((ANode)mGroupCell);
        }
    }

    @Override
    public void setPropertyValue(Object id, Object value) {
        JRDesignCrosstabRowGroup jrField = (JRDesignCrosstabRowGroup)this.getValue();
        if (id.equals("position")) {
            jrField.setPosition((CrosstabRowPositionEnum)columnPositionD.getEnumValue(value));
        } else if (id.equals("width")) {
            jrField.setWidth(((Integer)value).intValue());
            MCrosstab cross = this.getMCrosstab();
            cross.getCrosstabManager().refresh();
            this.getPropertyChangeSupport().firePropertyChange(new PropertyChangeEvent((Object)this, "width", null, value));
        } else {
            super.setPropertyValue(id, value);
        }
    }

    public void propertyChange(PropertyChangeEvent evt) {
        MCrosstab crosstabModel;
        if (evt.getPropertyName().equals("totalPosition") && (crosstabModel = this.getMCrosstab()) != null) {
            JRDesignCrosstab jrCrosstab = crosstabModel.getValue();
            jrCrosstab.getEventSupport().firePropertyChange("updateCrosstabModel", null, this.getValue());
        }
        super.propertyChange(evt);
    }

    public ICopyable.RESULT isCopyable2(Object parent) {
        if (parent instanceof MRowGroups) {
            return ICopyable.RESULT.COPYABLE;
        }
        return ICopyable.RESULT.CHECK_PARENT;
    }

    public boolean isCuttable(ISelection currentSelection) {
        return true;
    }
}

