/*
 * Decompiled with CFR 0.152.
 */
package com.jaspersoft.studio.components.crosstab.part;

import com.jaspersoft.studio.components.crosstab.model.MCrosstab;
import com.jaspersoft.studio.components.crosstab.part.editpolicy.CrosstabCellMoveEditPolicy;
import com.jaspersoft.studio.components.crosstab.part.editpolicy.CrosstabCellResizableEditPolicy;
import com.jaspersoft.studio.editor.gef.parts.APrefFigureEditPart;
import com.jaspersoft.studio.editor.gef.parts.IContainerPart;
import com.jaspersoft.studio.editor.gef.parts.editPolicy.ElementEditPolicy;
import com.jaspersoft.studio.model.IContainer;
import org.eclipse.draw2d.IFigure;
import org.eclipse.draw2d.geometry.Dimension;
import org.eclipse.draw2d.geometry.Point;
import org.eclipse.draw2d.geometry.Rectangle;
import org.eclipse.gef.EditPolicy;
import org.eclipse.gef.GraphicalEditPart;
import org.eclipse.gef.requests.ChangeBoundsRequest;

public abstract class ACrosstabCellEditPart
extends APrefFigureEditPart
implements IContainerPart,
IContainer {
    public static final int X_OFFSET = 10;
    public static final int Y_OFFSET = 10;
    private Dimension containerSize;

    public Object getAdapter(Class key) {
        return this.getParent().getAdapter(key);
    }

    protected void createEditPolicies() {
        this.installEditPolicy("ComponentEditPolicy", (EditPolicy)new ElementEditPolicy());
        this.installEditPolicy("Selection Feedback", (EditPolicy)new CrosstabCellResizableEditPolicy(){

            protected void showSelection() {
                super.showSelection();
                ACrosstabCellEditPart.this.updateRulers();
            }
        });
    }

    public EditPolicy getEditPolicy() {
        return new CrosstabCellMoveEditPolicy();
    }

    protected abstract void setupFigure(IFigure var1);

    public boolean isSelectable() {
        return true;
    }

    public Object getConstraintFor(ChangeBoundsRequest request, GraphicalEditPart child) {
        return new Rectangle(0, 0, request.getSizeDelta().width, request.getSizeDelta().height);
    }

    public void updateRulers() {
        MCrosstab table = this.getCrosstab();
        if (table != null) {
            Dimension d = table.getCrosstabManager().getSize();
            int dh = Math.max(d.height, (Integer)table.getPropertyValue("height"));
            int dw = Math.max(d.width, (Integer)table.getPropertyValue("width"));
            this.getViewer().setProperty("HOFFSET", (Object)10);
            this.getViewer().setProperty("VOFFSET", (Object)10);
            this.getViewer().setProperty("HEND", (Object)dw);
            this.getViewer().setProperty("VEND", (Object)dh);
            this.getViewer().setProperty("SnapToGrid.GridOrigin", (Object)new Point(10, 10));
        }
    }

    public Dimension getContaierSize() {
        return this.containerSize;
    }

    protected void updateContainerSize() {
        MCrosstab table = this.getCrosstab();
        if (table != null) {
            Dimension d = table.getCrosstabManager().getSize();
            d.height = Math.max(d.height, (Integer)table.getPropertyValue("height"));
            d.width = Math.max(d.width, (Integer)table.getPropertyValue("width"));
            this.containerSize = d;
        } else {
            this.containerSize = null;
        }
    }

    protected abstract MCrosstab getCrosstab();
}

