/*
 * Decompiled with CFR 0.152.
 */
package com.jaspersoft.studio.components.engine;

import com.jaspersoft.studio.JaspersoftStudioPlugin;
import com.jaspersoft.studio.components.engine.TableTemplateBundle;
import com.jaspersoft.studio.components.engine.TableTemplateEngine;
import com.jaspersoft.studio.messages.Messages;
import com.jaspersoft.studio.templates.TemplateProvider;
import com.jaspersoft.studio.utils.jasper.JasperReportsConfiguration;
import com.jaspersoft.templates.TemplateBundle;
import com.jaspersoft.templates.TemplateLoadingException;
import java.io.File;
import java.io.FileFilter;
import java.net.URL;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.List;
import java.util.StringTokenizer;
import net.sf.jasperreports.engine.JasperReportsContext;
import net.sf.jasperreports.engine.design.JasperDesign;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;

public class ExtendedTemplateProvider
implements TemplateProvider {
    public static List<TemplateBundle> cache = null;
    public static final String tableTemplateKey = "tabular_template";

    public List<TemplateBundle> getTemplateBundles() {
        ArrayList<TemplateBundle> templates = new ArrayList<TemplateBundle>();
        if (cache == null) {
            cache = new ArrayList<TemplateBundle>();
            Enumeration en = JaspersoftStudioPlugin.getInstance().getBundle().findEntries("templates/table", "*.jrxml", false);
            while (en.hasMoreElements()) {
                URL templateURL = (URL)en.nextElement();
                try {
                    TableTemplateBundle bundle = new TableTemplateBundle(templateURL, (JasperReportsContext)JasperReportsConfiguration.getDefaultInstance());
                    if (bundle == null) continue;
                    cache.add((TemplateBundle)bundle);
                }
                catch (Exception ex) {
                    JaspersoftStudioPlugin.getInstance().getLog().log((IStatus)new Status(4, "com.jaspersoft.studio", MessageFormat.format(Messages.DefaultTemplateProvider_TemplateLoadingErr, templateURL), (Throwable)ex));
                }
            }
        }
        templates.addAll(cache);
        this.loadAdditionalTemplateBundles(templates);
        return templates;
    }

    private void loadAdditionalTemplateBundles(List<TemplateBundle> templates) {
        String paths = JaspersoftStudioPlugin.getInstance().getPreferenceStore().getString("TEMPLATES_LOCATIONS_LIST");
        StringTokenizer st = new StringTokenizer(paths, String.valueOf(File.pathSeparator) + "\n\r");
        ArrayList<String> pathsList = new ArrayList<String>();
        while (st.hasMoreTokens()) {
            pathsList.add(st.nextToken());
        }
        for (String dir : pathsList) {
            File[] files = new File(dir).listFiles(new FileFilter(){

                @Override
                public boolean accept(File f) {
                    return f.getName().endsWith(".jrxml");
                }
            });
            if (files == null) continue;
            File[] fileArray = files;
            int n = files.length;
            int n2 = 0;
            while (n2 < n) {
                File f = fileArray[n2];
                try {
                    TableTemplateBundle bundle = new TableTemplateBundle(f.toURI().toURL(), true, (JasperReportsContext)JasperReportsConfiguration.getDefaultInstance());
                    if (bundle != null && tableTemplateKey.equals(bundle.getProperty("template.engine"))) {
                        templates.add((TemplateBundle)bundle);
                    }
                }
                catch (TemplateLoadingException ex) {
                    JaspersoftStudioPlugin.getInstance().logError((Throwable)ex);
                }
                catch (Exception ex) {
                    JaspersoftStudioPlugin.getInstance().getLog().log((IStatus)new Status(4, "com.jaspersoft.studio", MessageFormat.format(Messages.DefaultTemplateProvider_TemplateLoadingErr, f.getAbsolutePath()), (Throwable)ex));
                }
                ++n2;
            }
        }
    }

    public String getProviderKey() {
        return tableTemplateKey;
    }

    public String getProviderName() {
        return "Table Based Report";
    }

    public List<String> validateTemplate(JasperReportsContext jrContext, JasperDesign design) {
        return TableTemplateEngine.validateJasperDesig(jrContext, design);
    }
}

