/*
 * Decompiled with CFR 0.152.
 */
package com.jaspersoft.studio.components.list.editor;

import com.jaspersoft.studio.JaspersoftStudioPlugin;
import com.jaspersoft.studio.components.list.messages.Messages;
import com.jaspersoft.studio.components.list.model.MList;
import com.jaspersoft.studio.editor.gef.parts.JSSGraphicalViewerKeyHandler;
import com.jaspersoft.studio.editor.gef.parts.JasperDesignEditPartFactory;
import com.jaspersoft.studio.editor.gef.parts.MainDesignerRootEditPart;
import com.jaspersoft.studio.editor.gef.rulers.ReportRuler;
import com.jaspersoft.studio.editor.gef.rulers.ReportRulerProvider;
import com.jaspersoft.studio.editor.java2d.ISelectionOverrider;
import com.jaspersoft.studio.editor.java2d.JSSScrollingGraphicalViewer;
import com.jaspersoft.studio.editor.name.NamedSubeditor;
import com.jaspersoft.studio.editor.report.MarqueeSelectionOverrider;
import com.jaspersoft.studio.editor.report.ParentSelectionOverrider;
import com.jaspersoft.studio.model.ANode;
import com.jaspersoft.studio.model.IContainer;
import com.jaspersoft.studio.model.INode;
import com.jaspersoft.studio.model.util.ModelVisitor;
import com.jaspersoft.studio.property.dataset.dialog.ContextualDatasetAction;
import com.jaspersoft.studio.property.dataset.dialog.DatasetAction;
import com.jaspersoft.studio.utils.AContributorAction;
import com.jaspersoft.studio.utils.jasper.JasperReportsConfiguration;
import java.util.ArrayList;
import java.util.List;
import net.sf.jasperreports.engine.base.JRBaseElement;
import org.eclipse.draw2d.ColorConstants;
import org.eclipse.gef.EditPartFactory;
import org.eclipse.gef.GraphicalViewer;
import org.eclipse.gef.KeyHandler;
import org.eclipse.gef.RootEditPart;
import org.eclipse.gef.ui.actions.ActionRegistry;
import org.eclipse.jface.action.ActionContributionItem;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.action.IContributionItem;
import org.eclipse.jface.action.IToolBarManager;
import org.eclipse.jface.action.Separator;
import org.eclipse.ui.IWorkbenchPart;

public class ListEditor
extends NamedSubeditor {
    public ListEditor(JasperReportsConfiguration jrContext) {
        super(jrContext);
        this.setPartName(this.getDefaultEditorName());
        this.setPartImage(JaspersoftStudioPlugin.getInstance().getImage(MList.getIconDescriptor().getIcon16()));
    }

    protected void configureGraphicalViewer() {
        super.configureGraphicalViewer();
        this.getGraphicalViewer().getControl().setBackground(ColorConstants.button);
        GraphicalViewer graphicalViewer = this.getGraphicalViewer();
        MainDesignerRootEditPart rootEditPart = new MainDesignerRootEditPart();
        graphicalViewer.setRootEditPart((RootEditPart)rootEditPart);
        graphicalViewer.setEditPartFactory((EditPartFactory)new JasperDesignEditPartFactory());
        ReportRulerProvider provider = new ReportRulerProvider(new ReportRuler(true, 2));
        graphicalViewer.setProperty("horizontal ruler", (Object)provider);
        provider = new ReportRulerProvider(new ReportRuler(false, 2));
        graphicalViewer.setProperty("vertical ruler", (Object)provider);
        Boolean isRulerVisible = this.jrContext.getPropertyBoolean("pageRulerGrid_SHOWRULER");
        graphicalViewer.setProperty("ruler$visibility", (Object)isRulerVisible);
        this.createAdditionalActions();
        graphicalViewer.setKeyHandler((KeyHandler)new JSSGraphicalViewerKeyHandler(graphicalViewer));
        if (graphicalViewer instanceof JSSScrollingGraphicalViewer) {
            JSSScrollingGraphicalViewer jssViewer = (JSSScrollingGraphicalViewer)graphicalViewer;
            jssViewer.addSelectionOverrider((ISelectionOverrider)new ParentSelectionOverrider(IContainer.class, true));
            jssViewer.addSelectionOverrider((ISelectionOverrider)new MarqueeSelectionOverrider());
        }
    }

    protected void createEditorActions(ActionRegistry registry) {
        super.createEditorActions(registry);
        this.createDatasetAndStyleActions(registry);
        List selectionActions = this.getSelectionActions();
        DatasetAction action = new DatasetAction((IWorkbenchPart)this);
        registry.registerAction((IAction)action);
        selectionActions.add(action.getId());
        action = new ContextualDatasetAction((IWorkbenchPart)this);
        registry.registerAction((IAction)action);
        selectionActions.add(action.getId());
    }

    public void contributeItemsToEditorTopToolbar(IToolBarManager toolbarManager) {
        ActionContributionItem item = new ActionContributionItem(this.getActionRegistry().getAction((Object)"datasetAction"));
        this.act4TextIcon.add(item);
        toolbarManager.add((IContributionItem)item);
        List contributedActions = JaspersoftStudioPlugin.getExtensionManager().getActions();
        for (AContributorAction a : contributedActions) {
            a.setJrConfig((JasperReportsConfiguration)this.getGraphicalViewer().getProperty("JRCONTEXT"));
            item = new ActionContributionItem((IAction)a);
            this.act4TextIcon.add(item);
            toolbarManager.add((IContributionItem)item);
        }
        toolbarManager.add((IContributionItem)new Separator());
        super.contributeItemsToEditorTopToolbar(toolbarManager);
    }

    protected List<String> getIgnorePalleteElements() {
        ArrayList<String> lst = new ArrayList<String>();
        lst.add("com.jaspersoft.studio.components.crosstab.model.MCrosstab");
        return lst;
    }

    public String getDefaultEditorName() {
        return Messages.common_list;
    }

    public ANode getEditedNode() {
        INode model = this.getModel();
        if (model != null) {
            ModelVisitor<MList> mv = new ModelVisitor<MList>(model){

                public boolean visit(INode n) {
                    if (n instanceof MList) {
                        this.setObject((Object)((MList)n));
                        this.stop();
                    }
                    return true;
                }
            };
            return (ANode)mv.getObject();
        }
        return null;
    }

    public String getEditorName() {
        ANode node = this.getEditedNode();
        if (node != null && node.getValue() instanceof JRBaseElement) {
            JRBaseElement el = (JRBaseElement)node.getValue();
            return el.getPropertiesMap().getProperty("com.jaspersoft.studio.element.name");
        }
        return null;
    }
}

