/*
 * Decompiled with CFR 0.152.
 */
package com.jaspersoft.studio.components.list.part;

import com.jaspersoft.studio.JSSCompoundCommand;
import com.jaspersoft.studio.callout.CalloutEditPart;
import com.jaspersoft.studio.callout.command.CalloutSetConstraintCommand;
import com.jaspersoft.studio.callout.pin.PinEditPart;
import com.jaspersoft.studio.callout.pin.command.PinSetConstraintCommand;
import com.jaspersoft.studio.compatibility.ToolUtilitiesCompatibility;
import com.jaspersoft.studio.components.SubEditorEditPartTracker;
import com.jaspersoft.studio.components.SubeditorResizableEditPolicy;
import com.jaspersoft.studio.components.list.ListComponentFactory;
import com.jaspersoft.studio.components.list.figure.ListFigure;
import com.jaspersoft.studio.components.list.model.MList;
import com.jaspersoft.studio.editor.action.create.CreateElementAction;
import com.jaspersoft.studio.editor.gef.commands.SetPageConstraintCommand;
import com.jaspersoft.studio.editor.gef.parts.EditableFigureEditPart;
import com.jaspersoft.studio.editor.gef.parts.SnapToGeometryThreshold;
import com.jaspersoft.studio.editor.gef.parts.editPolicy.FigurePageLayoutEditPolicy;
import com.jaspersoft.studio.editor.gef.parts.editPolicy.FigureSelectionEditPolicy;
import com.jaspersoft.studio.editor.gef.parts.editPolicy.SearchParentDragTracker;
import com.jaspersoft.studio.editor.outline.OutlineTreeEditPartFactory;
import com.jaspersoft.studio.editor.outline.editpolicy.CloseSubeditorDeletePolicy;
import com.jaspersoft.studio.model.ANode;
import com.jaspersoft.studio.model.MGraphicElement;
import com.jaspersoft.studio.model.MPage;
import com.jaspersoft.studio.model.command.CreateElementCommand;
import java.util.ArrayList;
import java.util.Collection;
import net.sf.jasperreports.engine.design.JRDesignElement;
import org.eclipse.draw2d.IFigure;
import org.eclipse.draw2d.geometry.Rectangle;
import org.eclipse.gef.CompoundSnapToHelper;
import org.eclipse.gef.DragTracker;
import org.eclipse.gef.EditPart;
import org.eclipse.gef.EditPolicy;
import org.eclipse.gef.GraphicalEditPart;
import org.eclipse.gef.Request;
import org.eclipse.gef.SnapToGrid;
import org.eclipse.gef.SnapToGuides;
import org.eclipse.gef.SnapToHelper;
import org.eclipse.gef.commands.Command;
import org.eclipse.gef.requests.CreateRequest;

public class ListEditPart
extends EditableFigureEditPart {
    protected IFigure createFigure() {
        ListFigure rect = new ListFigure((MList)this.getModel());
        this.setupListFigure((IFigure)rect);
        this.setPrefsBorder((IFigure)rect);
        this.setupFigure((IFigure)rect);
        this.figure = rect;
        return rect;
    }

    protected void setupListFigure(IFigure rect) {
        MList model = (MList)this.getModel();
        ListFigure lfig = (ListFigure)rect;
        Integer h = (Integer)model.getPropertyValue("CONTENTS.height");
        if (h == null) {
            h = (Integer)model.getPropertyValue("height");
        }
        lfig.setCellHeight(h);
        Integer w = (Integer)model.getPropertyValue("CONTENTS.width");
        if (w == null) {
            w = (Integer)model.getPropertyValue("width");
        }
        lfig.setCellWidth(w);
    }

    public void refreshVisuals() {
        this.setupListFigure(this.getFigure());
        super.refreshVisuals();
    }

    protected void createEditPolicies() {
        this.installEditPolicy("ComponentEditPolicy", (EditPolicy)new CloseSubeditorDeletePolicy());
        this.installEditPolicy("LayoutEditPolicy", (EditPolicy)new FigurePageLayoutEditPolicy(){

            protected Command getCreateCommand(CreateRequest request) {
                Rectangle constraint = (Rectangle)this.getConstraintFor(request);
                if (request.getNewObject() instanceof CreateElementAction) {
                    CreateElementAction action = (CreateElementAction)request.getNewObject();
                    action.dropInto(this.getHost().getModel(), constraint.getCopy(), -1);
                    action.run();
                    return action.getCommand();
                }
                if (request.getNewObject() instanceof MGraphicElement) {
                    return OutlineTreeEditPartFactory.getCreateCommand((ANode)((ANode)this.getHost().getModel()), (ANode)((ANode)request.getNewObject()), (Rectangle)constraint.getCopy(), (int)-1, (Request)request, (boolean)false);
                }
                if (request.getNewObject() instanceof Collection) {
                    JSSCompoundCommand cmd = new JSSCompoundCommand(null);
                    Collection c = (Collection)request.getNewObject();
                    for (Object obj : c) {
                        if (!(obj instanceof ANode)) continue;
                        ANode aObj = (ANode)obj;
                        cmd.setReferenceNodeIfNull(aObj);
                        cmd.add(OutlineTreeEditPartFactory.getCreateCommand((ANode)((ANode)this.getHost().getModel()), (ANode)aObj, (Rectangle)constraint.getCopy(), (int)-1, (Request)request, (boolean)false));
                    }
                    return cmd;
                }
                return null;
            }

            /*
             * Enabled force condition propagation
             * Lifted jumps to return sites
             */
            protected Command createAddCommand(EditPart child, Object constraint) {
                Rectangle rect = (Rectangle)constraint;
                if (child.getModel() instanceof MGraphicElement) {
                    MGraphicElement cmodel = (MGraphicElement)child.getModel();
                    if (cmodel.getParent() instanceof MList) {
                        MList cparent = (MList)cmodel.getParent();
                        if (cparent != ListEditPart.this.getModel()) return null;
                        Rectangle r = cmodel.getBounds();
                        SetPageConstraintCommand cmd = new SetPageConstraintCommand();
                        JRDesignElement jde = cmodel.getValue();
                        int x = r.x + rect.x - jde.getX() + 2;
                        int y = r.y + rect.y - jde.getY() + 2;
                        rect.setLocation(x, y);
                        cmd.setContext((ANode)this.getHost().getModel(), (ANode)child.getModel(), rect);
                        return cmd;
                    }
                    JSSCompoundCommand c = new JSSCompoundCommand((ANode)cmodel);
                    c.add(OutlineTreeEditPartFactory.getOrphanCommand((ANode)cmodel.getParent(), (ANode)cmodel));
                    c.add((Command)new CreateElementCommand((ANode)((MList)ListEditPart.this.getModel()), cmodel, rect, -1));
                    return c;
                }
                if (child instanceof CalloutEditPart) {
                    return new CalloutSetConstraintCommand(((CalloutEditPart)child).getModel(), this.adaptConstraint(constraint));
                }
                if (!(child instanceof PinEditPart)) return super.createChangeConstraintCommand(child, constraint);
                return new PinSetConstraintCommand(((PinEditPart)child).getModel(), this.adaptConstraint(constraint));
            }
        });
        this.installEditPolicy("Selection Feedback", (EditPolicy)new FigureSelectionEditPolicy());
        this.installEditPolicy("PrimaryDrag Policy", (EditPolicy)new SubeditorResizableEditPolicy());
    }

    public void performRequest(Request req) {
        if ("open".equals(req.getType())) {
            MList model = (MList)this.getModel();
            Command c = ListComponentFactory.INST().getStretchToContent((ANode)model);
            if (c != null) {
                this.getViewer().getEditDomain().getCommandStack().execute(c);
            }
        }
        super.performRequest(req);
    }

    public Object getAdapter(Class key) {
        if (key == SnapToHelper.class) {
            ArrayList<Object> snapStrategies = new ArrayList<Object>();
            Boolean val = this.jConfig.getPropertyBoolean("pageRulerGrid_SHOWRULER", Boolean.TRUE.booleanValue());
            Boolean stg = this.jConfig.getPropertyBoolean("pageRulerGrid_SNAPTOGUIDES", Boolean.TRUE.booleanValue());
            if (val.booleanValue() && stg != null && stg.booleanValue()) {
                snapStrategies.add(new SnapToGuides((GraphicalEditPart)this));
            }
            if ((val = this.jConfig.getPropertyBoolean("pageRulerGrid_SNAPTOGEOMETRY", Boolean.TRUE.booleanValue())).booleanValue()) {
                SnapToGeometryThreshold snapper = new SnapToGeometryThreshold((GraphicalEditPart)this);
                snapper.setThreshold(2.0);
                snapStrategies.add(snapper);
            }
            if ((val = this.jConfig.getPropertyBoolean("pageRulerGrid_SNAPTOGRID", Boolean.TRUE.booleanValue())).booleanValue()) {
                snapStrategies.add(new SnapToGrid((GraphicalEditPart)this));
            }
            if (snapStrategies.size() == 0) {
                return null;
            }
            if (snapStrategies.size() == 1) {
                return snapStrategies.get(0);
            }
            SnapToHelper[] ss = new SnapToHelper[snapStrategies.size()];
            int i = 0;
            while (i < snapStrategies.size()) {
                ss[i] = (SnapToHelper)snapStrategies.get(i);
                ++i;
            }
            return new CompoundSnapToHelper(ss);
        }
        return super.getAdapter(key);
    }

    public DragTracker getDragTracker(Request request) {
        if (ToolUtilitiesCompatibility.isSubeditorMainElement((EditPart)this)) {
            return new SubEditorEditPartTracker((EditPart)this);
        }
        return new SearchParentDragTracker((EditPart)this);
    }

    public EditPart getDropContainer() {
        if (this.getModel().getParent() instanceof MPage) {
            return this;
        }
        return ListEditPart.getParentEditPart((EditPart)this);
    }
}

