/*
 * Decompiled with CFR 0.152.
 */
package com.jaspersoft.studio.components.map.model.itemdata.dialog;

import com.jaspersoft.studio.components.map.messages.Messages;
import com.jaspersoft.studio.editor.expression.ExpressionContext;
import com.jaspersoft.studio.jface.dialogs.EditableDatasetBaseComposite;
import com.jaspersoft.studio.model.dataset.ComponentElementDatasetAdapter;
import com.jaspersoft.studio.model.dataset.ComponentElementDatasetRunAdapter;
import com.jaspersoft.studio.model.dataset.IEditableDataset;
import com.jaspersoft.studio.model.dataset.IEditableDatasetRun;
import com.jaspersoft.studio.property.dataset.DatasetRunSelectionListener;
import com.jaspersoft.studio.utils.ModelUtils;
import com.jaspersoft.studio.utils.jasper.JasperReportsConfiguration;
import net.sf.jasperreports.engine.JRDatasetRun;
import net.sf.jasperreports.engine.JRElementDataset;
import net.sf.jasperreports.engine.design.JRDesignDataset;
import net.sf.jasperreports.engine.design.JRDesignElementDataset;
import net.sf.jasperreports.engine.design.JasperDesign;
import org.eclipse.jface.dialogs.TitleAreaDialog;
import org.eclipse.swt.layout.FillLayout;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;

public class ElementDatasetDialog
extends TitleAreaDialog {
    private String title;
    private String message;
    private JRDesignElementDataset dataset;
    private JasperReportsConfiguration jConfig;
    private ExpressionContext defaultExpressionContext;

    public ElementDatasetDialog(Shell parentShell, String title, String message, JRElementDataset dataset, JasperReportsConfiguration jConfig) {
        super(parentShell);
        this.title = title;
        this.message = message;
        this.dataset = (JRDesignElementDataset)dataset;
        if (this.dataset == null) {
            this.dataset = new JRDesignElementDataset();
        }
        this.jConfig = jConfig;
    }

    protected void configureShell(Shell newShell) {
        super.configureShell(newShell);
        newShell.setText(Messages.ElementDatasetDialog_DialogTitle);
    }

    protected void setShellStyle(int newShellStyle) {
        super.setShellStyle(newShellStyle | 0x10);
    }

    protected Control createDialogArea(Composite parent) {
        Composite area = (Composite)super.createDialogArea(parent);
        Composite container = new Composite(area, 0);
        container.setLayout((Layout)new FillLayout());
        container.setLayoutData((Object)new GridData(4, 4, true, true));
        final EditableDatasetBaseComposite compositeDatasetInfo = new EditableDatasetBaseComposite((IEditableDataset)new ComponentElementDatasetAdapter(this.dataset, this.jConfig), container, 0){

            protected IEditableDatasetRun getEditableDatesetRun() {
                return new ComponentElementDatasetRunAdapter(this.getEditableDataset());
            }
        };
        compositeDatasetInfo.addDatasetRunSelectionListener(new DatasetRunSelectionListener(){

            public void selectionChanged() {
                ExpressionContext contextFromDSRun = ElementDatasetDialog.this.getExpressionContextFromDSRun();
                compositeDatasetInfo.setExpressionContext(contextFromDSRun);
            }
        });
        compositeDatasetInfo.setExpressionContext(this.getExpressionContextFromDSRun());
        compositeDatasetInfo.setDefaultExpressionContext(this.defaultExpressionContext);
        this.setTitle(this.title);
        this.setMessage(this.message);
        return area;
    }

    public void setDefaultExpressionContext(ExpressionContext expContext) {
        this.defaultExpressionContext = expContext;
    }

    private ExpressionContext getExpressionContextFromDSRun() {
        if (this.dataset != null) {
            JRDesignDataset ds = ModelUtils.getDesignDatasetForDatasetRun((JasperDesign)this.jConfig.getJasperDesign(), (JRDatasetRun)this.dataset.getDatasetRun());
            return new ExpressionContext(ds, this.jConfig);
        }
        return null;
    }

    public JRElementDataset getDataset() {
        return this.dataset;
    }
}

