/*
 * Decompiled with CFR 0.152.
 */
package com.jaspersoft.studio.components.map.model.marker.dialog;

import com.jaspersoft.studio.components.Activator;
import com.jaspersoft.studio.components.map.messages.Messages;
import com.jaspersoft.studio.components.map.model.marker.MarkerCoordinatesType;
import com.jaspersoft.studio.components.map.model.marker.dialog.MarkerPropertyDialog;
import com.jaspersoft.studio.components.map.model.marker.dialog.TMarkerPropertyLabelProvider;
import com.jaspersoft.studio.editor.expression.ExpressionContext;
import com.jaspersoft.studio.swt.widgets.table.DeleteButton;
import com.jaspersoft.studio.swt.widgets.table.EditButton;
import com.jaspersoft.studio.swt.widgets.table.IEditElement;
import com.jaspersoft.studio.swt.widgets.table.INewElement;
import com.jaspersoft.studio.swt.widgets.table.ListContentProvider;
import com.jaspersoft.studio.swt.widgets.table.ListOrderButtons;
import com.jaspersoft.studio.swt.widgets.table.NewButton;
import java.util.ArrayList;
import java.util.List;
import net.sf.jasperreports.components.items.ItemProperty;
import net.sf.jasperreports.components.items.StandardItem;
import net.sf.jasperreports.components.items.StandardItemProperty;
import net.sf.jasperreports.eclipse.ui.util.PersistentLocationDialog;
import org.eclipse.jface.viewers.ColumnLayoutData;
import org.eclipse.jface.viewers.ColumnWeightData;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.TableLayout;
import org.eclipse.jface.viewers.TableViewer;
import org.eclipse.swt.events.MouseEvent;
import org.eclipse.swt.events.MouseListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Table;
import org.eclipse.swt.widgets.TableColumn;

public class MarkerDialog
extends PersistentLocationDialog {
    private MarkerCoordinatesType coordinatesType = MarkerCoordinatesType.LATITUDE_LONGITUDE;
    private StandardItem value;
    private Table table;
    private TableViewer tableViewer;
    private EditButton<ItemProperty> editButton;
    private String propsDescFile;
    private ExpressionContext expContext;

    private boolean isPropertyMandatory(ItemProperty mprop) {
        return "id".equals(mprop.getName()) || this.coordinatesType.isMandatoryProperty(mprop.getName());
    }

    public MarkerDialog(Shell parentShell) {
        this(parentShell, MarkerCoordinatesType.LATITUDE_LONGITUDE, null);
        try {
            this.propsDescFile = Activator.getDefault().getFileLocation("resources/googleMap.properties");
        }
        catch (Exception exception) {}
    }

    public MarkerDialog(Shell parentShell, MarkerCoordinatesType coordinatesType, String propsDescFile) {
        super(parentShell);
        this.coordinatesType = coordinatesType;
        this.propsDescFile = propsDescFile;
    }

    protected void configureShell(Shell newShell) {
        super.configureShell(newShell);
        newShell.setText(Messages.MarkerDialog_Title);
    }

    protected boolean isResizable() {
        return true;
    }

    public boolean close() {
        this.value.getProperties().clear();
        List in = (List)this.tableViewer.getInput();
        this.value.getProperties().addAll(in);
        return super.close();
    }

    protected Control createDialogArea(Composite parent) {
        Composite composite = (Composite)super.createDialogArea(parent);
        composite.setLayout((Layout)new GridLayout(2, false));
        this.buildTable(composite);
        GridData gd = new GridData(1808);
        gd.heightHint = 200;
        gd.widthHint = 500;
        this.table.setLayoutData((Object)gd);
        Composite bGroup = new Composite(composite, 0);
        bGroup.setLayout((Layout)new GridLayout(1, false));
        bGroup.setLayoutData((Object)new GridData(1040));
        new NewButton().createNewButtons(bGroup, this.tableViewer, new INewElement(){

            public Object newElement(List<?> input, int pos) {
                StandardItemProperty v = new StandardItemProperty("property", "value", null);
                MarkerPropertyDialog dialog = new MarkerPropertyDialog(Display.getDefault().getActiveShell(), MarkerDialog.this.propsDescFile);
                dialog.setValue(v, MarkerDialog.this.expContext, MarkerDialog.this.isPropertyMandatory((ItemProperty)v));
                if (dialog.open() == 0) {
                    return v;
                }
                return null;
            }
        });
        this.editButton = new EditButton();
        this.editButton.createEditButtons(bGroup, this.tableViewer, (IEditElement)new EditElement());
        new DeleteButton(){

            protected boolean canRemove(Object obj) {
                if (obj instanceof ItemProperty) {
                    return !MarkerDialog.this.isPropertyMandatory((ItemProperty)obj);
                }
                return super.canRemove(obj);
            }
        }.createDeleteButton(bGroup, this.tableViewer);
        new ListOrderButtons().createOrderButtons(bGroup, this.tableViewer);
        this.fillValue(this.value);
        return composite;
    }

    private void buildTable(Composite composite) {
        this.table = new Table(composite, 68100);
        this.table.setHeaderVisible(true);
        this.table.addMouseListener(new MouseListener(){

            public void mouseUp(MouseEvent e) {
            }

            public void mouseDown(MouseEvent e) {
            }

            public void mouseDoubleClick(MouseEvent e) {
                MarkerDialog.this.editButton.push();
            }
        });
        this.tableViewer = new TableViewer(this.table);
        this.tableViewer.setContentProvider((IContentProvider)new ListContentProvider());
        this.tableViewer.setLabelProvider((IBaseLabelProvider)new TMarkerPropertyLabelProvider());
        TableColumn[] column = new TableColumn[2];
        column[0] = new TableColumn(this.table, 0);
        column[0].setText(Messages.MarkerDialog_Name);
        column[1] = new TableColumn(this.table, 0);
        column[1].setText(Messages.MarkerDialog_ValueOrExpression);
        int i = 0;
        int n = column.length;
        while (i < n) {
            column[i].pack();
            ++i;
        }
        TableLayout tlayout = new TableLayout();
        tlayout.addColumnData((ColumnLayoutData)new ColumnWeightData(45, true));
        tlayout.addColumnData((ColumnLayoutData)new ColumnWeightData(55, true));
        this.table.setLayout((Layout)tlayout);
    }

    public void setValue(StandardItem value, ExpressionContext expContext) {
        this.value = value;
        this.expContext = expContext;
    }

    private void fillValue(StandardItem value) {
        ArrayList<ItemProperty> mprops = new ArrayList<ItemProperty>();
        for (ItemProperty smp : value.getProperties()) {
            mprops.add(smp);
        }
        this.tableViewer.setInput(mprops);
    }

    private final class EditElement
    implements IEditElement<ItemProperty> {
        private EditElement() {
        }

        public void editElement(List<ItemProperty> input, int pos) {
            StandardItemProperty v = (StandardItemProperty)input.get(pos);
            if (v == null) {
                return;
            }
            v = (StandardItemProperty)v.clone();
            MarkerPropertyDialog dialog = new MarkerPropertyDialog(Display.getDefault().getActiveShell(), MarkerDialog.this.propsDescFile);
            dialog.setValue(v, MarkerDialog.this.expContext, MarkerDialog.this.isPropertyMandatory((ItemProperty)v));
            if (dialog.open() == 0) {
                input.set(pos, (ItemProperty)v);
            }
        }
    }
}

