/*
 * Decompiled with CFR 0.152.
 */
package com.jaspersoft.studio.components.map.model.path;

import com.jaspersoft.studio.components.Activator;
import com.jaspersoft.studio.components.map.messages.Messages;
import com.jaspersoft.studio.components.map.model.itemdata.ElementDataHelper;
import com.jaspersoft.studio.components.map.model.itemdata.dto.MapDataElementDTO;
import com.jaspersoft.studio.components.map.model.itemdata.dto.MapDataElementItemDTO;
import net.sf.jasperreports.components.items.ItemProperty;
import org.eclipse.jface.viewers.LabelProvider;
import org.eclipse.osgi.util.NLS;
import org.eclipse.swt.graphics.Image;

public class PathsLabelProvider
extends LabelProvider {
    private static final String LATITUDE_ATTRIBUTE = "latitude";
    private static final String LONGITUDE_ATTRIBUTE = "longitude";

    public String getText(Object element) {
        if (element instanceof MapDataElementDTO) {
            ItemProperty name = ((MapDataElementDTO)element).getName();
            if (name != null) {
                return String.valueOf(Messages.PathsLabelProvider_PathPrefix) + ElementDataHelper.getItemPropertyValueAsString(name);
            }
            return String.valueOf(Messages.PathsLabelProvider_PathPrefix) + "<default>";
        }
        if (element instanceof MapDataElementItemDTO) {
            String lat = ElementDataHelper.getItemPropertyValueAsString(((MapDataElementItemDTO)element).getItem(), LATITUDE_ATTRIBUTE);
            String lon = ElementDataHelper.getItemPropertyValueAsString(((MapDataElementItemDTO)element).getItem(), LONGITUDE_ATTRIBUTE);
            return NLS.bind((String)Messages.PathsLabelProvider_ItemAt, (Object)lat, (Object)lon);
        }
        return super.getText(element);
    }

    public Image getImage(Object element) {
        if (element instanceof MapDataElementDTO) {
            return Activator.getDefault().getImage("/icons/path-icon-16.png");
        }
        if (element instanceof MapDataElementItemDTO) {
            return Activator.getDefault().getImage("/icons/pathitem-icon-16.png");
        }
        return super.getImage(element);
    }
}

