/*
 * Decompiled with CFR 0.152.
 */
package com.jaspersoft.studio.components.map.property;

import com.jaspersoft.studio.widgets.framework.IPropertyEditor;
import net.sf.jasperreports.components.items.Item;
import net.sf.jasperreports.components.items.ItemProperty;
import net.sf.jasperreports.components.items.StandardItem;
import net.sf.jasperreports.components.items.StandardItemProperty;
import net.sf.jasperreports.engine.JRExpression;

public class ItemElementPropertyEditor
implements IPropertyEditor {
    private Item item;

    public ItemElementPropertyEditor(Item item) {
        this.item = item;
    }

    public String getPropertyValue(String propertyName) {
        for (ItemProperty prop : this.item.getProperties()) {
            if (!prop.getName().equals(propertyName)) continue;
            StandardItemProperty stdProp = (StandardItemProperty)prop;
            return stdProp.getValue();
        }
        return null;
    }

    public JRExpression getPropertyValueExpression(String propertyName) {
        for (ItemProperty prop : this.item.getProperties()) {
            if (!prop.getName().equals(propertyName)) continue;
            StandardItemProperty stdProp = (StandardItemProperty)prop;
            return stdProp.getValueExpression();
        }
        return null;
    }

    public void createUpdateProperty(String propertyName, String value, JRExpression valueExpression) {
        boolean found = false;
        for (ItemProperty prop : this.item.getProperties()) {
            if (!prop.getName().equals(propertyName)) continue;
            StandardItemProperty stdProp = (StandardItemProperty)prop;
            stdProp.setValue(value);
            stdProp.setValueExpression(valueExpression);
            found = true;
            break;
        }
        if (!found) {
            ((StandardItem)this.item).addItemProperty((ItemProperty)new StandardItemProperty(propertyName, value, valueExpression));
        }
    }

    public void removeProperty(String propertyName) {
        for (ItemProperty prop : this.item.getProperties()) {
            if (!prop.getName().equals(propertyName)) continue;
            ((StandardItem)this.item).removeItemProperty(prop);
            break;
        }
    }
}

