/*
 * Decompiled with CFR 0.152.
 */
package com.jaspersoft.studio.components.table.action;

import com.jaspersoft.studio.JSSCompoundCommand;
import com.jaspersoft.studio.JaspersoftStudioPlugin;
import com.jaspersoft.studio.components.Activator;
import com.jaspersoft.studio.components.table.action.RemoveStyleCommand;
import com.jaspersoft.studio.components.table.messages.Messages;
import com.jaspersoft.studio.components.table.model.MTable;
import com.jaspersoft.studio.editor.action.ACachedSelectionAction;
import com.jaspersoft.studio.editor.gef.parts.FigureEditPart;
import com.jaspersoft.studio.model.ANode;
import com.jaspersoft.studio.model.MReport;
import com.jaspersoft.studio.model.command.ForceRefreshCommand;
import com.jaspersoft.studio.model.style.command.DeleteStyleCommand;
import com.jaspersoft.studio.property.SetPropertyValueCommand;
import com.jaspersoft.studio.utils.ModelUtils;
import java.util.HashSet;
import java.util.List;
import net.sf.jasperreports.components.table.BaseColumn;
import net.sf.jasperreports.components.table.Cell;
import net.sf.jasperreports.components.table.DesignCell;
import net.sf.jasperreports.components.table.GroupCell;
import net.sf.jasperreports.components.table.StandardColumn;
import net.sf.jasperreports.components.table.StandardColumnGroup;
import net.sf.jasperreports.components.table.StandardTable;
import net.sf.jasperreports.eclipse.ui.util.ExtendedMessageDialog;
import net.sf.jasperreports.eclipse.ui.util.UIUtils;
import net.sf.jasperreports.engine.JRPropertiesMap;
import net.sf.jasperreports.engine.JRStyle;
import net.sf.jasperreports.engine.design.JRDesignComponentElement;
import net.sf.jasperreports.engine.design.JRDesignStyle;
import org.eclipse.gef.EditPart;
import org.eclipse.gef.commands.Command;
import org.eclipse.jface.preference.IPreferenceStore;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.IWorkbenchPart;

public class RemoveTableStylesAction
extends ACachedSelectionAction {
    public static final String ID = "com.jaspersoft.studio.components.table.action.RemoveTableStyles";
    private boolean deleteStyles = false;
    private HashSet<String> deletedStyles;

    public RemoveTableStylesAction(IWorkbenchPart part) {
        super(part);
        this.setText(Messages.RemoveStylesAction_actionTitle);
        this.setId(ID);
        this.setImageDescriptor(Activator.getDefault().getImageDescriptor("icons/table-style-remove-16.png"));
    }

    protected boolean calculateEnabled() {
        List tables = this.editor.getSelectionCache().getSelectionModelForType(MTable.class);
        for (Object obj : tables) {
            MTable table = (MTable)((Object)obj);
            StandardTable jrTable = (StandardTable)((JRDesignComponentElement)table.getValue()).getComponent();
            if (!this.hasStyles(jrTable.getColumns())) continue;
            return true;
        }
        return false;
    }

    private List<EditPart> getSelectedTables() {
        List result = this.editor.getSelectionCache().getSelectionModelPartForType(MTable.class);
        return result;
    }

    public void run() {
        this.deleteStyles = false;
        int selection = this.getResponse();
        if (selection != 2 && selection != -1) {
            this.deleteStyles = selection == 0;
            List<EditPart> parts = this.getSelectedTables();
            this.execute(this.changeStyleCommand(parts));
            for (EditPart part : parts) {
                if (!(part instanceof FigureEditPart)) continue;
                ((FigureEditPart)part).refreshVisuals();
            }
        }
    }

    protected int getResponse() {
        IPreferenceStore store = JaspersoftStudioPlugin.getInstance().getPreferenceStore();
        String styleBehavior = store.getString("tableCrosstabDeleteStyle");
        if (styleBehavior.equals("deleteStyles")) {
            return 0;
        }
        if (styleBehavior.equals("deleteStylesReferences")) {
            return 1;
        }
        Shell shell = UIUtils.getShell();
        ExtendedMessageDialog question = new ExtendedMessageDialog(shell, Messages.RemoveStylesAction_messageTitle, null, Messages.RemoveStylesAction_messageText, 3, new String[]{Messages.RemoveStylesAction_option1, Messages.RemoveStylesAction_option2, Messages.RemoveStylesAction_option3}, 2, Messages.EditTableStyleAction_rememberDecision);
        int response = question.open();
        if (question.getCheckboxResult()) {
            if (response == 0) {
                store.setValue("tableCrosstabDeleteStyle", "deleteStyles");
            } else if (response == 1) {
                store.setValue("tableCrosstabDeleteStyle", "deleteStylesReferences");
            }
        }
        return response;
    }

    protected void createCommand(Cell cell, JSSCompoundCommand container, MReport report) {
        if (cell != null && cell instanceof DesignCell) {
            JRStyle style;
            container.add((Command)new RemoveStyleCommand((DesignCell)cell));
            if (this.deleteStyles && cell.getStyle() != null && !this.deletedStyles.contains((style = cell.getStyle()).getName())) {
                this.deletedStyles.add(style.getName());
                container.add((Command)new DeleteStyleCommand(report, (JRDesignStyle)style));
            }
        }
    }

    protected void createCommandForColumns(List<BaseColumn> columns, JSSCompoundCommand command, MReport report) {
        for (BaseColumn col : columns) {
            this.createCommand(col.getColumnFooter(), command, report);
            this.createCommand(col.getColumnHeader(), command, report);
            this.createCommand(col.getTableFooter(), command, report);
            this.createCommand(col.getTableHeader(), command, report);
            for (GroupCell cell : col.getGroupFooters()) {
                this.createCommand(cell.getCell(), command, report);
            }
            for (GroupCell cell : col.getGroupHeaders()) {
                this.createCommand(cell.getCell(), command, report);
            }
            if (col instanceof StandardColumn) {
                StandardColumn baseCol = (StandardColumn)col;
                this.createCommand(baseCol.getDetailCell(), command, report);
            }
            if (!(col instanceof StandardColumnGroup)) continue;
            StandardColumnGroup colGroup = (StandardColumnGroup)col;
            this.createCommandForColumns(colGroup.getColumns(), command, report);
        }
    }

    protected boolean hasStyles(List<BaseColumn> columns) {
        for (BaseColumn col : columns) {
            StandardColumnGroup colGroup;
            StandardColumn baseCol;
            if (this.hasStyle(col.getColumnFooter())) {
                return true;
            }
            if (this.hasStyle(col.getColumnHeader())) {
                return true;
            }
            if (this.hasStyle(col.getTableFooter())) {
                return true;
            }
            if (this.hasStyle(col.getTableHeader())) {
                return true;
            }
            for (GroupCell cell : col.getGroupFooters()) {
                if (!this.hasStyle(cell.getCell())) continue;
                return true;
            }
            for (GroupCell cell : col.getGroupHeaders()) {
                if (!this.hasStyle(cell.getCell())) continue;
                return true;
            }
            if (col instanceof StandardColumn && this.hasStyle((baseCol = (StandardColumn)col).getDetailCell())) {
                return true;
            }
            if (!(col instanceof StandardColumnGroup) || !this.hasStyles((colGroup = (StandardColumnGroup)col).getColumns())) continue;
            return true;
        }
        return false;
    }

    protected boolean hasStyle(Cell cell) {
        return cell != null && (cell.getStyle() != null || cell.getStyleNameReference() != null);
    }

    protected Command changeStyleCommand(List<EditPart> parts) {
        JSSCompoundCommand command = new JSSCompoundCommand(null);
        this.deletedStyles = new HashSet();
        for (EditPart part : parts) {
            MTable table = (MTable)((Object)part.getModel());
            MReport report = ModelUtils.getReport((ANode)table);
            command.setReferenceNodeIfNull((ANode)table);
            StandardTable jrTable = (StandardTable)((JRDesignComponentElement)table.getValue()).getComponent();
            command.add((Command)new ForceRefreshCommand((ANode)table));
            this.createCommandForColumns(jrTable.getColumns(), command, report);
            JRPropertiesMap tableMap = table.getPropertiesMap();
            command.add((Command)new SetPropertyValueCommand(tableMap, "com.jaspersoft.studio.table.style.table_header", null));
            command.add((Command)new SetPropertyValueCommand(tableMap, "com.jaspersoft.studio.table.style.column_header", null));
            command.add((Command)new SetPropertyValueCommand(tableMap, "com.jaspersoft.studio.table.style.detail", null));
            command.add((Command)new ForceRefreshCommand((ANode)table));
        }
        return command;
    }
}

