/*
 * Decompiled with CFR 0.152.
 */
package com.jaspersoft.studio.components.table.model.cell.command;

import com.jaspersoft.studio.components.table.messages.Messages;
import com.jaspersoft.studio.components.table.model.column.MCell;
import com.jaspersoft.studio.model.MElementGroup;
import net.sf.jasperreports.components.table.DesignCell;
import net.sf.jasperreports.engine.design.JRDesignElementGroup;
import org.eclipse.gef.commands.Command;

public class ReorderElementGroupCommand
extends Command {
    private int oldIndex;
    private int newIndex;
    private JRDesignElementGroup jrElement;
    private DesignCell jrCell;

    public ReorderElementGroupCommand(MElementGroup child, MCell parent, int newIndex) {
        super(Messages.common_reorder_elements);
        this.newIndex = Math.max(0, newIndex);
        this.jrElement = (JRDesignElementGroup)child.getValue();
        this.jrCell = parent.getCell();
    }

    public void execute() {
        this.oldIndex = this.jrCell.getChildren().indexOf(this.jrElement);
        this.jrCell.removeElementGroup(this.jrElement);
        if (this.newIndex >= 0 && this.newIndex < this.jrCell.getChildren().size()) {
            this.jrCell.addElementGroup(this.newIndex, this.jrElement);
        } else {
            this.jrCell.addElementGroup(this.jrElement);
        }
    }

    public void undo() {
        this.jrCell.removeElementGroup(this.jrElement);
        if (this.oldIndex >= 0 && this.oldIndex < this.jrCell.getChildren().size()) {
            this.jrCell.addElementGroup(this.oldIndex, this.jrElement);
        } else {
            this.jrCell.addElementGroup(this.jrElement);
        }
    }
}

