/*
 * Decompiled with CFR 0.152.
 */
package com.jaspersoft.studio.components.table.model.column.action;

import com.jaspersoft.studio.components.Activator;
import com.jaspersoft.studio.components.table.TableManager;
import com.jaspersoft.studio.components.table.messages.Messages;
import com.jaspersoft.studio.components.table.model.MTable;
import com.jaspersoft.studio.components.table.model.column.MColumn;
import com.jaspersoft.studio.components.table.model.column.command.SetColumnWidthCommand;
import com.jaspersoft.studio.components.table.part.editpolicy.JSSCompoundTableCommand;
import com.jaspersoft.studio.editor.action.ACachedSelectionAction;
import com.jaspersoft.studio.model.ANode;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import net.sf.jasperreports.components.table.BaseColumn;
import net.sf.jasperreports.components.table.StandardBaseColumn;
import org.eclipse.gef.EditPart;
import org.eclipse.gef.commands.Command;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.ui.IWorkbenchPart;

public class ColumnsStretchToTableAction
extends ACachedSelectionAction {
    public static final String ID = "com.jaspersoft.studio.components.table.action.columnsStretchToTable";

    public ColumnsStretchToTableAction(IWorkbenchPart part) {
        super(part);
        this.setText(Messages.ColumnsStretchToTableAction_actionName);
        this.setId(ID);
        this.setToolTipText(Messages.ColumnsStretchToTableAction_actionDescription);
        this.setImageDescriptor(Activator.getDefault().getImageDescriptor("icons/resources/stretchToTable.png"));
    }

    protected boolean calculateEnabled() {
        return this.canExecute(this.editor.getSelectionCache().getLastRawSelection());
    }

    public boolean canExecute(ISelection selectionSet) {
        MTable table;
        List<MColumn> selectedCols = this.getSelectionSet(selectionSet);
        if (selectedCols.size() > 0 && (table = TableManager.getTableNode((ANode)selectedCols.get(0))) != null && !table.hasColumnsAutoresizeProportional()) {
            int currentColumnsWidth = 0;
            for (BaseColumn col : table.getStandardTable().getColumns()) {
                currentColumnsWidth += col.getWidth().intValue();
            }
            int availableSpace = table.getValue().getWidth() - currentColumnsWidth;
            if (availableSpace == 0) {
                return false;
            }
            if (availableSpace > 0) {
                return true;
            }
            int selectedColumnsWidth = 0;
            for (MColumn col : selectedCols) {
                selectedColumnsWidth += col.getValue().getWidth().intValue();
            }
            return table.getValue().getWidth() - (currentColumnsWidth - selectedColumnsWidth) > 0;
        }
        return false;
    }

    private List<MColumn> getSelectionSet(ISelection selection) {
        HashMap<StandardBaseColumn, MColumn> result = new HashMap<StandardBaseColumn, MColumn>();
        StructuredSelection structSelection = (StructuredSelection)selection;
        if (structSelection != null) {
            for (Object element : structSelection.toList()) {
                MColumn colModel;
                EditPart part;
                if (!(element instanceof EditPart) || !((part = (EditPart)element).getModel() instanceof MColumn) || (colModel = (MColumn)((Object)part.getModel())).getValue() == null || result.containsKey(colModel.getValue())) continue;
                result.put(colModel.getValue(), colModel);
            }
        }
        return new ArrayList<MColumn>(result.values());
    }

    private int[] getColumnsProportionalWidth(List<MColumn> columns, int newWidth) {
        int[] proportionalWidths = new int[columns.size()];
        int index = 0;
        int currentColumnsWidth = 0;
        for (MColumn col : columns) {
            currentColumnsWidth += col.getValue().getWidth().intValue();
        }
        int columnsTotalWidth = 0;
        for (MColumn col : columns) {
            int proportionalWidth;
            float proportionalFactor = (float)col.getValue().getWidth().intValue() / (float)currentColumnsWidth;
            proportionalWidths[index] = proportionalWidth = (int)(proportionalFactor * (float)newWidth);
            columnsTotalWidth += proportionalWidth;
            ++index;
        }
        int remains = newWidth - columnsTotalWidth;
        index = 0;
        while (remains > 0) {
            int n = index++;
            proportionalWidths[n] = proportionalWidths[n] + 1;
            --remains;
            if (index != proportionalWidths.length) continue;
            index = 0;
        }
        return proportionalWidths;
    }

    public void run(ISelection selection) {
        List<MColumn> selectedCols = this.getSelectionSet(selection);
        if (selectedCols.size() > 0) {
            int[] newWidths = null;
            MTable table = TableManager.getTableNode((ANode)selectedCols.get(0));
            if (table != null && !table.hasColumnsAutoresizeProportional()) {
                int availableSpace;
                int currentColumnsWidth = 0;
                for (BaseColumn col : table.getStandardTable().getColumns()) {
                    currentColumnsWidth += col.getWidth().intValue();
                }
                int selectedColumnsWidth = 0;
                for (MColumn col : selectedCols) {
                    selectedColumnsWidth += col.getValue().getWidth().intValue();
                }
                int freeTableSpace = table.getValue().getWidth() - currentColumnsWidth;
                if (table.getValue().getWidth() - currentColumnsWidth > 0) {
                    availableSpace = selectedColumnsWidth + freeTableSpace;
                    newWidths = this.getColumnsProportionalWidth(selectedCols, availableSpace);
                } else {
                    availableSpace = table.getValue().getWidth() - (currentColumnsWidth - selectedColumnsWidth);
                    newWidths = this.getColumnsProportionalWidth(selectedCols, availableSpace);
                }
            }
            if (newWidths != null) {
                JSSCompoundTableCommand cmd = new JSSCompoundTableCommand(table);
                cmd.setLayoutTableContent(true);
                int index = 0;
                for (MColumn col : selectedCols) {
                    SetColumnWidthCommand setCommand = new SetColumnWidthCommand(col, (int)newWidths[index]);
                    ++index;
                    cmd.add(setCommand);
                }
                this.execute((Command)cmd);
            }
        }
    }

    public void run() {
        this.run(this.getSelection());
    }
}

