/*
 * Decompiled with CFR 0.152.
 */
package com.jaspersoft.studio.components.table.model.column.action;

import com.jaspersoft.studio.JSSCompoundCommand;
import com.jaspersoft.studio.components.table.TableComponentFactory;
import com.jaspersoft.studio.components.table.messages.Messages;
import com.jaspersoft.studio.components.table.model.column.MColumn;
import com.jaspersoft.studio.components.table.model.column.command.RefreshColumnNamesCommand;
import com.jaspersoft.studio.model.ANode;
import java.util.HashSet;
import java.util.List;
import net.sf.jasperreports.components.table.StandardBaseColumn;
import org.eclipse.gef.EditPart;
import org.eclipse.gef.commands.Command;
import org.eclipse.gef.ui.actions.DeleteAction;
import org.eclipse.ui.IWorkbenchPart;

public class DeleteColumnAction
extends DeleteAction {
    public static final String ID = "delete_table_column";

    public DeleteColumnAction(IWorkbenchPart part) {
        super(part);
    }

    protected void init() {
        super.init();
        this.setText(Messages.DeleteColumnAction_text);
        this.setToolTipText(Messages.DeleteColumnAction_tooltip);
        this.setId(ID);
    }

    public Command createDeleteCommand(List objects) {
        if (objects.isEmpty()) {
            return null;
        }
        if (!(objects.get(0) instanceof EditPart)) {
            return null;
        }
        JSSCompoundCommand compoundCmd = new JSSCompoundCommand(this.getText(), null);
        MColumn col = null;
        HashSet<StandardBaseColumn> deletedColumns = new HashSet<StandardBaseColumn>();
        int i = 0;
        while (i < objects.size()) {
            EditPart object = (EditPart)objects.get(i);
            if (object.getModel() instanceof MColumn) {
                Command cmd;
                MColumn model;
                col = model = (MColumn)((Object)object.getModel());
                compoundCmd.setReferenceNodeIfNull((ANode)model);
                if (!deletedColumns.contains(model.getValue()) && (cmd = TableComponentFactory.getDeleteColumnCommand(model.getParent(), (ANode)model)) != null) {
                    compoundCmd.add(cmd);
                    deletedColumns.add(model.getValue());
                }
            }
            ++i;
        }
        if (compoundCmd.isEmpty()) {
            return null;
        }
        compoundCmd.addFirst((Command)new RefreshColumnNamesCommand((ANode)col, false, true));
        compoundCmd.add((Command)new RefreshColumnNamesCommand((ANode)col, true, false));
        return compoundCmd;
    }
}

