/*
 * Decompiled with CFR 0.152.
 */
package com.jaspersoft.studio.components.table.model.column.command;

import com.jaspersoft.studio.components.table.model.MTable;
import com.jaspersoft.studio.components.table.util.TableColumnNumerator;
import com.jaspersoft.studio.model.ANode;
import org.eclipse.gef.commands.Command;

public class RefreshColumnNamesCommand
extends Command {
    private MTable mTable;
    private boolean renameOnUndo = false;
    private boolean renameOnExecute = false;

    public RefreshColumnNamesCommand(ANode tableNode, boolean renameOnExecute, boolean renameOnUndo) {
        this(RefreshColumnNamesCommand.getTableFromNode(tableNode), renameOnExecute, renameOnUndo);
    }

    public RefreshColumnNamesCommand(MTable mTable, boolean renameOnExecute, boolean renameOnUndo) {
        this.renameOnExecute = renameOnExecute;
        this.renameOnUndo = renameOnUndo;
        this.mTable = mTable;
    }

    private static MTable getTableFromNode(ANode startingNode) {
        ANode parent = startingNode;
        while (parent != null && !(parent instanceof MTable)) {
            parent = parent.getParent();
        }
        return (MTable)parent;
    }

    private void refreshColumnNames() {
        if (this.mTable != null) {
            TableColumnNumerator.renumerateColumnNames(this.mTable);
        }
    }

    public void execute() {
        if (this.renameOnExecute) {
            this.refreshColumnNames();
        }
    }

    public void undo() {
        if (this.renameOnUndo) {
            this.refreshColumnNames();
        }
    }

    public void redo() {
        this.execute();
    }

    public boolean canUndo() {
        return true;
    }

    public boolean canExecute() {
        return true;
    }
}

