/*
 * Decompiled with CFR 0.152.
 */
package com.jaspersoft.studio.components.table.model.columngroup;

import com.jaspersoft.studio.components.table.TableNodeIconDescriptor;
import com.jaspersoft.studio.components.table.model.AMCollection;
import com.jaspersoft.studio.components.table.model.MTable;
import com.jaspersoft.studio.components.table.model.column.MColumn;
import com.jaspersoft.studio.components.table.util.TableColumnSize;
import com.jaspersoft.studio.model.ANode;
import com.jaspersoft.studio.model.INode;
import com.jaspersoft.studio.model.util.IIconDescriptor;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.util.List;
import java.util.Map;
import net.sf.jasperreports.components.table.BaseColumn;
import net.sf.jasperreports.components.table.StandardBaseColumn;
import net.sf.jasperreports.components.table.StandardColumnGroup;
import net.sf.jasperreports.engine.design.events.CollectionElementAddedEvent;
import net.sf.jasperreports.engine.design.events.JRChangeEventsSupport;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.ui.views.properties.IPropertyDescriptor;

public class MColumnGroup
extends MColumn {
    public static final long serialVersionUID = 10200L;
    private static IIconDescriptor iconDescriptor;
    public static int DEFAULT_CELL_HEIGHT;
    protected static IPropertyDescriptor[] descriptors;

    static {
        DEFAULT_CELL_HEIGHT = 30;
    }

    public MColumnGroup() {
    }

    public static IIconDescriptor getIconDescriptor() {
        if (iconDescriptor == null) {
            iconDescriptor = new TableNodeIconDescriptor("tablecolumngroup");
        }
        return iconDescriptor;
    }

    public MColumnGroup(ANode parent, StandardColumnGroup jrDataset, String name, int index) {
        super(parent, (StandardBaseColumn)jrDataset, name, index);
    }

    public StandardColumnGroup getValue() {
        return (StandardColumnGroup)super.getValue();
    }

    @Override
    public ImageDescriptor getImagePath() {
        return MColumnGroup.getIconDescriptor().getIcon16();
    }

    @Override
    public String getToolTip() {
        return String.valueOf(MColumnGroup.getIconDescriptor().getToolTip()) + ": " + this.getDisplayText();
    }

    @Override
    public void propertyChange(PropertyChangeEvent evt) {
        AMCollection section = this.getSection();
        if (section != null) {
            MTable mTable;
            if (evt.getPropertyName().equals("columns") && evt.getSource() instanceof StandardColumnGroup && evt.getSource() == this.getValue()) {
                if (evt.getOldValue() == null && evt.getNewValue() != null) {
                    int newIndex = -1;
                    if (evt instanceof CollectionElementAddedEvent) {
                        newIndex = ((CollectionElementAddedEvent)evt).getAddedIndex();
                    }
                    StandardBaseColumn bc = (StandardBaseColumn)evt.getNewValue();
                    if (section != null) {
                        section.createColumn((ANode)this, (BaseColumn)bc, 122, newIndex);
                    }
                } else if (evt.getOldValue() != null && evt.getNewValue() == null) {
                    for (INode n : this.getChildren()) {
                        if (n.getValue() != evt.getOldValue()) continue;
                        this.removeChild((ANode)n);
                        break;
                    }
                } else {
                    for (INode n : this.getChildren()) {
                        if (n.getValue() != evt.getOldValue()) continue;
                        n.setValue(evt.getNewValue());
                    }
                }
            }
            if ((mTable = (MTable)section.getParent()) == null) {
                if (evt.getSource() instanceof JRChangeEventsSupport) {
                    ((JRChangeEventsSupport)evt.getSource()).getEventSupport().removePropertyChangeListener((PropertyChangeListener)((Object)this));
                }
            } else {
                mTable.getTableManager().refresh();
            }
        }
        super.propertyChange(evt);
    }

    public Map<String, List<ANode>> getUsedStyles() {
        Map result = super.getUsedStyles();
        StandardColumnGroup group = this.getValue();
        if (group != null && this.containerSection != null) {
            Class<?> classType = ((Object)((Object)this.containerSection)).getClass();
            int sectionType = TableColumnSize.getType(classType);
            if (sectionType == 3 && group.getColumnFooter() != null) {
                this.addElementStyle(group.getColumnFooter().getStyle(), result);
            }
            if (sectionType == 2 && group.getColumnHeader() != null) {
                this.addElementStyle(group.getColumnHeader().getStyle(), result);
            }
            if (sectionType == 1 && group.getTableFooter() != null) {
                this.addElementStyle(group.getTableFooter().getStyle(), result);
            }
            if (sectionType == 0 && group.getTableHeader() != null) {
                this.addElementStyle(group.getTableHeader().getStyle(), result);
            }
        }
        for (INode child : this.getChildren()) {
            if (!(child instanceof ANode)) continue;
            this.mergeElementStyle(result, ((ANode)child).getUsedStyles());
        }
        return result;
    }
}

